/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.network.PrivateAddresses;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Splitter;
import com.google.common.collect.AbstractSequentialIterator;
import com.google.common.collect.Iterators;
import com.google.common.net.InetAddresses;
import com.google.common.primitives.UnsignedInteger;
import com.google.common.primitives.UnsignedInts;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Immutable;
import java.lang.ref.SoftReference;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.BytecodeInterface8;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.GeneratedClosure;
import org.codehaus.groovy.runtime.InvokerHelper;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberMinus;
import org.codehaus.groovy.runtime.dgmimpl.NumberNumberPlus;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;
import org.codehaus.groovy.transform.ImmutableASTTransformation;
import org.codehaus.groovy.util.HashCodeHelper;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Immutable
public final class IPRange
implements Iterable<Integer>,
GroovyObject {
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private final int lower;
    private final int upper;
    private /* synthetic */ int $hash$code;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1453166314146;
    private static /* synthetic */ SoftReference $callSiteArray;

    /*
     * WARNING - void declaration
     */
    public IPRange(HashMap hashMap) {
        void args;
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
        if (!(args == null)) {
            if (args.get("lower") == null) {
                if (!(null == null)) {
                    Object var3_3 = null;
                    this.lower = DefaultTypeTransformation.intUnbox(var3_3);
                }
            } else {
                Object v = args.get("lower");
                this.lower = DefaultTypeTransformation.intUnbox(v);
            }
            if (args.get("upper") == null) {
                if (!(null == null)) {
                    Object var5_5 = null;
                    this.upper = DefaultTypeTransformation.intUnbox(var5_5);
                }
            } else {
                Object v = args.get("upper");
                this.upper = DefaultTypeTransformation.intUnbox(v);
            }
            ImmutableASTTransformation.checkPropNames((Object)this, (Map)args);
            if (DefaultGroovyMethods.getMetaClass((Object)args) == null) {
                if (!(this.$getStaticMetaClass() == null)) {
                    MetaClass metaClass2;
                    this.metaClass = metaClass2 = this.$getStaticMetaClass();
                }
            } else {
                MetaClass metaClass3;
                this.metaClass = metaClass3 = DefaultGroovyMethods.getMetaClass((Object)args);
            }
        }
    }

    public IPRange(int lower, int upper) {
        this((HashMap)ScriptBytecodeAdapter.castToType((Object)ScriptBytecodeAdapter.createMap((Object[])new Object[]{"lower", lower, "upper", upper}), HashMap.class));
    }

    public static IPRange parse(String range) {
        Parameters.checkParam((String)"range", (Object)range, (Matcher)Matchers.notNullValue());
        Iterable parts = Splitter.on((String)"-").trimResults().omitEmptyStrings().limit(2).split((CharSequence)range);
        String lowerPart = (String)ScriptBytecodeAdapter.castToType((Object)DefaultGroovyMethods.getAt((Iterable)parts, (int)0), String.class);
        if (lowerPart == null) {
            throw (Throwable)new IllegalArgumentException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{range}, new String[]{"Invalid range: ", ""}), String.class));
        }
        Object object = DefaultGroovyMethods.getAt((Iterable)parts, (int)1);
        String string = (String)ScriptBytecodeAdapter.castToType((Object)object, String.class);
        String upperPart = DefaultTypeTransformation.booleanUnbox((Object)object) ? string : lowerPart;
        if (!InetAddresses.isInetAddress((String)lowerPart) || !InetAddresses.isInetAddress((String)upperPart)) {
            throw (Throwable)new IllegalArgumentException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{range}, new String[]{"Invalid range: ", ""}), String.class));
        }
        int lower = PrivateAddresses.asInteger(lowerPart);
        int upper = PrivateAddresses.asInteger(upperPart);
        if (UnsignedInts.compare((int)lower, (int)upper) > 0) {
            throw (Throwable)new IllegalArgumentException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{range}, new String[]{"Invalid range: ", ""}), String.class));
        }
        return new IPRange(lower, upper);
    }

    public static Function<String, Optional<IPRange>> parse() {
        return IPRangeParse.INSTANCE;
    }

    public static IPRange fromSubnet(String subnet, String netmask) {
        Parameters.checkParam((String)"subnet", (Object)subnet, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((String)"netmask", (Object)netmask, (Matcher)Matchers.notNullValue());
        if (!InetAddresses.isInetAddress((String)subnet) || !InetAddresses.isInetAddress((String)netmask)) {
            throw (Throwable)new IllegalArgumentException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{subnet, netmask}, new String[]{"Invalid subnet/netmask: ", "/", ""}), String.class));
        }
        int snet = PrivateAddresses.asInteger(subnet);
        int mask = PrivateAddresses.asInteger(netmask);
        return new IPRange(snet & mask, DefaultTypeTransformation.intUnbox((Object)DefaultGroovyMethods.or((Number)snet, (Number)DefaultGroovyMethods.xor((Number)-1, (Number)mask)))).perhapsShrink();
    }

    public static IPRange fromCidr(Cidr cidr) {
        Parameters.checkParam((String)"cidr", (Object)cidr, (Matcher)Matchers.notNullValue());
        int snet = cidr.getIp();
        int mask = Cidr.prefixMask((int)cidr.getPrefix());
        return new IPRange(snet & mask, DefaultTypeTransformation.intUnbox((Object)DefaultGroovyMethods.or((Number)snet, (Number)DefaultGroovyMethods.xor((Number)-1, (Number)mask)))).perhapsShrink();
    }

    public static boolean isIPRange(String range) {
        return ((Optional)IPRange.parse().apply((Object)range)).isPresent();
    }

    public List<IPRange> split(String ip) {
        Parameters.checkParam((String)"ip", (Object)ip, (Matcher)Matchers.notNullValue());
        if (!InetAddresses.isInetAddress((String)ip)) {
            throw (Throwable)new IllegalArgumentException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{ip}, new String[]{"Invalid ip: ", ""}), String.class));
        }
        int address = PrivateAddresses.asInteger(ip);
        if (UnsignedInts.compare((int)address, (int)this.lower) > 0 && UnsignedInts.compare((int)address, (int)this.upper) < 0) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[]{new IPRange(this.lower, IPRange.unsigned(address).minus(IPRange.unsigned(1)).intValue()), new IPRange(IPRange.unsigned(address).plus(IPRange.unsigned(1)).intValue(), this.upper)});
        }
        if (UnsignedInts.compare((int)this.lower, (int)address) == 0) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[]{new IPRange(IPRange.unsigned(address).plus(IPRange.unsigned(1)).intValue(), this.upper)});
        }
        if (UnsignedInts.compare((int)this.upper, (int)address) == 0) {
            return ScriptBytecodeAdapter.createList((Object[])new Object[]{new IPRange(this.lower, IPRange.unsigned(address).minus(IPRange.unsigned(1)).intValue())});
        }
        return ScriptBytecodeAdapter.createList((Object[])new Object[]{this});
    }

    public boolean contains(IPRange range) {
        return UnsignedInts.compare((int)this.lower, (int)range.getLower()) < 1 && ScriptBytecodeAdapter.compareGreaterThan((Object)UnsignedInts.compare((int)this.upper, (int)range.getUpper()), (Object)-1);
    }

    public IPRange perhapsShrink() {
        UnsignedInteger shrinkLower = IPRange.unsigned(this.lower).plus(IPRange.unsigned(1));
        UnsignedInteger shrinkUpper = IPRange.unsigned(this.upper).minus(IPRange.unsigned(1));
        return shrinkLower.compareTo(shrinkUpper) <= 0 ? new IPRange(shrinkLower.intValue(), shrinkUpper.intValue()) : this;
    }

    @Override
    public Iterator<Integer> iterator() {
        return Iterators.transform((Iterator)DefaultGroovyMethods.iterator((Iterator)new LongSequentialIterator(this.lower, this.upper)), (Function)((Function)ScriptBytecodeAdapter.asType((Object)new GeneratedClosure(this, this){
            private static /* synthetic */ ClassInfo $staticClassInfo;
            public static transient /* synthetic */ boolean __$stMC;
            private static /* synthetic */ SoftReference $callSiteArray;

            public Object doCall(Long value) {
                return value.intValue();
            }

            public Object call(Long value) {
                return this.doCall(value);
            }

            protected /* synthetic */ MetaClass $getStaticMetaClass() {
                if (((Object)((Object)this)).getClass() != _iterator_closure1.class) {
                    return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
                }
                ClassInfo classInfo = $staticClassInfo;
                if (classInfo == null) {
                    $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
                }
                return classInfo.getMetaClass();
            }

            public static /* synthetic */ void __$swapInit() {
            }

            static {
                _iterator_closure1.__$swapInit();
            }

            private static /* synthetic */ CallSiteArray $createCallSiteArray() {
                String[] stringArray = new String[]{};
                return new CallSiteArray(_iterator_closure1.class, stringArray);
            }

            private static /* synthetic */ CallSite[] $getCallSiteArray() {
                CallSiteArray callSiteArray;
                if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                    callSiteArray = _iterator_closure1.$createCallSiteArray();
                    $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
                }
                return callSiteArray.array;
            }

            static /* synthetic */ Class class$(String string) {
                try {
                    return Class.forName(string);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
        }, Function.class)));
    }

    public String toString() {
        return (String)ScriptBytecodeAdapter.castToType((Object)(this.lower == this.upper ? PrivateAddresses.fromInteger(this.lower) : new GStringImpl(new Object[]{PrivateAddresses.fromInteger(this.lower), PrivateAddresses.fromInteger(this.upper)}, new String[]{"", "-", ""})), String.class);
    }

    private static UnsignedInteger unsigned(int value) {
        return UnsignedInteger.fromIntBits((int)value);
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != IPRange.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public int hashCode() {
        if (ScriptBytecodeAdapter.compareEqual((Object)this.$hash$code, (Object)0)) {
            int n;
            int _result = HashCodeHelper.initHash();
            if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"lower"), (Object)this)) {
                int n2;
                _result = n2 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"lower"));
            }
            if (!DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"upper"), (Object)this)) {
                int n3;
                _result = n3 = HashCodeHelper.updateHash((int)_result, (Object)InvokerHelper.getProperty((Object)this, (String)"upper"));
            }
            this.$hash$code = n = _result;
        }
        return this.$hash$code;
    }

    public boolean equals(Object other) {
        if (other == null) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
        }
        if (DefaultGroovyMethods.is((Object)this, (Object)other)) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
        }
        if (ScriptBytecodeAdapter.compareNotEqual(IPRange.class, other.getClass())) {
            return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
        }
        IPRange otherTyped = (IPRange)ScriptBytecodeAdapter.castToType((Object)other, IPRange.class);
        if (!DefaultGroovyMethods.is((Object)this.getLower(), (Object)otherTyped.getLower())) {
            if (DefaultGroovyMethods.is((Object)this.getLower(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getLower(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getLower(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getLower(), (Object)otherTyped)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (!(DefaultGroovyMethods.is((Object)this.getLower(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getLower(), (Object)otherTyped)) && this.getLower() != otherTyped.getLower()) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
        }
        if (!DefaultGroovyMethods.is((Object)this.getUpper(), (Object)otherTyped.getUpper())) {
            if (DefaultGroovyMethods.is((Object)this.getUpper(), (Object)this) && !DefaultGroovyMethods.is((Object)otherTyped.getUpper(), (Object)otherTyped) || !DefaultGroovyMethods.is((Object)this.getUpper(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getUpper(), (Object)otherTyped)) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
            if (!(DefaultGroovyMethods.is((Object)this.getUpper(), (Object)this) && DefaultGroovyMethods.is((Object)otherTyped.getUpper(), (Object)otherTyped)) && this.getUpper() != otherTyped.getUpper()) {
                return DefaultTypeTransformation.booleanUnbox((Object)Boolean.FALSE);
            }
        }
        return DefaultTypeTransformation.booleanUnbox((Object)Boolean.TRUE);
    }

    private String _toString() {
        StringBuilder _result = new StringBuilder();
        Boolean $toStringFirst = Boolean.TRUE;
        _result.append("com.eucalyptus.network.IPRange(");
        if (InvokerHelper.getProperty((Object)this, (String)"lower") != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl2;
                $toStringFirst = bl2 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"lower"), (Object)this)) {
                _result.append("(this)");
            } else {
                _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"lower")));
            }
        }
        if (InvokerHelper.getProperty((Object)this, (String)"upper") != null) {
            Boolean bl = $toStringFirst;
            if (bl == null ? false : bl) {
                Boolean bl3;
                $toStringFirst = bl3 = Boolean.FALSE;
            } else {
                _result.append(", ");
            }
            if (DefaultGroovyMethods.is((Object)InvokerHelper.getProperty((Object)this, (String)"upper"), (Object)this)) {
                _result.append("(this)");
            } else {
                _result.append(InvokerHelper.toString((Object)InvokerHelper.getProperty((Object)this, (String)"upper")));
            }
        }
        _result.append(")");
        return _result.toString();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(IPRange.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, IPRange.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectField(IPRange.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        long l;
        long l2;
        IPRange.__$swapInit();
        __timeStamp__239_neverHappen1453166314146 = l2 = 0L;
        __timeStamp = l = 1453166314146L;
    }

    public final int getLower() {
        return this.lower;
    }

    public final int getUpper() {
        return this.upper;
    }

    public /* synthetic */ String this$2$_toString() {
        return this._toString();
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(IPRange.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = IPRange.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class LongSequentialIterator
    extends AbstractSequentialIterator<Long>
    implements Iterator<Long>,
    GroovyObject {
        private long last;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public LongSequentialIterator(Integer first, Integer last) {
            this(UnsignedInts.toLong((int)DefaultTypeTransformation.intUnbox((Object)first)), UnsignedInts.toLong((int)DefaultTypeTransformation.intUnbox((Object)last)));
        }

        public LongSequentialIterator(Long first, Long last) {
            super((Object)first);
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            Long l = last;
            this.last = l;
        }

        protected Long computeNext(Long value) {
            return (Long)ScriptBytecodeAdapter.castToType(ScriptBytecodeAdapter.compareGreaterThanEqual((Object)value, (Object)this.last) ? (Number)null : (Number)NumberNumberPlus.plus((Number)value, (Number)1), Long.class);
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (this.getClass() != LongSequentialIterator.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)this);
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ Object this$dist$invoke$3(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodOnCurrentN(LongSequentialIterator.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void this$dist$set$3(String name, Object value) {
            Object object = value;
            ScriptBytecodeAdapter.setGroovyObjectField((Object)object, LongSequentialIterator.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object this$dist$get$3(String name) {
            return ScriptBytecodeAdapter.getGroovyObjectField(LongSequentialIterator.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object methodMissing(String name, Object args) {
            return ScriptBytecodeAdapter.invokeMethodN(LongSequentialIterator.class, IPRange.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
        }

        public /* synthetic */ void propertyMissing(String name, Object val) {
            Object object = val;
            ScriptBytecodeAdapter.setField((Object)object, LongSequentialIterator.class, IPRange.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ Object propertyMissing(String name) {
            return ScriptBytecodeAdapter.getField(LongSequentialIterator.class, IPRange.class, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        static {
            LongSequentialIterator.__$swapInit();
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$1$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ void super$1$finalize() {
            super.finalize();
        }

        public /* synthetic */ void super$2$remove() {
            super.remove();
        }

        public /* synthetic */ Object super$3$next() {
            return super.next();
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$3$hasNext() {
            return super.hasNext();
        }

        public /* synthetic */ boolean super$1$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$1$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$1$hashCode() {
            return super.hashCode();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(LongSequentialIterator.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = LongSequentialIterator.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class IPRangeParse
    extends Enum<IPRangeParse>
    implements Function<String, Optional<IPRange>>,
    GroovyObject {
        public static final /* enum */ IPRangeParse INSTANCE;
        public static final IPRangeParse MIN_VALUE;
        public static final IPRangeParse MAX_VALUE;
        private static final /* synthetic */ IPRangeParse[] $VALUES;
        private static /* synthetic */ ClassInfo $staticClassInfo;
        public static transient /* synthetic */ boolean __$stMC;
        private transient /* synthetic */ MetaClass metaClass;
        private static /* synthetic */ ClassInfo $staticClassInfo$;
        private static /* synthetic */ SoftReference $callSiteArray;

        public IPRangeParse(LinkedHashMap __namedArgs) {
            MetaClass metaClass;
            this.metaClass = metaClass = this.$getStaticMetaClass();
            if (__namedArgs == null) {
                throw (Throwable)new IllegalArgumentException("One of the enum constants for enum com.eucalyptus.network.IPRange$IPRangeParse was initialized with null. Please use a non-null value or define your own constructor.");
            }
            ImmutableASTTransformation.checkPropNames((Object)((Object)this), (Map)__namedArgs);
        }

        public IPRangeParse() {
            this(new LinkedHashMap());
        }

        public Optional<IPRange> apply(@Nullable String range) {
            Optional optional = Optional.of((Object)IPRange.parse(range));
            try {
                return optional;
            }
            catch (Exception IllegalArgumentException2) {
                Optional optional2 = Optional.absent();
                return optional2;
            }
        }

        public static final IPRangeParse[] values() {
            return (IPRangeParse[])ScriptBytecodeAdapter.castToType((Object)$VALUES.clone(), IPRangeParse[].class);
        }

        public /* synthetic */ IPRangeParse next() {
            Number ordinal = DefaultGroovyMethods.next((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareGreaterThanEqual((Object)ordinal, (Object)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))))) {
                int n = 0;
                ordinal = n;
            }
            return (IPRangeParse)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), IPRangeParse.class));
        }

        public /* synthetic */ IPRangeParse previous() {
            Number ordinal = DefaultGroovyMethods.previous((Number)this.ordinal());
            if (ScriptBytecodeAdapter.compareLessThan((Object)ordinal, (Object)0)) {
                Number number;
                ordinal = number = NumberNumberMinus.minus((Number)DefaultGroovyMethods.size((Object[])((Object[])ScriptBytecodeAdapter.castToType((Object)$VALUES, Object[].class))), (Number)1);
            }
            return (IPRangeParse)((Object)ScriptBytecodeAdapter.castToType((Object)BytecodeInterface8.objectArrayGet((Object[])$VALUES, (int)DefaultTypeTransformation.intUnbox((Object)ordinal)), IPRangeParse.class));
        }

        public static IPRangeParse valueOf(String name) {
            return (IPRangeParse)((Object)ScriptBytecodeAdapter.castToType((Object)((Object)Enum.valueOf(IPRangeParse.class, name)), IPRangeParse.class));
        }

        public static final /* synthetic */ IPRangeParse $INIT(Object ... para) {
            IPRangeParse iPRangeParse;
            Object[] objectArray = ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{para}, (int[])new int[]{0});
            switch (ScriptBytecodeAdapter.selectConstructorAndTransformArguments((Object[])objectArray, (int)-1, IPRangeParse.class)) {
                case -1348271900: {
                    IPRangeParse iPRangeParse2;
                    iPRangeParse = iPRangeParse2;
                    Object[] objectArray2 = objectArray;
                    iPRangeParse2 = new IPRangeParse();
                    break;
                }
                case -242181752: {
                    IPRangeParse iPRangeParse2;
                    iPRangeParse = iPRangeParse2;
                    Object[] objectArray2 = objectArray;
                    iPRangeParse2 = new IPRangeParse((LinkedHashMap)ScriptBytecodeAdapter.castToType((Object)objectArray[2], LinkedHashMap.class));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("This class has been compiled with a super class which is binary incompatible with the current super class found on classpath. You should recompile this class with the new version.");
                }
            }
            return iPRangeParse;
        }

        static {
            IPRangeParse iPRangeParse;
            IPRangeParse iPRangeParse2;
            IPRangeParse iPRangeParse3;
            IPRangeParse.__$swapInit();
            INSTANCE = iPRangeParse3 = IPRangeParse.$INIT("INSTANCE", 0);
            MIN_VALUE = iPRangeParse2 = INSTANCE;
            MAX_VALUE = iPRangeParse = INSTANCE;
            IPRangeParse[] iPRangeParseArray = new IPRangeParse[]{INSTANCE};
            $VALUES = iPRangeParseArray;
        }

        protected /* synthetic */ MetaClass $getStaticMetaClass() {
            if (((Object)((Object)this)).getClass() != IPRangeParse.class) {
                return ScriptBytecodeAdapter.initMetaClass((Object)((Object)this));
            }
            ClassInfo classInfo = $staticClassInfo;
            if (classInfo == null) {
                $staticClassInfo = classInfo = ClassInfo.getClassInfo(((Object)((Object)this)).getClass());
            }
            return classInfo.getMetaClass();
        }

        public /* synthetic */ MetaClass getMetaClass() {
            MetaClass metaClass = this.metaClass;
            if (metaClass != null) {
                return metaClass;
            }
            this.metaClass = this.$getStaticMetaClass();
            return this.metaClass;
        }

        public /* synthetic */ void setMetaClass(MetaClass metaClass) {
            this.metaClass = metaClass;
        }

        public /* synthetic */ Object invokeMethod(String string, Object object) {
            return this.getMetaClass().invokeMethod((Object)this, string, object);
        }

        public /* synthetic */ Object getProperty(String string) {
            return this.getMetaClass().getProperty((Object)this, string);
        }

        public /* synthetic */ void setProperty(String string, Object object) {
            this.getMetaClass().setProperty((Object)this, string, object);
        }

        public static /* synthetic */ void __$swapInit() {
        }

        public /* synthetic */ void super$1$wait() {
            super.wait();
        }

        public /* synthetic */ String super$2$toString() {
            return super.toString();
        }

        public /* synthetic */ void super$1$wait(long l, int n) {
            super.wait(l, n);
        }

        public /* synthetic */ void super$1$notify() {
            super.notify();
        }

        public /* synthetic */ Class super$1$getClass() {
            return super.getClass();
        }

        public /* synthetic */ void super$1$notifyAll() {
            super.notifyAll();
        }

        public /* synthetic */ int super$2$ordinal() {
            return super.ordinal();
        }

        public /* synthetic */ String super$2$name() {
            return super.name();
        }

        public /* synthetic */ void super$2$finalize() {
            super.finalize();
        }

        public /* synthetic */ int super$2$compareTo(Enum enum_) {
            return super.compareTo(enum_);
        }

        public /* synthetic */ void super$1$wait(long l) {
            super.wait(l);
        }

        public /* synthetic */ boolean super$2$equals(Object object) {
            return super.equals(object);
        }

        public /* synthetic */ Object super$2$clone() {
            return super.clone();
        }

        public /* synthetic */ int super$2$hashCode() {
            return super.hashCode();
        }

        public /* synthetic */ Class super$2$getDeclaringClass() {
            return super.getDeclaringClass();
        }

        private static /* synthetic */ CallSiteArray $createCallSiteArray() {
            String[] stringArray = new String[]{};
            return new CallSiteArray(IPRangeParse.class, stringArray);
        }

        private static /* synthetic */ CallSite[] $getCallSiteArray() {
            CallSiteArray callSiteArray;
            if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
                callSiteArray = IPRangeParse.$createCallSiteArray();
                $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
            }
            return callSiteArray.array;
        }

        static /* synthetic */ Class class$(String string) {
            try {
                return Class.forName(string);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
    }
}

