/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.network;

import com.eucalyptus.cloud.util.Reference;
import com.eucalyptus.cloud.util.ResourceAllocationException;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.entities.AccountMetadata;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.network.PrivateNetworkIndex;
import com.eucalyptus.util.FullName;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_extant_network")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class ExtantNetwork
extends UserMetadata<Reference.State> {
    private static final long serialVersionUID = 1L;
    private static final Logger LOG = Logger.getLogger(ExtantNetwork.class);
    private static final ConcurrentMap<NetworkIndexKey, Long> inFlightNetworkIndexes = Maps.newConcurrentMap();
    @Column(name="metadata_extant_network_tag", unique=true)
    private Integer tag;
    @NotFound(action=NotFoundAction.IGNORE)
    @OneToMany(fetch=FetchType.EAGER, orphanRemoval=true, cascade={CascadeType.ALL})
    @JoinColumn(name="metadata_extant_network_index_fk")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private final Set<PrivateNetworkIndex> indexes = new HashSet<PrivateNetworkIndex>();
    @OneToOne(fetch=FetchType.EAGER)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private NetworkGroup networkGroup;
    private static AtomicInteger bogusTag = new AtomicInteger(0);

    private ExtantNetwork() {
    }

    private ExtantNetwork(Integer tag) {
        super(null, null);
        this.tag = tag;
    }

    private ExtantNetwork(NetworkGroup networkGroup, Integer tag) {
        super(networkGroup.getOwner(), networkGroup.getDisplayName());
        this.tag = tag;
        this.networkGroup = networkGroup;
        this.setState(Reference.State.PENDING);
    }

    private ExtantNetwork(NetworkGroup networkGroup) {
        super(networkGroup.getOwner(), networkGroup.getDisplayName());
    }

    public static ExtantNetwork named(Integer tag) {
        return new ExtantNetwork(tag);
    }

    public static ExtantNetwork named(NetworkGroup networkGroup) {
        return new ExtantNetwork(networkGroup);
    }

    public static ExtantNetwork create(NetworkGroup networkGroup, Integer tag) {
        return new ExtantNetwork(networkGroup, tag);
    }

    public static ExtantNetwork bogus(NetworkGroup networkGroup) {
        while (true) {
            EntityTransaction db = Entities.get(ExtantNetwork.class);
            try {
                ExtantNetwork net = (ExtantNetwork)((Object)Entities.uniqueResult((Object)((Object)new ExtantNetwork(bogusTag.decrementAndGet()))));
                db.rollback();
            }
            catch (Exception ex) {
                db.rollback();
                return new ExtantNetwork(networkGroup, bogusTag.get());
            }
        }
    }

    public Integer getTag() {
        return this.tag;
    }

    protected void setTag(Integer tag) {
        this.tag = tag;
    }

    public PrivateNetworkIndex reclaimNetworkIndex(Long idx) throws Exception {
        try {
            return (PrivateNetworkIndex)Entities.uniqueResult((Object)PrivateNetworkIndex.named(this, idx));
        }
        catch (Exception ex) {
            return (PrivateNetworkIndex)((PrivateNetworkIndex)Entities.persist((Object)PrivateNetworkIndex.create(this, idx))).allocate();
        }
    }

    /*
     * Exception decompiling
     */
    PrivateNetworkIndex allocateNetworkIndex() throws TransactionException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void clearInFlight(Collection<Long> indexes) {
        for (Long index : indexes) {
            NetworkIndexKey key = new NetworkIndexKey(this.getTag(), index);
            inFlightNetworkIndexes.remove(key);
        }
    }

    private boolean ifNotInFlight(Long index) {
        NetworkIndexKey key = new NetworkIndexKey(this.getTag(), index);
        Long reservedTime = inFlightNetworkIndexes.putIfAbsent(key, System.currentTimeMillis());
        return reservedTime == null || reservedTime + TimeUnit.MINUTES.toMillis(1L) < System.currentTimeMillis() && inFlightNetworkIndexes.replace(key, reservedTime, System.currentTimeMillis());
    }

    public NetworkGroup getNetworkGroup() {
        return this.networkGroup;
    }

    void setNetworkGroup(NetworkGroup networkGroup) {
        this.networkGroup = networkGroup;
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.tag == null ? 0 : this.tag.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ExtantNetwork other = (ExtantNetwork)((Object)obj);
        return !(this.tag == null ? other.tag != null : !this.tag.equals(other.tag));
    }

    public int compareTo(AccountMetadata that) {
        if (that instanceof ExtantNetwork) {
            return this.getTag().compareTo(((ExtantNetwork)that).getTag());
        }
        return super.compareTo(that);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ExtantNetwork:");
        if (this.networkGroup != null) {
            builder.append(this.networkGroup.getDisplayName()).append(":");
        }
        if (this.tag != null) {
            builder.append("tag=").append(this.tag).append(":");
        }
        if (this.indexes != null) {
            builder.append("indexes=").append(this.indexes).append(":");
        }
        return builder.toString();
    }

    public String getPartition() {
        return Eucalyptus.INSTANCE.getName();
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"security-group", this.getNetworkGroup().getDisplayName(), "tag", this.getTag().toString()});
    }

    boolean teardown() {
        if (!this.indexes.isEmpty()) {
            for (PrivateNetworkIndex index : this.indexes) {
                switch ((Reference.State)index.getState()) {
                    case PENDING: {
                        if (index.lastUpdateMillis() < TimeUnit.MINUTES.toMillis(NetworkGroups.NETWORK_INDEX_PENDING_TIMEOUT.intValue())) {
                            LOG.warn((Object)("Failing teardown of extant network " + (Object)((Object)this) + ": Found pending index " + index + " which is within the timeout window."));
                            return false;
                        }
                        this.indexes.remove(index);
                        try {
                            index.release();
                            index.teardown();
                        }
                        catch (ResourceAllocationException ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                        }
                        break;
                    }
                    case EXTANT: {
                        LOG.warn((Object)("Failing teardown of extant network " + (Object)((Object)this) + ": Found extant index " + index + "."));
                        return false;
                    }
                    case UNKNOWN: 
                    case FREE: 
                    case RELEASING: {
                        this.indexes.remove(index);
                        try {
                            index.release();
                            index.teardown();
                            break;
                        }
                        catch (ResourceAllocationException ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                        }
                    }
                }
            }
        }
        this.indexes.clear();
        return true;
    }

    private static final class NetworkIndexKey {
        private Integer tag;
        private Long index;

        private NetworkIndexKey(Integer tag, Long index) {
            this.tag = tag;
            this.index = index;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            NetworkIndexKey that = (NetworkIndexKey)o;
            if (this.index != null ? !this.index.equals(that.index) : that.index != null) {
                return false;
            }
            return !(this.tag != null ? !this.tag.equals(that.tag) : that.tag != null);
        }

        public int hashCode() {
            int result = this.tag != null ? this.tag.hashCode() : 0;
            result = 31 * result + (this.index != null ? this.index.hashCode() : 0);
            return result;
        }
    }
}

