/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.keys;

import com.eucalyptus.auth.principal.Principals;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.Type;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_keypairs")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class SshKeyPair
extends UserMetadata<State>
implements CloudMetadata.KeyPairMetadata {
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="metadata_keypair_public_key")
    private String publicKey;
    @Column(name="metadata_keypair_finger_print")
    private String fingerPrint;

    SshKeyPair() {
    }

    SshKeyPair(OwnerFullName userFullName, String keyName) {
        super(userFullName, keyName);
    }

    SshKeyPair(OwnerFullName user) {
        super(user);
    }

    SshKeyPair(OwnerFullName user, String keyName, String publicKey, String fingerPrint) {
        this(user, keyName);
        this.publicKey = publicKey;
        this.fingerPrint = fingerPrint;
    }

    public String getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(String publicKey) {
        this.publicKey = publicKey;
    }

    public String getFingerPrint() {
        return this.fingerPrint;
    }

    public void setFingerPrint(String fingerPrint) {
        this.fingerPrint = fingerPrint;
    }

    public String toString() {
        return String.format("SshKeyPair:%s:fingerPrint=%s", this.getUniqueName(), this.fingerPrint);
    }

    public String getPartition() {
        return ((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name();
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"keypair", this.getDisplayName()});
    }

    static SshKeyPair noKey() {
        return new SshKeyPair(Principals.nobodyFullName(), "nokey", "", "");
    }

    public static SshKeyPair named(OwnerFullName ownerFullName, String keyName) {
        return new SshKeyPair(ownerFullName, keyName);
    }

    public static SshKeyPair create(UserFullName userFullName, String keyName) {
        return new SshKeyPair((OwnerFullName)userFullName, keyName);
    }

    public static SshKeyPair withPublicKey(OwnerFullName ownerFullName, String keyValue) {
        return new SshKeyPair(ownerFullName, null, keyValue, null);
    }

    public static SshKeyPair withPublicKey(OwnerFullName ownerFullName, String keyName, String keyValue) {
        return new SshKeyPair(ownerFullName, keyName, keyValue, null);
    }

    static enum State {
        available,
        removing;

    }
}

