/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.keys;

import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.cloud.util.DuplicateMetadataException;
import com.eucalyptus.cloud.util.MetadataCreationException;
import com.eucalyptus.cloud.util.MetadataException;
import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.crypto.Certs;
import com.eucalyptus.crypto.Digest;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.keys.NoSuchKeyMetadataException;
import com.eucalyptus.keys.SshKeyPair;
import com.eucalyptus.records.Logs;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.primitives.Ints;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.RSAPublicKeySpec;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.DecoderException;
import org.hibernate.criterion.Criterion;
import org.hibernate.exception.ConstraintViolationException;

public class KeyPairs {
    private static Logger LOG = Logger.getLogger(KeyPairs.class);
    private static SshKeyPair NO_KEY = SshKeyPair.noKey();
    public static String NO_KEY_NAME = "";

    public static SshKeyPair noKey() {
        return NO_KEY;
    }

    public static List<SshKeyPair> list(OwnerFullName ownerFullName) throws NoSuchMetadataException {
        try {
            return Transactions.findAll((Object)((Object)SshKeyPair.named(ownerFullName, null)));
        }
        catch (Exception e) {
            throw new NoSuchMetadataException("Failed to find key pairs for " + ownerFullName, e);
        }
    }

    public static List<SshKeyPair> list(OwnerFullName ownerFullName, Predicate<? super SshKeyPair> filter, Criterion criterion, Map<String, String> aliases) throws NoSuchMetadataException {
        try {
            return Transactions.filter((Object)((Object)SshKeyPair.named(ownerFullName, null)), filter, (Criterion)criterion, aliases);
        }
        catch (Exception e) {
            throw new NoSuchMetadataException("Failed to find key pairs for " + ownerFullName, e);
        }
    }

    public static SshKeyPair lookup(OwnerFullName ownerFullName, String keyName) throws NoSuchMetadataException {
        try {
            return (SshKeyPair)((Object)Transactions.find((Object)((Object)new SshKeyPair(ownerFullName, keyName))));
        }
        catch (Exception e) {
            throw new NoSuchKeyMetadataException("Failed to find key pair: " + keyName + " for " + ownerFullName, e);
        }
    }

    public static void delete(OwnerFullName ownerFullName, String keyName) throws NoSuchMetadataException {
        EntityTransaction db = Entities.get(SshKeyPair.class);
        try {
            SshKeyPair entity = (SshKeyPair)((Object)Entities.uniqueResult((Object)((Object)SshKeyPair.named(ownerFullName, keyName))));
            Entities.delete((Object)((Object)entity));
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
            throw new NoSuchKeyMetadataException("Failed to find key pair: " + keyName + " for " + ownerFullName, ex);
        }
    }

    public static SshKeyPair fromPublicKey(OwnerFullName ownerFullName, String keyValue) throws NoSuchMetadataException {
        try {
            return (SshKeyPair)((Object)Transactions.find((Object)((Object)SshKeyPair.withPublicKey(ownerFullName, keyValue))));
        }
        catch (Exception e) {
            throw new NoSuchMetadataException("Failed to find key pair with public key: " + keyValue + " for " + ownerFullName, e);
        }
    }

    public static PrivateKey create(UserFullName userName, String keyName) throws MetadataException, TransactionException {
        SshKeyPair newKey = SshKeyPair.create(userName, keyName);
        KeyPair newKeys = null;
        try {
            newKeys = Certs.generateKeyPair();
            String authKeyString = KeyPairs.getAuthKeyString(userName, keyName, newKeys);
            newKey.setPublicKey(authKeyString);
            newKey.setFingerPrint(Certs.getFingerPrint((Key)newKeys.getPrivate()));
        }
        catch (Exception e) {
            throw new MetadataCreationException("KeyPair generation error: Key pair creation failed.", e);
        }
        try {
            Transactions.save((Object)((Object)newKey));
        }
        catch (ConstraintViolationException ex) {
            Logs.exhaust().error((Object)ex);
            throw new DuplicateMetadataException("Failed to create keypair '" + keyName + "', already exists.");
        }
        return newKeys.getPrivate();
    }

    public static RSAPublicKey decodeSshRsaPublicKey(String publicKeyB64) throws GeneralSecurityException {
        byte[] data;
        try {
            data = B64.standard.dec((String)publicKeyB64);
        }
        catch (ArrayIndexOutOfBoundsException | StringIndexOutOfBoundsException | DecoderException e) {
            throw new GeneralSecurityException("Invalid key format (expected Base64)");
        }
        if (data.length < 64) {
            throw new InvalidKeyException("Data too short");
        }
        int length = Ints.fromBytes((byte)data[0], (byte)data[1], (byte)data[2], (byte)data[3]);
        if (length != 7 || data[4] != 115 || data[5] != 115 || data[6] != 104 || data[7] != 45 || data[8] != 114 || data[9] != 115 || data[10] != 97) {
            throw new InvalidKeyException("Not an RSA key");
        }
        int exponentLength = Ints.fromBytes((byte)data[11], (byte)data[12], (byte)data[13], (byte)data[14]);
        if (exponentLength <= 0 || exponentLength > 4) {
            throw new InvalidKeyException("Invalid RSA exponent");
        }
        int modulusLength = Ints.fromBytes((byte)data[15 + exponentLength], (byte)data[16 + exponentLength], (byte)data[17 + exponentLength], (byte)data[18 + exponentLength]);
        if (modulusLength <= 0 || modulusLength > 513 || data.length < 19 + exponentLength + modulusLength) {
            throw new InvalidKeyException("Invalid RSA modulus");
        }
        BigInteger modulus = KeyPairs.intFromBytes(data, 19 + exponentLength, modulusLength);
        BigInteger exponent = KeyPairs.intFromBytes(data, 15, exponentLength);
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        RSAPublicKeySpec spec = new RSAPublicKeySpec(modulus, exponent);
        PublicKey key = keyFactory.generatePublic(spec);
        return (RSAPublicKey)key;
    }

    public static String rfc4253Format(UserFullName userName, String keyName, RSAPublicKey publicKey) {
        return KeyPairs.getAuthKeyString(userName.getAccountNumber(), keyName, publicKey);
    }

    public static String getPublicKeyFingerprint(RSAPublicKey publicKey) {
        try {
            MessageDigest digest = Digest.MD5.get();
            byte[] fingerprint = digest.digest(KeyPairs.encodeSshRsaPublicKey(publicKey));
            StringBuilder sb = new StringBuilder();
            for (byte b : fingerprint) {
                sb.append(String.format("%02X:", b));
            }
            return sb.substring(0, sb.length() - 1).toLowerCase();
        }
        catch (Exception e) {
            LOG.error((Object)("Error generating fingerprint: " + e.getMessage()), (Throwable)e);
            return null;
        }
    }

    private static String getAuthKeyString(UserFullName userName, String keyName, KeyPair newKeys) {
        RSAPublicKey publicKey = (RSAPublicKey)newKeys.getPublic();
        return KeyPairs.getAuthKeyString(userName.getAccountNumber(), keyName, publicKey);
    }

    private static byte[] encodeSshRsaPublicKey(RSAPublicKey publicKey) {
        byte[] keyType = "ssh-rsa".getBytes();
        byte[] expBlob = publicKey.getPublicExponent().toByteArray();
        byte[] modBlob = publicKey.getModulus().toByteArray();
        byte[] authKeyBlob = new byte[12 + keyType.length + expBlob.length + modBlob.length];
        byte[] lenArray = null;
        lenArray = BigInteger.valueOf(keyType.length).toByteArray();
        System.arraycopy(lenArray, 0, authKeyBlob, 4 - lenArray.length, lenArray.length);
        System.arraycopy(keyType, 0, authKeyBlob, 4, keyType.length);
        lenArray = BigInteger.valueOf(expBlob.length).toByteArray();
        System.arraycopy(lenArray, 0, authKeyBlob, 4 + keyType.length + 4 - lenArray.length, lenArray.length);
        System.arraycopy(expBlob, 0, authKeyBlob, 4 + (4 + keyType.length), expBlob.length);
        lenArray = BigInteger.valueOf(modBlob.length).toByteArray();
        System.arraycopy(lenArray, 0, authKeyBlob, 4 + expBlob.length + 4 + keyType.length + 4 - lenArray.length, lenArray.length);
        System.arraycopy(modBlob, 0, authKeyBlob, 4 + (4 + expBlob.length + (4 + keyType.length)), modBlob.length);
        return authKeyBlob;
    }

    private static String getAuthKeyString(String userDesc, String keyName, RSAPublicKey publicKey) {
        byte[] authKeyBlob = KeyPairs.encodeSshRsaPublicKey(publicKey);
        return String.format("ssh-rsa %s %s@eucalyptus.%s", B64.standard.encString((byte[])authKeyBlob), userDesc, keyName);
    }

    private static BigInteger intFromBytes(byte[] data, int index, int length) {
        byte[] intBytes = new byte[length];
        System.arraycopy(data, index, intBytes, 0, length);
        return new BigInteger(intBytes);
    }

    private static enum FilterFunctions implements Function<SshKeyPair, String>
    {
        FINGERPRINT{

            public String apply(SshKeyPair keyPair) {
                return keyPair.getFingerPrint();
            }
        };

    }

    public static class KeyPairFilterSupport
    extends FilterSupport<SshKeyPair> {
        public KeyPairFilterSupport() {
            super(KeyPairFilterSupport.builderFor(SshKeyPair.class).withStringProperty("fingerprint", FilterFunctions.FINGERPRINT).withStringProperty("key-name", (Function<SshKeyPair, String>)CloudMetadatas.toDisplayName()).withPersistenceFilter("fingerprint", "fingerPrint").withPersistenceFilter("key-name", "displayName"));
        }
    }
}

