/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.keys;

import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.keys.SshKeyPair;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.collect.Lists;
import java.util.List;
import javax.persistence.EntityTransaction;
import org.apache.log4j.Logger;

public class KeyPairUtil {
    private static Logger LOG = Logger.getLogger(KeyPairUtil.class);

    public static List<SshKeyPair> getUserKeyPairs(OwnerFullName ownerFullName) {
        EntityTransaction db = Entities.get(SshKeyPair.class);
        List keys = Lists.newArrayList();
        try {
            keys = Entities.query((Object)((Object)SshKeyPair.named(ownerFullName, null)));
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
        }
        return keys;
    }

    public static SshKeyPair deleteUserKeyPair(UserFullName userFullName, String keyName) throws EucalyptusCloudException {
        EntityTransaction db = Entities.get(SshKeyPair.class);
        SshKeyPair key = null;
        try {
            key = (SshKeyPair)((Object)Entities.uniqueResult((Object)((Object)new SshKeyPair((OwnerFullName)userFullName, keyName))));
            Entities.delete((Object)((Object)key));
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            throw new EucalyptusCloudException("Failed to find key pair: " + keyName, (Throwable)e);
        }
        return key;
    }
}

