/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.keys;

import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.cloud.util.DuplicateMetadataException;
import com.eucalyptus.compute.ClientComputeException;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.DescribeKeyPairsResponseItemType;
import com.eucalyptus.compute.common.backend.CreateKeyPairResponseType;
import com.eucalyptus.compute.common.backend.CreateKeyPairType;
import com.eucalyptus.compute.common.backend.DeleteKeyPairResponseType;
import com.eucalyptus.compute.common.backend.DeleteKeyPairType;
import com.eucalyptus.compute.common.backend.DescribeKeyPairsResponseType;
import com.eucalyptus.compute.common.backend.DescribeKeyPairsType;
import com.eucalyptus.compute.common.backend.ImportKeyPairResponseType;
import com.eucalyptus.compute.common.backend.ImportKeyPairType;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.IllegalContextAccessException;
import com.eucalyptus.crypto.Certs;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.keys.KeyPairs;
import com.eucalyptus.keys.SshKeyPair;
import com.eucalyptus.tags.Filter;
import com.eucalyptus.tags.Filters;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.CharMatcher;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.io.CharStreams;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.PrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collection;
import java.util.NoSuchElementException;
import javax.persistence.PersistenceException;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.util.encoders.DecoderException;

public class KeyPairManager {
    private static Logger LOG = Logger.getLogger(KeyPairManager.class);

    public DescribeKeyPairsResponseType describe(DescribeKeyPairsType request) throws Exception {
        DescribeKeyPairsResponseType reply = (DescribeKeyPairsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean showAll = request.getKeySet().remove("verbose");
        AccountFullName ownerFullName = ctx.isAdministrator() && showAll ? null : Contexts.lookup().getUserFullName().asAccountFullName();
        Filter filter = Filters.generate(request.getFilterSet(), SshKeyPair.class);
        Predicate requestedAndAccessible = CloudMetadatas.filteringFor(SshKeyPair.class).byId((Collection)request.getKeySet()).byPredicate(filter.asPredicate()).byPrivileges().buildPredicate();
        ArrayList<String> foundKeyNameList = new ArrayList<String>();
        for (SshKeyPair kp : KeyPairs.list((OwnerFullName)ownerFullName, (Predicate<? super SshKeyPair>)requestedAndAccessible, filter.asCriterion(), filter.getAliases())) {
            reply.getKeySet().add(new DescribeKeyPairsResponseItemType(kp.getDisplayName(), kp.getFingerPrint()));
            foundKeyNameList.add(kp.getDisplayName());
        }
        if (!request.getKeySet().isEmpty() && request.getKeySet().size() != reply.getKeySet().size()) {
            ImmutableList reverseRequestedKeySet = ImmutableList.copyOf((Collection)request.getKeySet()).reverse();
            for (String requestedKey : reverseRequestedKeySet) {
                if (foundKeyNameList.contains(requestedKey)) continue;
                throw new ClientComputeException("InvalidKeyPair.NotFound", "The key pair '" + requestedKey + "' does not exist");
            }
        }
        return reply;
    }

    public DeleteKeyPairResponseType delete(DeleteKeyPairType request) throws EucalyptusCloudException {
        DeleteKeyPairResponseType reply = (DeleteKeyPairResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        try {
            SshKeyPair key = KeyPairs.lookup((OwnerFullName)ctx.getUserFullName().asAccountFullName(), request.getKeyName());
            if (!RestrictedTypes.filterPrivileged().apply((Object)key)) {
                throw new EucalyptusCloudException("Permission denied while trying to delete keypair " + key.getName() + " by " + ctx.getUser());
            }
            KeyPairs.delete((OwnerFullName)ctx.getUserFullName().asAccountFullName(), request.getKeyName());
            reply.set_return(Boolean.valueOf(true));
        }
        catch (Exception e1) {
            LOG.error((Object)e1);
            reply.set_return(Boolean.valueOf(false));
        }
        return reply;
    }

    public CreateKeyPairResponseType create(CreateKeyPairType request) throws AuthException, EucalyptusCloudException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        final CreateKeyPairResponseType reply = (CreateKeyPairResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        final String keyName = request.getKeyName();
        if (!CharMatcher.ASCII.matchesAllOf((CharSequence)keyName)) {
            throw new ClientComputeException("InvalidParameterValue", "Value (" + keyName + ") for parameter KeyName is invalid. Character sets beyond ASCII are not supported.");
        }
        try {
            Supplier<SshKeyPair> allocator = new Supplier<SshKeyPair>(){

                public SshKeyPair get() {
                    try {
                        PrivateKey pk = KeyPairs.create(ctx.getUserFullName(), keyName);
                        reply.setKeyFingerprint(Certs.getFingerPrint((Key)pk));
                        ByteArrayOutputStream byteOut = new ByteArrayOutputStream();
                        PEMWriter privOut = new PEMWriter((Writer)new OutputStreamWriter(byteOut));
                        try {
                            privOut.writeObject((Object)pk);
                            privOut.close();
                        }
                        catch (IOException e) {
                            LOG.error((Object)e);
                            throw new EucalyptusCloudException((Throwable)e);
                        }
                        reply.setKeyName(keyName);
                        reply.setKeyMaterial(byteOut.toString());
                        return KeyPairs.lookup((OwnerFullName)ctx.getUserFullName(), keyName);
                    }
                    catch (Exception ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
            RestrictedTypes.allocateUnitlessResource((Supplier)allocator);
            return reply;
        }
        catch (Exception ex) {
            String cause = Exceptions.causeString((Throwable)ex);
            if (Exceptions.isCausedBy((Throwable)ex, DuplicateMetadataException.class)) {
                throw new ClientComputeException("InvalidKeyPair.Duplicate", "The keypair '" + keyName + "' already exists.");
            }
            throw new EucalyptusCloudException("CreateKeyPair failed because: " + cause, (Throwable)ex);
        }
    }

    public ImportKeyPairResponseType importKeyPair(final ImportKeyPairType request) throws AuthException, EucalyptusCloudException {
        final ImportKeyPairResponseType reply = (ImportKeyPairResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        boolean duplicate = false;
        try {
            KeyPairs.lookup((OwnerFullName)ctx.getUserFullName(), request.getKeyName());
            duplicate = true;
        }
        catch (Exception e1) {
            try {
                final RSAPublicKey key = KeyPairManager.decodeKeyMaterial(request.getPublicKeyMaterial());
                final String keyFingerprint = KeyPairs.getPublicKeyFingerprint(key);
                if (keyFingerprint == null) {
                    throw new GeneralSecurityException("Error generating fingerprint");
                }
                Supplier<SshKeyPair> allocator = new Supplier<SshKeyPair>(){

                    public SshKeyPair get() {
                        SshKeyPair newKey = new SshKeyPair((OwnerFullName)ctx.getUserFullName(), request.getKeyName());
                        newKey.setFingerPrint(keyFingerprint);
                        newKey.setPublicKey(KeyPairs.rfc4253Format(ctx.getUserFullName(), request.getKeyName(), key));
                        try {
                            Transactions.save((Object)((Object)newKey));
                            reply.setKeyName(newKey.getDisplayName());
                            reply.setKeyFingerprint(newKey.getFingerPrint());
                        }
                        catch (TransactionException e) {
                            LOG.warn((Object)"Error saving imported key", (Throwable)e);
                        }
                        return newKey;
                    }
                };
                RestrictedTypes.allocateUnitlessResource((Supplier)allocator);
            }
            catch (GeneralSecurityException e) {
                LOG.warn((Object)"Error importing SSH public key", (Throwable)e);
                throw new ClientComputeException("InvalidKey.Format", "Invalid or unsupported key format");
            }
        }
        if (duplicate) {
            throw new ClientComputeException("InvalidKeyPair.Duplicate", "The keypair '" + request.getKeyName() + "' already exists.");
        }
        return reply;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static RSAPublicKey decodeKeyMaterial(String b64EncodedKeyMaterial) throws GeneralSecurityException {
        RSAPublicKey key;
        String decoded;
        try {
            decoded = B64.standard.decString((String)b64EncodedKeyMaterial);
        }
        catch (ArrayIndexOutOfBoundsException | StringIndexOutOfBoundsException | DecoderException e) {
            throw new GeneralSecurityException("Invalid key material (expected Base64)");
        }
        if (decoded.startsWith("ssh-rsa ")) {
            String[] keyParts = decoded.split("\\s+");
            if (keyParts.length <= 1) throw new GeneralSecurityException("Invalid SSH key format");
            key = KeyPairs.decodeSshRsaPublicKey(keyParts[1]);
        } else if (decoded.startsWith("---- BEGIN SSH2 PUBLIC KEY ----")) {
            String keyB64;
            try {
                keyB64 = Joiner.on((String)"\n").join(Iterables.filter((Iterable)CharStreams.readLines((Readable)new StringReader(decoded)), (Predicate)new Predicate<String>(){
                    boolean continueLine = false;
                    boolean sawEnd = false;

                    public boolean apply(String line) {
                        boolean bl = this.sawEnd = this.sawEnd || line.contains("---- END SSH2 PUBLIC KEY ----");
                        if (line.contains("---- BEGIN SSH2 PUBLIC KEY ----") || this.sawEnd) {
                            this.continueLine = false;
                            return false;
                        }
                        if (this.continueLine || line.contains(":")) {
                            this.continueLine = line.endsWith("\\");
                            return false;
                        }
                        return true;
                    }
                }));
            }
            catch (IOException e) {
                throw new GeneralSecurityException("Error reading key data");
            }
            key = KeyPairs.decodeSshRsaPublicKey(keyB64);
        } else {
            try {
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                X509EncodedKeySpec encodedSpec = new X509EncodedKeySpec(B64.standard.dec((String)decoded));
                key = (RSAPublicKey)keyFactory.generatePublic(encodedSpec);
            }
            catch (ArrayIndexOutOfBoundsException | StringIndexOutOfBoundsException | DecoderException e) {
                throw new GeneralSecurityException("Invalid key material");
            }
        }
        int keySize = key.getModulus().bitLength();
        if (keySize == 1024 || keySize == 2048 || keySize == 4096) return key;
        throw new GeneralSecurityException("Invalid key size: " + keySize);
    }
}

