/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.StaticDiskImage;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Parameters;
import javax.persistence.Column;
import javax.persistence.Lob;
import javax.persistence.MappedSuperclass;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.annotations.Type;

@MappedSuperclass
public class PutGetImageInfo
extends ImageInfo
implements StaticDiskImage {
    @Column(name="metadata_image_manifest_path")
    private String manifestLocation;
    @Lob
    @Type(type="org.hibernate.type.StringClobType")
    @Column(name="metadata_image_signature")
    private String signature;
    @Column(name="metadata_image_unencrypted_checksum")
    private String checksum;
    @Column(name="metadata_image_unencrypted_checksum_type")
    private String checksumType;
    @Column(name="metadata_image_bundle_size")
    private Long bundleSizeBytes;
    @Column(name="metadata_image_manifest_hash")
    private String manifestHash;

    protected PutGetImageInfo(UserFullName userFullName, String imageId, ImageMetadata.Type imageType, String imageName, String imageDescription, Long imageSizeBytes, ImageMetadata.Architecture arch, ImageMetadata.Platform platform, String manifestLocation, Long imageBundleSizeBytes, String imageChecksum, String imageChecksumType) {
        super((OwnerFullName)userFullName, imageId, imageType, imageName, imageDescription, imageSizeBytes, arch, platform);
        Parameters.checkParam((Object)manifestLocation, (Matcher)Matchers.notNullValue());
        this.manifestLocation = manifestLocation;
        this.bundleSizeBytes = imageBundleSizeBytes;
        this.checksum = imageChecksum;
        this.checksumType = imageChecksumType;
    }

    protected PutGetImageInfo(ImageMetadata.Type imageType) {
        super(imageType);
    }

    protected PutGetImageInfo(ImageMetadata.Type imageType, String imageId) {
        super(imageType, imageId);
    }

    public String getSignature() {
        return this.signature;
    }

    public void setSignature(String signature) {
        this.signature = signature;
    }

    public String getManifestLocation() {
        return this.manifestLocation;
    }

    public void setManifestLocation(String manifestLocation) {
        this.manifestLocation = manifestLocation;
    }

    public Long getBundleSizeBytes() {
        return this.bundleSizeBytes;
    }

    public void setBundleSizeBytes(Long bundleSizeBytes) {
        this.bundleSizeBytes = bundleSizeBytes;
    }

    public String getChecksum() {
        return this.checksum;
    }

    public void setChecksum(String checksum) {
        this.checksum = checksum;
    }

    public String getChecksumType() {
        return this.checksumType;
    }

    public void setChecksumType(String checksumType) {
        this.checksumType = checksumType;
    }

    public String getManifestHash() {
        return this.manifestHash;
    }

    public void setManifestHash(String manifestHash) {
        this.manifestHash = manifestHash;
    }

    public String getRunManifestLocation() {
        return this.getManifestLocation();
    }
}

