/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.images.BootableImageInfo;
import com.eucalyptus.images.PutGetImageInfo;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PersistenceContext;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="machine")
public class MachineImageInfo
extends PutGetImageInfo
implements BootableImageInfo {
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_image_kernel_id")
    private String kernelId;
    @Column(name="metadata_image_ramdisk_id")
    private String ramdiskId;
    @Column(name="metadata_image_ami")
    private String ami;
    @Column(name="metadata_image_root_directive")
    private String rootDirective;
    @Column(name="metadata_image_virtualization_type")
    @Enumerated(value=EnumType.STRING)
    private ImageMetadata.VirtualizationType virtType;
    @Column(name="metadata_image_conversion_id", nullable=true)
    private String imageConversionId;
    @Column(name="metadata_image_run_manifest_path")
    private String runManifestLocation;

    public MachineImageInfo() {
        super(ImageMetadata.Type.machine);
    }

    public MachineImageInfo(String imageId) {
        super(ImageMetadata.Type.machine, imageId);
    }

    public MachineImageInfo(UserFullName userFullName, String imageId, String imageName, String imageDescription, Long imageSizeBytes, ImageMetadata.Architecture arch, ImageMetadata.Platform platform, String imageLocation, Long imageBundleSizeBytes, String imageChecksum, String imageChecksumType, String kernelId, String ramdiskId, ImageMetadata.VirtualizationType virtType, String ami, String root) {
        super(userFullName, imageId, ImageMetadata.Type.machine, imageName, imageDescription, imageSizeBytes, arch, platform, imageLocation, imageBundleSizeBytes, imageChecksum, imageChecksumType);
        this.kernelId = kernelId;
        this.ramdiskId = ramdiskId;
        this.virtType = virtType;
        this.ami = ami;
        this.rootDirective = root;
    }

    @Override
    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    @Override
    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    @Override
    public boolean hasKernel() {
        return this.getKernelId() != null;
    }

    @Override
    public boolean hasRamdisk() {
        return this.getRamdiskId() != null;
    }

    @Override
    public String getManifestLocation() {
        return super.getManifestLocation();
    }

    @Override
    public String getRootDeviceName() {
        if (this.ami == null || this.ami.isEmpty()) {
            return this.virtType == ImageMetadata.VirtualizationType.hvm ? "/dev/sda" : "/dev/sda1";
        }
        return this.ami.startsWith("/dev/") ? this.ami : "/dev/" + this.ami;
    }

    public String getShortRootDeviceName() {
        return this.getRootDeviceName().substring(5);
    }

    public String getRootDirective() {
        return this.rootDirective;
    }

    @Override
    public String getRootDeviceType() {
        return "instance-store";
    }

    @Override
    public ImageMetadata.VirtualizationType getVirtualizationType() {
        return this.virtType;
    }

    public void setVirtualizationType(ImageMetadata.VirtualizationType virtType) {
        this.virtType = virtType;
    }

    public void setImageConversionId(String conversionId) {
        this.imageConversionId = conversionId;
    }

    public String getImageConversionId() {
        return this.imageConversionId;
    }

    @Override
    public String getRunManifestLocation() {
        return this.runManifestLocation;
    }

    public void setRunManifestLocation(String runManifestLocation) {
        this.runManifestLocation = runManifestLocation;
    }

    @Upgrades.EntityUpgrade(entities={MachineImageInfo.class}, since=Upgrades.Version.v4_0_0, value=Eucalyptus.class)
    public static enum MachineImageInfo400Upgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(Class arg0) {
            Throwable throwable = null;
            try (TransactionResource db = Entities.transactionFor(MachineImageInfo.class);){
                List images = Entities.query((Object)new MachineImageInfo());
                for (MachineImageInfo image : images) {
                    LOG.info((Object)("Upgrading MachineImageInfo: " + image.toString()));
                    if (ImageMetadata.VirtualizationType.paravirtualized.equals((Object)image.virtType)) {
                        image.setState((Enum)ImageMetadata.State.pending_available);
                        image.setImageFormat(ImageMetadata.ImageFormat.partitioned.name());
                    } else {
                        image.setImageFormat(ImageMetadata.ImageFormat.fulldisk.name());
                        image.setRunManifestLocation(image.getManifestLocation());
                    }
                    Entities.persist((Object)image);
                }
                db.commit();
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                try {
                    LOG.error((Object)"Error upgrading MachineImageInfo: ", (Throwable)ex);
                    db.rollback();
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
        }

        static {
            LOG = Logger.getLogger(MachineImageInfo400Upgrade.class);
        }
    }

    @Upgrades.EntityUpgrade(entities={MachineImageInfo.class}, since=Upgrades.Version.v3_4_0, value=Eucalyptus.class)
    public static enum MachineImageInfo340Upgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(@Nullable Class arg0) {
            EntityTransaction db = Entities.get(MachineImageInfo.class);
            try {
                List images = Entities.query((Object)new MachineImageInfo());
                for (MachineImageInfo image : images) {
                    LOG.info((Object)("Upgrading MachineImageInfo: " + image.toString()));
                    if (image.virtType != null) continue;
                    if (ImageMetadata.Platform.windows.equals((Object)image.getPlatform())) {
                        image.virtType = ImageMetadata.VirtualizationType.hvm;
                    } else {
                        image.virtType = ImageMetadata.VirtualizationType.paravirtualized;
                    }
                    Entities.persist((Object)image);
                }
                db.commit();
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                LOG.error((Object)"Error upgrading MachineImageInfo: ", (Throwable)ex);
                db.rollback();
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
        }

        static {
            LOG = Logger.getLogger(MachineImageInfo340Upgrade.class);
        }
    }
}

