/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.blockstorage.Snapshot;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.bootstrap.Databases;
import com.eucalyptus.cloud.util.MetadataException;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.BlockDeviceMappingItemType;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.EbsDeviceMapping;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.StaticDiskImage;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionExecutionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Hertz;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.images.BlockStorageDeviceMapping;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.images.BootableImageInfo;
import com.eucalyptus.images.DeviceMapping;
import com.eucalyptus.images.EphemeralDeviceMapping;
import com.eucalyptus.images.ImageConfiguration;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.images.ImageInfoTag;
import com.eucalyptus.images.ImageManager;
import com.eucalyptus.images.ImageManifests;
import com.eucalyptus.images.InstanceNotTerminatedException;
import com.eucalyptus.images.KernelImageInfo;
import com.eucalyptus.images.MachineImageInfo;
import com.eucalyptus.images.NoSuchImageException;
import com.eucalyptus.images.PutGetImageInfo;
import com.eucalyptus.images.RamdiskImageInfo;
import com.eucalyptus.images.StaticDiskImages;
import com.eucalyptus.images.SuppressDeviceMappping;
import com.eucalyptus.records.Logs;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.Strings;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.vm.VmVolumeAttachment;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.exception.ConstraintViolationException;

public class Images {
    private static Logger LOG = Logger.getLogger(Images.class);
    static final String SELF = "self";
    public static final String DEFAULT_ROOT_DEVICE = "/dev/sda";
    public static final String DEFAULT_PARTITIONED_ROOT_DEVICE = "/dev/sda1";
    public static final String DEFAULT_EPHEMERAL_DEVICE = "/dev/sdb";
    public static Function<ImageInfo, ImageDetails> TO_IMAGE_DETAILS = new Function<ImageInfo, ImageDetails>(){

        public ImageDetails apply(ImageInfo input) {
            return (ImageDetails)TypeMappers.transform((Object)((Object)input), ImageDetails.class);
        }
    };
    public static ImageInfo ALL = new ImageInfo();

    public static Predicate<ImageInfo> filterExecutableBy(final Collection<String> executableSet) {
        final boolean executableSelf = executableSet.remove(SELF);
        final boolean executableAll = executableSet.remove("all");
        return new Predicate<ImageInfo>(){

            public boolean apply(ImageInfo image) {
                if (executableSet.isEmpty() && !executableSelf && !executableAll) {
                    return true;
                }
                UserFullName userFullName = Contexts.lookup().getUserFullName();
                return executableAll && image.getImagePublic() != false || executableSelf && image.hasPermission(userFullName.getAccountNumber()) || image.hasPermission(executableSet.toArray(new String[executableSet.size()]));
            }
        };
    }

    public static Function<BlockDeviceMappingItemType, DeviceMapping> deviceMappingGenerator(ImageInfo parent, Integer rootVolSize) {
        return Images.deviceMappingGenerator(parent, rootVolSize, Collections.emptyMap());
    }

    public static Function<BlockDeviceMappingItemType, DeviceMapping> deviceMappingGenerator(final ImageInfo parent, final Integer rootVolSize, final Map<String, String> deviceNameMap) {
        return new Function<BlockDeviceMappingItemType, DeviceMapping>(){

            /*
             * Unable to fully structure code
             */
            public DeviceMapping apply(BlockDeviceMappingItemType input) {
                Parameters.checkParam((Object)input, (Matcher)Matchers.notNullValue());
                Parameters.checkParam((Object)input.getDeviceName(), (Matcher)Matchers.notNullValue());
                if (Images.isEbsMapping(input).booleanValue()) {
                    ebsInfo = input.getEbs();
                    size = -1;
                    snapshotId = (String)ResourceIdentifiers.tryNormalize().apply((Object)ebsInfo.getSnapshotId());
                    if (ebsInfo.getVolumeSize() != null) {
                        size = ebsInfo.getVolumeSize();
                    } else if (ebsInfo.getSnapshotId() != null) {
                        try {
                            snap = (Snapshot)Transactions.find((Object)Snapshot.named(null, snapshotId));
                            size = snap.getVolumeSize();
                            if (ebsInfo.getVolumeSize() == null || ebsInfo.getVolumeSize() < snap.getVolumeSize()) ** GOTO lbl25
                            size = ebsInfo.getVolumeSize();
                        }
                        catch (NoSuchElementException ex) {
                            throw Exceptions.toUndeclared((Throwable)new MetadataException("Snapshot " + ebsInfo.getSnapshotId() + " does not exist"));
                        }
                        catch (ExecutionException ex) {
                            Images.access$000().error((Object)("Unable to find snapshot " + ebsInfo.getSnapshotId()), (Throwable)ex);
                            throw Exceptions.toUndeclared((Throwable)new MetadataException("Snapshot " + ebsInfo.getSnapshotId() + " does not exist"));
                        }
                    } else {
                        size = rootVolSize;
                    }
lbl25:
                    // 4 sources

                    mappedDeviceName = deviceNameMap.containsKey(input.getDeviceName()) != false ? (String)deviceNameMap.get(input.getDeviceName()) : input.getDeviceName();
                    return new BlockStorageDeviceMapping(parent, mappedDeviceName, input.getEbs().getVirtualName(), snapshotId, size, ebsInfo.getDeleteOnTermination());
                }
                if (input.getVirtualName() != null) {
                    return new EphemeralDeviceMapping(parent, input.getDeviceName(), input.getVirtualName());
                }
                return new SuppressDeviceMappping(parent, input.getDeviceName());
            }
        };
    }

    public static Boolean isEbsMapping(BlockDeviceMappingItemType input) {
        if (!(input.getEbs() == null || input.getVirtualName() != null || input.getNoDevice() != null && input.getNoDevice().booleanValue())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static <T extends ImageInfo> Predicate<T> inState(final Set<ImageMetadata.State> states) {
        return new Predicate<T>(){

            public boolean apply(T imageInfo) {
                return states.contains(imageInfo.getState());
            }
        };
    }

    public static Predicate<BlockStorageDeviceMapping> imageInState(final Set<ImageMetadata.State> states) {
        return new Predicate<BlockStorageDeviceMapping>(){

            public boolean apply(BlockStorageDeviceMapping arg0) {
                return states.contains(arg0.getParent().getState());
            }
        };
    }

    public static ArrayList<BlockDeviceMappingItemType> validateBlockDeviceMappings(List<BlockDeviceMappingItemType> bdms, Set<DeviceMappingValidationOption> options) throws MetadataException {
        ArrayList<BlockDeviceMappingItemType> resultedBdms = new ArrayList<BlockDeviceMappingItemType>();
        if (bdms != null) {
            HashSet deviceNames = Sets.newHashSet();
            boolean ephemeralAlreadyPresent = false;
            int ephemeralCount = 0;
            for (BlockDeviceMappingItemType bdm : bdms) {
                Parameters.checkParam((Object)bdm, (Matcher)Matchers.notNullValue());
                Parameters.checkParam((Object)bdm.getDeviceName(), (Matcher)Matchers.notNullValue());
                if (!deviceNames.add(bdm.getDeviceName().replace("/dev/", ""))) {
                    throw new MetadataException(bdm.getDeviceName() + " is assigned multiple times");
                }
                if (DeviceMappingValidationOption.SkipExtraEphemeral.present(options) && StringUtils.isNotBlank((String)bdm.getVirtualName())) {
                    if (ephemeralAlreadyPresent) continue;
                    ephemeralAlreadyPresent = true;
                }
                resultedBdms.add(bdm);
            }
            HashSet fullDeviceNames = Sets.newHashSet();
            for (String name : deviceNames) {
                fullDeviceNames.add(String.format("/dev/%s", name));
            }
            deviceNames = fullDeviceNames;
            for (BlockDeviceMappingItemType bdm : resultedBdms) {
                if (!bdm.getDeviceName().matches("(/dev/)?([svh]|xv)d[a-z]([1-9])*")) {
                    throw new MetadataException("Device name " + bdm.getDeviceName() + " is invalid");
                }
                if (bdm.getDeviceName().matches(".*\\d\\Z") && (!DeviceMappingValidationOption.AllowDevSda1.present(options) || !DEFAULT_PARTITIONED_ROOT_DEVICE.equals(bdm.getDeviceName()) || deviceNames.contains(DEFAULT_ROOT_DEVICE))) {
                    throw new MetadataException(bdm.getDeviceName() + " is not supported. Device name cannot be a partition");
                }
                if (bdm.getNoDevice() != null && bdm.getNoDevice().booleanValue()) {
                    if (DeviceMappingValidationOption.AllowSuppressMapping.present(options)) continue;
                    throw new MetadataException("Block device mapping for " + bdm.getDeviceName() + " cannot be suppressed");
                }
                if (StringUtils.isNotBlank((String)bdm.getVirtualName())) {
                    if (!bdm.getVirtualName().matches("ephemeral[0123]")) {
                        throw new MetadataException("Virtual device name must be of the form ephemeral[0123]. Fix the mapping for " + bdm.getDeviceName());
                    }
                    if (DeviceMappingValidationOption.SkipExtraEphemeral.present(options) || ++ephemeralCount <= 1) continue;
                    throw new MetadataException("Only one ephemeral device is supported. More than one ephemeral device mappings found");
                }
                if (null != bdm.getEbs()) {
                    if (!DeviceMappingValidationOption.AllowEbsMapping.present(options)) {
                        throw new MetadataException("Ebs block device mappings are not supported");
                    }
                    EbsDeviceMapping ebsInfo = bdm.getEbs();
                    if (ebsInfo.getSnapshotId() != null) {
                        Snapshot snap;
                        try {
                            snap = (Snapshot)((Object)Transactions.find((Object)((Object)Snapshot.named(null, (String)ResourceIdentifiers.tryNormalize().apply((Object)ebsInfo.getSnapshotId())))));
                        }
                        catch (Exception ex) {
                            LOG.error((Object)("Failed to find snapshot " + ebsInfo.getSnapshotId()), (Throwable)ex);
                            throw new MetadataException("Unable to find snapshot " + ebsInfo.getSnapshotId() + " in the block device mapping for " + bdm.getDeviceName());
                        }
                        if (ebsInfo.getVolumeSize() == null || ebsInfo.getVolumeSize() >= snap.getVolumeSize()) continue;
                        throw new MetadataException("Size of the volume cannot be smaller than the source snapshot for " + bdm.getDeviceName());
                    }
                    if (ebsInfo.getVolumeSize() == null || ebsInfo.getVolumeSize() != 0) continue;
                    throw new MetadataException("Volume size for " + bdm.getDeviceName() + " cannot be 0");
                }
                throw new MetadataException("Incorrectly constructed block device mapping for " + bdm.getDeviceName() + " . Refer to documentation");
            }
        }
        return resultedBdms;
    }

    public static boolean isImageNameValid(String imgName) {
        if (imgName == null) {
            return false;
        }
        if (!imgName.matches("[A-Za-z0-9()./_-]+")) {
            return false;
        }
        return imgName.length() >= 3 && imgName.length() <= 128;
    }

    public static boolean isImageDescriptionValid(String imgDescription) {
        if (imgDescription == null) {
            return false;
        }
        return imgDescription.length() <= 255;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<ImageInfo> listAllImages() {
        ArrayList images = Lists.newArrayList();
        EntityTransaction db = Entities.get(ImageInfo.class);
        try {
            List found = Entities.query((Object)((Object)ALL), (boolean)true);
            images.addAll(found);
            db.rollback();
        }
        catch (Exception e) {
            db.rollback();
            LOG.error((Object)"failed to query images", (Throwable)e);
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
        return images;
    }

    public static void enableImage(String imageId) throws NoSuchImageException {
        EntityTransaction db = Entities.get(ImageInfo.class);
        try {
            ImageInfo img = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(imageId))));
            img.setState((Enum)ImageMetadata.State.available);
            db.commit();
        }
        catch (NoSuchElementException e) {
            db.rollback();
            throw new NoSuchImageException("Failed to lookup image: " + imageId, (Throwable)e);
        }
        catch (Exception e) {
            db.rollback();
            throw new NoSuchImageException("Failed to lookup image: " + imageId, (Throwable)e);
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public static void setImageState(String imageId, ImageMetadata.State state) throws NoSuchImageException {
        EntityTransaction db = Entities.get(ImageInfo.class);
        try {
            ImageInfo img = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(imageId))));
            img.setState((Enum)state);
            db.commit();
        }
        catch (Exception e) {
            db.rollback();
            throw new NoSuchImageException("Failed to update image state: " + imageId);
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public static void deregisterImage(String imageId) throws NoSuchImageException, InstanceNotTerminatedException {
        EntityTransaction tx = Entities.get(ImageInfo.class);
        try {
            ImageInfo img = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(imageId))));
            if (ImageMetadata.State.deregistered.equals((Object)img.getState()) || ImageMetadata.State.failed.equals((Object)img.getState())) {
                Entities.delete((Object)((Object)img));
            } else if (img instanceof MachineImageInfo) {
                String runManifestLocation = ((MachineImageInfo)img).getRunManifestLocation();
                String manifestLocation = ((MachineImageInfo)img).getManifestLocation();
                if (!manifestLocation.equals(runManifestLocation)) {
                    img.setState((Enum)ImageMetadata.State.deregistered_cleanup);
                } else {
                    img.setState((Enum)ImageMetadata.State.deregistered);
                }
            } else {
                img.setState((Enum)ImageMetadata.State.deregistered);
            }
            tx.commit();
            if (img instanceof StaticDiskImage) {
                StaticDiskImages.flush((StaticDiskImage)img);
            }
        }
        catch (ConstraintViolationException cve) {
            tx.rollback();
            throw new InstanceNotTerminatedException("To deregister " + imageId + " all associated instances must be in the terminated state.");
        }
        catch (TransactionException ex) {
            tx.rollback();
            throw new NoSuchImageException("Failed to lookup image: " + imageId, (Throwable)ex);
        }
        catch (NoSuchElementException ex) {
            tx.rollback();
            throw new NoSuchImageException("Failed to lookup image: " + imageId, (Throwable)ex);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
    }

    public static MachineImageInfo exampleMachineWithImageId(String imageId) {
        return new MachineImageInfo(imageId);
    }

    public static BlockStorageImageInfo exampleBlockStorageWithImageId(String imageId) {
        return new BlockStorageImageInfo(imageId);
    }

    public static BlockStorageImageInfo exampleBlockStorageWithSnapshotId(String snapshotId) {
        BlockStorageImageInfo info = new BlockStorageImageInfo();
        info.setSnapshotId(snapshotId);
        return info;
    }

    public static BlockStorageDeviceMapping exampleBSDMappingWithSnapshotId(String snapshotId) {
        BlockStorageDeviceMapping bsdm = new BlockStorageDeviceMapping();
        bsdm.setSnapshotId(snapshotId);
        return bsdm;
    }

    public static KernelImageInfo exampleKernelWithImageId(String imageId) {
        return new KernelImageInfo(imageId);
    }

    public static KernelImageInfo lookupKernel(String kernelId) {
        EntityTransaction tx = Entities.get(KernelImageInfo.class);
        KernelImageInfo ret = new KernelImageInfo();
        try {
            ret = (KernelImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleKernelWithImageId(kernelId))));
            tx.commit();
        }
        catch (Exception e) {
            LOG.error((Object)("Kernel '" + kernelId + "' does not exist" + e));
            throw new NoSuchElementException("InvalidAMIID.NotFound");
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        return ret;
    }

    public static RamdiskImageInfo exampleRamdiskWithImageId(String imageId) {
        return new RamdiskImageInfo(imageId);
    }

    public static RamdiskImageInfo lookupRamdisk(String ramdiskId) {
        EntityTransaction tx = Entities.get(RamdiskImageInfo.class);
        RamdiskImageInfo ret = new RamdiskImageInfo();
        try {
            ret = (RamdiskImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleRamdiskWithImageId(ramdiskId))));
            tx.commit();
        }
        catch (Exception e) {
            LOG.error((Object)("Ramdisk '" + ramdiskId + "' does not exist" + e));
            throw new NoSuchElementException("InvalidAMIID.NotFound");
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        return ret;
    }

    public static ImageInfo lookupImage(String imageId) {
        EntityTransaction db = Entities.get(ImageInfo.class);
        try {
            ImageInfo found = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(imageId))));
            db.commit();
            ImageInfo imageInfo = found;
            return imageInfo;
        }
        catch (NoSuchElementException ex) {
            db.rollback();
            throw ex;
        }
        catch (Exception ex) {
            db.rollback();
            throw Exceptions.toUndeclared((Throwable)ex);
        }
        finally {
            if (db.isActive()) {
                db.rollback();
            }
        }
    }

    public static ImageInfo exampleWithImageId(String imageId) {
        return new ImageInfo(imageId);
    }

    public static ImageInfo exampleWithName(@Nullable OwnerFullName owner, @Nullable String name) {
        ImageInfo example = new ImageInfo();
        example.setOwner(owner);
        example.setImageName(name);
        return example;
    }

    public static ImageInfo exampleWithImageState(ImageMetadata.State state) {
        ImageInfo img = new ImageInfo();
        img.setState((Enum)state);
        img.setStateChangeStack(null);
        img.setLastState(null);
        return img;
    }

    public static ImageInfo exampleWithImageFormat(ImageMetadata.ImageFormat format) {
        ImageInfo img = new ImageInfo();
        img.setImageFormat(format.toString());
        img.setStateChangeStack(null);
        img.setLastState(null);
        return img;
    }

    public static Predicate<BlockDeviceMappingItemType> findEbsRoot(String rootDevName) {
        return Images.findEbsRoot(rootDevName, true);
    }

    public static Predicate<BlockDeviceMappingItemType> findEbsRootOptionalSnapshot(String rootDevName) {
        return Images.findEbsRoot(rootDevName, false);
    }

    private static Predicate<BlockDeviceMappingItemType> findEbsRoot(final String rootDevName, final boolean requireSnapshotId) {
        return new Predicate<BlockDeviceMappingItemType>(){

            public boolean apply(BlockDeviceMappingItemType input) {
                return rootDevName.equals(input.getDeviceName()) && input.getEbs() != null && (!requireSnapshotId || input.getEbs().getSnapshotId() != null);
            }
        };
    }

    public static Predicate<BlockDeviceMappingItemType> findCreateImageRoot() {
        return new Predicate<BlockDeviceMappingItemType>(){

            public boolean apply(BlockDeviceMappingItemType input) {
                return input.getEbs() != null && "snap-EUCARESERVED".equals(input.getEbs().getSnapshotId());
            }
        };
    }

    public static Predicate<DeviceMapping> findDeviceMap(final String deviceName) {
        return new Predicate<DeviceMapping>(){

            public boolean apply(DeviceMapping input) {
                return deviceName.equals(input.getDeviceName());
            }
        };
    }

    public static Predicate<BlockDeviceMappingItemType> findBlockDeviceMappingItempType(final String deviceName) {
        return new Predicate<BlockDeviceMappingItemType>(){

            public boolean apply(BlockDeviceMappingItemType input) {
                return deviceName.equals(input.getDeviceName());
            }
        };
    }

    public static Predicate<VmVolumeAttachment> findEbsRootVolumeAttachment(final String rootDevName) {
        return new Predicate<VmVolumeAttachment>(){

            public boolean apply(VmVolumeAttachment input) {
                return input.getDevice().equals(rootDevName) || input.getIsRootDevice() != false;
            }
        };
    }

    public static ImageInfo createFromDeviceMapping(UserFullName userFullName, String imageName, String imageDescription, ImageMetadata.Platform platform, String eki, String eri, String rootDeviceName, List<BlockDeviceMappingItemType> blockDeviceMappings, ImageMetadata.Architecture imageArch) throws EucalyptusCloudException {
        Snapshot snap;
        BlockDeviceMappingItemType rootBlockDevice;
        ImageMetadata.Platform imagePlatform = platform;
        if (ImageMetadata.Platform.windows.equals((Object)imagePlatform)) {
            eki = null;
            eri = null;
        }
        if ((rootBlockDevice = (BlockDeviceMappingItemType)Iterables.find(blockDeviceMappings, Images.findEbsRoot(rootDeviceName), null)) == null) {
            throw new EucalyptusCloudException("Failed to create image, root device mapping not found: " + rootDeviceName);
        }
        String snapshotId = (String)ResourceIdentifiers.tryNormalize().apply((Object)rootBlockDevice.getEbs().getSnapshotId());
        try {
            snap = (Snapshot)((Object)Transactions.one((Object)((Object)Snapshot.named((OwnerFullName)userFullName.asAccountFullName(), snapshotId)), (Predicate)RestrictedTypes.filterPrivileged(), (Function)Functions.identity()));
        }
        catch (NoSuchElementException ex) {
            throw new EucalyptusCloudException("Failed to create image from specified block device mapping: " + rootBlockDevice + " because of: Snapshot not found " + snapshotId);
        }
        catch (TransactionExecutionException ex) {
            throw new EucalyptusCloudException("Failed to create image from specified block device mapping: " + rootBlockDevice + " because of: " + ex.getMessage());
        }
        catch (ExecutionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new EucalyptusCloudException("Failed to create image from specified block device mapping: " + rootBlockDevice + " because of: " + ex.getMessage());
        }
        Integer suppliedVolumeSize = rootBlockDevice.getEbs().getVolumeSize() != null ? rootBlockDevice.getEbs().getVolumeSize() : snap.getVolumeSize();
        Long imageSizeBytes = (long)suppliedVolumeSize.intValue() * 1024L * 1024L * 1024L;
        Boolean targetDeleteOnTermination = Boolean.TRUE.equals(rootBlockDevice.getEbs().getDeleteOnTermination());
        String imageId = ResourceIdentifiers.generateString(ImageMetadata.Type.machine.getTypePrefix());
        boolean mapRoot = DEFAULT_PARTITIONED_ROOT_DEVICE.equals(rootDeviceName);
        BlockStorageImageInfo ret = new BlockStorageImageInfo(userFullName, imageId, imageName, imageDescription, imageSizeBytes, imageArch, imagePlatform, eki, eri, snap.getDisplayName(), targetDeleteOnTermination, mapRoot ? DEFAULT_ROOT_DEVICE : rootDeviceName);
        EntityTransaction tx = Entities.get(BlockStorageImageInfo.class);
        try {
            ret = (BlockStorageImageInfo)Entities.merge((Object)ret);
            Iterables.addAll(ret.getDeviceMappings(), (Iterable)Iterables.transform(blockDeviceMappings, Images.deviceMappingGenerator(ret, suppliedVolumeSize, mapRoot ? Collections.singletonMap(DEFAULT_PARTITIONED_ROOT_DEVICE, DEFAULT_ROOT_DEVICE) : Collections.emptyMap())));
            ret.setImageFormat(ImageMetadata.ImageFormat.fulldisk.toString());
            ret.setState((Enum)ImageMetadata.State.available);
            tx.commit();
            LOG.info((Object)("Registering image pk=" + ret.getDisplayName() + " ownerId=" + userFullName));
        }
        catch (Exception e) {
            throw new EucalyptusCloudException("Failed to register image using snapshot: " + snapshotId + " because of: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        return ret;
    }

    public static ImageInfo createPendingFromDeviceMapping(UserFullName creator, String imageNameArg, String imageDescription, ImageMetadata.Architecture requestArch, ImageMetadata.Platform imagePlatform, List<BlockDeviceMappingItemType> blockDeviceMappings) throws Exception {
        String imageId = ResourceIdentifiers.generateString(ImageMetadata.Type.machine.getTypePrefix());
        BlockStorageImageInfo ret = new BlockStorageImageInfo(creator, imageId, imageNameArg, imageDescription, new Long(-1L), requestArch, imagePlatform, null, null, "snap-EUCARESERVED", false, DEFAULT_ROOT_DEVICE);
        BlockDeviceMappingItemType toRemove = null;
        for (BlockDeviceMappingItemType device : blockDeviceMappings) {
            if (!Images.findCreateImageRoot().apply((Object)device)) continue;
            toRemove = device;
        }
        if (toRemove != null) {
            blockDeviceMappings.remove(toRemove);
        }
        EntityTransaction tx = Entities.get(BlockStorageImageInfo.class);
        try {
            ret = (BlockStorageImageInfo)Entities.merge((Object)ret);
            ret.setState((Enum)ImageMetadata.State.pending);
            ret.setImageFormat(ImageMetadata.ImageFormat.fulldisk.toString());
            ret.getDeviceMappings().addAll(Lists.transform(blockDeviceMappings, Images.deviceMappingGenerator(ret, -1)));
            tx.commit();
            LOG.info((Object)("Registering image pk=" + ret.getDisplayName() + " ownerId=" + creator));
        }
        catch (Exception e) {
            tx.rollback();
            throw new EucalyptusCloudException("Failed to register pending bfebs image because of: " + e.getMessage(), (Throwable)e);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
        return ret;
    }

    public static ImageInfo updateWithDeviceMapping(String imageId, UserFullName userFullName, String rootDeviceName, List<BlockDeviceMappingItemType> blockDeviceMappings) throws EucalyptusCloudException {
        BlockDeviceMappingItemType rootBlockDevice = (BlockDeviceMappingItemType)Iterables.find(blockDeviceMappings, Images.findEbsRoot(rootDeviceName));
        String snapshotId = (String)ResourceIdentifiers.tryNormalize().apply((Object)rootBlockDevice.getEbs().getSnapshotId());
        try {
            Snapshot snap = (Snapshot)((Object)Transactions.find((Object)((Object)Snapshot.named((OwnerFullName)userFullName, snapshotId))));
            if (!userFullName.getUserId().equals(snap.getOwnerUserId())) {
                throw new EucalyptusCloudException("Failed to create image from specified block device mapping: " + rootBlockDevice + " because of: you must be the owner of the source snapshot.");
            }
            Integer suppliedVolumeSize = rootBlockDevice.getEbs().getVolumeSize() != null ? rootBlockDevice.getEbs().getVolumeSize() : snap.getVolumeSize();
            Long imageSizeBytes = (long)suppliedVolumeSize.intValue() * 1024L * 1024L * 1024L;
            Boolean targetDeleteOnTermination = Boolean.TRUE.equals(rootBlockDevice.getEbs().getDeleteOnTermination());
            BlockStorageImageInfo ret = null;
            EntityTransaction tx = Entities.get(BlockStorageImageInfo.class);
            try {
                ret = (BlockStorageImageInfo)Entities.uniqueResult((Object)((Object)BlockStorageImageInfo.named(imageId)));
                List mappings = Lists.transform(blockDeviceMappings, Images.deviceMappingGenerator(ret, suppliedVolumeSize));
                ret.getDeviceMappings().addAll(mappings);
                ret.setSnapshotId(snap.getDisplayName());
                ret.setDeleteOnTerminate(targetDeleteOnTermination);
                ret.setImageSizeBytes(imageSizeBytes);
                ret.setRootDeviceName(rootDeviceName);
                ret.setState((Enum)ImageMetadata.State.available);
                Entities.persist((Object)ret);
                tx.commit();
                LOG.info((Object)("Registering image pk=" + ret.getDisplayName() + " ownerId=" + userFullName));
            }
            catch (Exception e) {
                tx.rollback();
                throw new EucalyptusCloudException("Failed to register image using snapshot: " + snapshotId + " because of: " + e.getMessage(), (Throwable)e);
            }
            return ret;
        }
        catch (TransactionExecutionException ex) {
            throw new EucalyptusCloudException("Failed to update image with specified block device mapping: " + rootBlockDevice + " because of: " + ex.getMessage());
        }
        catch (ExecutionException ex) {
            LOG.error((Object)ex, (Throwable)ex);
            throw new EucalyptusCloudException("Failed to update image with specified block device mapping: " + rootBlockDevice + " because of: " + ex.getMessage());
        }
    }

    public static ImageInfo registerFromManifest(UserFullName creator, String imageNameArg, String imageDescription, ImageMetadata.Architecture requestArch, ImageMetadata.VirtualizationType virtType, ImageMetadata.Platform platform, ImageMetadata.ImageFormat imgFormat, String eki, String eri, ImageManifests.ImageManifest manifest) throws Exception {
        PutGetImageInfo ret = Images.prepareFromManifest(creator, imageNameArg, imageDescription, requestArch, virtType, platform, imgFormat, eki, eri, manifest);
        ret.setState((Enum)ImageMetadata.State.available);
        ret = Images.persistRegistration(creator, manifest, ret);
        return ret;
    }

    public static ImageInfo createPendingAvailableFromManifest(UserFullName creator, String imageNameArg, String imageDescription, ImageMetadata.Architecture requestArch, ImageMetadata.VirtualizationType virtType, ImageMetadata.Platform platform, ImageMetadata.ImageFormat imgFormat, String eki, String eri, ImageManifests.ImageManifest manifest) throws Exception {
        PutGetImageInfo ret = Images.prepareFromManifest(creator, imageNameArg, imageDescription, requestArch, virtType, platform, imgFormat, eki, eri, manifest);
        ret.setState((Enum)ImageMetadata.State.pending_available);
        ret = Images.persistRegistration(creator, manifest, ret);
        return ret;
    }

    public static void registerFromPendingImage(String imageId) throws Exception {
        EntityTransaction tx = Entities.get(PutGetImageInfo.class);
        try {
            ImageInfo ret = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(imageId))));
            ret.setState((Enum)ImageMetadata.State.available);
            tx.commit();
        }
        catch (Exception e) {
            tx.rollback();
            throw new EucalyptusCloudException("Failed to update image: " + imageId + " because of: " + e.getMessage(), (Throwable)e);
        }
    }

    private static PutGetImageInfo prepareFromManifest(UserFullName creator, String imageNameArg, String imageDescription, ImageMetadata.Architecture requestArch, ImageMetadata.VirtualizationType virtType, ImageMetadata.Platform platform, ImageMetadata.ImageFormat format, String eki, String eri, ImageManifests.ImageManifest manifest) throws Exception {
        PutGetImageInfo ret = null;
        String imageName = imageNameArg != null ? imageNameArg : manifest.getName();
        eki = eki != null ? eki : manifest.getKernelId();
        eri = eri != null ? eri : manifest.getRamdiskId();
        ImageMetadata.Architecture imageArch = requestArch != null ? requestArch : manifest.getArchitecture();
        ImageMetadata.Platform imagePlatform = platform;
        switch (manifest.getImageType()) {
            case kernel: {
                ret = new KernelImageInfo(creator, ResourceIdentifiers.generateString(ImageMetadata.Type.kernel.getTypePrefix()), imageName, imageDescription, manifest.getSize(), imageArch, imagePlatform, manifest.getImageLocation(), manifest.getBundledSize(), manifest.getChecksum(), manifest.getChecksumType());
                break;
            }
            case ramdisk: {
                ret = new RamdiskImageInfo(creator, ResourceIdentifiers.generateString(ImageMetadata.Type.ramdisk.getTypePrefix()), imageName, imageDescription, manifest.getSize(), imageArch, imagePlatform, manifest.getImageLocation(), manifest.getBundledSize(), manifest.getChecksum(), manifest.getChecksumType());
                break;
            }
            case machine: {
                if (ImageMetadata.Platform.windows.equals((Object)imagePlatform)) {
                    virtType = ImageMetadata.VirtualizationType.hvm;
                }
                String manifestAmi = manifest.getAmi();
                ret = new MachineImageInfo(creator, ResourceIdentifiers.generateString(ImageMetadata.Type.machine.getTypePrefix()), imageName, imageDescription, manifest.getSize(), imageArch, imagePlatform, manifest.getImageLocation(), manifest.getBundledSize(), manifest.getChecksum(), manifest.getChecksumType(), eki, eri, virtType, manifestAmi, manifest.getRoot());
                ret.setImageFormat(format.toString());
                if (!ImageMetadata.VirtualizationType.hvm.equals((Object)virtType) && (manifestAmi.isEmpty() || ImageManager.isPathAPartition(manifestAmi))) break;
                ((MachineImageInfo)ret).setRunManifestLocation(manifest.getImageLocation());
            }
        }
        if (ret == null) {
            throw new IllegalArgumentException("Failed to prepare image using the provided image manifest: " + manifest);
        }
        ret.setSignature(manifest.getSignature());
        ret.setManifestHash(ImageManifests.calculateManifestHash(manifest.getManifest()));
        return ret;
    }

    private static PutGetImageInfo persistRegistration(UserFullName creator, ImageManifests.ImageManifest manifest, PutGetImageInfo ret) throws Exception {
        if (!manifest.checkManifestSignature(Accounts.lookupUserById((String)creator.getUserId()))) {
            throw new EucalyptusCloudException("Manifest has invalid signature");
        }
        try (TransactionResource tx = Entities.transactionFor(PutGetImageInfo.class);){
            ret = (PutGetImageInfo)((Object)Entities.merge((Object)((Object)ret)));
            tx.commit();
            LOG.info((Object)("Registering image pk=" + ret.getDisplayName() + " ownerId=" + creator));
        }
        catch (Exception e) {
            throw new EucalyptusCloudException("Failed to register image: " + manifest + " because of: " + e.getMessage(), (Throwable)e);
        }
        LOG.info((Object)("Triggering cache population in Walrus for: " + ret.getDisplayName()));
        if (ret instanceof StaticDiskImage && ret.getRunManifestLocation() != null) {
            StaticDiskImages.prepare(ret.getRunManifestLocation());
        }
        return ret;
    }

    public static ImageConfiguration configuration() {
        return ImageConfiguration.getInstance();
    }

    public static void setConversionTaskId(String imageId, String taskId) {
        try (TransactionResource db = Entities.transactionFor(ImageInfo.class);){
            try {
                ImageInfo entity = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(imageId))));
                ((MachineImageInfo)entity).setImageConversionId(taskId);
                Entities.persist((Object)((Object)entity));
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public static void setImageFormat(String imageId, ImageMetadata.ImageFormat format) {
        try (TransactionResource db = Entities.transactionFor(ImageInfo.class);){
            try {
                ImageInfo entity = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(imageId))));
                entity.setImageFormat(format.toString());
                Entities.persist((Object)((Object)entity));
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public static void setRunManifestLocation(String imageId, String runManifestLocation) {
        try (TransactionResource db = Entities.transactionFor(ImageInfo.class);){
            try {
                ImageInfo entity = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(imageId))));
                ((MachineImageInfo)entity).setRunManifestLocation(runManifestLocation);
                Entities.persist((Object)((Object)entity));
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    public static void setImageVirtualizationType(String imageId, ImageMetadata.VirtualizationType virtType) {
        try (TransactionResource db = Entities.transactionFor(ImageInfo.class);){
            try {
                ImageInfo entity = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(imageId))));
                ((MachineImageInfo)entity).setVirtualizationType(virtType);
                Entities.persist((Object)((Object)entity));
                db.commit();
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }
    }

    private static Function<String, Collection> accountAliasExploder() {
        return new Function<String, Collection>(){

            public Collection<String> apply(String accountAliasExpression) {
                try {
                    return Accounts.resolveAccountNumbersForName((String)accountAliasExpression);
                }
                catch (AuthException e) {
                    LOG.error((Object)e, (Throwable)e);
                    return Collections.emptySet();
                }
            }
        };
    }

    private static <T> Function<ImageInfo, T> asImageInfoFunction(Function<BootableImageInfo, T> bootableImageInfoFunction) {
        return Images.typedFunction(bootableImageInfoFunction, BootableImageInfo.class, null);
    }

    private static <R, T, TT> Function<T, R> typedFunction(final Function<TT, R> typeSpecificFunction, final Class<TT> subClass, final @Nullable R defaultValue) {
        return new Function<T, R>(){

            public R apply(T parameter) {
                return subClass.isInstance(parameter) ? typeSpecificFunction.apply(subClass.cast(parameter)) : defaultValue;
            }
        };
    }

    private static <T> Set<T> blockDeviceSet(ImageInfo imageInfo, Function<DeviceMapping, T> transform) {
        return Sets.newHashSet((Iterable)Iterables.transform(imageInfo.getDeviceMappings(), transform));
    }

    public static void cleanDeregistered() {
        List<String> imageIdentifiers;
        try {
            imageIdentifiers = Transactions.filteredTransform((Object)((Object)Images.exampleWithImageState(ImageMetadata.State.deregistered)), (Predicate)Predicates.alwaysTrue(), (Function)RestrictedTypes.toDisplayName());
        }
        catch (TransactionException e) {
            LOG.error((Object)"Error loading deregistered image list", (Throwable)e);
            imageIdentifiers = Collections.emptyList();
        }
        for (String imageIdentifier : imageIdentifiers) {
            try {
                Transactions.delete((Object)((Object)Images.exampleWithImageId(imageIdentifier)));
            }
            catch (TransactionException | RuntimeException e) {
                Logs.extreme().debug((Object)("Attempted image delete failed (image still referenced?): " + imageIdentifier), e);
            }
        }
    }

    public static Predicate<ImageInfo> standardStatePredicate() {
        return StandardStatePredicate.INSTANCE;
    }

    public static class ImageCleanupEventListener
    implements EventListener<Hertz> {
        private static final Supplier<Long> periodSupplier = Suppliers.memoizeWithExpiration((Supplier)ConfigurationValueSupplier.INSTANCE, (long)10L, (TimeUnit)TimeUnit.SECONDS);

        public static void register() {
            Listeners.register(Hertz.class, (EventListener)new ImageCleanupEventListener());
        }

        public void fireEvent(Hertz hertz) {
            if (Bootstrap.isOperational().booleanValue() && !Databases.isVolatile().booleanValue() && (Long)periodSupplier.get() > 0L && hertz.isAsserted(TimeUnit.MILLISECONDS.toSeconds((Long)periodSupplier.get())) && Topology.isEnabledLocally(Eucalyptus.class)) {
                Images.cleanDeregistered();
            }
        }

        private static enum ConfigurationValueSupplier implements Supplier<Long>
        {
            INSTANCE;


            public Long get() {
                return ImageConfiguration.getInstance().getCleanupPeriodMillis();
            }
        }
    }

    private static enum StandardStatePredicate implements Predicate<ImageInfo>
    {
        INSTANCE;


        public boolean apply(ImageInfo imageInfo) {
            return ((ImageMetadata.State)imageInfo.getState()).standardState();
        }
    }

    private static enum FilterStringSetFunctions implements Function<ImageInfo, Set<String>>
    {
        BLOCK_DEVICE_MAPPING_DEVICE_NAME{

            public Set<String> apply(ImageInfo imageInfo) {
                return Images.blockDeviceSet(imageInfo, DeviceMappingFilterFunctions.DEVICE_NAME);
            }
        }
        ,
        BLOCK_DEVICE_MAPPING_SNAPSHOT_ID{

            public Set<String> apply(ImageInfo imageInfo) {
                return Images.blockDeviceSet(imageInfo, Images.typedFunction(BlockDeviceMappingFilterFunctions.SNAPSHOT_ID, BlockStorageDeviceMapping.class, null));
            }
        }
        ,
        PRODUCT_CODE{

            public Set<String> apply(ImageInfo imageInfo) {
                return imageInfo.getProductCodes();
            }
        };

    }

    private static enum FilterStringFunctions implements Function<ImageInfo, String>
    {
        ARCHITECTURE{

            public String apply(ImageInfo imageInfo) {
                return Strings.toString((Object)imageInfo.getArchitecture());
            }
        }
        ,
        DESCRIPTION{

            public String apply(ImageInfo imageInfo) {
                return imageInfo.getDescription();
            }
        }
        ,
        IMAGE_TYPE{

            public String apply(ImageInfo imageInfo) {
                return Strings.toString((Object)imageInfo.getImageType());
            }
        }
        ,
        MANIFEST_LOCATION{

            public String apply(ImageInfo imageInfo) {
                return imageInfo instanceof PutGetImageInfo ? ((PutGetImageInfo)imageInfo).getManifestLocation() : null;
            }
        }
        ,
        NAME{

            public String apply(ImageInfo imageInfo) {
                return imageInfo.getImageName();
            }
        }
        ,
        OWNER_ID{

            public String apply(ImageInfo imageInfo) {
                return imageInfo.getOwnerAccountNumber();
            }
        }
        ,
        PLATFORM{

            public String apply(ImageInfo imageInfo) {
                return Strings.toString((Object)imageInfo.getPlatform());
            }
        }
        ,
        STATE{

            public String apply(ImageInfo imageInfo) {
                return Strings.toString((Object)imageInfo.getState());
            }
        }
        ,
        VIRTUALIZATION_TYPE{

            public String apply(ImageInfo imageInfo) {
                return imageInfo instanceof MachineImageInfo ? Strings.toString((Object)((MachineImageInfo)imageInfo).getVirtualizationType()) : null;
            }
        };

    }

    private static enum BootableImageInfoFilterStringFunctions implements Function<BootableImageInfo, String>
    {
        KERNEL_ID{

            public String apply(BootableImageInfo imageInfo) {
                return imageInfo.getKernelId();
            }
        }
        ,
        RAMDISK_ID{

            public String apply(BootableImageInfo imageInfo) {
                return imageInfo.getRamdiskId();
            }
        }
        ,
        ROOT_DEVICE_NAME{

            public String apply(BootableImageInfo imageInfo) {
                return imageInfo.getRootDeviceName();
            }
        }
        ,
        ROOT_DEVICE_TYPE{

            public String apply(BootableImageInfo imageInfo) {
                return imageInfo.getRootDeviceType();
            }
        };

    }

    private static enum FilterIntegerSetFunctions implements Function<ImageInfo, Set<Integer>>
    {
        BLOCK_DEVICE_MAPPING_VOLUME_SIZE{

            public Set<Integer> apply(ImageInfo imageInfo) {
                return Images.blockDeviceSet(imageInfo, Images.typedFunction(BlockDeviceMappingIntegerFilterFunctions.SIZE, BlockStorageDeviceMapping.class, null));
            }
        };

    }

    private static enum FilterBooleanSetFunctions implements Function<ImageInfo, Set<Boolean>>
    {
        BLOCK_DEVICE_MAPPING_DELETE_ON_TERMINATION{

            public Set<Boolean> apply(ImageInfo imageInfo) {
                return Images.blockDeviceSet(imageInfo, Images.typedFunction(BlockDeviceMappingBooleanFilterFunctions.DELETE_ON_TERMINATION, BlockStorageDeviceMapping.class, null));
            }
        };

    }

    private static enum FilterBooleanFunctions implements Function<ImageInfo, Boolean>
    {
        IS_PUBLIC{

            public Boolean apply(ImageInfo imageInfo) {
                return imageInfo.getImagePublic();
            }
        };

    }

    private static enum DeviceMappingFilterFunctions implements Function<DeviceMapping, String>
    {
        DEVICE_NAME{

            public String apply(DeviceMapping deviceMapping) {
                return deviceMapping.getDeviceName();
            }
        };

    }

    private static enum BlockDeviceMappingFilterFunctions implements Function<BlockStorageDeviceMapping, String>
    {
        SNAPSHOT_ID{

            public String apply(BlockStorageDeviceMapping deviceMapping) {
                return deviceMapping.getSnapshotId();
            }
        };

    }

    private static enum BlockDeviceMappingIntegerFilterFunctions implements Function<BlockStorageDeviceMapping, Integer>
    {
        SIZE{

            public Integer apply(BlockStorageDeviceMapping deviceMapping) {
                return deviceMapping.getSize();
            }
        };

    }

    private static enum BlockDeviceMappingBooleanFilterFunctions implements Function<BlockStorageDeviceMapping, Boolean>
    {
        DELETE_ON_TERMINATION{

            public Boolean apply(BlockStorageDeviceMapping deviceMapping) {
                return deviceMapping.getDelete();
            }
        };

    }

    public static class ImageInfoFilterSupport
    extends FilterSupport<ImageInfo> {
        public ImageInfoFilterSupport() {
            super(ImageInfoFilterSupport.builderFor(ImageInfo.class).withTagFiltering(ImageInfoTag.class, "image").withStringProperty("architecture", FilterStringFunctions.ARCHITECTURE).withBooleanSetProperty("block-device-mapping.delete-on-termination", FilterBooleanSetFunctions.BLOCK_DEVICE_MAPPING_DELETE_ON_TERMINATION).withStringSetProperty("block-device-mapping.device-name", FilterStringSetFunctions.BLOCK_DEVICE_MAPPING_DEVICE_NAME).withStringSetProperty("block-device-mapping.snapshot-id", FilterStringSetFunctions.BLOCK_DEVICE_MAPPING_SNAPSHOT_ID).withIntegerSetProperty("block-device-mapping.volume-size", FilterIntegerSetFunctions.BLOCK_DEVICE_MAPPING_VOLUME_SIZE).withConstantProperty("block-device-mapping.volume-type", "standard").withStringProperty("description", FilterStringFunctions.DESCRIPTION).withStringProperty("image-id", (Function<ImageInfo, String>)CloudMetadatas.toDisplayName()).withStringProperty("image-type", FilterStringFunctions.IMAGE_TYPE).withBooleanProperty("is-public", FilterBooleanFunctions.IS_PUBLIC).withStringProperty("kernel-id", (Function<ImageInfo, String>)Images.asImageInfoFunction(BootableImageInfoFilterStringFunctions.KERNEL_ID)).withStringProperty("manifest-location", FilterStringFunctions.MANIFEST_LOCATION).withStringProperty("name", FilterStringFunctions.NAME).withLikeExplodedProperty("owner-alias", FilterStringFunctions.OWNER_ID, (Function<String, Collection>)Images.accountAliasExploder()).withStringProperty("owner-id", FilterStringFunctions.OWNER_ID).withStringProperty("platform", FilterStringFunctions.PLATFORM).withStringSetProperty("product-code", FilterStringSetFunctions.PRODUCT_CODE).withUnsupportedProperty("product-code.type").withStringProperty("ramdisk-id", (Function<ImageInfo, String>)Images.asImageInfoFunction(BootableImageInfoFilterStringFunctions.RAMDISK_ID)).withStringProperty("root-device-name", (Function<ImageInfo, String>)Images.asImageInfoFunction(BootableImageInfoFilterStringFunctions.ROOT_DEVICE_NAME)).withStringProperty("root-device-type", (Function<ImageInfo, String>)Images.asImageInfoFunction(BootableImageInfoFilterStringFunctions.ROOT_DEVICE_TYPE)).withStringProperty("state", FilterStringFunctions.STATE).withUnsupportedProperty("state-reason-code").withUnsupportedProperty("state-reason-message").withStringProperty("virtualization-type", FilterStringFunctions.VIRTUALIZATION_TYPE).withUnsupportedProperty("hypervisor").withPersistenceAlias("deviceMappings", "deviceMappings").withPersistenceFilter("architecture", "architecture", Enums.valueOfFunction(ImageMetadata.Architecture.class)).withPersistenceFilter("block-device-mapping.delete-on-termination", "deviceMappings.delete", FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("block-device-mapping.device-name", "deviceMappings.deviceName").withPersistenceFilter("block-device-mapping.snapshot-id", "deviceMappings.snapshotId").withPersistenceFilter("block-device-mapping.volume-size", "deviceMappings.size", FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("description").withPersistenceFilter("image-id", "displayName").withPersistenceFilter("image-type", "imageType", Enums.valueOfFunction(ImageMetadata.Type.class)).withPersistenceFilter("is-public", "imagePublic", FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("kernel-id", "kernelId").withPersistenceFilter("manifest-location", "manifestLocation").withPersistenceFilter("name", "imageName").withLikeExplodingPersistenceFilter("owner-alias", "ownerAccountNumber", (Function<String, Collection>)Images.accountAliasExploder()).withPersistenceFilter("owner-id", "ownerAccountNumber").withPersistenceFilter("platform", "platform", Enums.valueOfFunction(ImageMetadata.Platform.class)).withPersistenceFilter("ramdisk-id", "ramdiskId").withPersistenceFilter("state", "state", Enums.valueOfFunction(ImageMetadata.State.class)).withPersistenceFilter("virtualization-type", "virtType", ImageMetadata.VirtualizationType.fromString()));
        }
    }

    public static enum DeviceMappingValidationOption {
        AllowSuppressMapping,
        AllowEbsMapping,
        AllowDevSda1,
        SkipExtraEphemeral;


        public boolean present(Set<DeviceMappingValidationOption> options) {
            return options != null && options.contains((Object)this);
        }
    }

    @TypeMapper
    public static enum DeviceMappingDetails implements Function<DeviceMapping, BlockDeviceMappingItemType>
    {
        INSTANCE;


        public BlockDeviceMappingItemType apply(DeviceMapping input) {
            BlockDeviceMappingItemType ret = new BlockDeviceMappingItemType();
            ret.setDeviceName(input.getDeviceName());
            if (input instanceof BlockStorageDeviceMapping) {
                final BlockStorageDeviceMapping ebsDev = (BlockStorageDeviceMapping)input;
                ret.setEbs(new EbsDeviceMapping(){
                    {
                        this.setVirtualName(ebsDev.getVirtualName());
                        this.setSnapshotId(ebsDev.getSnapshotId());
                        this.setVolumeSize(ebsDev.getSize());
                        this.setDeleteOnTermination(ebsDev.getDelete());
                    }
                });
            } else {
                ret.setVirtualName(input.getVirtualName());
            }
            return ret;
        }
    }

    @TypeMapper
    public static enum MachineImageDetails implements Function<MachineImageInfo, ImageDetails>
    {
        INSTANCE;


        public ImageDetails apply(MachineImageInfo arg0) {
            ImageDetails i = new ImageDetails();
            i.setName(arg0.getImageName());
            i.setDescription(arg0.getDescription());
            i.setArchitecture(arg0.getArchitecture().toString());
            i.setRootDeviceName(arg0.getRootDeviceName());
            i.setRootDeviceType(arg0.getRootDeviceType());
            i.setImageId(arg0.getDisplayName());
            i.setImageLocation(arg0.getManifestLocation());
            i.setImageOwnerId(arg0.getOwnerAccountNumber().toString());
            i.setImageState(((ImageMetadata.State)arg0.getState()).getExternalStateName());
            i.setImageType(arg0.getImageType().toString());
            i.setIsPublic(arg0.getImagePublic());
            i.setImageType(arg0.getImageType().toString());
            i.setKernelId(arg0.getKernelId());
            i.setRamdiskId(arg0.getRamdiskId());
            i.setPlatform(arg0.getPlatform().toString());
            if (arg0.getVirtualizationType() == null) {
                if (ImageMetadata.Platform.windows.equals((Object)arg0.getPlatform())) {
                    i.setVirtualizationType(ImageMetadata.VirtualizationType.hvm.toString());
                } else {
                    i.setVirtualizationType(ImageMetadata.VirtualizationType.paravirtualized.toString());
                }
            } else {
                i.setVirtualizationType(arg0.getVirtualizationType().toString());
            }
            i.getBlockDeviceMappings().addAll(Collections2.transform(arg0.getDeviceMappings(), (Function)DeviceMappingDetails.INSTANCE));
            return i;
        }
    }

    @TypeMapper
    public static enum BlockStorageImageDetails implements Function<BlockStorageImageInfo, ImageDetails>
    {
        INSTANCE;


        public ImageDetails apply(BlockStorageImageInfo arg0) {
            ImageDetails i = new ImageDetails();
            i.setName(arg0.getImageName());
            i.setDescription(arg0.getDescription());
            i.setArchitecture(arg0.getArchitecture().toString());
            i.setRootDeviceName(arg0.getRootDeviceName());
            i.setRootDeviceType(arg0.getRootDeviceType());
            i.setImageId(arg0.getDisplayName());
            i.setImageLocation(arg0.getOwnerAccountNumber() + "/" + arg0.getImageName());
            i.setImageOwnerId(arg0.getOwnerAccountNumber().toString());
            i.setImageState(((ImageMetadata.State)arg0.getState()).getExternalStateName());
            i.setImageType(arg0.getImageType().toString());
            i.setIsPublic(arg0.getImagePublic());
            i.setImageType(arg0.getImageType().toString());
            i.setKernelId(arg0.getKernelId());
            i.setRamdiskId(arg0.getRamdiskId());
            i.setPlatform(arg0.getPlatform().toString());
            if (arg0.getVirtualizationType() == null) {
                i.setVirtualizationType(ImageMetadata.VirtualizationType.hvm.toString());
            } else {
                i.setVirtualizationType(arg0.getVirtualizationType().toString());
            }
            i.getBlockDeviceMappings().addAll(Collections2.transform(arg0.getDeviceMappings(), (Function)DeviceMappingDetails.INSTANCE));
            return i;
        }
    }

    @TypeMapper
    public static enum RamdiskImageDetails implements Function<RamdiskImageInfo, ImageDetails>
    {
        INSTANCE;


        public ImageDetails apply(RamdiskImageInfo arg0) {
            ImageDetails i = new ImageDetails();
            i.setName(arg0.getImageName());
            i.setDescription(arg0.getDescription());
            i.setArchitecture(arg0.getArchitecture().toString());
            i.setImageId(arg0.getDisplayName());
            i.setImageLocation(arg0.getManifestLocation());
            i.setImageOwnerId(arg0.getOwnerAccountNumber().toString());
            i.setImageState(((ImageMetadata.State)arg0.getState()).getExternalStateName());
            i.setImageType(arg0.getImageType().toString());
            i.setIsPublic(arg0.getImagePublic());
            i.setPlatform(ImageMetadata.Platform.linux.toString());
            return i;
        }
    }

    @TypeMapper
    public static enum KernelImageDetails implements Function<KernelImageInfo, ImageDetails>
    {
        INSTANCE;


        public ImageDetails apply(KernelImageInfo arg0) {
            ImageDetails i = new ImageDetails();
            i.setName(arg0.getImageName());
            i.setDescription(arg0.getDescription());
            i.setArchitecture(arg0.getArchitecture().toString());
            i.setImageId(arg0.getDisplayName());
            i.setImageLocation(arg0.getManifestLocation());
            i.setImageOwnerId(arg0.getOwnerAccountNumber().toString());
            i.setImageState(((ImageMetadata.State)arg0.getState()).getExternalStateName());
            i.setImageType(arg0.getImageType().toString());
            i.setIsPublic(arg0.getImagePublic());
            i.setPlatform(ImageMetadata.Platform.linux.toString());
            return i;
        }
    }

    @RestrictedTypes.QuantityMetricFunction(value=ImageMetadata.class)
    public static enum CountImages implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Long apply(OwnerFullName input) {
            EntityTransaction db = Entities.get(ImageInfo.class);
            try {
                Long l = Entities.count((Object)((Object)ImageInfo.named(input, null)));
                return l;
            }
            finally {
                db.rollback();
            }
        }
    }

    public static enum FilterPermissions implements Predicate<ImageInfo>
    {
        INSTANCE;


        public boolean apply(ImageInfo input) {
            try {
                Context ctx = Contexts.lookup();
                if (ctx.isAdministrator()) {
                    return true;
                }
                UserFullName luser = ctx.getUserFullName();
                if (input.getImagePublic().booleanValue()) {
                    return true;
                }
                if (input.getOwnerAccountNumber().equals(luser.getAccountNumber())) {
                    return true;
                }
                if (input.hasPermission(luser.getAccountNumber(), luser.getUserId())) {
                    return true;
                }
                for (AccessKey key : ctx.getUser().getKeys()) {
                    if (!input.hasPermission(key.getAccessKey())) continue;
                    return true;
                }
                return false;
            }
            catch (Exception ex) {
                return false;
            }
        }
    }

    public static enum FilterImageStates implements Predicate<ImageInfo>
    {
        INSTANCE;


        public boolean apply(ImageInfo input) {
            return ImageMetadata.State.available.name().equals(((ImageMetadata.State)input.getState()).getExternalStateName());
        }
    }
}

