/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.auth.SystemCredentials;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.ClientComputeException;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.images.ImageConfiguration;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.images.Images;
import com.eucalyptus.objectstorage.client.EucaS3Client;
import com.eucalyptus.objectstorage.client.EucaS3ClientFactory;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.XMLParser;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.bouncycastle.util.encoders.Base64;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ImageManifests {
    private static Logger LOG = Logger.getLogger(ImageManifests.class);

    private static byte[] hexToBytes(String data) {
        int k = 0;
        byte[] results = new byte[data.length() / 2];
        int i = 0;
        while (i < data.length()) {
            results[k] = (byte)(Character.digit(data.charAt(i++), 16) << 4);
            int n = k++;
            results[n] = (byte)(results[n] + (byte)Character.digit(data.charAt(i++), 16));
        }
        return results;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static String requestManifestData(String bucketName, String objectName) throws EucalyptusCloudException {
        try (EucaS3Client s3Client = EucaS3ClientFactory.getEucaS3ClientForUser((User)Accounts.lookupAwsExecReadAdmin((boolean)true), (int)((int)TimeUnit.MINUTES.toSeconds(15L)));){
            String string = s3Client.getObjectContent(bucketName, objectName, ImageConfiguration.getInstance().getMaxManifestSizeBytes().intValue());
            return string;
        }
        catch (Exception e) {
            LOG.error((Object)("Can't read manifest due to: " + e));
            throw new EucalyptusCloudException("Failed to read manifest file: " + bucketName + "/" + objectName, (Throwable)e);
        }
    }

    public static String getManifestHash(String manifestLocation) throws EucalyptusCloudException {
        ImageManifest.ManifestLocation mLoc = new ImageManifest.ManifestLocation(manifestLocation);
        String manifest = ImageManifests.requestManifestData(mLoc.bucketName, mLoc.manifestKey);
        return ImageManifests.calculateManifestHash(manifest);
    }

    public static String calculateManifestHash(String content) throws EucalyptusCloudException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-256");
            messageDigest.update(content.getBytes());
            return Base64.toBase64String((byte[])messageDigest.digest());
        }
        catch (NoSuchAlgorithmException e) {
            throw new EucalyptusCloudException("Can't load SHA-256 algorithm", (Throwable)e);
        }
    }

    public static ImageManifest lookup(String imageLocation) throws EucalyptusCloudException {
        return new ImageManifest(imageLocation, null);
    }

    public static ImageManifest lookup(String imageLocation, User owner) throws EucalyptusCloudException {
        ImageManifest manifest = new ImageManifest(imageLocation, owner);
        try {
            String ownerAcctId = owner.getAccountNumber();
            if (ownerAcctId.equals(manifest.getAccountId())) {
                return manifest;
            }
        }
        catch (AuthException ex) {
            throw new ClientComputeException("AuthFailure", "Manifest is not accessible");
        }
        throw new ClientComputeException("AuthFailure", "Manifest is not accessible");
    }

    static void checkPrivileges(String diskId) throws EucalyptusCloudException {
        Context ctx = Contexts.lookup();
        if (diskId != null) {
            ImageInfo disk = null;
            try {
                disk = Images.lookupImage(diskId);
            }
            catch (Exception ex) {
                LOG.error((Object)ex, (Throwable)ex);
                throw new EucalyptusCloudException("Referenced image id is invalid: " + diskId, (Throwable)ex);
            }
            if (!RestrictedTypes.filterPrivileged().apply((Object)disk)) {
                throw new EucalyptusCloudException("Access to " + disk.getImageType().toString() + " image " + diskId + " is denied for " + ctx.getUser().getName());
            }
        }
    }

    public static class ImageManifest {
        private final String imageLocation;
        private final ImageMetadata.Architecture architecture;
        private final String kernelId;
        private final String ramdiskId;
        private final ImageMetadata.Type imageType;
        private final ImageMetadata.Platform platform;
        private final ImageMetadata.VirtualizationType virtualizationType;
        private final String signature;
        private final String checksum;
        private final String checksumType;
        private final String manifest;
        private final Document inputSource;
        private final String name;
        private final Long size;
        private final Long bundledSize;
        private final List<String> ancestors = Lists.newArrayList();
        private XPath xpath;
        private Function<String, String> xpathHelper;
        private String encryptedKey;
        private String encryptedIV;
        private String userId;
        private List<ManifestDeviceMapping> deviceMappings = Lists.newArrayList();

        ImageManifest(@Nonnull String imageLocation, @Nullable User user) throws EucalyptusCloudException {
            int i;
            ManifestLocation mLoc = new ManifestLocation(imageLocation);
            this.imageLocation = mLoc.cleanLocation;
            String bucketName = mLoc.bucketName;
            String manifestKey = mLoc.manifestKey;
            final String manifestName = manifestKey.replaceAll(".*/", "");
            this.xpath = XPathFactory.newInstance().newXPath();
            this.xpathHelper = new Function<String, String>(){

                public String apply(String input) {
                    try {
                        return (String)ImageManifest.this.xpath.evaluate(input, ImageManifest.this.inputSource, XPathConstants.STRING);
                    }
                    catch (XPathExpressionException ex) {
                        return null;
                    }
                }
            };
            this.encryptedKey = (String)this.xpathHelper.apply((Object)"//ec2_encrypted_key");
            this.encryptedIV = (String)this.xpathHelper.apply((Object)"//ec2_encrypted_iv");
            Predicate<ImageMetadata.Type> checkIdType = new Predicate<ImageMetadata.Type>(){

                public boolean apply(ImageMetadata.Type input) {
                    String type = (String)ImageManifest.this.xpathHelper.apply((Object)"/manifest/image/type/text()");
                    if (type != null && type.equals(input.name())) {
                        return true;
                    }
                    String value = (String)ImageManifest.this.xpathHelper.apply((Object)input.getManifestPath());
                    return "yes".equals(value) || "true".equals(value) || manifestName.startsWith(input.getNamePrefix());
                }
            };
            if (checkIdType.apply((Object)ImageMetadata.Type.kernel) && user != null && !user.isSystemAdmin()) {
                throw new EucalyptusCloudException("Only administrators can register kernel images.");
            }
            if (checkIdType.apply((Object)ImageMetadata.Type.ramdisk) && user != null && !user.isSystemAdmin()) {
                throw new EucalyptusCloudException("Only administrators can register ramdisk images.");
            }
            this.manifest = ImageManifests.requestManifestData(bucketName, manifestKey);
            try {
                DocumentBuilder builder = XMLParser.getDocBuilder();
                this.inputSource = builder.parse(new ByteArrayInputStream(this.manifest.getBytes()));
            }
            catch (Exception e) {
                throw new EucalyptusCloudException("Failed to read manifest file: " + bucketName + "/" + manifestKey, (Throwable)e);
            }
            String temp = (String)this.xpathHelper.apply((Object)"/manifest/image/name/text()");
            this.name = temp != null ? temp : manifestName.replace(".manifest.xml", "");
            temp = (String)this.xpathHelper.apply((Object)"/manifest/image/digest/text()");
            this.checksum = temp != null ? temp : "0000000000000000000000000000000000000000";
            temp = (String)this.xpathHelper.apply((Object)"/manifest/image/digest/@algorithm");
            this.checksumType = temp != null ? temp : "SHA1";
            temp = (String)this.xpathHelper.apply((Object)"//signature");
            this.signature = temp != null ? temp : null;
            temp = (String)this.xpathHelper.apply((Object)"//user");
            this.userId = temp != null ? temp : null;
            String typeInManifest = (String)this.xpathHelper.apply((Object)"/manifest/image/type/text()");
            temp = (String)this.xpathHelper.apply((Object)"/manifest/image/size/text()");
            this.size = temp != null ? Long.parseLong(temp) : -1L;
            temp = (String)this.xpathHelper.apply((Object)"/manifest/image/bundled_size/text()");
            this.bundledSize = temp != null ? Long.parseLong(temp) : -1L;
            String arch = (String)this.xpathHelper.apply((Object)"/manifest/machine_configuration/architecture/text()");
            this.architecture = ImageMetadata.Architecture.valueOf((String)(arch == null ? "i386" : arch));
            try {
                NodeList ancestorNodes = (NodeList)this.xpath.evaluate("/manifest/image/ancestry/ancestor_ami_id/text()", this.inputSource, XPathConstants.NODESET);
                if (ancestorNodes != null) {
                    for (i = 0; i < ancestorNodes.getLength(); ++i) {
                        for (String ancestorId : ancestorNodes.item(i).getNodeValue().split(",")) {
                            this.ancestors.add(ancestorId);
                        }
                    }
                }
            }
            catch (XPathExpressionException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            try {
                NodeList devMapList = (NodeList)this.xpath.evaluate("/manifest/machine_configuration/block_device_mapping/mapping", this.inputSource, XPathConstants.NODESET);
                for (i = 0; i < devMapList.getLength(); ++i) {
                    Node node = devMapList.item(i);
                    NodeList children = node.getChildNodes();
                    String virtualName = null;
                    String device = null;
                    for (int j = 0; j < children.getLength(); ++j) {
                        Node childNode = children.item(j);
                        String nodeType = childNode.getNodeName();
                        if ("virtual".equals(nodeType) && childNode.getTextContent() != null) {
                            virtualName = childNode.getTextContent();
                            continue;
                        }
                        if (!"device".equals(nodeType) || childNode.getTextContent() == null) continue;
                        device = childNode.getTextContent();
                    }
                    if (virtualName == null || device == null) continue;
                    if ("ami".equals(virtualName)) {
                        this.deviceMappings.add(new ManifestDeviceMapping(ImageMetadata.DeviceMappingType.ami, virtualName, device));
                        continue;
                    }
                    if ("root".equals(virtualName)) {
                        this.deviceMappings.add(new ManifestDeviceMapping(ImageMetadata.DeviceMappingType.root, virtualName, device));
                        continue;
                    }
                    if ("swap".equals(virtualName)) {
                        this.deviceMappings.add(new ManifestDeviceMapping(ImageMetadata.DeviceMappingType.swap, virtualName, device));
                        continue;
                    }
                    if (!virtualName.startsWith("ephemeral")) continue;
                    this.deviceMappings.add(new ManifestDeviceMapping(ImageMetadata.DeviceMappingType.ephemeral, virtualName, device));
                }
            }
            catch (XPathExpressionException ex) {
                LOG.error((Object)ex, (Throwable)ex);
            }
            if (checkIdType.apply((Object)ImageMetadata.Type.kernel)) {
                this.imageType = ImageMetadata.Type.kernel;
                this.platform = ImageMetadata.Platform.linux;
                this.virtualizationType = ImageMetadata.VirtualizationType.paravirtualized;
                this.kernelId = null;
                this.ramdiskId = null;
            } else if (checkIdType.apply((Object)ImageMetadata.Type.ramdisk)) {
                this.imageType = ImageMetadata.Type.ramdisk;
                this.platform = ImageMetadata.Platform.linux;
                this.virtualizationType = ImageMetadata.VirtualizationType.paravirtualized;
                this.kernelId = null;
                this.ramdiskId = null;
            } else {
                String kId = (String)this.xpathHelper.apply((Object)ImageMetadata.Type.kernel.getManifestPath());
                String rId = (String)this.xpathHelper.apply((Object)ImageMetadata.Type.ramdisk.getManifestPath());
                this.imageType = ImageMetadata.Type.machine;
                if (!(manifestName.startsWith(ImageMetadata.Platform.windows.toString()) || kId != null && ImageMetadata.Platform.windows.name().equals(kId))) {
                    this.platform = ImageMetadata.Platform.linux;
                    this.virtualizationType = ImageMetadata.VirtualizationType.paravirtualized;
                    if (CloudMetadatas.isKernelImageIdentifier((String)kId)) {
                        ImageManifests.checkPrivileges(this.kernelId);
                        this.kernelId = kId;
                    } else {
                        this.kernelId = null;
                    }
                    if (CloudMetadatas.isRamdiskImageIdentifier((String)rId)) {
                        ImageManifests.checkPrivileges(this.ramdiskId);
                        this.ramdiskId = rId;
                    } else {
                        this.ramdiskId = null;
                    }
                } else {
                    this.platform = ImageMetadata.Platform.windows;
                    this.virtualizationType = ImageMetadata.VirtualizationType.hvm;
                    this.kernelId = null;
                    this.ramdiskId = null;
                }
            }
        }

        public boolean checkManifestSignature(User user) throws EucalyptusCloudException {
            int idxImgOpen = this.manifest.indexOf("<image>");
            int idxImgClose = this.manifest.lastIndexOf("</image>");
            if (idxImgOpen < 0 || idxImgClose < 0 || idxImgOpen > idxImgClose) {
                throw new EucalyptusCloudException("Manifest in wrong format");
            }
            String image = this.manifest.substring(idxImgOpen, idxImgClose + "</image>".length());
            int idxConfOpen = this.manifest.indexOf("<machine_configuration>");
            int idxConfClose = this.manifest.lastIndexOf("</machine_configuration>");
            if (idxConfOpen < 0 || idxConfClose < 0 || idxConfOpen > idxConfClose) {
                throw new EucalyptusCloudException("Manifest in wrong format");
            }
            String machineConfiguration = this.manifest.substring(idxConfOpen, idxConfClose + "</machine_configuration>".length());
            final String pad = machineConfiguration + image;
            Predicate<Certificate> tryVerifyWithCert = new Predicate<Certificate>(){

                public boolean apply(Certificate checkCert) {
                    if (checkCert instanceof X509Certificate) {
                        X509Certificate cert = (X509Certificate)checkCert;
                        try {
                            Signature sigVerifier = Signature.getInstance("SHA1withRSA");
                            PublicKey publicKey = cert.getPublicKey();
                            sigVerifier.initVerify(publicKey);
                            sigVerifier.update(pad.getBytes());
                            return sigVerifier.verify(ImageManifests.hexToBytes(ImageManifest.this.signature));
                        }
                        catch (Exception ex) {
                            LOG.error((Object)ex, (Throwable)ex);
                            return false;
                        }
                    }
                    return false;
                }
            };
            Function<com.eucalyptus.auth.principal.Certificate, X509Certificate> activeEuareToX509 = new Function<com.eucalyptus.auth.principal.Certificate, X509Certificate>(){

                public X509Certificate apply(com.eucalyptus.auth.principal.Certificate input) {
                    return input.isActive() != false ? input.getX509Certificate() : null;
                }
            };
            try {
                if (Iterables.any((Iterable)Lists.transform((List)user.getCertificates(), (Function)activeEuareToX509), (Predicate)tryVerifyWithCert)) {
                    return true;
                }
                if (tryVerifyWithCert.apply((Object)SystemCredentials.lookup(Eucalyptus.class).getCertificate())) {
                    return true;
                }
                for (User u : user.getAccount().getUsers()) {
                    if (!Iterables.any((Iterable)Lists.transform((List)u.getCertificates(), (Function)activeEuareToX509), (Predicate)tryVerifyWithCert)) continue;
                    return true;
                }
                for (Partition p : Partitions.list()) {
                    if (!tryVerifyWithCert.apply((Object)p.getNodeCertificate())) continue;
                    return true;
                }
            }
            catch (AuthException e) {
                throw new EucalyptusCloudException("Invalid Manifest: Failed to verify signature because of missing (deleted?) user certificate.", (Throwable)e);
            }
            return false;
        }

        public String getSignature() {
            return this.signature;
        }

        public ImageMetadata.Platform getPlatform() {
            return this.platform;
        }

        public ImageMetadata.Architecture getArchitecture() {
            return this.architecture;
        }

        public String getKernelId() {
            return this.kernelId;
        }

        public List<ManifestDeviceMapping> getDeviceMappings() {
            return this.deviceMappings;
        }

        public String getAmi() {
            try {
                ManifestDeviceMapping root = (ManifestDeviceMapping)Iterables.find(this.deviceMappings, (Predicate)new Predicate<ManifestDeviceMapping>(){

                    public boolean apply(ManifestDeviceMapping man) {
                        return man.type == ImageMetadata.DeviceMappingType.ami;
                    }
                });
                return root.deviceName;
            }
            catch (NoSuchElementException ex) {
                return "";
            }
        }

        public String getRoot() {
            try {
                ManifestDeviceMapping root = (ManifestDeviceMapping)Iterables.find(this.deviceMappings, (Predicate)new Predicate<ManifestDeviceMapping>(){

                    public boolean apply(ManifestDeviceMapping man) {
                        return man.type == ImageMetadata.DeviceMappingType.root;
                    }
                });
                return root.deviceName;
            }
            catch (NoSuchElementException ex) {
                return "";
            }
        }

        public String getRamdiskId() {
            return this.ramdiskId;
        }

        public ImageMetadata.Type getImageType() {
            return this.imageType;
        }

        public String getImageLocation() {
            return this.imageLocation;
        }

        public String getManifest() {
            return this.manifest;
        }

        public String getName() {
            return this.name;
        }

        public String getAccountId() {
            return this.userId;
        }

        public Long getSize() {
            return this.size;
        }

        public Long getBundledSize() {
            return this.bundledSize;
        }

        public String getChecksum() {
            return this.checksum;
        }

        public String getChecksumType() {
            return this.checksumType;
        }

        public ImageMetadata.VirtualizationType getVirtualizationType() {
            return this.virtualizationType;
        }

        public static class ManifestLocation {
            public final String bucketName;
            public final String manifestKey;
            public final String cleanLocation;

            public ManifestLocation(String imageLocation) throws EucalyptusCloudException {
                this.cleanLocation = imageLocation.replaceAll("^/*", "");
                int index = this.cleanLocation.indexOf(47);
                if (index < 2 || index + 1 >= this.cleanLocation.length()) {
                    throw new EucalyptusCloudException("Invalid image location: " + imageLocation);
                }
                this.bucketName = this.cleanLocation.substring(0, index);
                this.manifestKey = this.cleanLocation.substring(index + 1);
            }
        }
    }

    public static class ManifestDeviceMapping {
        ImageMetadata.DeviceMappingType type;
        String virtualName;
        String deviceName;

        ManifestDeviceMapping(ImageMetadata.DeviceMappingType type, String virtualName, String deviceName) {
            this.type = type;
            this.virtualName = virtualName;
            this.deviceName = deviceName;
        }
    }
}

