/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.cloud.util.MetadataException;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.ClusterController;
import com.eucalyptus.compute.ClientComputeException;
import com.eucalyptus.compute.ComputeException;
import com.eucalyptus.compute.common.BlockDeviceMappingItemType;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.EbsDeviceMapping;
import com.eucalyptus.compute.common.ImageDetails;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.LaunchPermissionItemType;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.backend.ConfirmProductInstanceResponseType;
import com.eucalyptus.compute.common.backend.ConfirmProductInstanceType;
import com.eucalyptus.compute.common.backend.CopyImageResponseType;
import com.eucalyptus.compute.common.backend.CopyImageType;
import com.eucalyptus.compute.common.backend.CreateImageResponseType;
import com.eucalyptus.compute.common.backend.CreateImageType;
import com.eucalyptus.compute.common.backend.DeregisterImageResponseType;
import com.eucalyptus.compute.common.backend.DeregisterImageType;
import com.eucalyptus.compute.common.backend.DescribeImageAttributeResponseType;
import com.eucalyptus.compute.common.backend.DescribeImageAttributeType;
import com.eucalyptus.compute.common.backend.DescribeImagesResponseType;
import com.eucalyptus.compute.common.backend.DescribeImagesType;
import com.eucalyptus.compute.common.backend.ModifyImageAttributeResponseType;
import com.eucalyptus.compute.common.backend.ModifyImageAttributeType;
import com.eucalyptus.compute.common.backend.RegisterImageResponseType;
import com.eucalyptus.compute.common.backend.RegisterImageType;
import com.eucalyptus.compute.common.backend.ResetImageAttributeResponseType;
import com.eucalyptus.compute.common.backend.ResetImageAttributeType;
import com.eucalyptus.compute.identifier.InvalidResourceIdentifier;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.IllegalContextAccessException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.images.BlockStorageDeviceMapping;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.images.DeviceMapping;
import com.eucalyptus.images.Emis;
import com.eucalyptus.images.ImageConfiguration;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.images.ImageManifests;
import com.eucalyptus.images.Images;
import com.eucalyptus.images.InstanceNotTerminatedException;
import com.eucalyptus.images.MachineImageInfo;
import com.eucalyptus.images.NoSuchImageException;
import com.eucalyptus.records.Logs;
import com.eucalyptus.tags.Filter;
import com.eucalyptus.tags.Filters;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Parameters;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.vm.CreateImageTask;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Strings;
import com.google.common.base.Supplier;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.criterion.Criterion;
import org.hibernate.exception.ConstraintViolationException;

public class ImageManager {
    public static Logger LOG = Logger.getLogger(ImageManager.class);
    private static final long GB = 0x40000000L;

    public CopyImageResponseType copyImage(CopyImageType request) {
        return (CopyImageResponseType)request.getReply();
    }

    public DescribeImagesResponseType describe(DescribeImagesType request) throws EucalyptusCloudException, TransactionException {
        DescribeImagesResponseType reply = (DescribeImagesResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        boolean showAllStates = ctx.isAdministrator() && request.getImagesSet().remove("verbose");
        String requestAccountId = ctx.getUserFullName().getAccountNumber();
        List<String> imageIds = ImageManager.normalizeImageIdentifiers(request.getImagesSet());
        ArrayList ownersSet = request.getOwnersSet();
        if (ownersSet.remove("self")) {
            ownersSet.add(requestAccountId);
        }
        Filter filter = Filters.generate(request.getFilterSet(), ImageInfo.class);
        Predicate requestedAndAccessible = CloudMetadatas.filteringFor(ImageInfo.class).byId(imageIds).byOwningAccount((Collection)request.getOwnersSet()).byPredicate(showAllStates ? Predicates.alwaysTrue() : Images.standardStatePredicate()).byPredicate(Images.filterExecutableBy(request.getExecutableBySet())).byPredicate(filter.asPredicate()).byPredicate((Predicate)Images.FilterPermissions.INSTANCE).byPrivilegesWithoutOwner().buildPredicate();
        List imageDetailsList = Transactions.filteredTransform((Object)((Object)new ImageInfo()), (Criterion)filter.asCriterion(), filter.getAliases(), (Predicate)requestedAndAccessible, Images.TO_IMAGE_DETAILS);
        Map<String, List<Tag>> tagsMap = TagSupport.forResourceClass(ImageInfo.class).getResourceTagMap((OwnerFullName)AccountFullName.getInstance((Account)ctx.getAccount(), (String[])new String[0]), Iterables.transform((Iterable)imageDetailsList, (Function)ImageDetailsToImageId.INSTANCE));
        for (ImageDetails details : imageDetailsList) {
            Tags.addFromTags(details.getTagSet(), ResourceTag.class, (Iterable<Tag>)tagsMap.get(details.getImageId()));
        }
        reply.getImagesSet().addAll(imageDetailsList);
        return reply;
    }

    public RegisterImageResponseType register(final RegisterImageType request) throws EucalyptusCloudException, AuthException, IllegalContextAccessException, NoSuchElementException, PersistenceException {
        final Context ctx = Contexts.lookup();
        ImageInfo imageInfo = null;
        final String rootDevName = request.getRootDeviceName() != null ? request.getRootDeviceName() : "/dev/sda";
        final String eki = ImageMetadata.Platform.windows.name().equals(request.getKernelId()) ? request.getKernelId() : ImageManager.normalizeOptionalImageIdentifier(request.getKernelId());
        final String eri = ImageManager.normalizeOptionalImageIdentifier(request.getRamdiskId());
        ImageManager.verifyImageNameAndDescription(request.getName(), request.getDescription());
        ImageMetadata.VirtualizationType virtType = ImageMetadata.VirtualizationType.paravirtualized;
        if (request.getVirtualizationType() != null) {
            if (StringUtils.equalsIgnoreCase((String)"paravirtual", (String)request.getVirtualizationType())) {
                virtType = ImageMetadata.VirtualizationType.paravirtualized;
            } else if (StringUtils.equalsIgnoreCase((String)"hvm", (String)request.getVirtualizationType())) {
                virtType = ImageMetadata.VirtualizationType.hvm;
            } else {
                throw new EucalyptusCloudException("Unknown virtualization-type");
            }
        }
        if (request.getImageLocation() != null) {
            Integer maxSize;
            ImageMetadata.Platform imagePlatform;
            ImageManager.bdmInstanceStoreImageVerifier().apply((Object)request);
            final ImageManifests.ImageManifest manifest = ImageManifests.lookup(request.getImageLocation(), ctx.getUser());
            LOG.debug((Object)("Obtained manifest information for requested image registration: " + manifest));
            ImageMetadata.Platform platform = imagePlatform = request.getPlatform() != null ? ImageMetadata.Platform.valueOf((String)request.getPlatform()) : manifest.getPlatform();
            if (ImageMetadata.Platform.windows.equals((Object)imagePlatform)) {
                virtType = ImageMetadata.VirtualizationType.hvm;
            }
            final ImageMetadata.VirtualizationType virtualizationType = virtType;
            if (ImageMetadata.Type.machine.equals((Object)manifest.getImageType()) && ImageMetadata.VirtualizationType.paravirtualized.equals((Object)virtualizationType)) {
                if (request.getKernelId() == null && manifest.getKernelId() == null) {
                    throw new ClientComputeException("MissingParameter", "Kernel ID must be specified");
                }
                if (request.getRamdiskId() == null && manifest.getRamdiskId() == null) {
                    throw new ClientComputeException("MissingParameter", "Ramdisk ID must be specified");
                }
            }
            if ((maxSize = ImageConfiguration.getInstance().getMaxImageSizeGb()) != null && maxSize > 0 && manifest.getSize() > (long)maxSize.intValue() * 0x40000000L) {
                throw new EucalyptusCloudException("Cannot register image of size " + manifest.getSize() + " bytes because it exceeds the configured maximum instance-store image size of " + maxSize + " GB. Please contact your administrator ");
            }
            List vbr = Lists.transform((List)request.getBlockDeviceMappings(), Images.deviceMappingGenerator(imageInfo, null));
            final ImageMetadata.Architecture arch = request.getArchitecture() == null ? null : ImageMetadata.Architecture.valueOf((String)request.getArchitecture());
            final String amiFromManifest = manifest.getAmi();
            Supplier<ImageInfo> allocator = new Supplier<ImageInfo>(){

                public ImageInfo get() {
                    try {
                        if (ImageMetadata.Type.machine.equals((Object)manifest.getImageType()) && ImageMetadata.VirtualizationType.paravirtualized.equals((Object)virtualizationType) && (amiFromManifest.isEmpty() || ImageManager.isPathAPartition(amiFromManifest))) {
                            return Images.createPendingAvailableFromManifest(ctx.getUserFullName(), request.getName(), request.getDescription(), arch, virtualizationType, ImageMetadata.Platform.linux, ImageMetadata.ImageFormat.partitioned, eki, eri, manifest);
                        }
                        return Images.registerFromManifest(ctx.getUserFullName(), request.getName(), request.getDescription(), arch, virtualizationType, imagePlatform, ImageMetadata.ImageFormat.fulldisk, eki, eri, manifest);
                    }
                    catch (Exception ex) {
                        LOG.error((Object)ex);
                        Logs.extreme().error((Object)ex, (Throwable)ex);
                        throw Exceptions.toUndeclared((Throwable)ex);
                    }
                }
            };
            imageInfo = (ImageInfo)RestrictedTypes.allocateUnitlessResource((Supplier)allocator);
            imageInfo.getDeviceMappings().addAll(vbr);
        } else if (rootDevName != null && Iterables.any((Iterable)request.getBlockDeviceMappings(), Images.findEbsRoot(rootDevName))) {
            Supplier<ImageInfo> allocator = null;
            ImageManager.bdmBfebsImageVerifier().apply((Object)request);
            ImageMetadata.Platform platform = ImageMetadata.Platform.linux;
            if (request.getPlatform() != null) {
                platform = ImageMetadata.Platform.valueOf((String)request.getPlatform());
            } else if (ImageMetadata.Platform.windows.name().equals(eki)) {
                platform = ImageMetadata.Platform.windows;
            }
            final ImageMetadata.Platform imagePlatform = platform;
            final ImageMetadata.Architecture arch = request.getArchitecture() == null ? ImageMetadata.Architecture.i386 : ImageMetadata.Architecture.valueOf((String)request.getArchitecture());
            allocator = new Supplier<ImageInfo>(){

                public ImageInfo get() {
                    try {
                        return Images.createFromDeviceMapping(ctx.getUserFullName(), request.getName(), request.getDescription(), imagePlatform, eki, eri, rootDevName, request.getBlockDeviceMappings(), arch);
                    }
                    catch (EucalyptusCloudException ex) {
                        throw new RuntimeException(ex);
                    }
                }
            };
            imageInfo = (ImageInfo)RestrictedTypes.allocateUnitlessResource((Supplier)allocator);
        } else {
            throw new EucalyptusCloudException("Invalid request:  the request must specify either ImageLocation for an instance-store image or a snapshot for the root device for an EBS image.  Provided values were: ImageLocation=" + request.getImageLocation() + " BlockDeviceMappings=" + request.getBlockDeviceMappings());
        }
        RegisterImageResponseType reply = (RegisterImageResponseType)request.getReply();
        reply.setImageId(imageInfo.getDisplayName());
        return reply;
    }

    public static boolean isPathAPartition(String str) {
        char lastChar = str.charAt(str.length() - 1);
        return !Character.isLetter(lastChar);
    }

    public DeregisterImageResponseType deregister(DeregisterImageType request) throws EucalyptusCloudException {
        DeregisterImageResponseType reply = (DeregisterImageResponseType)request.getReply();
        EntityTransaction tx = Entities.get(ImageInfo.class);
        try {
            ImageInfo imgInfo = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(ImageManager.imageIdentifier(request.getImageId())))));
            if (!ImageManager.canModifyImage(imgInfo)) {
                throw new EucalyptusCloudException("Not authorized to deregister image");
            }
            Images.deregisterImage(imgInfo.getDisplayName());
            tx.commit();
            DeregisterImageResponseType deregisterImageResponseType = reply;
            return deregisterImageResponseType;
        }
        catch (NoSuchImageException | NoSuchElementException ex) {
            throw new ClientComputeException("InvalidAMIID.NotFound", "The image ID '" + request.getImageId() + "' does not exist");
        }
        catch (InstanceNotTerminatedException | ConstraintViolationException re) {
            throw new ClientComputeException("InvalidAMIID.Unavailable", "The image ID '" + request.getImageId() + "' is no longer available");
        }
        catch (TransactionException ex) {
            if (ex.getCause() instanceof NoSuchElementException) {
                throw new ClientComputeException("InvalidAMIID.NotFound", "The image ID '" + request.getImageId() + "' does not exist");
            }
            throw new EucalyptusCloudException((Throwable)ex);
        }
        finally {
            if (tx.isActive()) {
                tx.rollback();
            }
        }
    }

    public ConfirmProductInstanceResponseType confirmProductInstance(ConfirmProductInstanceType request) throws EucalyptusCloudException {
        ConfirmProductInstanceResponseType reply = (ConfirmProductInstanceResponseType)request.getReply();
        reply.set_return(Boolean.valueOf(false));
        VmInstance vm = null;
        try {
            vm = VmInstances.lookup(request.getInstanceId());
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
        return reply;
    }

    public DescribeImageAttributeResponseType describeImageAttribute(DescribeImageAttributeType request) throws EucalyptusCloudException {
        DescribeImageAttributeResponseType reply;
        block25: {
            reply = (DescribeImageAttributeResponseType)request.getReply();
            if (request.getAttribute() != null) {
                request.applyAttribute();
            }
            EntityTransaction tx = Entities.get(ImageInfo.class);
            try {
                ImageInfo imgInfo = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(ImageManager.imageIdentifier(request.getImageId())))));
                if (!ImageManager.canModifyImage(imgInfo)) {
                    throw new EucalyptusCloudException("Not authorized to describe image attribute");
                }
                reply.setImageId(imgInfo.getDisplayName());
                if (request.getKernel() != null) {
                    if (imgInfo instanceof MachineImageInfo && ((MachineImageInfo)imgInfo).getKernelId() != null) {
                        reply.getKernel().add(((MachineImageInfo)imgInfo).getKernelId());
                    }
                    break block25;
                }
                if (request.getRamdisk() != null) {
                    if (imgInfo instanceof MachineImageInfo && ((MachineImageInfo)imgInfo).getRamdiskId() != null) {
                        reply.getRamdisk().add(((MachineImageInfo)imgInfo).getRamdiskId());
                    }
                    break block25;
                }
                if (request.getLaunchPermission() != null) {
                    if (imgInfo.getImagePublic().booleanValue()) {
                        reply.getLaunchPermission().add(LaunchPermissionItemType.newGroupLaunchPermission());
                    }
                    for (String permission : imgInfo.getPermissions()) {
                        reply.getLaunchPermission().add(LaunchPermissionItemType.newUserLaunchPermission((String)permission));
                    }
                    break block25;
                }
                if (request.getProductCodes() != null) {
                    reply.getProductCodes().addAll(imgInfo.getProductCodes());
                    break block25;
                }
                if (request.getBlockDeviceMapping() != null) {
                    if (imgInfo instanceof BlockStorageImageInfo) {
                        BlockStorageImageInfo bfebsImage = (BlockStorageImageInfo)imgInfo;
                        reply.getBlockDeviceMapping().add(new BlockDeviceMappingItemType((Object)VmInstances.EBS_ROOT_DEVICE_NAME, (Object)bfebsImage.getRootDeviceName()));
                        reply.getBlockDeviceMapping().add(new BlockDeviceMappingItemType((Object)"root", (Object)bfebsImage.getRootDeviceName()));
                        int i = 0;
                        for (DeviceMapping mapping : bfebsImage.getDeviceMappings()) {
                            if (mapping.getDeviceName().equalsIgnoreCase(bfebsImage.getRootDeviceName())) continue;
                            switch (mapping.getDeviceMappingType()) {
                                case blockstorage: {
                                    BlockStorageDeviceMapping bsdm = (BlockStorageDeviceMapping)mapping;
                                    BlockDeviceMappingItemType bdmItem = new BlockDeviceMappingItemType((Object)("ebs" + ++i), (Object)mapping.getDeviceName());
                                    EbsDeviceMapping ebsItem = new EbsDeviceMapping();
                                    ebsItem.setSnapshotId(bsdm.getSnapshotId());
                                    ebsItem.setVolumeSize(bsdm.getSize());
                                    ebsItem.setDeleteOnTermination(bsdm.getDelete());
                                    bdmItem.setEbs(ebsItem);
                                    reply.getBlockDeviceMapping().add(bdmItem);
                                    break;
                                }
                                case ephemeral: {
                                    reply.getBlockDeviceMapping().add(new BlockDeviceMappingItemType((Object)mapping.getVirtualName(), (Object)mapping.getDeviceName()));
                                    break;
                                }
                            }
                        }
                    } else {
                        reply.getBlockDeviceMapping().add(new BlockDeviceMappingItemType((Object)VmInstances.EBS_ROOT_DEVICE_NAME, (Object)"sda1"));
                        reply.getBlockDeviceMapping().add(new BlockDeviceMappingItemType((Object)"ephemeral0", (Object)"sda2"));
                        reply.getBlockDeviceMapping().add(new BlockDeviceMappingItemType((Object)"swap", (Object)"sda3"));
                        reply.getBlockDeviceMapping().add(new BlockDeviceMappingItemType((Object)"root", (Object)"/dev/sda1"));
                    }
                    break block25;
                }
                if (request.getDescription() != null) {
                    if (imgInfo.getDescription() != null) {
                        reply.getDescription().add(imgInfo.getDescription());
                    }
                    break block25;
                }
                throw new EucalyptusCloudException("invalid image attribute request.");
            }
            catch (TransactionException | NoSuchElementException ex) {
                throw new EucalyptusCloudException("Error handling image attribute request: " + ex.getMessage(), ex);
            }
            finally {
                tx.commit();
            }
        }
        return reply;
    }

    private static List<String> verifyUserIds(List<String> userIds) throws EucalyptusCloudException {
        HashSet validUserIds = Sets.newHashSet();
        for (String userId : userIds) {
            try {
                validUserIds.add(Accounts.lookupAccountById((String)userId).getAccountNumber());
            }
            catch (Exception e) {
                try {
                    validUserIds.add(Accounts.lookupUserById((String)userId).getAccount().getAccountNumber());
                }
                catch (AuthException ex) {
                    try {
                        validUserIds.add(Accounts.lookupUserByAccessKeyId((String)userId).getAccount().getAccountNumber());
                    }
                    catch (AuthException ex1) {
                        throw new EucalyptusCloudException("Not a valid userId : " + userId);
                    }
                }
            }
        }
        return Lists.newArrayList((Iterable)validUserIds);
    }

    public ModifyImageAttributeResponseType modifyImageAttribute(ModifyImageAttributeType request) throws EucalyptusCloudException {
        ModifyImageAttributeResponseType reply = (ModifyImageAttributeResponseType)request.getReply();
        EntityTransaction tx = Entities.get(ImageInfo.class);
        try {
            ImageInfo imgInfo = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(ImageManager.imageIdentifier(request.getImageId())))));
            if (!ImageManager.canModifyImage(imgInfo)) {
                throw new EucalyptusCloudException("Not authorized to modify image attribute");
            }
            switch (request.imageAttribute()) {
                case LaunchPermission: {
                    if (request.add()) {
                        imgInfo.addPermissions(ImageManager.verifyUserIds(request.userIds()));
                        if (!request.groupAll()) break;
                        imgInfo.setImagePublic(true);
                        break;
                    }
                    imgInfo.removePermissions(request.userIds());
                    if (!request.groupAll()) break;
                    imgInfo.setImagePublic(false);
                    break;
                }
                case ProductCode: {
                    for (String productCode : request.getProductCodes()) {
                        imgInfo.addProductCode(productCode);
                    }
                    break;
                }
                case Description: {
                    imgInfo.setDescription(request.getDescription());
                }
            }
            tx.commit();
            reply.set_return(Boolean.valueOf(true));
        }
        catch (EucalyptusCloudException e) {
            tx.rollback();
            reply.set_return(Boolean.valueOf(false));
            throw e;
        }
        catch (TransactionException | NoSuchElementException ex) {
            tx.rollback();
            throw new EucalyptusCloudException(ex);
        }
        return reply;
    }

    public ResetImageAttributeResponseType resetImageAttribute(ResetImageAttributeType request) throws EucalyptusCloudException {
        ResetImageAttributeResponseType reply = (ResetImageAttributeResponseType)request.getReply();
        reply.set_return(Boolean.valueOf(true));
        EntityTransaction tx = Entities.get(ImageInfo.class);
        try {
            ImageInfo imgInfo = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(ImageManager.imageIdentifier(request.getImageId())))));
            if (ImageManager.canModifyImage(imgInfo)) {
                imgInfo.resetPermission();
                tx.commit();
                return (ResetImageAttributeResponseType)reply.markWinning();
            }
            tx.rollback();
            return (ResetImageAttributeResponseType)reply.markFailed();
        }
        catch (EucalyptusCloudException e) {
            LOG.error((Object)e, (Throwable)e);
            tx.rollback();
            return (ResetImageAttributeResponseType)reply.markFailed();
        }
        catch (TransactionException | NoSuchElementException ex) {
            tx.rollback();
            return (ResetImageAttributeResponseType)reply.markFailed();
        }
    }

    public CreateImageResponseType createImage(CreateImageType request) throws EucalyptusCloudException {
        VmInstance vm;
        CreateImageResponseType reply = (CreateImageResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        ImageManager.verifyImageNameAndDescription(request.getName(), request.getDescription());
        String instanceId = ImageManager.normalizeInstanceIdentifier(request.getInstanceId());
        try {
            vm = (VmInstance)RestrictedTypes.doPrivileged((String)instanceId, VmInstance.class);
            if (!vm.isBlockStorage()) {
                throw new EucalyptusCloudException("Cannot create an image from an instance which is not booted from an EBS volume");
            }
            if (!VmInstance.VmState.RUNNING.equals(vm.getState()) && !VmInstance.VmState.STOPPED.equals(vm.getState())) {
                throw new EucalyptusCloudException("Cannot create an image from an instance which is not in either the 'running' or 'stopped' state: " + vm.getInstanceId() + " is in state " + ((VmInstance.VmState)vm.getState()).getName());
            }
            try {
                Clusters.lookup(Topology.lookup(ClusterController.class, (Partition[])new Partition[]{vm.lookupPartition()}));
            }
            catch (NoSuchElementException e) {
                LOG.debug((Object)e);
                throw new EucalyptusCloudException("Cluster does not exist: " + vm.getPartition());
            }
        }
        catch (AuthException ex) {
            throw new EucalyptusCloudException("Not authorized to create an image from instance " + request.getInstanceId() + " as " + ctx.getUser().getName());
        }
        catch (NoSuchElementException ex) {
            throw new EucalyptusCloudException("Instance does not exist: " + request.getInstanceId(), (Throwable)ex);
        }
        catch (PersistenceException ex) {
            throw new EucalyptusCloudException("Instance does not exist: " + request.getInstanceId(), (Throwable)ex);
        }
        String userId = ctx.getUser().getUserId();
        final String name = request.getName();
        boolean noReboot = request.getNoReboot() != null && request.getNoReboot() != false;
        final String desc = request.getDescription();
        String rootDeviceName = null;
        ArrayList<BlockDeviceMappingItemType> blockDevices = request.getBlockDeviceMappings();
        ImageMetadata.Architecture arch = null;
        ImageMetadata.Platform platform = null;
        try {
            BlockStorageImageInfo image = Emis.LookupBlockStorage.INSTANCE.apply(vm.getImageId());
            arch = image.getArchitecture();
            platform = image.getPlatform();
            rootDeviceName = image.getRootDeviceName();
        }
        catch (Exception ex) {
            throw new EucalyptusCloudException("Unable to get the image information");
        }
        final ImageMetadata.Architecture imageArch = arch;
        final ImageMetadata.Platform imagePlatform = platform;
        if (blockDevices == null) {
            blockDevices = new ArrayList<BlockDeviceMappingItemType>();
        }
        ArrayList<String> suppressedDevice = new ArrayList<String>();
        ArrayList<BlockDeviceMappingItemType> creteImageDevices = new ArrayList<BlockDeviceMappingItemType>();
        List<String> existingNames = VmInstances.lookupPersistentDeviceNames(instanceId);
        for (BlockDeviceMappingItemType device : blockDevices) {
            if (rootDeviceName != null && rootDeviceName.equals(device.getDeviceName())) {
                throw new ClientComputeException("InvalidBlockDeviceMapping", "The device names should not contain root device");
            }
            if (device.getNoDevice() != null && device.getNoDevice().booleanValue()) {
                suppressedDevice.add(device.getDeviceName());
            }
            if (device.getEbs() != null) {
                if (existingNames.contains(device.getDeviceName())) {
                    throw new ClientComputeException("InvalidBlockDeviceMapping", "Can't add new block device mapping with a device name that is already in use");
                }
                creteImageDevices.add(device);
                existingNames.add(device.getDeviceName());
            }
            if (device.getVirtualName() == null) continue;
            existingNames.add(device.getDeviceName());
            creteImageDevices.add(device);
        }
        if (!ImageManager.bdmCreateImageVerifier().apply((Object)request)) {
            throw new ClientComputeException("InvalidBlockDeviceMapping", "A block device mapping parameter is not valid");
        }
        try {
            for (BlockDeviceMappingItemType device : Lists.transform(VmInstances.lookupEphemeralDevices(instanceId), VmInstances.EphemeralAttachmentToDevice)) {
                String dName = device.getDeviceName();
                if (dName != null && existingNames.contains(dName)) {
                    throw new ClientComputeException("InvalidBlockDeviceMapping", "Can't add new block device mapping with a device name that is already in use by an ephemeral device");
                }
                if (dName != null && !suppressedDevice.contains(dName)) {
                    creteImageDevices.add(device);
                    continue;
                }
                blockDevices.add(device);
            }
        }
        catch (ClientComputeException e) {
            throw e;
        }
        catch (Exception ex) {
            LOG.warn((Object)"Failed to retrieve ephemeral device information", (Throwable)ex);
        }
        try {
            Images.validateBlockDeviceMappings(creteImageDevices, EnumSet.of(Images.DeviceMappingValidationOption.AllowEbsMapping));
        }
        catch (MetadataException e) {
            throw new ClientComputeException("InvalidBlockDeviceMapping", e.getMessage());
        }
        final ArrayList<BlockDeviceMappingItemType> blockDeviceMapping = creteImageDevices;
        Supplier<ImageInfo> allocator = new Supplier<ImageInfo>(){

            public ImageInfo get() {
                try {
                    return Images.createPendingFromDeviceMapping(ctx.getUserFullName(), name, desc, imageArch, imagePlatform, blockDeviceMapping);
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        Predicate<ImageInfo> deallocator = new Predicate<ImageInfo>(){

            public boolean apply(@Nullable ImageInfo input) {
                try {
                    Images.setImageState(input.getDisplayName(), ImageMetadata.State.failed);
                    Images.deregisterImage(input.getDisplayName());
                }
                catch (Exception ex) {
                    LOG.error((Object)"failed to delete image from unsucccessful create-image request", (Throwable)ex);
                    return false;
                }
                return true;
            }
        };
        ImageInfo imageInfo = null;
        try {
            imageInfo = (ImageInfo)RestrictedTypes.allocateUnitlessResource((Supplier)allocator);
            reply.setImageId(imageInfo.getDisplayName());
        }
        catch (AuthException ex) {
            throw new ClientComputeException("AuthFailure", "Not authorized to create an image");
        }
        catch (Exception ex) {
            LOG.error((Object)"Unable to register the image", (Throwable)ex);
            throw new EucalyptusCloudException("Unable to register the image", (Throwable)ex);
        }
        CreateImageTask task = new CreateImageTask(userId, instanceId, noReboot, blockDevices);
        try {
            task.create(imageInfo.getDisplayName());
        }
        catch (Exception ex) {
            deallocator.apply((Object)imageInfo);
            LOG.error((Object)"CreateImage task failed", (Throwable)ex);
            if (ex instanceof EucalyptusCloudException) {
                throw (EucalyptusCloudException)((Object)ex);
            }
            throw new EucalyptusCloudException("Create-image has failed", (Throwable)ex);
        }
        return reply;
    }

    private static String imageIdentifier(String identifier) throws EucalyptusCloudException {
        if (!CloudMetadatas.isImageIdentifier((String)identifier)) {
            throw new EucalyptusCloudException("Invalid id: \"" + identifier + "\"");
        }
        return ImageManager.normalizeImageIdentifier(identifier);
    }

    private static Predicate<RegisterImageType> bdmInstanceStoreImageVerifier() {
        return new Predicate<RegisterImageType>(){

            public boolean apply(RegisterImageType arg0) {
                Parameters.checkParam((Object)arg0, (Matcher)Matchers.notNullValue());
                try {
                    Images.validateBlockDeviceMappings(arg0.getBlockDeviceMappings(), EnumSet.of(Images.DeviceMappingValidationOption.AllowSuppressMapping));
                    return true;
                }
                catch (MetadataException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        };
    }

    private static Predicate<RegisterImageType> bdmBfebsImageVerifier() {
        return new Predicate<RegisterImageType>(){

            public boolean apply(RegisterImageType arg0) {
                Parameters.checkParam((Object)arg0, (Matcher)Matchers.notNullValue());
                try {
                    Images.validateBlockDeviceMappings(arg0.getBlockDeviceMappings(), EnumSet.of(Images.DeviceMappingValidationOption.AllowEbsMapping, Images.DeviceMappingValidationOption.AllowDevSda1));
                    return true;
                }
                catch (MetadataException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        };
    }

    private static Predicate<CreateImageType> bdmCreateImageVerifier() {
        return new Predicate<CreateImageType>(){

            public boolean apply(CreateImageType arg0) {
                Parameters.checkParam((Object)arg0, (Matcher)Matchers.notNullValue());
                try {
                    Images.validateBlockDeviceMappings(arg0.getBlockDeviceMappings(), EnumSet.of(Images.DeviceMappingValidationOption.AllowEbsMapping, Images.DeviceMappingValidationOption.AllowSuppressMapping));
                    return true;
                }
                catch (MetadataException e) {
                    throw Exceptions.toUndeclared((Throwable)e);
                }
            }
        };
    }

    private static void verifyImageNameAndDescription(String name, String description) throws ComputeException {
        Context ctx = Contexts.lookup();
        if (name != null) {
            if (!Images.isImageNameValid(name)) {
                throw new ClientComputeException("InvalidAMIName.Malformed", "AMI names must be between 3 and 128 characters long, and may contain letters, numbers, '(', ')', '.', '-', '/' and '_'");
            }
            EntityTransaction db = Entities.get(ImageInfo.class);
            try {
                ArrayList images = Lists.newArrayList((Iterable)Iterables.filter((Iterable)Entities.query((Object)((Object)Images.exampleWithName((OwnerFullName)ctx.getUserFullName().asAccountFullName(), name)), (Entities.QueryOptions)Entities.queryOptions().withReadonly(Boolean.valueOf(true)).build()), (Predicate)new Predicate<ImageInfo>(){

                    public boolean apply(ImageInfo arg0) {
                        return ImageMetadata.State.available.name().equals(((ImageMetadata.State)arg0.getState()).getExternalStateName()) || ImageMetadata.State.pending.name().equals(((ImageMetadata.State)arg0.getState()).getExternalStateName());
                    }
                }));
                if (images.size() > 0) {
                    throw new ClientComputeException("InvalidAMIName.Duplicate", String.format("AMI name %s is already in use by EMI %s", name, ((ImageInfo)((Object)images.get(0))).getDisplayName()));
                }
            }
            catch (ComputeException e) {
                throw e;
            }
            catch (Exception ex) {
                LOG.error((Object)"Error checking for duplicate image name", (Throwable)ex);
                throw new ComputeException("InternalError", "Error processing request.");
            }
            finally {
                db.rollback();
            }
        }
        if (description != null && !Images.isImageDescriptionValid(description)) {
            throw new ClientComputeException("InvalidParameter", "AMI descriptions must be less than 256 characters long");
        }
    }

    private static boolean canModifyImage(ImageInfo imgInfo) {
        Context ctx = Contexts.lookup();
        String requestAccountId = ctx.getUserFullName().getAccountNumber();
        return (ctx.isAdministrator() || imgInfo.getOwnerAccountNumber().equals(requestAccountId)) && RestrictedTypes.filterPrivileged().apply((Object)imgInfo);
    }

    private static String normalizeIdentifier(String identifier, String prefix, boolean required, String message) throws ClientComputeException {
        try {
            return Strings.emptyToNull((String)identifier) == null && !required ? null : ResourceIdentifiers.parse(prefix, identifier).getIdentifier();
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidParameterValue", String.format(message, e.getIdentifier()));
        }
    }

    private static String normalizeInstanceIdentifier(String identifier) throws EucalyptusCloudException {
        return ImageManager.normalizeIdentifier(identifier, "i", true, "Value (%s) for parameter instanceId is invalid. Expected: 'i-...'.");
    }

    private static String normalizeImageIdentifier(String identifier) throws EucalyptusCloudException {
        return ImageManager.normalizeIdentifier(identifier, null, true, "Value (%s) for parameter image is invalid.");
    }

    @Nullable
    private static String normalizeOptionalImageIdentifier(String identifier) throws EucalyptusCloudException {
        return ImageManager.normalizeIdentifier(identifier, null, false, "Value (%s) for parameter image is invalid.");
    }

    private static List<String> normalizeImageIdentifiers(List<String> identifiers) throws EucalyptusCloudException {
        try {
            return ResourceIdentifiers.normalize(identifiers);
        }
        catch (InvalidResourceIdentifier e) {
            throw new ClientComputeException("InvalidParameterValue", "Value (" + e.getIdentifier() + ") for parameter images is invalid.");
        }
    }

    private static enum ImageDetailsToImageId implements Function<ImageDetails, String>
    {
        INSTANCE{

            public String apply(ImageDetails imageDetails) {
                return imageDetails.getImageId();
            }
        };

    }
}

