/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_tags_images")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="image")
public class ImageInfoTag
extends Tag<ImageInfoTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private ImageInfo image;

    protected ImageInfoTag() {
        super("image", ResourceIdFunction.INSTANCE);
    }

    public ImageInfoTag(@Nonnull ImageInfo image, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        super("image", ResourceIdFunction.INSTANCE, ownerFullName, key, value);
        this.setImage(image);
        this.init();
    }

    public ImageInfo getImage() {
        return this.image;
    }

    public void setImage(ImageInfo image) {
        this.image = image;
    }

    @Nonnull
    public static Tag named(@Nonnull ImageInfo image, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return ImageInfoTag.namedWithValue(image, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull ImageInfo image, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)image), (Object)"image");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new ImageInfoTag(image, ownerFullName, key, value);
    }

    public static final class ImageInfoTagSupport
    extends TagSupport {
        public ImageInfoTagSupport() {
            super(ImageInfo.class, Sets.newHashSet((Object[])new String[]{"emi", "eri", "eki", "ami", "ari", "aki"}), "displayName", "image", "InvalidAMIID.NotFound", "The image '%s' does not exist");
        }

        @Override
        public Tag createOrUpdate(CloudMetadata metadata, OwnerFullName ownerFullName, String key, String value) {
            return Tags.createOrUpdate(new ImageInfoTag((ImageInfo)metadata, ownerFullName, key, value));
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new ImageInfoTag(), ownerFullName);
        }

        @Override
        public Tag example(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return ImageInfoTag.namedWithValue((ImageInfo)metadata, ownerFullName, key, value);
        }

        @Override
        public CloudMetadata lookup(String identifier) throws TransactionException {
            return (CloudMetadata)Entities.uniqueResult((Object)((Object)ImageInfo.named(identifier)));
        }
    }

    private static enum ResourceIdFunction implements Function<ImageInfoTag, String>
    {
        INSTANCE{

            public String apply(ImageInfoTag imageInfoTag) {
                return imageInfoTag.getImage().getDisplayName();
            }
        };

    }
}

