/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.images.DeviceMapping;
import com.eucalyptus.images.ImageConfiguration;
import com.eucalyptus.images.ImageInfoTag;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Parameters;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.FetchType;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_images")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="metadata_image_discriminator", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="metadata_kernel_or_ramdisk")
public class ImageInfo
extends UserMetadata<ImageMetadata.State>
implements ImageMetadata {
    @Transient
    private static final long serialVersionUID = 1L;
    @Transient
    private static Logger LOG = Logger.getLogger(ImageInfo.class);
    @Column(name="metadata_image_name", nullable=false)
    private String imageName;
    @Column(name="metadata_image_description")
    private String description;
    @Column(name="metadata_image_arch", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ImageMetadata.Architecture architecture;
    @Column(name="metadata_image_is_public", columnDefinition="boolean default false")
    private Boolean imagePublic;
    @Column(name="metadata_image_platform", nullable=false)
    @Enumerated(value=EnumType.STRING)
    private ImageMetadata.Platform platform;
    @Column(name="metadata_image_type")
    @Enumerated(value=EnumType.STRING)
    private ImageMetadata.Type imageType;
    @ElementCollection
    @CollectionTable(name="metadata_images_permissions")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<String> permissions = new HashSet<String>();
    @ElementCollection
    @CollectionTable(name="metadata_images_pcodes")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<String> productCodes = new HashSet<String>();
    @OneToMany(cascade={CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH}, orphanRemoval=true)
    @JoinColumn(name="metadata_image_dev_map_fk")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<DeviceMapping> deviceMappings = new ArrayList<DeviceMapping>();
    @Column(name="metadata_image_size_bytes", nullable=false)
    private Long imageSizeBytes;
    @Column(name="metadata_image_format", nullable=true)
    private String imageFormat;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="image")
    private Collection<ImageInfoTag> tags;
    @Transient
    private FullName fullName;

    public ImageInfo() {
    }

    public ImageInfo(ImageMetadata.Type imageType) {
        this.imageType = imageType;
    }

    ImageInfo(String imageId) {
        this();
        this.setDisplayName((String)ResourceIdentifiers.tryNormalize().apply((Object)imageId));
    }

    ImageInfo(ImageMetadata.Type imageType, String imageId) {
        this(imageId);
        this.imageType = imageType;
    }

    protected ImageInfo(OwnerFullName ownerFullName, String imageId, ImageMetadata.Type imageType, String imageName, String imageDescription, Long imageSizeBytes, ImageMetadata.Architecture arch, ImageMetadata.Platform platform) {
        this(ownerFullName, (String)ResourceIdentifiers.tryNormalize().apply((Object)imageId));
        Parameters.checkParam((Object)imageName, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((Object)imageType, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((Object)imageSizeBytes, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((Object)arch, (Matcher)Matchers.notNullValue());
        Parameters.checkParam((Object)platform, (Matcher)Matchers.notNullValue());
        this.setState((Enum)ImageMetadata.State.pending);
        this.imageType = imageType;
        this.imageName = imageName;
        this.description = imageDescription;
        this.imageSizeBytes = imageSizeBytes;
        this.architecture = arch;
        this.platform = platform;
        this.imagePublic = ImageConfiguration.getInstance().getDefaultVisibility();
    }

    ImageInfo(OwnerFullName ownerFullName, String imageId) {
        super(ownerFullName, imageId);
    }

    static ImageInfo self(ImageInfo image) {
        return new ImageInfo(image.getDisplayName());
    }

    public static ImageInfo named(String imageId) {
        return new ImageInfo(imageId);
    }

    public ImageMetadata.Type getImageType() {
        return this.imageType;
    }

    public ImageMetadata.Platform getPlatform() {
        return this.platform;
    }

    protected void setPlatform(ImageMetadata.Platform platform) {
        this.platform = platform;
    }

    public ImageMetadata.Architecture getArchitecture() {
        return this.architecture;
    }

    protected void setArchitecture(ImageMetadata.Architecture architecture) {
        this.architecture = architecture;
    }

    public Boolean getImagePublic() {
        return this.imagePublic;
    }

    public void setImagePublic(Boolean aPublic) {
        this.imagePublic = aPublic;
    }

    protected Set<String> getPermissions() {
        return this.permissions;
    }

    private void setPermissions(Set<String> permissions) {
        this.permissions = permissions;
    }

    public void setImageFormat(String imageFormat) {
        this.imageFormat = imageFormat;
    }

    public String getImageFormat() {
        return this.imageFormat;
    }

    public ImageInfo revokePermission(Account account) {
        EntityTransaction db = Entities.get(ImageInfo.class);
        try {
            ImageInfo entity = (ImageInfo)((Object)Entities.merge((Object)((Object)this)));
            entity.getPermissions().remove(account.getAccountNumber());
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
        }
        return this;
    }

    public ImageInfo grantPermission(Account account) {
        EntityTransaction db = Entities.get(ImageInfo.class);
        try {
            ImageInfo entity = (ImageInfo)((Object)Entities.merge((Object)((Object)this)));
            entity.getPermissions().add(account.getAccountNumber());
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
        }
        return this;
    }

    public boolean checkPermission(String accountId) {
        EntityTransaction db = Entities.get(ImageInfo.class);
        try {
            ImageInfo entity = (ImageInfo)((Object)Entities.merge((Object)((Object)this)));
            boolean ret = this.getPermissions().contains(accountId) || this.getOwner().isOwner(accountId);
            db.commit();
            return ret;
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
            return false;
        }
    }

    public ImageInfo resetPermission() {
        try {
            Transactions.one((Object)((Object)new ImageInfo(this.displayName)), (Callback)new Callback<ImageInfo>(){

                public void fire(ImageInfo t) {
                    t.getPermissions().clear();
                    t.getPermissions().add(t.getOwnerAccountNumber());
                    t.setImagePublic(ImageConfiguration.getInstance().getDefaultVisibility());
                }
            });
        }
        catch (ExecutionException e) {
            LOG.debug((Object)e, (Throwable)e);
        }
        return this;
    }

    public ImageInfo resetProductCodes() {
        try {
            Transactions.one((Object)((Object)ImageInfo.self(this)), (Callback)new Callback<ImageInfo>(){

                public void fire(ImageInfo t) {
                    t.getProductCodes().clear();
                }
            });
        }
        catch (ExecutionException e) {
            LOG.debug((Object)e, (Throwable)e);
        }
        return this;
    }

    public Set<String> getProductCodes() {
        return this.productCodes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ImageInfo imageInfo = (ImageInfo)((Object)o);
        return this.getDisplayName().equals(imageInfo.getDisplayName());
    }

    public int hashCode() {
        return this.getDisplayName().hashCode();
    }

    public String toString() {
        return this.getFullName().toString();
    }

    public String getPartition() {
        return ((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name();
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"image", this.getDisplayName()});
    }

    protected void setImageType(ImageMetadata.Type imageType) {
        this.imageType = imageType;
    }

    public Long getImageSizeBytes() {
        return this.imageSizeBytes;
    }

    protected void setImageSizeBytes(Long imageSizeBytes) {
        this.imageSizeBytes = imageSizeBytes;
    }

    public boolean addProductCode(String prodCode) {
        EntityTransaction db = Entities.get(ImageInfo.class);
        try {
            ImageInfo entity = (ImageInfo)((Object)Entities.merge((Object)((Object)this)));
            entity.getProductCodes().add(prodCode);
            db.commit();
            return true;
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
            return false;
        }
    }

    public String getDescription() {
        return this.description;
    }

    protected void setDescription(String description) {
        this.description = description;
    }

    public List<DeviceMapping> getDeviceMappings() {
        return this.deviceMappings;
    }

    protected void setDeviceMappings(List<DeviceMapping> deviceMappings) {
        this.deviceMappings = deviceMappings;
    }

    public String getImageName() {
        return this.imageName;
    }

    public void setImageName(String imageName) {
        this.imageName = imageName;
    }

    public boolean hasPermission(String ... accountIds) {
        return !Sets.intersection(this.getPermissions(), (Set)Sets.newHashSet((Object[])accountIds)).isEmpty();
    }

    public void addPermissions(List<String> accountIds) {
        EntityTransaction db = Entities.get(ImageInfo.class);
        try {
            ImageInfo entity = (ImageInfo)((Object)Entities.merge((Object)((Object)this)));
            Iterables.all(accountIds, (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    try {
                        Account account = Accounts.lookupAccountById((String)input);
                        ImageInfo.this.getPermissions().add(input);
                    }
                    catch (Exception e) {
                        try {
                            User user = Accounts.lookupUserById((String)input);
                            ImageInfo.this.getPermissions().add(user.getAccount().getAccountNumber());
                        }
                        catch (AuthException ex) {
                            try {
                                User user = Accounts.lookupUserByAccessKeyId((String)input);
                                ImageInfo.this.getPermissions().add(user.getAccount().getAccountNumber());
                            }
                            catch (AuthException ex1) {
                                LOG.error((Object)ex1, (Throwable)ex1);
                            }
                        }
                    }
                    return true;
                }
            });
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
        }
    }

    public void removePermissions(List<String> accountIds) {
        EntityTransaction db = Entities.get(ImageInfo.class);
        try {
            ImageInfo entity = (ImageInfo)((Object)Entities.merge((Object)((Object)this)));
            Iterables.all(accountIds, (Predicate)new Predicate<String>(){

                public boolean apply(String input) {
                    ImageInfo.this.getPermissions().remove(input);
                    return true;
                }
            });
            db.commit();
        }
        catch (Exception ex) {
            Logs.exhaust().error((Object)ex, (Throwable)ex);
            db.rollback();
        }
    }

    public static ImageInfo named(@Nullable OwnerFullName input, @Nullable String imageId) {
        return new ImageInfo(input, imageId);
    }
}

