/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.principal.AccessKey;
import com.eucalyptus.bootstrap.Bootstrap;
import com.eucalyptus.component.ComponentId;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.Partitions;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.ComputeMessage;
import com.eucalyptus.compute.common.DeleteResourceTag;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.ResourceTag;
import com.eucalyptus.compute.common.backend.CreateTagsResponseType;
import com.eucalyptus.compute.common.backend.CreateTagsType;
import com.eucalyptus.compute.common.backend.DeleteTagsResponseType;
import com.eucalyptus.compute.common.backend.DeleteTagsType;
import com.eucalyptus.crypto.Crypto;
import com.eucalyptus.crypto.util.B64;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.event.ClockTick;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.images.Emis;
import com.eucalyptus.images.ImageConfiguration;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.images.Images;
import com.eucalyptus.images.KernelImageInfo;
import com.eucalyptus.images.MachineImageInfo;
import com.eucalyptus.images.RamdiskImageInfo;
import com.eucalyptus.imaging.common.ConvertedImageDetail;
import com.eucalyptus.imaging.common.DescribeConversionTasksResponseType;
import com.eucalyptus.imaging.common.DescribeConversionTasksType;
import com.eucalyptus.imaging.common.DiskImageConversionTask;
import com.eucalyptus.imaging.common.Imaging;
import com.eucalyptus.imaging.common.ImagingMessage;
import com.eucalyptus.imaging.common.ImportDiskImage;
import com.eucalyptus.imaging.common.ImportDiskImageDetail;
import com.eucalyptus.imaging.common.ImportImageResponseType;
import com.eucalyptus.imaging.common.ImportImageType;
import com.eucalyptus.imaging.manifest.BundleImageManifest;
import com.eucalyptus.imaging.manifest.DownloadManifestFactory;
import com.eucalyptus.imaging.manifest.ImageManifest;
import com.eucalyptus.imaging.manifest.ImageManifestFile;
import com.eucalyptus.objectstorage.ObjectStorage;
import com.eucalyptus.objectstorage.msgs.CreateBucketResponseType;
import com.eucalyptus.objectstorage.msgs.CreateBucketType;
import com.eucalyptus.objectstorage.msgs.DeleteBucketResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteBucketType;
import com.eucalyptus.objectstorage.msgs.DeleteObjectResponseType;
import com.eucalyptus.objectstorage.msgs.DeleteObjectType;
import com.eucalyptus.objectstorage.msgs.ListAllMyBucketsResponseType;
import com.eucalyptus.objectstorage.msgs.ListAllMyBucketsType;
import com.eucalyptus.objectstorage.msgs.ListBucketResponseType;
import com.eucalyptus.objectstorage.msgs.ListBucketType;
import com.eucalyptus.objectstorage.msgs.ObjectStorageRequestType;
import com.eucalyptus.storage.msgs.s3.BucketListEntry;
import com.eucalyptus.storage.msgs.s3.ListEntry;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.DispatchingClient;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.async.Futures;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import java.net.URI;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.log4j.Logger;

public class ImageConversionManager
implements EventListener<ClockTick> {
    private static Logger LOG = Logger.getLogger(ImageConversionManager.class);
    public static final String BUCKET_PREFIX = "euca-internal";
    private static final LoadingCache<String, Optional<DiskImageConversionTask>> conversionTaskCache = CacheBuilder.newBuilder().maximumSize(250L).expireAfterWrite(20L, TimeUnit.SECONDS).build((CacheLoader)new CacheLoader<String, Optional<DiskImageConversionTask>>(){

        public Optional<DiskImageConversionTask> load(String taskId) throws Exception {
            try {
                DescribeConversionTasks task = new DescribeConversionTasks(Lists.newArrayList((Object[])new String[]{taskId}));
                CheckedListenableFuture<Boolean> result = task.dispatch();
                if (((Boolean)result.get()).booleanValue()) {
                    return Optional.of((Object)task.getTasks().get(0));
                }
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to call describe-conversion-task: " + taskId));
            }
            return Optional.absent();
        }
    });
    private static Set<String> taggedImages = Sets.newHashSet();
    static final String TAG_KEY_STATE = "euca:image-conversion-state";
    static final String TAG_KEY_MESSAGE = "euca:image-conversion-status";
    static final Map<String, String> tagState = Maps.newHashMap();
    static final Map<String, String> tagMessage = Maps.newHashMap();

    public static void register() {
        Listeners.register(ClockTick.class, (EventListener)new ImageConversionManager());
    }

    public void fireEvent(ClockTick event) {
        if (!Bootstrap.isFinished().booleanValue() || !Topology.isEnabledLocally(Eucalyptus.class)) {
            return;
        }
        List<ImageInfo> partitionedImages = this.getPartitionedImages();
        ArrayList newConversion = Lists.newArrayList((Iterable)Collections2.filter(partitionedImages, (Predicate)new Predicate<ImageInfo>(){

            public boolean apply(ImageInfo arg0) {
                if (arg0 instanceof MachineImageInfo) {
                    MachineImageInfo image = (MachineImageInfo)arg0;
                    return ImageMetadata.State.pending_conversion.equals((Object)image.getState()) && (image.getImageConversionId() == null || image.getImageConversionId().length() <= 0);
                }
                return false;
            }
        }));
        ArrayList inConversion = Lists.newArrayList((Iterable)Collections2.filter(partitionedImages, (Predicate)new Predicate<ImageInfo>(){

            public boolean apply(ImageInfo arg0) {
                if (arg0 instanceof MachineImageInfo) {
                    MachineImageInfo image = (MachineImageInfo)arg0;
                    return image.getImageConversionId() != null && image.getImageConversionId().length() > 0 && (ImageMetadata.State.pending_conversion.equals((Object)image.getState()) || ImageMetadata.State.deregistered_cleanup.equals((Object)image.getState()));
                }
                return false;
            }
        }));
        if (!(Topology.isEnabled(Imaging.class) || newConversion.isEmpty() && inConversion.isEmpty())) {
            LOG.warn((Object)"To convert partitioned images, Imaging Service should be enabled");
            return;
        }
        if (!Topology.isEnabled(ObjectStorage.class) && !newConversion.isEmpty()) {
            LOG.warn((Object)"To convert partitioned images, Object Storage Service should be enabled");
            return;
        }
        try {
            this.createBuckets(newConversion);
            this.convertImages(newConversion);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to convert images", (Throwable)ex);
        }
        try {
            this.checkConversion(inConversion);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to check and update images in conversion", (Throwable)ex);
        }
        ArrayList cleanupImages = Lists.newArrayList((Iterable)Collections2.filter(this.getDeregisteredCleanupImages(), (Predicate)new Predicate<ImageInfo>(){

            public boolean apply(ImageInfo arg0) {
                return !ImageMetadata.State.pending_conversion.equals((Object)arg0.getLastState());
            }
        }));
        try {
            this.cleanupBuckets(cleanupImages, true);
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to clean up objects and bucket of deregistered images", (Throwable)ex);
        }
        try {
            this.updateTags(Lists.transform(partitionedImages, (Function)new Function<ImageInfo, String>(){

                public String apply(ImageInfo arg0) {
                    return arg0.getDisplayName();
                }
            }));
        }
        catch (Exception ex) {
            LOG.error((Object)"Failed to tag images and instances in conversion", (Throwable)ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void createBuckets(List<ImageInfo> images) throws Exception {
        HashSet systemBuckets = null;
        if (images.size() > 0) {
            try {
                ListBucketsTask task = new ListBucketsTask();
                CheckedListenableFuture<Boolean> result = task.dispatch();
                if (((Boolean)result.get()).booleanValue()) {
                    List<String> bucketNames = task.getBuckets();
                    systemBuckets = Sets.newHashSet();
                    systemBuckets.addAll(bucketNames);
                }
            }
            catch (Exception ex) {
                throw new Exception("Failed to check the existing buckets", ex);
            }
        }
        String newBucket = null;
        Iterator<ImageInfo> i$ = images.iterator();
        while (i$.hasNext()) {
            ImageInfo image = i$.next();
            try {
                if (!(image instanceof MachineImageInfo)) continue;
                MachineImageInfo machineImage = (MachineImageInfo)image;
                String manifestLocation = machineImage.getManifestLocation();
                String[] tokens = manifestLocation.split("/");
                String bucketName = tokens[0];
                String prefix = tokens[1].replace(".manifest.xml", "");
                do {
                    if ((newBucket = String.format("%s-%s-%s", BUCKET_PREFIX, Crypto.generateAlphanumericId((int)5, (String)""), bucketName)).length() <= 63) continue;
                    newBucket = String.format("%s-%s", BUCKET_PREFIX, Crypto.generateAlphanumericId((int)8, (String)""));
                } while (systemBuckets.contains(newBucket = newBucket.toLowerCase()));
                try {
                    CreateBucketTask task = new CreateBucketTask(newBucket);
                    CheckedListenableFuture<Boolean> result = task.dispatch();
                    if (!((Boolean)result.get()).booleanValue()) {
                        // empty if block
                    }
                }
                catch (Exception ex) {
                    throw new Exception("Failed to create a system-owned bucket for converted image", ex);
                }
                String runManifestPath = String.format("%s/%s.manifest.xml", newBucket, prefix);
                try {
                    machineImage.setRunManifestLocation(runManifestPath);
                    Images.setRunManifestLocation(machineImage.getDisplayName(), runManifestPath);
                }
                catch (Exception ex) {
                    throw new Exception("Failed to update run manifest location");
                }
            }
            catch (Exception ex) {
                LOG.error((Object)String.format("Unable to create the bucket %s for image %s", newBucket, image.getDisplayName()));
                this.resetImagePendingAvailable(image.getDisplayName(), "Failed to create bucket");
                throw ex;
            }
        }
        return;
    }

    private void cleanupBuckets(List<ImageInfo> images, boolean deregister) {
        HashSet systemBuckets = null;
        if (images.size() > 0) {
            try {
                ListBucketsTask task = new ListBucketsTask();
                CheckedListenableFuture<Boolean> result = task.dispatch();
                if (((Boolean)result.get()).booleanValue()) {
                    List<String> bucketNames = task.getBuckets();
                    systemBuckets = Sets.newHashSet();
                    systemBuckets.addAll(bucketNames);
                }
            }
            catch (Exception task) {
                // empty catch block
            }
        }
        for (ImageInfo image : images) {
            if (!(image instanceof MachineImageInfo)) continue;
            try {
                String[] tokens;
                String bucket;
                MachineImageInfo machineImage = (MachineImageInfo)image;
                String runManifestPath = machineImage.getRunManifestLocation();
                String manifestPath = machineImage.getManifestLocation();
                if (runManifestPath == null || runManifestPath.length() <= 0 || runManifestPath.equals(manifestPath) || !systemBuckets.contains(bucket = (tokens = runManifestPath.split("/"))[0])) continue;
                ListObjectsInBucketTask listObjTask = new ListObjectsInBucketTask(bucket);
                CheckedListenableFuture<Boolean> result = listObjTask.dispatch();
                List<String> keysInBucket = null;
                if (!((Boolean)result.get()).booleanValue()) {
                    throw new Exception("Failed to list bucket");
                }
                keysInBucket = listObjTask.getKeyNames();
                for (String key : keysInBucket) {
                    DeleteObjectTask delObjTask = new DeleteObjectTask(bucket, key);
                    CheckedListenableFuture<Boolean> delResult = delObjTask.dispatch();
                    if (((Boolean)delResult.get()).booleanValue()) continue;
                    throw new Exception("Failed to delete object " + bucket + ":" + key);
                }
                DeleteBucketTask delBucketTask = new DeleteBucketTask(bucket);
                result = delBucketTask.dispatch();
                if (!((Boolean)result.get()).booleanValue()) {
                    throw new Exception("Failed to delete the bucket " + bucket);
                }
                if (!deregister) continue;
                Images.setImageState(image.getDisplayName(), ImageMetadata.State.deregistered);
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to cleanup buckets and objects of deregistered image " + image.getDisplayName()), (Throwable)ex);
            }
        }
    }

    private void convertImages(List<ImageInfo> images) {
        for (ImageInfo image : images) {
            if (!(image instanceof MachineImageInfo)) continue;
            try {
                MachineImageInfo machineImage = (MachineImageInfo)image;
                String kernelId = machineImage.getKernelId();
                String ramdiskId = machineImage.getRamdiskId();
                if (kernelId == null || ramdiskId == null) {
                    LOG.warn((Object)String.format("Kernel and ramdisk are not found for the image %s", image.getDisplayName()));
                    continue;
                }
                KernelImageInfo kernel = Images.lookupKernel(kernelId);
                RamdiskImageInfo ramdisk = Images.lookupRamdisk(ramdiskId);
                ServiceConfiguration osg = Topology.lookup(ObjectStorage.class, (Partition[])new Partition[0]);
                URI osgUri = osg.getUri();
                String osgPrefix = String.format("%s://%s:%d%s", osgUri.getScheme(), osgUri.getHost(), osgUri.getPort(), osgUri.getPath());
                String kernelManifest = String.format("%s/%s", osgPrefix, kernel.getManifestLocation());
                String ramdiskManifest = String.format("%s/%s", osgPrefix, ramdisk.getManifestLocation());
                String machineManifest = String.format("%s/%s", osgPrefix, machineImage.getManifestLocation());
                String[] tokens = machineImage.getRunManifestLocation().split("/");
                String bucket = tokens[0];
                String prefix = tokens[1].replace(".manifest.xml", "");
                String taskId = null;
                ImportImageBuilder builder = new ImportImageBuilder();
                ImportImageTask task = new ImportImageTask(builder.withArchitecture(machineImage.getArchitecture().name()).withBucket(bucket).withPrefix(prefix).withKernel(kernel.getDisplayName(), kernelManifest, kernel.getImageSizeBytes()).withRamdisk(ramdisk.getDisplayName(), ramdiskManifest, ramdisk.getImageSizeBytes()).withMachineImage(machineImage.getDisplayName(), machineManifest, machineImage.getImageSizeBytes()).withBucketUploadPolicy(bucket, prefix));
                CheckedListenableFuture<Boolean> result = task.dispatch();
                if (((Boolean)result.get()).booleanValue()) {
                    taskId = task.getTaskId();
                }
                if (taskId == null) {
                    throw new Exception("ImportImage Task id is null");
                }
                Images.setConversionTaskId(machineImage.getDisplayName(), taskId);
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to convert the image: " + image.getDisplayName()), (Throwable)ex);
                try {
                    this.cleanupBuckets(Lists.newArrayList((Object[])new ImageInfo[]{image}), false);
                    this.resetImagePendingAvailable(image.getDisplayName(), "Failed to request conversion");
                }
                catch (Exception ex2) {
                    LOG.error((Object)("Failed to cleanup the image's system bucket; setting image state failed: " + image.getDisplayName()));
                    try {
                        Images.setImageState(image.getDisplayName(), ImageMetadata.State.failed);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void checkConversion(List<ImageInfo> images) {
        for (ImageInfo image : images) {
            if (!(image instanceof MachineImageInfo)) continue;
            try {
                MachineImageInfo machineImage = (MachineImageInfo)image;
                String taskId = machineImage.getImageConversionId();
                if (taskId == null || taskId.length() <= 0) {
                    throw new Exception("Image " + machineImage.getDisplayName() + " has no conversion task Id");
                }
                DescribeConversionTasks task = new DescribeConversionTasks(Lists.newArrayList((Object[])new String[]{machineImage.getImageConversionId()}));
                CheckedListenableFuture<Boolean> result = task.dispatch();
                List<DiskImageConversionTask> ctasks = null;
                if (((Boolean)result.get()).booleanValue()) {
                    ctasks = task.getTasks();
                }
                boolean conversionSuccess = true;
                String errorMessage = null;
                if (ctasks.size() <= 0) {
                    conversionSuccess = true;
                } else {
                    DiskImageConversionTask ct = ctasks.get(0);
                    if ("completed".equals(ct.getState())) {
                        conversionSuccess = true;
                    } else {
                        if ("active".equals(ct.getState())) continue;
                        conversionSuccess = false;
                        errorMessage = ct.getStatusMessage();
                    }
                }
                if (conversionSuccess) {
                    if (ImageMetadata.State.deregistered_cleanup.equals((Object)image.getState())) {
                        try {
                            this.cleanupBuckets(Lists.newArrayList((Object[])new ImageInfo[]{image}), true);
                        }
                        catch (Exception ct) {}
                        continue;
                    }
                    Images.setImageFormat(machineImage.getDisplayName(), ImageMetadata.ImageFormat.fulldisk);
                    Images.setImageState(machineImage.getDisplayName(), ImageMetadata.State.available);
                    try {
                        this.generateDownloadManifests(machineImage.getDisplayName());
                    }
                    catch (Exception ct) {}
                    continue;
                }
                LOG.warn((Object)("Conversion task for image " + image.getDisplayName() + " has failed: " + errorMessage));
                try {
                    this.cleanupBuckets(Lists.newArrayList((Object[])new ImageInfo[]{image}), false);
                    this.resetImagePendingAvailable(image.getDisplayName(), null);
                }
                catch (Exception ex) {
                    LOG.error((Object)("Failed to cleanup the image's system bucket; setting image state failed: " + image.getDisplayName()));
                    Images.setImageState(machineImage.getDisplayName(), ImageMetadata.State.failed);
                }
            }
            catch (Exception ex) {
                LOG.warn((Object)("Conversion task for image " + image.getDisplayName() + " has failed: "), (Throwable)ex);
                try {
                    this.cleanupBuckets(Lists.newArrayList((Object[])new ImageInfo[]{image}), false);
                    this.resetImagePendingAvailable(image.getDisplayName(), "Failed to check conversion status");
                }
                catch (Exception ex2) {
                    LOG.error((Object)("Failed to cleanup the image's system bucket; setting image state failed: " + image.getDisplayName()));
                    try {
                        Images.setImageState(image.getDisplayName(), ImageMetadata.State.failed);
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private void generateDownloadManifests(final String imageId) {
        List<VmInstance> pendingInstances = VmInstances.list((Predicate<? super VmInstance>)new Predicate<VmInstance>(){

            public boolean apply(VmInstance arg0) {
                return imageId.equals(arg0.getBootRecord().getMachineImageId()) && VmInstance.VmState.PENDING.equals(arg0.getState());
            }
        });
        for (VmInstance instance : pendingInstances) {
            String reservationId = instance.getReservationId();
            String partitionName = instance.getPartition();
            Partition partition = Partitions.lookupByName((String)partitionName);
            MachineImageInfo machineImage = Emis.LookupMachine.INSTANCE.apply(imageId);
            try {
                DownloadManifestFactory.generateDownloadManifest((ImageManifestFile)new ImageManifestFile(machineImage.getRunManifestLocation(), (ImageManifest)BundleImageManifest.INSTANCE, ImageConfiguration.getInstance().getMaxManifestSizeBytes().intValue()), (PublicKey)partition.getNodeCertificate().getPublicKey(), (String)reservationId, (boolean)false);
                LOG.debug((Object)String.format("Generated download manifest for instance %s", instance.getDisplayName()));
            }
            catch (Exception ex) {
                LOG.error((Object)String.format("Failed to generate download manifest for instance %s", instance.getDisplayName()), (Throwable)ex);
            }
        }
    }

    private List<ImageInfo> getPartitionedImages() {
        List partitionedImages = null;
        try (TransactionResource db = Entities.transactionFor(ImageInfo.class);){
            partitionedImages = Entities.query((Object)((Object)Images.exampleWithImageFormat(ImageMetadata.ImageFormat.partitioned)));
        }
        return partitionedImages;
    }

    private List<ImageInfo> getDeregisteredCleanupImages() {
        List images = null;
        try (TransactionResource db = Entities.transactionFor(ImageInfo.class);){
            images = Entities.query((Object)((Object)Images.exampleWithImageState(ImageMetadata.State.deregistered_cleanup)));
        }
        return images;
    }

    private List<ImageInfo> getPendingConversionImages() {
        List pendingImages = null;
        try (TransactionResource db = Entities.transactionFor(ImageInfo.class);){
            pendingImages = Entities.query((Object)((Object)Images.exampleWithImageState(ImageMetadata.State.pending_conversion)));
        }
        return pendingImages;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateTags(List<String> images) throws Exception {
        for (String imageId : images) {
            try {
                ImageInfo image = Images.lookupImage(imageId);
                ImageMetadata.State imgState = (ImageMetadata.State)image.getState();
                String taskId = ((MachineImageInfo)image).getImageConversionId();
                if (ImageMetadata.State.pending_available.equals((Object)imgState)) continue;
                if (ImageMetadata.State.pending_conversion.equals((Object)imgState)) {
                    String message = "";
                    try {
                        Optional task = (Optional)conversionTaskCache.get((Object)taskId);
                        if (task.isPresent()) {
                            message = ((DiskImageConversionTask)task.get()).getStatusMessage();
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    this.tagResources(imageId, "active", message);
                    taggedImages.add(imageId);
                    continue;
                }
                if (!ImageMetadata.State.available.equals((Object)imgState) || !taggedImages.contains(imageId)) continue;
                try {
                    this.removeTags(imageId);
                }
                catch (Exception exception) {}
                continue;
                finally {
                    taggedImages.remove(imageId);
                }
            }
            catch (Exception ex) {
                LOG.error((Object)"Failed to update tags for resources in conversion", (Throwable)ex);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetImagePendingAvailable(String imageId, String reason) {
        String taskMessage = "";
        try {
            ImageInfo image = Images.lookupImage(imageId);
            String taskId = ((MachineImageInfo)image).getImageConversionId();
            if (taskId != null) {
                conversionTaskCache.invalidate((Object)taskId);
                Optional task = (Optional)conversionTaskCache.get((Object)taskId);
                if (task.isPresent()) {
                    taskMessage = ((DiskImageConversionTask)task.get()).getStatusMessage();
                }
            }
            String tagMessage = reason != null ? reason : taskMessage;
            this.tagResources(imageId, "failed", tagMessage);
        }
        catch (Exception image) {
        }
        finally {
            taggedImages.remove(imageId);
        }
        try (TransactionResource db = Entities.transactionFor(ImageInfo.class);){
            try {
                ImageInfo entity = (ImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleWithImageId(imageId))));
                entity.setState((Enum)ImageMetadata.State.pending_available);
                entity.setImageFormat(ImageMetadata.ImageFormat.partitioned.name());
                ((MachineImageInfo)entity).setImageConversionId(null);
                Entities.persist((Object)((Object)entity));
                db.commit();
            }
            catch (Exception ex) {
                LOG.error((Object)("Failed to mark the image state available for conversion: " + imageId), (Throwable)ex);
            }
        }
    }

    private void tagResources(String imageId, String state, String statusMessage) throws Exception {
        String instanceOwnerId;
        String instanceId;
        ImageInfo image = Images.lookupImage(imageId);
        String imageOwnerId = image.getOwnerUserId();
        List<VmInstance> instances = this.lookupInstances(imageId);
        if (!tagState.containsKey(imageId) || !state.equals(tagState.get(imageId))) {
            this.resetTag(imageOwnerId, imageId, TAG_KEY_STATE, state);
            tagState.put(imageId, state);
        }
        for (VmInstance instance : instances) {
            instanceId = instance.getInstanceId();
            instanceOwnerId = instance.getOwnerUserId();
            if (tagState.containsKey(instanceId) && state.equals(tagState.get(instanceId))) continue;
            this.resetTag(instanceOwnerId, instanceId, TAG_KEY_STATE, state);
            tagState.put(instanceId, state);
        }
        if (statusMessage == null) {
            statusMessage = "";
        }
        if (!tagMessage.containsKey(imageId) || !statusMessage.equals(tagMessage.get(imageId))) {
            this.resetTag(imageOwnerId, imageId, TAG_KEY_MESSAGE, statusMessage);
            tagMessage.put(imageId, statusMessage);
        }
        for (VmInstance instance : instances) {
            instanceId = instance.getInstanceId();
            instanceOwnerId = instance.getOwnerUserId();
            if (tagMessage.containsKey(instanceId) && statusMessage.equals(tagMessage.get(instanceId))) continue;
            this.resetTag(instanceOwnerId, instanceId, TAG_KEY_MESSAGE, statusMessage);
            tagMessage.put(instanceId, statusMessage);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void resetTag(String userId, String resourceId, String tagKey, String tagValue) throws Exception {
        try {
            DeleteTagsTask task = new DeleteTagsTask(userId, Lists.newArrayList((Object[])new String[]{resourceId}), Lists.newArrayList((Object[])new String[]{tagKey}));
            CheckedListenableFuture<Boolean> result = task.dispatch();
            if (!((Boolean)result.get()).booleanValue()) {
                // empty if block
            }
        }
        catch (Exception task) {
            // empty catch block
        }
        HashMap tag = Maps.newHashMap();
        tag.put(tagKey, tagValue);
        CreateTagsTask task = new CreateTagsTask(userId, Lists.newArrayList((Object[])new String[]{resourceId}), tag);
        CheckedListenableFuture<Boolean> result = task.dispatch();
        if (((Boolean)result.get()).booleanValue()) {
            return;
        }
        throw new Exception(String.format("Failed to create tag (%s-%s:%s)", resourceId, tagKey, tagValue));
    }

    private void removeTags(String imageId) throws Exception {
        ImageInfo image = Images.lookupImage(imageId);
        String imageOwnerId = image.getOwnerUserId();
        DeleteTagsTask task = new DeleteTagsTask(imageOwnerId, Lists.newArrayList((Object[])new String[]{image.getDisplayName()}), Lists.newArrayList((Object[])new String[]{TAG_KEY_STATE, TAG_KEY_MESSAGE}));
        CheckedListenableFuture<Boolean> result = task.dispatch();
        if (((Boolean)result.get()).booleanValue()) {
            // empty if block
        }
        List<VmInstance> instances = this.lookupInstances(imageId);
        for (VmInstance instance : instances) {
            String instanceId = instance.getInstanceId();
            String instanceOwnerId = instance.getOwnerUserId();
            try {
                task = new DeleteTagsTask(instanceOwnerId, Lists.newArrayList((Object[])new String[]{instanceId}), Lists.newArrayList((Object[])new String[]{TAG_KEY_STATE, TAG_KEY_MESSAGE}));
                result = task.dispatch();
                if (!((Boolean)result.get()).booleanValue()) continue;
            }
            catch (Exception exception) {}
        }
    }

    private List<VmInstance> lookupInstances(final String imageId) {
        try {
            List<VmInstance> instances = VmInstances.list((Predicate<? super VmInstance>)new Predicate<VmInstance>(){

                public boolean apply(VmInstance arg0) {
                    return imageId.equals(arg0.getBootRecord().getMachineImageId());
                }
            });
            return instances;
        }
        catch (Exception ex) {
            return Lists.newArrayList();
        }
    }

    private static abstract class ActivityTask<TM extends BaseMessage, TC extends ComponentId> {
        private volatile boolean dispatched = false;

        protected ActivityTask() {
        }

        final CheckedListenableFuture<Boolean> dispatch() {
            try {
                final CheckedListenableFuture future = Futures.newGenericeFuture();
                this.dispatchInternal(new Callback.Checked<TM>(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void fireException(Throwable throwable) {
                        try {
                            ActivityTask.this.dispatchFailure(throwable);
                        }
                        finally {
                            future.set((Object)false);
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void fire(TM response) {
                        try {
                            ActivityTask.this.dispatchSuccess(response);
                        }
                        finally {
                            future.set((Object)true);
                        }
                    }
                });
                this.dispatched = true;
                return future;
            }
            catch (Exception e) {
                LOG.error((Object)e, (Throwable)e);
                return Futures.predestinedFuture((Object)false);
            }
        }

        abstract void dispatchInternal(Callback.Checked<TM> var1);

        void dispatchFailure(Throwable throwable) {
            LOG.error((Object)"Image conversion task error", throwable);
        }

        abstract void dispatchSuccess(TM var1);

        protected abstract DispatchingClient<TM, TC> getClient();
    }

    private static abstract class EucalyptusActivityTask
    extends ActivityTask<ComputeMessage, Eucalyptus> {
        private EucalyptusActivityTask() {
        }

        @Override
        protected DispatchingClient<ComputeMessage, Eucalyptus> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(Accounts.lookupSystemAdmin().getUserId(), Eucalyptus.class);
                client.init();
                return client;
            }
            catch (Exception e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    private static abstract class EucalyptusUserActivityTask
    extends ActivityTask<ComputeMessage, Eucalyptus> {
        private String userId = null;

        private EucalyptusUserActivityTask(String userId) {
            this.userId = userId;
        }

        @Override
        protected DispatchingClient<ComputeMessage, Eucalyptus> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(this.userId, Eucalyptus.class);
                client.init();
                return client;
            }
            catch (Exception e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    private static abstract class ImagingSystemActivityTask
    extends ActivityTask<ImagingMessage, Imaging> {
        private ImagingSystemActivityTask() {
        }

        @Override
        protected DispatchingClient<ImagingMessage, Imaging> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(Accounts.lookupSystemAdmin().getUserId(), Imaging.class);
                client.init();
                return client;
            }
            catch (Exception e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    private static abstract class ObjectStorageActivityTask
    extends ActivityTask<ObjectStorageRequestType, ObjectStorage> {
        private ObjectStorageActivityTask() {
        }

        @Override
        protected DispatchingClient<ObjectStorageRequestType, ObjectStorage> getClient() {
            try {
                DispatchingClient client = new DispatchingClient(Accounts.lookupSystemAdmin().getUserId(), ObjectStorage.class);
                client.init();
                return client;
            }
            catch (Exception e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }

    private static class DeleteTagsTask
    extends EucalyptusUserActivityTask {
        private List<String> resourceIds = null;
        private List<String> tagKeys = null;

        private DeleteTagsTask(String userId, List<String> resourceIds, List<String> tagKeys) {
            super(userId);
            this.resourceIds = resourceIds;
            this.tagKeys = tagKeys;
        }

        private DeleteTagsType deleteTag() {
            DeleteTagsType req = new DeleteTagsType();
            req.setResourcesSet(new ArrayList<String>(this.resourceIds));
            req.setTagSet(new ArrayList());
            for (String tagKey : this.tagKeys) {
                DeleteResourceTag tag = new DeleteResourceTag();
                tag.setKey(tagKey);
                req.getTagSet().add(tag);
            }
            req.markPrivileged();
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = this.getClient();
            client.dispatch((BaseMessage)this.deleteTag(), callback);
        }

        @Override
        void dispatchSuccess(ComputeMessage response) {
            DeleteTagsResponseType resp = (DeleteTagsResponseType)response;
        }
    }

    private static class CreateTagsTask
    extends EucalyptusUserActivityTask {
        private List<String> resourceIds = null;
        private Map<String, String> tags = null;

        private CreateTagsTask(String userId, List<String> resourceIds, Map<String, String> tags) {
            super(userId);
            this.resourceIds = resourceIds;
            this.tags = tags;
        }

        private CreateTagsType createTag() {
            CreateTagsType req = new CreateTagsType();
            req.setResourcesSet(new ArrayList<String>(this.resourceIds));
            req.setTagSet(new ArrayList());
            for (String key : this.tags.keySet()) {
                ResourceTag tag = new ResourceTag();
                tag.setKey(key);
                tag.setValue(this.tags.get(key));
                req.getTagSet().add(tag);
            }
            req.markPrivileged();
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ComputeMessage> callback) {
            DispatchingClient<ComputeMessage, Eucalyptus> client = this.getClient();
            client.dispatch((BaseMessage)this.createTag(), callback);
        }

        @Override
        void dispatchSuccess(ComputeMessage response) {
            CreateTagsResponseType resp = (CreateTagsResponseType)response;
        }
    }

    private class ImportImageTask
    extends ImagingSystemActivityTask {
        private String taskId = null;
        private ImportDiskImage importImage = null;

        private ImportImageTask(ImportImageBuilder builder) {
            this.importImage = builder.importDisk;
        }

        private ImportImageType importImage() {
            ImportImageType req = new ImportImageType();
            req.setImage(this.importImage);
            req.setDescription("Conversion during image registration");
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ImagingMessage> callback) {
            DispatchingClient<ImagingMessage, Imaging> client = this.getClient();
            client.dispatch((BaseMessage)this.importImage(), callback);
        }

        @Override
        void dispatchSuccess(ImagingMessage response) {
            ImportImageResponseType resp = (ImportImageResponseType)response;
            this.taskId = resp.getConversionTask().getConversionTaskId();
        }

        public String getTaskId() {
            return this.taskId;
        }
    }

    private class ImportImageBuilder {
        final ImportDiskImage importDisk = new ImportDiskImage();

        public ImportImageBuilder() {
            this.importDisk.setConvertedImage(new ConvertedImageDetail());
            this.importDisk.setDiskImageSet(Lists.newArrayList());
        }

        public ImportImageBuilder withBucket(String bucket) {
            this.importDisk.getConvertedImage().setBucket(bucket);
            return this;
        }

        public ImportImageBuilder withArchitecture(String arch) {
            this.importDisk.getConvertedImage().setArchitecture(arch);
            return this;
        }

        public ImportImageBuilder withPrefix(String prefix) {
            this.importDisk.getConvertedImage().setPrefix(prefix);
            return this;
        }

        public ImportImageBuilder withMachineImage(String id, String manifestUrl, long bytes) {
            ImportDiskImageDetail image = new ImportDiskImageDetail();
            image.setId(id);
            image.setDownloadManifestUrl(manifestUrl);
            image.setBytes(Long.valueOf(bytes));
            image.setFormat("PARTITION");
            this.importDisk.getDiskImageSet().add(image);
            return this;
        }

        public ImportImageBuilder withKernel(String id, String manifestUrl, long bytes) {
            ImportDiskImageDetail image = new ImportDiskImageDetail();
            image.setId(id);
            image.setDownloadManifestUrl(manifestUrl);
            image.setBytes(Long.valueOf(bytes));
            image.setFormat("KERNEL");
            this.importDisk.getDiskImageSet().add(image);
            return this;
        }

        public ImportImageBuilder withRamdisk(String id, String manifestUrl, long bytes) {
            ImportDiskImageDetail image = new ImportDiskImageDetail();
            image.setId(id);
            image.setDownloadManifestUrl(manifestUrl);
            image.setBytes(Long.valueOf(bytes));
            image.setFormat("RAMDISK");
            this.importDisk.getDiskImageSet().add(image);
            return this;
        }

        public ImportImageBuilder withBucketUploadPolicy(String bucket, String prefix) {
            try {
                AccessKey adminAccessKey = (AccessKey)Accounts.lookupSystemAdmin().getKeys().get(0);
                this.importDisk.setAccessKey(adminAccessKey.getAccessKey());
                Calendar c = Calendar.getInstance();
                c.add(10, 48);
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.S'Z'");
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                String expiration = sdf.format(c.getTime());
                String policy = String.format("{\"expiration\":\"%s\",\"conditions\":[{\"bucket\": \"%s\"},[\"starts-with\", \"$key\", \"%s\"],{\"acl\":\"aws-exec-read\"}]}", expiration, bucket, prefix);
                this.importDisk.setUploadPolicy(B64.standard.encString((String)policy));
                Mac hmac = Mac.getInstance("HmacSHA1");
                hmac.init(new SecretKeySpec(adminAccessKey.getSecretKey().getBytes("UTF-8"), "HmacSHA1"));
                this.importDisk.setUploadPolicySignature(B64.standard.encString((byte[])hmac.doFinal(B64.standard.encString((String)policy).getBytes("UTF-8"))));
            }
            catch (Exception ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            return this;
        }
    }

    private static class DescribeConversionTasks
    extends ImagingSystemActivityTask {
        private List<String> taskIds = null;
        private List<DiskImageConversionTask> tasks = null;

        private DescribeConversionTasks(List<String> taskIds) {
            this.taskIds = taskIds;
        }

        private DescribeConversionTasksType describeConversionTasks() {
            DescribeConversionTasksType req = new DescribeConversionTasksType();
            req.setConversionTaskIdSet(new ArrayList<String>(this.taskIds));
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ImagingMessage> callback) {
            DispatchingClient<ImagingMessage, Imaging> client = this.getClient();
            client.dispatch((BaseMessage)this.describeConversionTasks(), callback);
        }

        @Override
        void dispatchSuccess(ImagingMessage response) {
            DescribeConversionTasksResponseType resp = (DescribeConversionTasksResponseType)response;
            this.tasks = resp.getConversionTasks() != null ? resp.getConversionTasks() : Lists.newArrayList();
        }

        public List<DiskImageConversionTask> getTasks() {
            return this.tasks;
        }
    }

    private class ListBucketsTask
    extends ObjectStorageActivityTask {
        List<String> buckets = null;

        private ListBucketsTask() {
        }

        private ListAllMyBucketsType listBuckets() {
            ListAllMyBucketsType req = new ListAllMyBucketsType();
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ObjectStorageRequestType> callback) {
            DispatchingClient<ObjectStorageRequestType, ObjectStorage> client = this.getClient();
            client.dispatch((BaseMessage)this.listBuckets(), callback);
        }

        @Override
        void dispatchSuccess(ObjectStorageRequestType response) {
            ListAllMyBucketsResponseType resp = (ListAllMyBucketsResponseType)response;
            if (resp.getBucketList() != null && resp.getBucketList().getBuckets() != null) {
                this.buckets = Lists.newArrayList();
                for (BucketListEntry entry : resp.getBucketList().getBuckets()) {
                    this.buckets.add(entry.getName());
                }
            }
        }

        public List<String> getBuckets() {
            return this.buckets;
        }
    }

    private class CreateBucketTask
    extends ObjectStorageActivityTask {
        private String bucketName = null;

        private CreateBucketTask(String bucketName) {
            this.bucketName = bucketName;
        }

        private CreateBucketType createBucket() {
            CreateBucketType req = new CreateBucketType(this.bucketName);
            req.setBucket(this.bucketName);
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ObjectStorageRequestType> callback) {
            DispatchingClient<ObjectStorageRequestType, ObjectStorage> client = this.getClient();
            client.dispatch((BaseMessage)this.createBucket(), callback);
        }

        @Override
        void dispatchSuccess(ObjectStorageRequestType response) {
            CreateBucketResponseType resp = (CreateBucketResponseType)response;
            String createdBucket = resp.getBucket();
        }
    }

    private class ListObjectsInBucketTask
    extends ObjectStorageActivityTask {
        private String bucketName = null;
        private List<String> keyNames = null;

        private ListObjectsInBucketTask(String bucketName) {
            this.bucketName = bucketName;
        }

        private ListBucketType listBucket() {
            ListBucketType req = new ListBucketType();
            req.setBucket(this.bucketName);
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ObjectStorageRequestType> callback) {
            DispatchingClient<ObjectStorageRequestType, ObjectStorage> client = this.getClient();
            client.dispatch((BaseMessage)this.listBucket(), callback);
        }

        @Override
        void dispatchSuccess(ObjectStorageRequestType response) {
            ListBucketResponseType resp = (ListBucketResponseType)response;
            ArrayList keys = resp.getContents();
            if (keys != null) {
                this.keyNames = Lists.newArrayList();
                for (ListEntry key : keys) {
                    this.keyNames.add(key.getKey());
                }
            }
        }

        public List<String> getKeyNames() {
            return this.keyNames;
        }
    }

    private class DeleteObjectTask
    extends ObjectStorageActivityTask {
        private String bucketName = null;
        private String objectKey = null;

        private DeleteObjectTask(String bucketName, String objectKey) {
            this.bucketName = bucketName;
            this.objectKey = objectKey;
        }

        private DeleteObjectType deleteObject() {
            DeleteObjectType req = new DeleteObjectType();
            req.setBucket(this.bucketName);
            req.setKey(this.objectKey);
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ObjectStorageRequestType> callback) {
            DispatchingClient<ObjectStorageRequestType, ObjectStorage> client = this.getClient();
            client.dispatch((BaseMessage)this.deleteObject(), callback);
        }

        @Override
        void dispatchSuccess(ObjectStorageRequestType response) {
            DeleteObjectResponseType resp = (DeleteObjectResponseType)response;
        }
    }

    private class DeleteBucketTask
    extends ObjectStorageActivityTask {
        private String bucketName = null;

        private DeleteBucketTask(String bucketName) {
            this.bucketName = bucketName;
        }

        private DeleteBucketType deleteBucket() {
            DeleteBucketType req = new DeleteBucketType();
            req.setBucket(this.bucketName);
            return req;
        }

        @Override
        void dispatchInternal(Callback.Checked<ObjectStorageRequestType> callback) {
            DispatchingClient<ObjectStorageRequestType, ObjectStorage> client = this.getClient();
            client.dispatch((BaseMessage)this.deleteBucket(), callback);
        }

        @Override
        void dispatchSuccess(ObjectStorageRequestType response) {
            DeleteBucketResponseType resp = (DeleteBucketResponseType)response;
        }
    }
}

