/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.configurable.ConfigurableClass;
import com.eucalyptus.configurable.ConfigurableField;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.records.Logs;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.Intervals;
import com.google.common.base.Objects;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.concurrent.ExecutionException;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceContext;
import javax.persistence.PrePersist;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="cloud_image_configuration")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@ConfigurableClass(root="cloud.images", description="Configuration options controlling the handling of registered images (EMI/EKI/ERI).")
public class ImageConfiguration
extends AbstractPersistent {
    @Transient
    private static Logger LOG = Logger.getLogger(ImageConfiguration.class);
    private static final Integer DEFAULT_MAX_IMAGE_SIZE_GB = 30;
    private static final Integer DEFAULT_MAX_MANIFEST_SIZE_IN_BYTES = 0x500000;
    @ConfigurableField(displayName="default_visibility", description="The default value used to determine whether or not images are marked 'public' when first registered.")
    @Column(name="config_image_is_public", nullable=false, columnDefinition="boolean default false")
    private Boolean defaultVisibility;
    @ConfigurableField(displayName="cleanup_period", description="The period between runs for clean up of deregistered images.", initial="10m")
    @Column(name="config_image_cleanup_period")
    private String cleanupPeriod;
    @ConfigurableField(displayName="max_image_size_gb", description="The maximum registerable image size in GB")
    @Column(name="max_image_size_gb")
    private Integer maxImageSizeGb;
    @ConfigurableField(displayName="max_manifest_size", description="The maximum allowed image manifest size in bytes")
    @Column(name="max_manifest_size_b")
    private Integer maxManifestSizeBytes;

    public static void modify(Callback<ImageConfiguration> callback) throws ExecutionException {
        Transactions.one((Object)((Object)new ImageConfiguration()), callback);
    }

    public static ImageConfiguration getInstance() {
        ImageConfiguration ret = null;
        try {
            ret = (ImageConfiguration)((Object)Transactions.find((Object)((Object)new ImageConfiguration())));
        }
        catch (Exception ex1) {
            try {
                ret = (ImageConfiguration)((Object)Transactions.save((Object)((Object)new ImageConfiguration())));
            }
            catch (Exception ex) {
                Logs.extreme().error((Object)ex, (Throwable)ex);
                ret = new ImageConfiguration();
            }
        }
        return ret;
    }

    @PrePersist
    protected void initialize() {
        if (this.defaultVisibility == null) {
            this.defaultVisibility = Boolean.FALSE;
        }
        if (this.cleanupPeriod == null) {
            this.cleanupPeriod = "10m";
        }
        if (this.maxImageSizeGb == null) {
            this.maxImageSizeGb = DEFAULT_MAX_IMAGE_SIZE_GB;
        }
        if (this.maxManifestSizeBytes == null) {
            this.maxManifestSizeBytes = DEFAULT_MAX_MANIFEST_SIZE_IN_BYTES;
        }
    }

    public Integer getMaxImageSizeGb() {
        return this.maxImageSizeGb;
    }

    public void setMaxImageSizeGb(Integer maxImageSize) {
        this.maxImageSizeGb = maxImageSize;
    }

    public Integer getMaxManifestSizeBytes() {
        return (Integer)Objects.firstNonNull((Object)this.maxManifestSizeBytes, (Object)DEFAULT_MAX_MANIFEST_SIZE_IN_BYTES);
    }

    public void setMaxManifestSizeBytes(Integer maxManifestSizeBytes) {
        this.maxManifestSizeBytes = maxManifestSizeBytes;
    }

    public Boolean getDefaultVisibility() {
        return this.defaultVisibility;
    }

    public void setDefaultVisibility(Boolean defaultVisibility) {
        this.defaultVisibility = defaultVisibility;
    }

    public String getCleanupPeriod() {
        return this.cleanupPeriod;
    }

    public void setCleanupPeriod(String cleanupPeriod) {
        this.cleanupPeriod = cleanupPeriod;
    }

    public long getCleanupPeriodMillis() {
        return Intervals.parse((String)this.getCleanupPeriod(), (long)0L);
    }

    @Upgrades.EntityUpgrade(entities={ImageConfiguration.class}, since=Upgrades.Version.v3_4_0, value=Eucalyptus.class)
    public static enum ImageConfigurationEntityUpgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(@Nullable Class aClass) {
            EntityTransaction tran = Entities.get(ImageConfiguration.class);
            try {
                List configs = Entities.query((Object)((Object)new ImageConfiguration()));
                if (configs != null && configs.size() > 0) {
                    for (ImageConfiguration config : configs) {
                        if (config.getMaxImageSizeGb() != null) continue;
                        config.setMaxImageSizeGb(0);
                        LOG.debug((Object)("Putting max image size as zero('unlimted') for image configuration entity: " + config.getId()));
                    }
                }
                tran.commit();
            }
            catch (Exception ex) {
                tran.rollback();
                LOG.error((Object)"caught exception during upgrade, while attempting to create max image size");
                Exceptions.toUndeclared((Throwable)ex);
            }
            return true;
        }

        static {
            LOG = Logger.getLogger(ImageConfigurationEntityUpgrade.class);
        }
    }
}

