/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.images.DeviceMapping;
import com.eucalyptus.images.ImageInfo;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="ephemeral")
public class EphemeralDeviceMapping
extends DeviceMapping {
    @Column(name="metadata_device_mapping_ephemeral_number")
    private Integer ephemeralNumber;

    public EphemeralDeviceMapping() {
        this.setDeviceMappingType(ImageMetadata.DeviceMappingType.ephemeral);
    }

    public EphemeralDeviceMapping(ImageInfo parent, String deviceName, String virtualName) {
        super(parent, ImageMetadata.DeviceMappingType.ephemeral, deviceName, virtualName);
        this.ephemeralNumber = Integer.parseInt(virtualName.replace("ephemeral", ""));
    }

    public Integer getEphemeralNumber() {
        return this.ephemeralNumber;
    }

    public void setEphemeralNumber(Integer ephemeralNumber) {
        this.ephemeralNumber = ephemeralNumber;
    }
}

