/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.cloud.util.IllegalMetadataAccessException;
import com.eucalyptus.cloud.util.InvalidMetadataException;
import com.eucalyptus.cloud.util.MetadataException;
import com.eucalyptus.cloud.util.NoSuchImageIdException;
import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.component.Partition;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.compute.common.RunInstancesType;
import com.eucalyptus.compute.common.StaticDiskImage;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.context.IllegalContextAccessException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.images.BlockStorageImageInfo;
import com.eucalyptus.images.BootableImageInfo;
import com.eucalyptus.images.ImageConfiguration;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.images.ImageManifests;
import com.eucalyptus.images.Images;
import com.eucalyptus.images.KernelImageInfo;
import com.eucalyptus.images.MachineImageInfo;
import com.eucalyptus.images.RamdiskImageInfo;
import com.eucalyptus.images.StaticDiskImages;
import com.eucalyptus.images.UnavailableImageInfo;
import com.eucalyptus.imaging.manifest.BundleImageManifest;
import com.eucalyptus.imaging.manifest.DownloadManifestException;
import com.eucalyptus.imaging.manifest.DownloadManifestFactory;
import com.eucalyptus.imaging.manifest.ImageManifest;
import com.eucalyptus.imaging.manifest.ImageManifestFile;
import com.eucalyptus.records.Logs;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.NonNullFunction;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vmtypes.VmType;
import com.eucalyptus.vmtypes.VmTypes;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import edu.ucsb.eucalyptus.msgs.VmTypeInfo;
import java.security.PublicKey;
import java.util.NoSuchElementException;
import javax.annotation.Nonnull;
import javax.persistence.EntityTransaction;
import javax.persistence.PersistenceException;
import org.apache.log4j.Logger;

public class Emis {
    private static Logger LOG = Logger.getLogger(Emis.class);

    private static boolean isEmptyString(String string) {
        return string == null || "".equals(string);
    }

    public static BootableSet recreateBootableSet(VmInstance vm) {
        BootableImageInfo bootableImageInfo = vm.getBootRecord().getMachine();
        KernelImageInfo kernel = vm.getBootRecord().getKernel();
        RamdiskImageInfo ramdisk = vm.getBootRecord().getRamdisk();
        if (kernel != null && ramdisk != null) {
            return new TrifectaBootableSet(bootableImageInfo, kernel, ramdisk);
        }
        if (kernel != null) {
            return new NoRamdiskBootableSet(bootableImageInfo, kernel);
        }
        return new BootableSet(bootableImageInfo);
    }

    public static BootableSet recreateBootableSet(String imageId, String kernelId, String ramdiskId) throws MetadataException {
        try {
            BootsetBuilder builder = new BootsetBuilder().imageId(imageId);
            if (kernelId != null) {
                builder.kernelId(kernelId);
                if (ramdiskId != null) {
                    builder.ramdiskId(ramdiskId);
                }
            }
            BootableSet bootSet = builder.start();
            Emis.checkStoredImage(bootSet);
            return bootSet;
        }
        catch (MetadataException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidMetadataException("Failed to construct bootset for image id: " + imageId + " because of: " + ex.getMessage(), ex);
        }
    }

    public static BootableSet unavailableBootableSet(ImageMetadata.Platform platform) {
        return new BootableSet(new UnavailableImageInfo(platform));
    }

    public static BootableSet newBootableSet(String imageId) throws MetadataException {
        try {
            BootableSet bootSet = new BootsetBuilder().imageId(imageId).run();
            Emis.checkStoredImage(bootSet);
            return bootSet;
        }
        catch (MetadataException ex) {
            throw ex;
        }
        catch (Exception ex) {
            throw new InvalidMetadataException("Failed to construct bootset for image id: " + imageId + " because of: " + ex.getMessage(), ex);
        }
    }

    private static <T extends ImageInfo> T resolveDiskImage(String imageId, Function<String, T> resolver) throws IllegalMetadataAccessException {
        ImageInfo img = (ImageInfo)((Object)resolver.apply((Object)imageId));
        if (Contexts.exists()) {
            Predicate filter = Predicates.and((Predicate)Images.FilterPermissions.INSTANCE, (Predicate)RestrictedTypes.filterPrivilegedWithoutOwner());
            if (filter.apply((Object)img)) {
                if (!Images.FilterImageStates.INSTANCE.apply(img)) {
                    throw Exceptions.toUndeclared((Throwable)new EucalyptusCloudException("Image state is not available"));
                }
                return (T)((Object)img);
            }
            throw new IllegalMetadataAccessException(imageId + ": permission denied.");
        }
        return (T)((Object)img);
    }

    private static String determineKernelId(BootableSet bootSet) throws MetadataException {
        BootableImageInfo disk = bootSet.getMachine();
        String kernelId = null;
        Context ctx = null;
        try {
            ctx = Contexts.lookup();
            if (ctx.getRequest() instanceof RunInstancesType) {
                kernelId = ((RunInstancesType)ctx.getRequest()).getKernelId();
            }
        }
        catch (IllegalContextAccessException ex) {
            LOG.debug((Object)("Context not found when determining kernel id:" + ex.getMessage()));
        }
        if (kernelId == null || "".equals(kernelId)) {
            kernelId = disk.getKernelId();
        }
        Preconditions.checkNotNull((Object)kernelId, (Object)("Attempt to resolve a kerneId for " + bootSet.toString() + " during request " + (ctx != null ? ctx.getRequest().toSimpleString() : "UNKNOWN")));
        if (kernelId == null) {
            throw new NoSuchMetadataException("Unable to determine required kernel image for " + disk.getDisplayName());
        }
        if (!CloudMetadatas.isKernelImageIdentifier((String)kernelId)) {
            throw new InvalidMetadataException("Image specified is not a kernel: " + kernelId);
        }
        return kernelId;
    }

    private static String determineRamdiskId(BootableSet bootSet) throws MetadataException {
        if (!bootSet.hasKernel()) {
            throw new InvalidMetadataException("Image specified does not have a kernel: " + bootSet);
        }
        String ramdiskId = bootSet.getMachine().getRamdiskId();
        try {
            RunInstancesType msg;
            Context ctx = Contexts.lookup();
            if (ctx.getRequest() instanceof RunInstancesType && (msg = (RunInstancesType)ctx.getRequest()).getRamdiskId() != null && !"".equals(msg.getRamdiskId())) {
                ramdiskId = msg.getRamdiskId();
            }
        }
        catch (IllegalContextAccessException ex) {
            LOG.debug((Object)("Context not found when determining ramdisk id:" + ex.getMessage()));
        }
        if (ramdiskId == null) {
            return ramdiskId;
        }
        if (!CloudMetadatas.isRamdiskImageIdentifier((String)ramdiskId)) {
            throw new InvalidMetadataException("Image specified is not a ramdisk: " + ramdiskId);
        }
        return ramdiskId;
    }

    private static void checkStoredImage(BootableSet bootSet) {
        try {
            if (bootSet.getMachine() instanceof StaticDiskImage) {
                StaticDiskImages.check((StaticDiskImage)bootSet.getMachine());
            }
            if (bootSet.hasKernel()) {
                StaticDiskImages.check(bootSet.getKernel());
            }
            if (bootSet.hasRamdisk()) {
                StaticDiskImages.check(bootSet.getRamdisk());
            }
        }
        catch (Exception ex) {
            LOG.error((Object)ex);
            Logs.extreme().error((Object)ex, (Throwable)ex);
        }
    }

    static enum BootsetWithKernel implements Function<BootableSet, BootableSet>
    {
        INSTANCE;


        public BootableSet apply(BootableSet input) {
            if (!input.isLinux() || input.isHvm()) {
                return input;
            }
            String kernelId = "unknown";
            try {
                kernelId = Emis.determineKernelId(input);
                LOG.debug((Object)("Determined the appropriate kernelId to be " + kernelId + " for " + input.toString()));
                KernelImageInfo kernel = (KernelImageInfo)RestrictedTypes.doPrivilegedWithoutOwner((String)kernelId, (Function)LookupKernel.INSTANCE);
                return new NoRamdiskBootableSet(input.getMachine(), kernel);
            }
            catch (Exception ex) {
                if (input.isBlockStorage()) {
                    return input;
                }
                if (input.isHvm()) {
                    return input;
                }
                throw Exceptions.toUndeclared((Throwable)new NoSuchMetadataException("Failed to lookup kernel image information " + kernelId + " because of: " + ex.getMessage(), ex));
            }
        }
    }

    static enum BootsetWithRamdisk implements Function<BootableSet, BootableSet>
    {
        INSTANCE;


        public BootableSet apply(BootableSet input) {
            if (!input.isLinux() || input.isHvm()) {
                return input;
            }
            String ramdiskId = null;
            try {
                ramdiskId = Emis.determineRamdiskId(input);
                LOG.debug((Object)("Determined the appropriate ramdiskId to be " + ramdiskId + " for " + input.toString()));
                if (ramdiskId == null) {
                    return input;
                }
                RamdiskImageInfo ramdisk = (RamdiskImageInfo)RestrictedTypes.doPrivilegedWithoutOwner((String)ramdiskId, (Function)LookupRamdisk.INSTANCE);
                return new TrifectaBootableSet(input.getMachine(), input.getKernel(), ramdisk);
            }
            catch (InvalidMetadataException ex) {
                return input;
            }
            catch (Exception ex) {
                if (input.isBlockStorage()) {
                    return input;
                }
                throw Exceptions.toUndeclared((Throwable)new NoSuchMetadataException("Failed to lookup ramdisk image information: " + ramdiskId + " because of: " + ex.getMessage(), ex));
            }
        }
    }

    static enum BootsetFromId implements Function<String, BootableSet>
    {
        INSTANCE;


        public BootableSet apply(String input) {
            BootableSet bootSet;
            try {
                bootSet = new BootableSet((BootableImageInfo)((Object)Emis.resolveDiskImage(input, (Function)LookupMachine.INSTANCE)));
            }
            catch (IllegalContextAccessException ex) {
                throw Exceptions.toUndeclared((Throwable)new IllegalMetadataAccessException(ex));
            }
            catch (IllegalMetadataAccessException ex) {
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            catch (Exception e) {
                try {
                    bootSet = new BootableSet((BootableImageInfo)((Object)Emis.resolveDiskImage(input, LookupBlockStorage.INSTANCE)));
                }
                catch (IllegalContextAccessException ex) {
                    throw Exceptions.toUndeclared((Throwable)new IllegalMetadataAccessException(ex));
                }
                catch (IllegalMetadataAccessException ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
                catch (NoSuchElementException ex) {
                    throw Exceptions.toUndeclared((Throwable)new NoSuchImageIdException("Failed to lookup image named: " + input, ex));
                }
                catch (PersistenceException ex) {
                    throw Exceptions.toUndeclared((Throwable)new InvalidMetadataException("Error occurred while trying to lookup image named: " + input, ex));
                }
            }
            return bootSet;
        }
    }

    private static class BootsetBuilder {
        private String imageId;
        private String kernelId;
        private String ramdiskId;

        private BootsetBuilder() {
        }

        public BootsetBuilder imageId(String imageId) {
            this.imageId = imageId;
            return this;
        }

        public BootsetBuilder ramdiskId(String ramdiskId) {
            this.ramdiskId = ramdiskId;
            return this;
        }

        public BootsetBuilder kernelId(String kernelId) {
            this.kernelId = kernelId;
            return this;
        }

        public BootableSet run() throws MetadataException {
            Function create2 = Functions.compose((Function)BootsetWithRamdisk.INSTANCE, (Function)Functions.compose((Function)BootsetWithKernel.INSTANCE, (Function)BootsetFromId.INSTANCE));
            return this.prepareBootset((Function<String, BootableSet>)create2);
        }

        private BootableSet prepareBootset(Function<String, BootableSet> create2) throws MetadataException {
            try {
                BootableSet bootSet = (BootableSet)create2.apply((Object)this.imageId);
                return bootSet;
            }
            catch (RuntimeException ex) {
                if (ex.getCause() instanceof MetadataException) {
                    throw (MetadataException)ex.getCause();
                }
                throw ex;
            }
        }

        public BootableSet start() throws MetadataException {
            Function<String, BootableSet> create2 = new Function<String, BootableSet>(){

                public BootableSet apply(String input) {
                    BootableSet b = BootsetFromId.INSTANCE.apply(BootsetBuilder.this.imageId);
                    try {
                        RamdiskImageInfo ramdisk;
                        KernelImageInfo kernel = BootsetBuilder.this.kernelId == null ? null : LookupKernel.INSTANCE.apply(BootsetBuilder.this.kernelId);
                        RamdiskImageInfo ramdiskImageInfo = ramdisk = BootsetBuilder.this.ramdiskId == null ? null : LookupRamdisk.INSTANCE.apply(BootsetBuilder.this.ramdiskId);
                        if (kernel != null && ramdisk != null) {
                            return new TrifectaBootableSet(b.getMachine(), kernel, ramdisk);
                        }
                        if (kernel != null) {
                            return new NoRamdiskBootableSet(b.getMachine(), kernel);
                        }
                        return b;
                    }
                    catch (NoSuchElementException e) {
                        throw Exceptions.toUndeclared((Throwable)new NoSuchMetadataException(e.getMessage(), e));
                    }
                }
            };
            return this.prepareBootset(create2);
        }
    }

    static class TrifectaBootableSet
    extends NoRamdiskBootableSet {
        private final RamdiskImageInfo ramdisk;

        public TrifectaBootableSet(BootableImageInfo bootableImageInfo, KernelImageInfo kernel, RamdiskImageInfo ramdisk) {
            super(bootableImageInfo, kernel);
            this.ramdisk = ramdisk;
        }

        @Override
        public RamdiskImageInfo getRamdisk() {
            return this.ramdisk;
        }
    }

    static class NoRamdiskBootableSet
    extends BootableSet {
        private final KernelImageInfo kernel;

        private NoRamdiskBootableSet(BootableImageInfo bootableImageInfo, KernelImageInfo kernel) {
            super(bootableImageInfo);
            this.kernel = kernel;
        }

        @Override
        public KernelImageInfo getKernel() {
            return this.kernel;
        }
    }

    public static class BootableSet {
        private final BootableImageInfo disk;

        private BootableSet(BootableImageInfo bootableImageInfo) {
            this.disk = bootableImageInfo;
        }

        public BootableImageInfo getMachine() {
            return this.disk;
        }

        public RamdiskImageInfo getRamdisk() {
            throw new NoSuchElementException("BootableSet:machine=" + this.getMachine() + " does not have a kernel.");
        }

        public KernelImageInfo getKernel() {
            throw new NoSuchElementException("BootableSet:machine=" + this.getMachine() + " does not have a kernel.");
        }

        public boolean hasKernel() {
            try {
                this.getKernel();
                return true;
            }
            catch (NoSuchElementException ex) {
                return false;
            }
        }

        public boolean hasRamdisk() {
            try {
                this.getRamdisk();
                return true;
            }
            catch (NoSuchElementException ex) {
                return false;
            }
        }

        public boolean isBlockStorage() {
            return this.getMachine() instanceof BlockStorageImageInfo;
        }

        public boolean isLinux() {
            return ImageMetadata.Platform.linux.equals((Object)this.getMachine().getPlatform()) || this.getMachine().getPlatform() == null;
        }

        public boolean isHvm() {
            return ImageMetadata.VirtualizationType.hvm.equals((Object)this.getMachine().getVirtualizationType());
        }

        public String toString() {
            return String.format("BootableSet:machine=%s:ramdisk=%s:kernel=%s:isLinux=%s", this.getMachine(), this.hasRamdisk() ? this.getRamdisk() : "false", this.hasKernel() ? this.getKernel() : "false", this.isLinux());
        }

        public VmTypeInfo populateVirtualBootRecord(VmType vmType, Partition partition, String reservationId) throws MetadataException {
            VmTypeInfo vmTypeInfo = VmTypes.asVmTypeInfo(vmType, this.getMachine());
            try {
                if (this.isLinux()) {
                    String manifestLocation;
                    if (this.hasKernel()) {
                        if (!Emis.isEmptyString(this.getKernel().getManifestHash()) && !this.getKernel().getManifestHash().equals(ImageManifests.getManifestHash(this.getKernel().getManifestLocation()))) {
                            throw new MetadataException("Kernel manifest was changed after registration");
                        }
                        manifestLocation = DownloadManifestFactory.generateDownloadManifest((ImageManifestFile)new ImageManifestFile(this.getKernel().getManifestLocation(), (ImageManifest)BundleImageManifest.INSTANCE, ImageConfiguration.getInstance().getMaxManifestSizeBytes().intValue()), (PublicKey)partition.getNodeCertificate().getPublicKey(), (String)(this.getKernel().getDisplayName() + "-" + reservationId), (boolean)true);
                        vmTypeInfo.setKernel(this.getKernel().getDisplayName(), manifestLocation, this.getKernel().getImageSizeBytes());
                    }
                    if (this.hasRamdisk()) {
                        if (!Emis.isEmptyString(this.getRamdisk().getManifestHash()) && !this.getRamdisk().getManifestHash().equals(ImageManifests.getManifestHash(this.getRamdisk().getManifestLocation()))) {
                            throw new MetadataException("Ramdisk manifest was changed after registration");
                        }
                        manifestLocation = DownloadManifestFactory.generateDownloadManifest((ImageManifestFile)new ImageManifestFile(this.getRamdisk().getManifestLocation(), (ImageManifest)BundleImageManifest.INSTANCE, ImageConfiguration.getInstance().getMaxManifestSizeBytes().intValue()), (PublicKey)partition.getNodeCertificate().getPublicKey(), (String)(this.getRamdisk().getDisplayName() + "-" + reservationId), (boolean)true);
                        vmTypeInfo.setRamdisk(this.getRamdisk().getDisplayName(), manifestLocation, this.getRamdisk().getImageSizeBytes());
                    }
                }
                if (this.getMachine() instanceof StaticDiskImage) {
                    StaticDiskImage diskImage = (StaticDiskImage)this.getMachine();
                    MachineImageInfo emi = LookupMachine.INSTANCE.apply(this.getMachine().getDisplayName());
                    String manifestLocation = null;
                    if (ImageMetadata.State.pending_available.equals((Object)emi.getState())) {
                        manifestLocation = DownloadManifestFactory.generatePresignedUrl((String)reservationId);
                        Images.setImageState(emi.getDisplayName(), ImageMetadata.State.pending_conversion);
                    } else if (ImageMetadata.State.pending_conversion.equals((Object)emi.getState())) {
                        manifestLocation = DownloadManifestFactory.generatePresignedUrl((String)reservationId);
                    } else {
                        if (diskImage.getManifestLocation().equals(diskImage.getRunManifestLocation()) && !Emis.isEmptyString(diskImage.getManifestHash()) && !diskImage.getManifestHash().equals(ImageManifests.getManifestHash(diskImage.getManifestLocation()))) {
                            throw new MetadataException("Instance manifest was changed after registration");
                        }
                        manifestLocation = DownloadManifestFactory.generateDownloadManifest((ImageManifestFile)new ImageManifestFile(diskImage.getRunManifestLocation(), (ImageManifest)BundleImageManifest.INSTANCE, ImageConfiguration.getInstance().getMaxManifestSizeBytes().intValue()), (PublicKey)partition.getNodeCertificate().getPublicKey(), (String)reservationId, (boolean)true);
                    }
                    vmTypeInfo.setRoot(diskImage.getDisplayName(), manifestLocation, this.getMachine().getImageSizeBytes());
                }
            }
            catch (DownloadManifestException ex) {
                throw new MetadataException(ex);
            }
            catch (Exception ex) {
                throw new MetadataException(ex);
            }
            return vmTypeInfo;
        }
    }

    public static enum LookupRamdisk implements NonNullFunction<String, RamdiskImageInfo>
    {
        INSTANCE;


        @Nonnull
        public RamdiskImageInfo apply(String identifier) {
            EntityTransaction db = Entities.get(RamdiskImageInfo.class);
            try {
                RamdiskImageInfo ret = (RamdiskImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleRamdiskWithImageId(identifier))));
                if (!ImageMetadata.State.available.name().equals(((ImageMetadata.State)ret.getState()).getExternalStateName())) {
                    db.rollback();
                    throw new NoSuchElementException("Unable to start instance with deregistered/failed image : " + (Object)((Object)ret));
                }
                db.rollback();
                return ret;
            }
            catch (Exception ex) {
                Logs.exhaust().error((Object)ex, (Throwable)ex);
                db.rollback();
                throw new NoSuchElementException("Failed to lookup image: " + identifier + " because of " + ex.getMessage());
            }
        }
    }

    public static enum LookupKernel implements NonNullFunction<String, KernelImageInfo>
    {
        INSTANCE;


        @Nonnull
        public KernelImageInfo apply(String identifier) {
            EntityTransaction db = Entities.get(KernelImageInfo.class);
            try {
                KernelImageInfo ret = (KernelImageInfo)((Object)Entities.uniqueResult((Object)((Object)Images.exampleKernelWithImageId(identifier))));
                if (!ImageMetadata.State.available.name().equals(((ImageMetadata.State)ret.getState()).getExternalStateName())) {
                    db.rollback();
                    throw new NoSuchElementException("Unable to start instance with deregistered/failed image : " + (Object)((Object)ret));
                }
                db.rollback();
                return ret;
            }
            catch (Exception ex) {
                Logs.exhaust().error((Object)ex, (Throwable)ex);
                db.rollback();
                throw new NoSuchElementException("Failed to lookup image: " + identifier + " because of " + ex.getMessage());
            }
        }
    }

    public static enum LookupMachine implements NonNullFunction<String, MachineImageInfo>
    {
        INSTANCE;


        @Nonnull
        public MachineImageInfo apply(String identifier) {
            EntityTransaction db = Entities.get(MachineImageInfo.class);
            try {
                MachineImageInfo ret = (MachineImageInfo)Entities.uniqueResult((Object)Images.exampleMachineWithImageId(identifier));
                if (!ImageMetadata.State.available.name().equals(((ImageMetadata.State)ret.getState()).getExternalStateName())) {
                    db.rollback();
                    throw new NoSuchElementException("Unable to start instance with deregistered/failed image : " + ret);
                }
                db.rollback();
                return ret;
            }
            catch (Exception ex) {
                Logs.exhaust().error((Object)ex, (Throwable)ex);
                db.rollback();
                throw new NoSuchElementException("Failed to lookup image: " + identifier + " because of " + ex.getMessage());
            }
        }
    }

    public static enum LookupBlockStorage implements Function<String, BlockStorageImageInfo>
    {
        INSTANCE;


        public BlockStorageImageInfo apply(String identifier) {
            EntityTransaction db = Entities.get(BlockStorageImageInfo.class);
            try {
                BlockStorageImageInfo ret = (BlockStorageImageInfo)Entities.uniqueResult((Object)Images.exampleBlockStorageWithImageId(identifier));
                if (ImageMetadata.Platform.windows.name().equals(ret.getKernelId()) || ret.getImageName().startsWith(ImageMetadata.Platform.windows.name())) {
                    ret.setPlatform(ImageMetadata.Platform.windows);
                }
                if (!ImageMetadata.State.available.equals((Object)ret.getState()) && !ImageMetadata.State.pending.equals((Object)ret.getState())) {
                    db.rollback();
                    throw new NoSuchElementException("Unable to start instance with deregistered/failed image : " + ret);
                }
                db.rollback();
                return ret;
            }
            catch (Exception ex) {
                Logs.exhaust().error((Object)ex, (Throwable)ex);
                db.rollback();
                throw new NoSuchElementException("Failed to lookup image: " + identifier + " because of " + ex.getMessage());
            }
        }
    }

    @RestrictedTypes.Resolver(value=ImageMetadata.class)
    public static enum LookupImage implements Function<String, ImageInfo>
    {
        INSTANCE;


        public ImageInfo apply(String input) {
            if (CloudMetadatas.isKernelImageIdentifier((String)input)) {
                return LookupKernel.INSTANCE.apply(input);
            }
            if (CloudMetadatas.isRamdiskImageIdentifier((String)input)) {
                return LookupRamdisk.INSTANCE.apply(input);
            }
            if (CloudMetadatas.isMachineImageIdentifier((String)input)) {
                try {
                    return LookupMachine.INSTANCE.apply(input);
                }
                catch (Exception ex) {
                    return LookupBlockStorage.INSTANCE.apply(input);
                }
            }
            throw new NoSuchElementException("Failed to lookup image: " + input);
        }
    }

    static enum VBRTypes {
        MACHINE("objectstorage://"),
        EBS,
        KERNEL("objectstorage://"),
        RAMDISK("objectstorage://"),
        EPHEMERAL,
        SWAP;

        String prefix;

        private VBRTypes() {
            this("");
        }

        private VBRTypes(String prefix) {
            this.prefix = prefix;
        }
    }
}

