/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.images.ImageInfo;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Inheritance;
import javax.persistence.InheritanceType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_device_mappings")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@Inheritance(strategy=InheritanceType.SINGLE_TABLE)
@DiscriminatorColumn(name="metadata_device_mapping_discriminator", discriminatorType=DiscriminatorType.STRING)
@DiscriminatorValue(value="basic")
public class DeviceMapping
extends AbstractPersistent {
    @Column(name="metadata_device_mapping_type")
    @Enumerated(value=EnumType.STRING)
    private ImageMetadata.DeviceMappingType deviceMappingType;
    @Column(name="metadata_device_mapping_device_name")
    private String deviceName;
    @Column(name="metadata_device_mapping_virtual_name")
    private String virtualName;
    @ManyToOne
    @JoinColumn(name="metadata_image_dev_map_fk", insertable=false, updatable=false)
    private ImageInfo parent;

    protected DeviceMapping() {
    }

    public DeviceMapping(ImageInfo parent, ImageMetadata.DeviceMappingType deviceMappingType, String deviceName, String virtualName) {
        this.parent = parent;
        this.deviceName = deviceName;
        this.deviceMappingType = deviceMappingType;
        this.virtualName = virtualName;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public ImageInfo getParent() {
        return this.parent;
    }

    public void setParent(ImageInfo parent) {
        this.parent = parent;
    }

    public ImageMetadata.DeviceMappingType getDeviceMappingType() {
        return this.deviceMappingType;
    }

    protected void setDeviceMappingType(ImageMetadata.DeviceMappingType deviceMappingType) {
        this.deviceMappingType = deviceMappingType;
    }

    public String getVirtualName() {
        return this.virtualName;
    }

    public void setVirtualName(String virtualName) {
        this.virtualName = virtualName;
    }
}

