/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.images.BlockStorageDeviceMapping;
import com.eucalyptus.images.BootableImageInfo;
import com.eucalyptus.images.DeviceMapping;
import com.eucalyptus.images.EphemeralDeviceMapping;
import com.eucalyptus.images.ImageInfo;
import com.eucalyptus.upgrade.Upgrades;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Predicate;
import java.util.List;
import javax.annotation.Nullable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.EntityTransaction;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="blockstorage")
public class BlockStorageImageInfo
extends ImageInfo
implements BootableImageInfo {
    @Column(name="metadata_image_snapshot_id")
    private String snapshotId;
    @Column(name="metadata_image_del_vol_on_terminate")
    private Boolean deleteOnTerminate;
    @Column(name="metadata_image_kernel_id")
    private String kernelId;
    @Column(name="metadata_image_ramdisk_id")
    private String ramdiskId;
    @Column(name="metadata_image_root_device")
    private String rootDeviceName;
    @Column(name="metadata_image_virtualization_type")
    @Enumerated(value=EnumType.STRING)
    private ImageMetadata.VirtualizationType virtType;

    BlockStorageImageInfo() {
        super(ImageMetadata.Type.machine);
    }

    BlockStorageImageInfo(String imageId) {
        super(ImageMetadata.Type.machine, imageId);
    }

    BlockStorageImageInfo(UserFullName userFullName, String imageId, String imageName, String imageDescription, Long imageSizeBytes, ImageMetadata.Architecture arch, ImageMetadata.Platform platform, String kernelId, String ramdiskId, String snapshotId, Boolean deleteOnTerminate, String rootDeviceName) {
        super((OwnerFullName)userFullName, imageId, ImageMetadata.Type.machine, imageName, imageDescription, imageSizeBytes, arch, platform);
        this.kernelId = kernelId;
        this.ramdiskId = ramdiskId;
        this.snapshotId = snapshotId;
        this.deleteOnTerminate = deleteOnTerminate;
        this.rootDeviceName = rootDeviceName;
        this.virtType = ImageMetadata.VirtualizationType.hvm;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public Boolean getDeleteOnTerminate() {
        return this.deleteOnTerminate;
    }

    public void setDeleteOnTerminate(Boolean deleteOnTerminate) {
        this.deleteOnTerminate = deleteOnTerminate;
    }

    @Override
    public String getKernelId() {
        return this.kernelId;
    }

    public void setKernelId(String kernelId) {
        this.kernelId = kernelId;
    }

    @Override
    public String getRamdiskId() {
        return this.ramdiskId;
    }

    public void setRamdiskId(String ramdiskId) {
        this.ramdiskId = ramdiskId;
    }

    @Override
    public boolean hasKernel() {
        return this.getKernelId() != null;
    }

    @Override
    public boolean hasRamdisk() {
        return this.getRamdiskId() != null;
    }

    @Override
    public String getRootDeviceName() {
        return this.rootDeviceName;
    }

    @Override
    public String getRootDeviceType() {
        return "ebs";
    }

    @Override
    public ImageMetadata.VirtualizationType getVirtualizationType() {
        return this.virtType;
    }

    public void setRootDeviceName(String rootDeviceName) {
        this.rootDeviceName = rootDeviceName;
    }

    @Upgrades.EntityUpgrade(entities={BlockStorageImageInfo.class}, since=Upgrades.Version.v3_4_0, value=Eucalyptus.class)
    public static enum BlockStorageImageInfo340Upgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(@Nullable Class arg0) {
            EntityTransaction db = Entities.get(BlockStorageImageInfo.class);
            try {
                List images = Entities.query((Object)new BlockStorageImageInfo());
                for (BlockStorageImageInfo image : images) {
                    LOG.info((Object)("Upgrading BlockStorageImageInfo: " + image.toString()));
                    if (image.virtType != null) continue;
                    image.virtType = ImageMetadata.VirtualizationType.hvm;
                    Entities.persist((Object)image);
                }
                db.commit();
                boolean bl = true;
                return bl;
            }
            catch (Exception ex) {
                LOG.error((Object)"Error upgrading BlockStorageImageInfo: ", (Throwable)ex);
                db.rollback();
                throw Exceptions.toUndeclared((Throwable)ex);
            }
            finally {
                if (db.isActive()) {
                    db.rollback();
                }
            }
        }

        static {
            LOG = Logger.getLogger(BlockStorageImageInfo340Upgrade.class);
        }
    }

    @Upgrades.EntityUpgrade(entities={BlockStorageImageInfo.class}, since=Upgrades.Version.v3_3_0, value=Eucalyptus.class)
    public static enum BlockStorageImageInfo330Upgrade implements Predicate<Class>
    {
        INSTANCE;

        private static Logger LOG;

        public boolean apply(Class arg0) {
            EntityTransaction db = Entities.get(BlockStorageImageInfo.class);
            try {
                List images = Entities.query((Object)new BlockStorageImageInfo());
                for (BlockStorageImageInfo image : images) {
                    LOG.info((Object)("Upgrading BlockStorageImageInfo: " + image.toString()));
                    if (StringUtils.isBlank((String)image.getRootDeviceName())) {
                        LOG.info((Object)"Setting the root device name to /dev/sda");
                        image.setRootDeviceName("/dev/sda");
                    }
                    DeviceMapping mapping = null;
                    if (image.getDeviceMappings().size() == 1 && (mapping = image.getDeviceMappings().iterator().next()) != null && mapping instanceof BlockStorageDeviceMapping) {
                        LOG.info((Object)"Setting the device mapping name to /dev/sda");
                        mapping.setDeviceName("/dev/sda");
                        LOG.info((Object)"Adding ephemeral disk at /dev/sdb");
                        image.getDeviceMappings().add(new EphemeralDeviceMapping(image, "/dev/sdb", "ephemeral0"));
                    } else {
                        LOG.error((Object)("Expected to see only the root block device mapping but encountered " + image.getDeviceMappings().size() + " device mappings."));
                    }
                    Entities.persist((Object)image);
                }
                db.commit();
                return true;
            }
            catch (Exception ex) {
                LOG.error((Object)"Error upgrading BlockStorageImageInfo: ", (Throwable)ex);
                db.rollback();
                throw Exceptions.toUndeclared((Throwable)ex);
            }
        }

        static {
            LOG = Logger.getLogger(BlockStorageImageInfo330Upgrade.class);
        }
    }
}

