/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.images;

import com.eucalyptus.compute.common.ImageMetadata;
import com.eucalyptus.images.DeviceMapping;
import com.eucalyptus.images.ImageInfo;
import javax.persistence.Column;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.PersistenceContext;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="blockstorage")
public class BlockStorageDeviceMapping
extends DeviceMapping {
    @Column(name="metadata_device_mapping_blockstorage_snapshot_id")
    private String snapshotId;
    @Column(name="metadata_device_mapping_blockstorage_size")
    private Integer size;
    @Column(name="metadata_device_mapping_blockstorage_delete")
    private Boolean delete;

    public BlockStorageDeviceMapping() {
        this.setDeviceMappingType(ImageMetadata.DeviceMappingType.blockstorage);
    }

    public BlockStorageDeviceMapping(ImageInfo parent, String deviceName, String virtualName, String snapshotId, Integer size, Boolean deleteOnTermiante) {
        super(parent, ImageMetadata.DeviceMappingType.blockstorage, deviceName, virtualName);
        this.snapshotId = snapshotId;
        this.size = size;
        this.delete = deleteOnTermiante;
    }

    public String getSnapshotId() {
        return this.snapshotId;
    }

    public void setSnapshotId(String snapshotId) {
        this.snapshotId = snapshotId;
    }

    public Integer getSize() {
        return this.size;
    }

    public void setSize(Integer size) {
        this.size = size;
    }

    public Boolean getDelete() {
        return this.delete;
    }

    public void setDelete(Boolean delete) {
        this.delete = delete;
    }
}

