/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc.persist;

import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.compute.vpc.Subnets;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.compute.vpc.VpcMetadataNotFoundException;
import com.eucalyptus.compute.vpc.persist.VpcPersistenceSupport;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;

@ComponentNamed
public class PersistenceSubnets
extends VpcPersistenceSupport<CloudMetadata.SubnetMetadata, Subnet>
implements Subnets {
    public PersistenceSubnets() {
        super("subnet");
    }

    @Override
    public <T> T lookupDefault(OwnerFullName ownerFullName, String availabilityZone, Function<? super Subnet, T> transform) throws VpcMetadataException {
        try {
            return (T)Iterables.getOnlyElement((Iterable)this.listByExample((AbstractPersistent)Subnet.exampleDefault(ownerFullName, availabilityZone), Predicates.alwaysTrue(), transform));
        }
        catch (NoSuchElementException e) {
            throw new VpcMetadataNotFoundException(this.qualifyOwner("Default subnet not found for zone: " + availabilityZone, ownerFullName));
        }
    }

    protected Subnet exampleWithOwner(OwnerFullName ownerFullName) {
        return Subnet.exampleWithOwner(ownerFullName);
    }

    protected Subnet exampleWithName(OwnerFullName ownerFullName, String name) {
        return Subnet.exampleWithName(ownerFullName, name);
    }
}

