/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc.persist;

import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.SecurityGroups;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.compute.vpc.VpcMetadataNotFoundException;
import com.eucalyptus.compute.vpc.persist.VpcPersistenceSupport;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Transactions;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedType;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.NoSuchElementException;

@ComponentNamed
public class PersistenceSecurityGroups
extends VpcPersistenceSupport<CloudMetadata.NetworkGroupMetadata, NetworkGroup>
implements SecurityGroups {
    public PersistenceSecurityGroups() {
        super("security-group");
    }

    @Override
    public <T> T lookupDefault(String vpcId, Function<? super NetworkGroup, T> transform) throws VpcMetadataException {
        try {
            return (T)Iterables.getOnlyElement((Iterable)this.listByExample((AbstractPersistent)NetworkGroup.namedForVpc(vpcId, NetworkGroups.defaultNetworkName()), Predicates.alwaysTrue(), transform));
        }
        catch (NoSuchElementException e) {
            throw new VpcMetadataNotFoundException("Default security group not found for " + vpcId);
        }
    }

    @Override
    public boolean delete(NetworkGroup networkGroup) throws VpcMetadataException {
        try {
            return Transactions.delete((Object)((Object)networkGroup));
        }
        catch (NoSuchElementException e) {
            return false;
        }
        catch (Exception e) {
            throw this.metadataException("Error deleting " + this.typeDescription + " '" + this.describe((RestrictedType)networkGroup) + "'", e);
        }
    }

    protected NetworkGroup exampleWithOwner(OwnerFullName ownerFullName) {
        return NetworkGroup.withOwner(ownerFullName);
    }

    protected NetworkGroup exampleWithName(OwnerFullName ownerFullName, String name) {
        return NetworkGroup.named(ownerFullName, name);
    }
}

