/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc.persist;

import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.RouteTable;
import com.eucalyptus.compute.vpc.RouteTables;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.compute.vpc.VpcMetadataNotFoundException;
import com.eucalyptus.compute.vpc.persist.VpcPersistenceSupport;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@ComponentNamed
public class PersistenceRouteTables
extends VpcPersistenceSupport<CloudMetadata.RouteTableMetadata, RouteTable>
implements RouteTables {
    public PersistenceRouteTables() {
        super("route-table");
    }

    @Override
    public <T> T lookupMain(String vpcId, Function<? super RouteTable, T> transform) throws VpcMetadataException {
        try {
            return (T)Iterables.getOnlyElement((Iterable)this.listByExample((AbstractPersistent)RouteTable.exampleMain(), Predicates.alwaysTrue(), (Criterion)Restrictions.eq((String)"vpc.displayName", (Object)vpcId), Collections.singletonMap("vpc", "vpc"), transform));
        }
        catch (NoSuchElementException e) {
            throw new VpcMetadataNotFoundException("Main route table not found for " + vpcId);
        }
    }

    @Override
    public <T> T updateByAssociationId(String associationId, OwnerFullName ownerFullName, Function<RouteTable, T> updateTransform) throws VpcMetadataException {
        return (T)this.updateByExample((AbstractPersistent)RouteTable.exampleWithOwner(ownerFullName), (Criterion)Restrictions.eq((String)"routeTableAssociations.associationId", (Object)associationId), Collections.singletonMap("routeTableAssociations", "routeTableAssociations"), ownerFullName, associationId, updateTransform);
    }

    protected RouteTable exampleWithOwner(OwnerFullName ownerFullName) {
        return RouteTable.exampleWithOwner(ownerFullName);
    }

    protected RouteTable exampleWithName(OwnerFullName ownerFullName, String name) {
        return RouteTable.exampleWithName(ownerFullName, name);
    }
}

