/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc.persist;

import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.compute.vpc.NetworkInterfaces;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.compute.vpc.persist.VpcPersistenceSupport;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.google.common.base.Function;
import com.google.common.base.Functions;

@ComponentNamed
public class PersistenceNetworkInterfaces
extends VpcPersistenceSupport<CloudMetadata.NetworkInterfaceMetadata, NetworkInterface>
implements NetworkInterfaces {
    public PersistenceNetworkInterfaces() {
        super("network-interfaces");
    }

    protected NetworkInterface exampleWithOwner(OwnerFullName ownerFullName) {
        return NetworkInterface.exampleWithOwner(ownerFullName);
    }

    protected NetworkInterface exampleWithName(OwnerFullName ownerFullName, String name) {
        return NetworkInterface.exampleWithName(ownerFullName, name);
    }

    @RestrictedTypes.Resolver(value=NetworkInterface.class)
    public static enum Lookup implements Function<String, NetworkInterface>
    {
        INSTANCE;


        public NetworkInterface apply(String identifier) {
            try {
                return (NetworkInterface)((Object)new PersistenceNetworkInterfaces().lookupByName(null, identifier, Functions.identity()));
            }
            catch (VpcMetadataException e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }
}

