/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc.persist;

import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.NetworkAcl;
import com.eucalyptus.compute.vpc.NetworkAcls;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.compute.vpc.VpcMetadataNotFoundException;
import com.eucalyptus.compute.vpc.persist.VpcPersistenceSupport;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.NoSuchElementException;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@ComponentNamed
public class PersistenceNetworkAcls
extends VpcPersistenceSupport<CloudMetadata.NetworkAclMetadata, NetworkAcl>
implements NetworkAcls {
    public PersistenceNetworkAcls() {
        super("network-acl");
    }

    @Override
    public <T> T lookupDefault(String vpcId, Function<? super NetworkAcl, T> transform) throws VpcMetadataException {
        try {
            return (T)Iterables.getOnlyElement((Iterable)this.listByExample((AbstractPersistent)NetworkAcl.exampleDefault(), Predicates.alwaysTrue(), (Criterion)Restrictions.eq((String)"vpc.displayName", (Object)vpcId), Collections.singletonMap("vpc", "vpc"), transform));
        }
        catch (NoSuchElementException e) {
            throw new VpcMetadataNotFoundException("Default network acl not found for " + vpcId);
        }
    }

    protected NetworkAcl exampleWithOwner(OwnerFullName ownerFullName) {
        return NetworkAcl.exampleWithOwner(ownerFullName);
    }

    protected NetworkAcl exampleWithName(OwnerFullName ownerFullName, String name) {
        return NetworkAcl.exampleWithName(ownerFullName, name);
    }
}

