/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc.persist;

import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.InternetGateway;
import com.eucalyptus.compute.vpc.InternetGateways;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.compute.vpc.VpcMetadataNotFoundException;
import com.eucalyptus.compute.vpc.persist.VpcPersistenceSupport;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Predicates;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.NoSuchElementException;
import javax.annotation.Nullable;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;

@ComponentNamed
public class PersistenceInternetGateways
extends VpcPersistenceSupport<CloudMetadata.InternetGatewayMetadata, InternetGateway>
implements InternetGateways {
    public PersistenceInternetGateways() {
        super("internet-gateway");
    }

    @Override
    public <T> T lookupByVpc(@Nullable OwnerFullName ownerFullName, String vpcId, Function<? super InternetGateway, T> transform) throws VpcMetadataException {
        try {
            return (T)Iterables.getOnlyElement((Iterable)this.listByExample((AbstractPersistent)InternetGateway.exampleWithOwner(ownerFullName), Predicates.alwaysTrue(), (Criterion)Restrictions.eq((String)"vpc.displayName", (Object)vpcId), Collections.singletonMap("vpc", "vpc"), transform));
        }
        catch (NoSuchElementException e) {
            throw new VpcMetadataNotFoundException("Internet gateway not found for " + vpcId);
        }
    }

    protected InternetGateway exampleWithOwner(OwnerFullName ownerFullName) {
        return InternetGateway.exampleWithOwner(ownerFullName);
    }

    protected InternetGateway exampleWithName(OwnerFullName ownerFullName, String name) {
        return InternetGateway.exampleWithName(ownerFullName, name);
    }
}

