/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.ResourceTagSetItemType;
import com.eucalyptus.compute.common.VpcType;
import com.eucalyptus.compute.vpc.Lister;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.compute.vpc.VpcTag;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.hibernate.criterion.Criterion;

public interface Vpcs
extends Lister<Vpc> {
    public static final String DEFAULT_VPC_CIDR = "172.31.0.0/16";

    @Override
    public <T> List<T> list(OwnerFullName var1, Criterion var2, Map<String, String> var3, Predicate<? super Vpc> var4, Function<? super Vpc, T> var5) throws VpcMetadataException;

    public <T> T lookupByName(@Nullable OwnerFullName var1, String var2, Function<? super Vpc, T> var3) throws VpcMetadataException;

    public <T> T lookupDefault(OwnerFullName var1, Function<? super Vpc, T> var2) throws VpcMetadataException;

    public boolean delete(CloudMetadata.VpcMetadata var1) throws VpcMetadataException;

    public Vpc save(Vpc var1) throws VpcMetadataException;

    public Vpc updateByExample(Vpc var1, OwnerFullName var2, String var3, Callback<Vpc> var4) throws VpcMetadataException;

    @RestrictedTypes.QuantityMetricFunction(value=CloudMetadata.VpcMetadata.class)
    public static enum CountVpcs implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        public Long apply(@Nullable OwnerFullName input) {
            try (TransactionResource tx = Entities.transactionFor(Vpc.class);){
                Long l = Entities.count((Object)((Object)Vpc.exampleWithOwner(input)));
                return l;
            }
        }
    }

    public static enum FilterBooleanFunctions implements Function<Vpc, Boolean>
    {
        IS_DEFAULT{

            public Boolean apply(Vpc vpc) {
                return vpc.getDefaultVpc();
            }
        };

    }

    public static enum FilterStringFunctions implements Function<Vpc, String>
    {
        CIDR{

            public String apply(Vpc vpc) {
                return vpc.getCidr();
            }
        }
        ,
        DHCP_OPTIONS_ID{

            public String apply(Vpc vpc) {
                return (String)CloudMetadatas.toDisplayName().apply((Object)vpc.getDhcpOptionSet());
            }
        }
        ,
        STATE{

            public String apply(Vpc vpc) {
                return Objects.toString(vpc.getState(), "");
            }
        }
        ,
        VPC_ID{

            public String apply(Vpc vpc) {
                return vpc.getDisplayName();
            }
        };

    }

    public static class VpcFilterSupport
    extends FilterSupport<Vpc> {
        public VpcFilterSupport() {
            super(VpcFilterSupport.builderFor(Vpc.class).withTagFiltering(VpcTag.class, "vpc").withStringProperty("cidr", FilterStringFunctions.CIDR).withStringProperty("cidrBlock", FilterStringFunctions.CIDR).withStringProperty("dhcp-options-id", FilterStringFunctions.DHCP_OPTIONS_ID).withStringProperty("dhcpOptionsId", FilterStringFunctions.DHCP_OPTIONS_ID).withBooleanProperty("isDefault", FilterBooleanFunctions.IS_DEFAULT).withStringProperty("state", FilterStringFunctions.STATE).withStringProperty("vpc-id", FilterStringFunctions.VPC_ID).withPersistenceAlias("dhcpOptionSet", "dhcpOptionSet").withPersistenceFilter("cidr").withPersistenceFilter("cidrBlock", "cidr").withPersistenceFilter("dhcp-options-id", "dhcpOptionSet.displayName").withPersistenceFilter("dhcpOptionsId", "dhcpOptionSet.displayName").withPersistenceFilter("isDefault", "defaultVpc", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("state", "state", Enums.valueOfFunction(Vpc.State.class)).withPersistenceFilter("vpc-id", "displayName"));
        }
    }

    @TypeMapper
    public static enum TagToResourceTagSetItemTypeTransform implements Function<Tag, ResourceTagSetItemType>
    {
        INSTANCE;


        @Nullable
        public ResourceTagSetItemType apply(@Nullable Tag tag) {
            return tag == null ? null : new ResourceTagSetItemType(tag.getKey(), tag.getValue());
        }
    }

    @TypeMapper
    public static enum VpcToVpcTypeTransform implements Function<Vpc, VpcType>
    {
        INSTANCE;


        @Nullable
        public VpcType apply(@Nullable Vpc vpc) {
            return vpc == null ? null : new VpcType(vpc.getDisplayName(), Objects.toString(vpc.getState(), null), vpc.getCidr(), (String)CloudMetadatas.toDisplayName().apply((Object)vpc.getDhcpOptionSet()), vpc.getDefaultVpc());
        }
    }
}

