/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_tags_vpcs")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="vpc")
public class VpcTag
extends Tag<VpcTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Vpc vpc;

    protected VpcTag() {
        super("vpc", ResourceIdFunction.INSTANCE);
    }

    public VpcTag(@Nonnull Vpc vpc, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        super("vpc", ResourceIdFunction.INSTANCE, ownerFullName, key, value);
        this.setVpc(vpc);
        this.init();
    }

    public Vpc getVpc() {
        return this.vpc;
    }

    public void setVpc(Vpc vpc) {
        this.vpc = vpc;
    }

    @Nonnull
    public static Tag named(@Nonnull Vpc vpc, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return VpcTag.namedWithValue(vpc, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull Vpc vpc, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)vpc), (Object)"vpc");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new VpcTag(vpc, ownerFullName, key, value);
    }

    public static final class VpcTagSupport
    extends TagSupport {
        public VpcTagSupport() {
            super(Vpc.class, "vpc", "displayName", "vpc", " InvalidVpcID.NotFound", "The vpc '%s' does not exist.");
        }

        @Override
        public Tag createOrUpdate(CloudMetadata metadata, OwnerFullName ownerFullName, String key, String value) {
            return Tags.createOrUpdate(new VpcTag((Vpc)metadata, ownerFullName, key, value));
        }

        @Override
        public Tag example(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return VpcTag.namedWithValue((Vpc)metadata, ownerFullName, key, value);
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new VpcTag(), ownerFullName);
        }

        @Override
        public CloudMetadata lookup(String identifier) throws TransactionException {
            return (CloudMetadata)Entities.uniqueResult((Object)((Object)Vpc.exampleWithName(null, identifier)));
        }
    }

    private static enum ResourceIdFunction implements Function<VpcTag, String>
    {
        INSTANCE{

            public String apply(VpcTag vpcTag) {
                return vpcTag.getVpc().getDisplayName();
            }
        };

    }
}

