/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.euare.events.AccountCreatedEvent;
import com.eucalyptus.component.Partition;
import com.eucalyptus.component.ServiceConfiguration;
import com.eucalyptus.component.Topology;
import com.eucalyptus.compute.common.Compute;
import com.eucalyptus.compute.common.CreateVpcType;
import com.eucalyptus.compute.common.network.Networking;
import com.eucalyptus.compute.common.network.NetworkingFeature;
import com.eucalyptus.compute.vpc.VpcConfiguration;
import com.eucalyptus.event.EventListener;
import com.eucalyptus.event.Listeners;
import com.eucalyptus.util.Internets;
import com.eucalyptus.util.async.AsyncRequests;
import com.eucalyptus.util.async.CheckedListenableFuture;
import com.eucalyptus.util.concurrent.ListenableFuture;
import com.google.common.collect.Lists;
import edu.ucsb.eucalyptus.msgs.BaseCallerContext;
import edu.ucsb.eucalyptus.msgs.BaseMessage;
import edu.ucsb.eucalyptus.msgs.EvaluatedIamConditionKey;
import java.util.concurrent.ExecutionException;
import org.apache.log4j.Logger;

public class VpcNewAccountEventListener
implements EventListener<AccountCreatedEvent> {
    private static final Logger logger = Logger.getLogger(VpcNewAccountEventListener.class);

    public static void register() {
        Listeners.register(AccountCreatedEvent.class, (EventListener)new VpcNewAccountEventListener());
    }

    public void fireEvent(AccountCreatedEvent event) {
        try {
            if (VpcConfiguration.getDefaultVpc() && Networking.getInstance().supports(NetworkingFeature.Vpc)) {
                ServiceConfiguration config = Topology.lookup(Compute.class, (Partition[])new Partition[0]);
                CreateVpcType createVpc = new CreateVpcType();
                createVpc.setCidrBlock((String)event.getMessage());
                createVpc.setUserId(Accounts.lookupSystemAdmin().getUserId());
                createVpc.setCallerContext(new BaseCallerContext(Lists.newArrayList((Object[])new EvaluatedIamConditionKey[]{new EvaluatedIamConditionKey("aws:sourceip", Internets.localHostAddress())})));
                CheckedListenableFuture dispatchFuture = AsyncRequests.dispatch((ServiceConfiguration)config, (BaseMessage)createVpc);
                dispatchFuture.addListener(new Runnable((ListenableFuture)dispatchFuture, event){
                    final /* synthetic */ ListenableFuture val$dispatchFuture;
                    final /* synthetic */ AccountCreatedEvent val$event;
                    {
                        this.val$dispatchFuture = listenableFuture;
                        this.val$event = accountCreatedEvent;
                    }

                    @Override
                    public void run() {
                        try {
                            this.val$dispatchFuture.get();
                        }
                        catch (InterruptedException e) {
                            logger.info((Object)("Interrupted while creating default vpc for account " + (String)this.val$event.getMessage()), (Throwable)e);
                        }
                        catch (ExecutionException e) {
                            logger.error((Object)("Error creating default vpc for account " + (String)this.val$event.getMessage()), (Throwable)e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            logger.error((Object)("Error creating default vpc for account " + (String)event.getMessage()), (Throwable)e);
        }
    }
}

