/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.auth.Accounts;
import com.eucalyptus.auth.AuthQuotaException;
import com.eucalyptus.auth.principal.Account;
import com.eucalyptus.auth.principal.AccountFullName;
import com.eucalyptus.auth.principal.User;
import com.eucalyptus.auth.principal.UserFullName;
import com.eucalyptus.cloud.util.NoSuchMetadataException;
import com.eucalyptus.cloud.util.ResourceAllocationException;
import com.eucalyptus.cluster.Clusters;
import com.eucalyptus.component.annotation.ComponentNamed;
import com.eucalyptus.compute.ClientComputeException;
import com.eucalyptus.compute.ClientUnauthorizedComputeException;
import com.eucalyptus.compute.ComputeException;
import com.eucalyptus.compute.common.AccountAttributeSetItemType;
import com.eucalyptus.compute.common.AttributeBooleanValueType;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.DhcpConfigurationItemType;
import com.eucalyptus.compute.common.DhcpOptionsType;
import com.eucalyptus.compute.common.Filter;
import com.eucalyptus.compute.common.GroupItemType;
import com.eucalyptus.compute.common.GroupSetType;
import com.eucalyptus.compute.common.InternetGatewayType;
import com.eucalyptus.compute.common.NetworkAclType;
import com.eucalyptus.compute.common.NetworkInterfaceAttachmentType;
import com.eucalyptus.compute.common.NetworkInterfaceType;
import com.eucalyptus.compute.common.NullableAttributeValueType;
import com.eucalyptus.compute.common.PrivateIpAddressesSetItemRequestType;
import com.eucalyptus.compute.common.ResourceTagSetItemType;
import com.eucalyptus.compute.common.ResourceTagSetType;
import com.eucalyptus.compute.common.RouteTableType;
import com.eucalyptus.compute.common.SubnetType;
import com.eucalyptus.compute.common.VpcTagged;
import com.eucalyptus.compute.common.VpcType;
import com.eucalyptus.compute.common.backend.AcceptVpcPeeringConnectionResponseType;
import com.eucalyptus.compute.common.backend.AcceptVpcPeeringConnectionType;
import com.eucalyptus.compute.common.backend.AssignPrivateIpAddressesResponseType;
import com.eucalyptus.compute.common.backend.AssignPrivateIpAddressesType;
import com.eucalyptus.compute.common.backend.AssociateDhcpOptionsResponseType;
import com.eucalyptus.compute.common.backend.AssociateDhcpOptionsType;
import com.eucalyptus.compute.common.backend.AssociateRouteTableResponseType;
import com.eucalyptus.compute.common.backend.AssociateRouteTableType;
import com.eucalyptus.compute.common.backend.AttachInternetGatewayResponseType;
import com.eucalyptus.compute.common.backend.AttachInternetGatewayType;
import com.eucalyptus.compute.common.backend.AttachNetworkInterfaceResponseType;
import com.eucalyptus.compute.common.backend.AttachNetworkInterfaceType;
import com.eucalyptus.compute.common.backend.AttachVpnGatewayResponseType;
import com.eucalyptus.compute.common.backend.AttachVpnGatewayType;
import com.eucalyptus.compute.common.backend.CreateCustomerGatewayResponseType;
import com.eucalyptus.compute.common.backend.CreateCustomerGatewayType;
import com.eucalyptus.compute.common.backend.CreateDhcpOptionsResponseType;
import com.eucalyptus.compute.common.backend.CreateDhcpOptionsType;
import com.eucalyptus.compute.common.backend.CreateInternetGatewayResponseType;
import com.eucalyptus.compute.common.backend.CreateInternetGatewayType;
import com.eucalyptus.compute.common.backend.CreateNetworkAclEntryResponseType;
import com.eucalyptus.compute.common.backend.CreateNetworkAclEntryType;
import com.eucalyptus.compute.common.backend.CreateNetworkAclResponseType;
import com.eucalyptus.compute.common.backend.CreateNetworkAclType;
import com.eucalyptus.compute.common.backend.CreateNetworkInterfaceResponseType;
import com.eucalyptus.compute.common.backend.CreateNetworkInterfaceType;
import com.eucalyptus.compute.common.backend.CreateRouteResponseType;
import com.eucalyptus.compute.common.backend.CreateRouteTableResponseType;
import com.eucalyptus.compute.common.backend.CreateRouteTableType;
import com.eucalyptus.compute.common.backend.CreateRouteType;
import com.eucalyptus.compute.common.backend.CreateSubnetResponseType;
import com.eucalyptus.compute.common.backend.CreateSubnetType;
import com.eucalyptus.compute.common.backend.CreateVpcPeeringConnectionResponseType;
import com.eucalyptus.compute.common.backend.CreateVpcPeeringConnectionType;
import com.eucalyptus.compute.common.backend.CreateVpcResponseType;
import com.eucalyptus.compute.common.backend.CreateVpcType;
import com.eucalyptus.compute.common.backend.CreateVpnConnectionResponseType;
import com.eucalyptus.compute.common.backend.CreateVpnConnectionRouteResponseType;
import com.eucalyptus.compute.common.backend.CreateVpnConnectionRouteType;
import com.eucalyptus.compute.common.backend.CreateVpnConnectionType;
import com.eucalyptus.compute.common.backend.CreateVpnGatewayResponseType;
import com.eucalyptus.compute.common.backend.CreateVpnGatewayType;
import com.eucalyptus.compute.common.backend.DeleteCustomerGatewayResponseType;
import com.eucalyptus.compute.common.backend.DeleteCustomerGatewayType;
import com.eucalyptus.compute.common.backend.DeleteDhcpOptionsResponseType;
import com.eucalyptus.compute.common.backend.DeleteDhcpOptionsType;
import com.eucalyptus.compute.common.backend.DeleteInternetGatewayResponseType;
import com.eucalyptus.compute.common.backend.DeleteInternetGatewayType;
import com.eucalyptus.compute.common.backend.DeleteNetworkAclEntryResponseType;
import com.eucalyptus.compute.common.backend.DeleteNetworkAclEntryType;
import com.eucalyptus.compute.common.backend.DeleteNetworkAclResponseType;
import com.eucalyptus.compute.common.backend.DeleteNetworkAclType;
import com.eucalyptus.compute.common.backend.DeleteNetworkInterfaceResponseType;
import com.eucalyptus.compute.common.backend.DeleteNetworkInterfaceType;
import com.eucalyptus.compute.common.backend.DeleteRouteResponseType;
import com.eucalyptus.compute.common.backend.DeleteRouteTableResponseType;
import com.eucalyptus.compute.common.backend.DeleteRouteTableType;
import com.eucalyptus.compute.common.backend.DeleteRouteType;
import com.eucalyptus.compute.common.backend.DeleteSubnetResponseType;
import com.eucalyptus.compute.common.backend.DeleteSubnetType;
import com.eucalyptus.compute.common.backend.DeleteVpcPeeringConnectionResponseType;
import com.eucalyptus.compute.common.backend.DeleteVpcPeeringConnectionType;
import com.eucalyptus.compute.common.backend.DeleteVpcResponseType;
import com.eucalyptus.compute.common.backend.DeleteVpcType;
import com.eucalyptus.compute.common.backend.DeleteVpnConnectionResponseType;
import com.eucalyptus.compute.common.backend.DeleteVpnConnectionRouteResponseType;
import com.eucalyptus.compute.common.backend.DeleteVpnConnectionRouteType;
import com.eucalyptus.compute.common.backend.DeleteVpnConnectionType;
import com.eucalyptus.compute.common.backend.DeleteVpnGatewayResponseType;
import com.eucalyptus.compute.common.backend.DeleteVpnGatewayType;
import com.eucalyptus.compute.common.backend.DescribeAccountAttributesResponseType;
import com.eucalyptus.compute.common.backend.DescribeAccountAttributesType;
import com.eucalyptus.compute.common.backend.DescribeCustomerGatewaysResponseType;
import com.eucalyptus.compute.common.backend.DescribeCustomerGatewaysType;
import com.eucalyptus.compute.common.backend.DescribeDhcpOptionsResponseType;
import com.eucalyptus.compute.common.backend.DescribeDhcpOptionsType;
import com.eucalyptus.compute.common.backend.DescribeInternetGatewaysResponseType;
import com.eucalyptus.compute.common.backend.DescribeInternetGatewaysType;
import com.eucalyptus.compute.common.backend.DescribeNetworkAclsResponseType;
import com.eucalyptus.compute.common.backend.DescribeNetworkAclsType;
import com.eucalyptus.compute.common.backend.DescribeNetworkInterfaceAttributeResponseType;
import com.eucalyptus.compute.common.backend.DescribeNetworkInterfaceAttributeType;
import com.eucalyptus.compute.common.backend.DescribeNetworkInterfacesResponseType;
import com.eucalyptus.compute.common.backend.DescribeNetworkInterfacesType;
import com.eucalyptus.compute.common.backend.DescribeRouteTablesResponseType;
import com.eucalyptus.compute.common.backend.DescribeRouteTablesType;
import com.eucalyptus.compute.common.backend.DescribeSubnetsResponseType;
import com.eucalyptus.compute.common.backend.DescribeSubnetsType;
import com.eucalyptus.compute.common.backend.DescribeVpcAttributeResponseType;
import com.eucalyptus.compute.common.backend.DescribeVpcAttributeType;
import com.eucalyptus.compute.common.backend.DescribeVpcPeeringConnectionsResponseType;
import com.eucalyptus.compute.common.backend.DescribeVpcPeeringConnectionsType;
import com.eucalyptus.compute.common.backend.DescribeVpcsResponseType;
import com.eucalyptus.compute.common.backend.DescribeVpcsType;
import com.eucalyptus.compute.common.backend.DescribeVpnConnectionsResponseType;
import com.eucalyptus.compute.common.backend.DescribeVpnConnectionsType;
import com.eucalyptus.compute.common.backend.DescribeVpnGatewaysResponseType;
import com.eucalyptus.compute.common.backend.DescribeVpnGatewaysType;
import com.eucalyptus.compute.common.backend.DetachInternetGatewayResponseType;
import com.eucalyptus.compute.common.backend.DetachInternetGatewayType;
import com.eucalyptus.compute.common.backend.DetachNetworkInterfaceResponseType;
import com.eucalyptus.compute.common.backend.DetachNetworkInterfaceType;
import com.eucalyptus.compute.common.backend.DetachVpnGatewayResponseType;
import com.eucalyptus.compute.common.backend.DetachVpnGatewayType;
import com.eucalyptus.compute.common.backend.DisableVgwRoutePropagationResponseType;
import com.eucalyptus.compute.common.backend.DisableVgwRoutePropagationType;
import com.eucalyptus.compute.common.backend.DisassociateRouteTableResponseType;
import com.eucalyptus.compute.common.backend.DisassociateRouteTableType;
import com.eucalyptus.compute.common.backend.EnableVgwRoutePropagationResponseType;
import com.eucalyptus.compute.common.backend.EnableVgwRoutePropagationType;
import com.eucalyptus.compute.common.backend.ModifyNetworkInterfaceAttributeResponseType;
import com.eucalyptus.compute.common.backend.ModifyNetworkInterfaceAttributeType;
import com.eucalyptus.compute.common.backend.ModifySubnetAttributeResponseType;
import com.eucalyptus.compute.common.backend.ModifySubnetAttributeType;
import com.eucalyptus.compute.common.backend.ModifyVpcAttributeResponseType;
import com.eucalyptus.compute.common.backend.ModifyVpcAttributeType;
import com.eucalyptus.compute.common.backend.RejectVpcPeeringConnectionResponseType;
import com.eucalyptus.compute.common.backend.RejectVpcPeeringConnectionType;
import com.eucalyptus.compute.common.backend.ReplaceNetworkAclAssociationResponseType;
import com.eucalyptus.compute.common.backend.ReplaceNetworkAclAssociationType;
import com.eucalyptus.compute.common.backend.ReplaceNetworkAclEntryResponseType;
import com.eucalyptus.compute.common.backend.ReplaceNetworkAclEntryType;
import com.eucalyptus.compute.common.backend.ReplaceRouteResponseType;
import com.eucalyptus.compute.common.backend.ReplaceRouteTableAssociationResponseType;
import com.eucalyptus.compute.common.backend.ReplaceRouteTableAssociationType;
import com.eucalyptus.compute.common.backend.ReplaceRouteType;
import com.eucalyptus.compute.common.backend.ResetNetworkInterfaceAttributeResponseType;
import com.eucalyptus.compute.common.backend.ResetNetworkInterfaceAttributeType;
import com.eucalyptus.compute.common.backend.UnassignPrivateIpAddressesResponseType;
import com.eucalyptus.compute.common.backend.UnassignPrivateIpAddressesType;
import com.eucalyptus.compute.common.network.Networking;
import com.eucalyptus.compute.common.network.NetworkingFeature;
import com.eucalyptus.compute.identifier.InvalidResourceIdentifier;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.compute.vpc.DhcpOption;
import com.eucalyptus.compute.vpc.DhcpOptionSet;
import com.eucalyptus.compute.vpc.DhcpOptionSets;
import com.eucalyptus.compute.vpc.InternetGateway;
import com.eucalyptus.compute.vpc.InternetGateways;
import com.eucalyptus.compute.vpc.Lister;
import com.eucalyptus.compute.vpc.NetworkAcl;
import com.eucalyptus.compute.vpc.NetworkAclEntry;
import com.eucalyptus.compute.vpc.NetworkAcls;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.compute.vpc.NetworkInterfaceHelper;
import com.eucalyptus.compute.vpc.NetworkInterfaces;
import com.eucalyptus.compute.vpc.Route;
import com.eucalyptus.compute.vpc.RouteTable;
import com.eucalyptus.compute.vpc.RouteTableAssociation;
import com.eucalyptus.compute.vpc.RouteTables;
import com.eucalyptus.compute.vpc.SecurityGroups;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.compute.vpc.Subnets;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.compute.vpc.VpcConfiguration;
import com.eucalyptus.compute.vpc.VpcInvalidator;
import com.eucalyptus.compute.vpc.VpcMetadataNotFoundException;
import com.eucalyptus.compute.vpc.Vpcs;
import com.eucalyptus.context.Context;
import com.eucalyptus.context.Contexts;
import com.eucalyptus.entities.AbstractPersistent;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.network.IPRange;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.network.NetworkPeer;
import com.eucalyptus.network.NetworkRule;
import com.eucalyptus.network.PrivateAddresses;
import com.eucalyptus.tags.Filters;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.CollectionUtils;
import com.eucalyptus.util.EucalyptusCloudException;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.Pair;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMappers;
import com.eucalyptus.util.dns.DomainNames;
import com.eucalyptus.vm.VmInstances;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.base.Supplier;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.net.InetAddresses;
import com.google.common.net.InternetDomainName;
import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.exception.ConstraintViolationException;

@ComponentNamed
public class VpcManager {
    private static final Logger logger = Logger.getLogger(VpcManager.class);
    private final DhcpOptionSets dhcpOptionSets;
    private final InternetGateways internetGateways;
    private final NetworkAcls networkAcls;
    private final NetworkInterfaces networkInterfaces;
    private final RouteTables routeTables;
    private final SecurityGroups securityGroups;
    private final Subnets subnets;
    private final Vpcs vpcs;
    private final VpcInvalidator vpcInvalidator;

    @Inject
    public VpcManager(DhcpOptionSets dhcpOptionSets, InternetGateways internetGateways, NetworkAcls networkAcls, NetworkInterfaces networkInterfaces, RouteTables routeTables, SecurityGroups securityGroups, Subnets subnets, Vpcs vpcs, VpcInvalidator vpcInvalidator) {
        this.dhcpOptionSets = dhcpOptionSets;
        this.internetGateways = internetGateways;
        this.networkAcls = networkAcls;
        this.networkInterfaces = networkInterfaces;
        this.routeTables = routeTables;
        this.securityGroups = securityGroups;
        this.subnets = subnets;
        this.vpcs = vpcs;
        this.vpcInvalidator = vpcInvalidator;
    }

    public AcceptVpcPeeringConnectionResponseType acceptVpcPeeringConnection(AcceptVpcPeeringConnectionType request) throws EucalyptusCloudException {
        AcceptVpcPeeringConnectionResponseType reply = (AcceptVpcPeeringConnectionResponseType)request.getReply();
        return reply;
    }

    public AssignPrivateIpAddressesResponseType assignPrivateIpAddresses(AssignPrivateIpAddressesType request) throws EucalyptusCloudException {
        AssignPrivateIpAddressesResponseType reply = (AssignPrivateIpAddressesResponseType)request.getReply();
        return reply;
    }

    public AssociateDhcpOptionsResponseType associateDhcpOptions(final AssociateDhcpOptionsType request) throws EucalyptusCloudException {
        AssociateDhcpOptionsResponseType reply = (AssociateDhcpOptionsResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String dhcpOptionsId = "default".equals(request.getDhcpOptionsId()) ? "default" : Identifier.dopt.normalize(request.getDhcpOptionsId());
        String vpcId = Identifier.vpc.normalize(request.getVpcId());
        try {
            this.vpcs.updateByExample(Vpc.exampleWithName((OwnerFullName)accountFullName, vpcId), (OwnerFullName)accountFullName, request.getVpcId(), new Callback<Vpc>(){

                public void fire(Vpc vpc) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)vpc)) {
                        try {
                            DhcpOptionSet dhcpOptionSet = "default".equals(dhcpOptionsId) ? (DhcpOptionSet)((Object)VpcManager.this.dhcpOptionSets.lookupByExample(DhcpOptionSet.exampleDefault((OwnerFullName)accountFullName), (OwnerFullName)accountFullName, "default", (Predicate<? super DhcpOptionSet>)Predicates.alwaysTrue(), Functions.identity())) : (DhcpOptionSet)((Object)VpcManager.this.dhcpOptionSets.lookupByName((OwnerFullName)accountFullName, dhcpOptionsId, Functions.identity()));
                            vpc.setDhcpOptionSet(dhcpOptionSet);
                        }
                        catch (VpcMetadataNotFoundException e) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidDhcpOptionsID.NotFound", "DHCP options not found '" + request.getDhcpOptionsId() + "'")));
                        }
                        catch (Exception e) {
                            throw Exceptions.toUndeclared((Throwable)e);
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to associate DHCP options")));
                    }
                }
            });
            this.invalidate(vpcId);
        }
        catch (VpcMetadataNotFoundException e) {
            throw new ClientComputeException("InvalidVpcID.NotFound", "Vpc not found '" + request.getVpcId() + "'");
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public AssociateRouteTableResponseType associateRouteTable(final AssociateRouteTableType request) throws EucalyptusCloudException {
        AssociateRouteTableResponseType reply = (AssociateRouteTableResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String routeTableId = Identifier.rtb.normalize(request.getRouteTableId());
        final String subnetId = Identifier.subnet.normalize(request.getSubnetId());
        try {
            RouteTable routeTable = this.routeTables.updateByExample(RouteTable.exampleWithName((OwnerFullName)accountFullName, routeTableId), (OwnerFullName)accountFullName, request.getRouteTableId(), new Callback<RouteTable>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void fire(RouteTable routeTable) {
                    if (!RestrictedTypes.filterPrivileged().apply((Object)routeTable)) throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to associate route table")));
                    try {
                        Subnet subnet = (Subnet)((Object)VpcManager.this.subnets.lookupByName((OwnerFullName)accountFullName, subnetId, Functions.identity()));
                        if (!subnet.getVpc().getDisplayName().equals(routeTable.getVpc().getDisplayName())) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidParameterValue", "Route table " + routeTableId + " and subnet " + subnetId + " belong to different networks")));
                        }
                        if (Iterables.tryFind(routeTable.getRouteTableAssociations(), (Predicate)CollectionUtils.propertyPredicate((Object)subnetId, (Function)RouteTables.AssociationFilterStringFunctions.SUBNET_ID)).isPresent()) return;
                        routeTable.associate(subnet);
                        return;
                    }
                    catch (VpcMetadataNotFoundException e) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidSubnetID.NotFound", "Subnet (" + request.getSubnetId() + ") not found")));
                    }
                    catch (Exception e) {
                        throw Exceptions.toUndeclared((Throwable)e);
                    }
                }
            });
            RouteTableAssociation association = (RouteTableAssociation)((Object)Iterables.find(routeTable.getRouteTableAssociations(), (Predicate)CollectionUtils.propertyPredicate((Object)subnetId, (Function)RouteTables.AssociationFilterStringFunctions.SUBNET_ID)));
            reply.setAssociationId(association.getAssociationId());
            this.invalidate(subnetId);
        }
        catch (VpcMetadataNotFoundException e) {
            throw new ClientComputeException("InvalidRouteTableID.NotFound", "Route table not found '" + request.getRouteTableId() + "'");
        }
        catch (Exception e) {
            if (Exceptions.isCausedBy((Throwable)e, ConstraintViolationException.class)) {
                throw new ClientComputeException("InvalidParameterValue", "Subnet " + subnetId + " already associated.");
            }
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public AttachInternetGatewayResponseType attachInternetGateway(final AttachInternetGatewayType request) throws EucalyptusCloudException {
        AttachInternetGatewayResponseType reply = (AttachInternetGatewayResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String gatewayId = Identifier.igw.normalize(request.getInternetGatewayId());
        final String vpcId = Identifier.vpc.normalize(request.getVpcId());
        try {
            this.internetGateways.updateByExample(InternetGateway.exampleWithName((OwnerFullName)accountFullName, gatewayId), (OwnerFullName)accountFullName, request.getInternetGatewayId(), new Callback<InternetGateway>(){

                public void fire(InternetGateway internetGateway) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)internetGateway)) {
                        try {
                            Vpc vpc = (Vpc)((Object)VpcManager.this.vpcs.lookupByName((OwnerFullName)accountFullName, vpcId, Functions.identity()));
                            if (internetGateway.getVpc() != null) {
                                throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("Resource.AlreadyAssociated", "resource " + gatewayId + " is already attached to network " + internetGateway.getVpc().getDisplayName())));
                            }
                            internetGateway.setVpc(vpc);
                        }
                        catch (VpcMetadataNotFoundException e) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidVpcID.NotFound", "Vpc not found '" + request.getVpcId() + "'")));
                        }
                        catch (Exception e) {
                            throw Exceptions.toUndeclared((Throwable)e);
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to attach internet gateway")));
                    }
                }
            });
            this.invalidate(vpcId);
        }
        catch (VpcMetadataNotFoundException e) {
            throw new ClientComputeException("InvalidInternetGatewayID.NotFound", "Internet gateway (" + request.getInternetGatewayId() + ") not found ");
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public AttachNetworkInterfaceResponseType attachNetworkInterface(AttachNetworkInterfaceType request) throws EucalyptusCloudException {
        AttachNetworkInterfaceResponseType reply = (AttachNetworkInterfaceResponseType)request.getReply();
        return reply;
    }

    public AttachVpnGatewayResponseType attachVpnGateway(AttachVpnGatewayType request) throws EucalyptusCloudException {
        AttachVpnGatewayResponseType reply = (AttachVpnGatewayResponseType)request.getReply();
        return reply;
    }

    public CreateCustomerGatewayResponseType createCustomerGateway(CreateCustomerGatewayType request) throws EucalyptusCloudException {
        CreateCustomerGatewayResponseType reply = (CreateCustomerGatewayResponseType)request.getReply();
        return reply;
    }

    public CreateDhcpOptionsResponseType createDhcpOptions(final CreateDhcpOptionsType request) throws EucalyptusCloudException {
        CreateDhcpOptionsResponseType reply = (CreateDhcpOptionsResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        Supplier<DhcpOptionSet> allocator = new Supplier<DhcpOptionSet>(){

            public DhcpOptionSet get() {
                try {
                    DhcpOptionSet dhcpOptionSet = DhcpOptionSet.create((OwnerFullName)ctx.getUserFullName(), Identifier.dopt.generate());
                    for (DhcpConfigurationItemType item : request.getDhcpConfigurationSet().getItem()) {
                        List values = item.values();
                        boolean validValue = false;
                        switch (item.getKey()) {
                            case "domain-name": {
                                validValue = values.size() == 1 && InternetDomainName.isValid((String)((String)values.get(0)));
                                break;
                            }
                            case "domain-name-servers": {
                                boolean bl = validValue = values.size() == 1 && "AmazonProvidedDNS".equals(values.get(0));
                                if (validValue) break;
                            }
                            case "ntp-servers": 
                            case "netbios-name-servers": {
                                String value;
                                Iterator i$ = values.iterator();
                                while (i$.hasNext() && (validValue = InetAddresses.isInetAddress((String)(value = (String)i$.next())))) {
                                }
                                break;
                            }
                            case "netbios-node-type": {
                                validValue = values.size() == 1 && (Boolean)Optional.fromNullable((Object)Ints.tryParse((String)((String)values.get(0)))).transform(Functions.forPredicate((Predicate)Predicates.in((Collection)Lists.newArrayList((Object[])new Integer[]{1, 2, 4, 8})))).or((Object)false) != false;
                                break;
                            }
                            default: {
                                throw new ClientComputeException("InvalidParameterValue", "Value (" + item.getKey() + ") for parameter name is invalid. Unknown DHCP option");
                            }
                        }
                        if (!validValue || values.isEmpty()) {
                            throw new ClientComputeException("InvalidParameterValue", "Value (" + Joiner.on((char)',').join((Iterable)values) + ") for parameter value is invalid. Invalid DHCP option value.");
                        }
                        dhcpOptionSet.getDhcpOptions().add(DhcpOption.create(dhcpOptionSet, item.getKey(), item.values()));
                    }
                    return VpcManager.this.dhcpOptionSets.save(dhcpOptionSet);
                }
                catch (Exception ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        };
        reply.setDhcpOptions(this.allocate(allocator, DhcpOptionSet.class, DhcpOptionsType.class));
        return reply;
    }

    public CreateInternetGatewayResponseType createInternetGateway(CreateInternetGatewayType request) throws EucalyptusCloudException {
        CreateInternetGatewayResponseType reply = (CreateInternetGatewayResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        Supplier<InternetGateway> allocator = new Supplier<InternetGateway>(){

            public InternetGateway get() {
                try {
                    return VpcManager.this.internetGateways.save(InternetGateway.create((OwnerFullName)ctx.getUserFullName(), Identifier.igw.generate()));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        reply.setInternetGateway(this.allocate(allocator, InternetGateway.class, InternetGatewayType.class));
        return reply;
    }

    public CreateNetworkAclResponseType createNetworkAcl(final CreateNetworkAclType request) throws EucalyptusCloudException {
        CreateNetworkAclResponseType reply = (CreateNetworkAclResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        final String vpcId = Identifier.vpc.normalize(request.getVpcId());
        Supplier<NetworkAcl> allocator = new Supplier<NetworkAcl>(){

            public NetworkAcl get() {
                try {
                    Vpc vpc = (Vpc)((Object)VpcManager.this.vpcs.lookupByName((OwnerFullName)ctx.getUserFullName().asAccountFullName(), vpcId, Functions.identity()));
                    long networkAclsForVpc = VpcManager.this.networkAcls.countByExample(NetworkAcl.exampleWithOwner((OwnerFullName)ctx.getUserFullName().asAccountFullName()), (Criterion)Restrictions.eq((String)"vpc.displayName", (Object)vpcId), Collections.singletonMap("vpc", "vpc"));
                    if (networkAclsForVpc >= (long)VpcConfiguration.getNetworkAclsPerVpc()) {
                        throw new ClientComputeException("NetworkAclLimitExceeded", "Network ACL limit exceeded for " + vpc.getDisplayName());
                    }
                    return VpcManager.this.networkAcls.save(NetworkAcl.create((OwnerFullName)ctx.getUserFullName(), vpc, Identifier.acl.generate(), false));
                }
                catch (VpcMetadataNotFoundException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidVpcID.NotFound", "Vpc not found '" + request.getVpcId() + "'")));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        reply.setNetworkAcl(this.allocate(allocator, NetworkAcl.class, NetworkAclType.class));
        return reply;
    }

    public CreateNetworkAclEntryResponseType createNetworkAclEntry(final CreateNetworkAclEntryType request) throws EucalyptusCloudException {
        CreateNetworkAclEntryResponseType reply = (CreateNetworkAclEntryResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String networkAclId = Identifier.acl.normalize(request.getNetworkAclId());
        final String cidr = request.getCidrBlock();
        Optional cidrOptional = (Optional)Cidr.parse().apply((Object)cidr);
        if (!cidrOptional.isPresent()) {
            throw new ClientComputeException("InvalidParameterValue", "Cidr invalid: " + cidr);
        }
        final Optional<Integer> protocolOptional = VpcManager.protocolNumber(request.getProtocol());
        if (!protocolOptional.isPresent()) {
            throw new ClientComputeException("InvalidParameterValue", "Protocol invalid: " + request.getProtocol());
        }
        if (!Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(32766)).apply((Comparable)request.getRuleNumber())) {
            throw new ClientComputeException("InvalidParameterValue", "Rule number invalid: " + request.getRuleNumber());
        }
        Supplier<NetworkAclEntry> allocator = this.transactional(new Supplier<NetworkAclEntry>(){

            public NetworkAclEntry get() {
                try {
                    VpcManager.this.networkAcls.updateByExample(NetworkAcl.exampleWithName((OwnerFullName)accountFullName, networkAclId), (OwnerFullName)accountFullName, request.getNetworkAclId(), new Callback<NetworkAcl>(){

                        public void fire(NetworkAcl networkAcl) {
                            if (RestrictedTypes.filterPrivileged().apply((Object)networkAcl)) {
                                try {
                                    NetworkAclEntry entry;
                                    List<NetworkAclEntry> entries = networkAcl.getEntries();
                                    Optional existingEntry = Iterables.tryFind(entries, (Predicate)VpcManager.entryPredicate(request.getEgress(), request.getRuleNumber()));
                                    if (existingEntry.isPresent()) {
                                        throw new ClientComputeException("NetworkAclEntryAlreadyExists", "Entry exists with rule number: " + request.getRuleNumber());
                                    }
                                    if ((Integer)CollectionUtils.reduce(entries, (Object)0, (Function)CollectionUtils.count((Predicate)VpcManager.entryPredicate(request.getEgress(), null))) >= VpcConfiguration.getRulesPerNetworkAcl()) {
                                        throw new ClientComputeException("NetworkAclEntryLimitExceeded", "Network ACL entry limit exceeded for " + request.getNetworkAclId());
                                    }
                                    switch ((Integer)protocolOptional.get()) {
                                        case 1: {
                                            entry = NetworkAclEntry.createIcmpEntry(networkAcl, request.getRuleNumber(), (NetworkAclEntry.RuleAction)((Object)Enums.valueOfFunction(NetworkAclEntry.RuleAction.class).apply((Object)request.getRuleAction())), request.getEgress(), cidr, request.getIcmpTypeCode().getCode(), request.getIcmpTypeCode().getType());
                                            break;
                                        }
                                        case 6: 
                                        case 17: {
                                            entry = NetworkAclEntry.createTcpUdpEntry(networkAcl, request.getRuleNumber(), (Integer)protocolOptional.get(), (NetworkAclEntry.RuleAction)((Object)Enums.valueOfFunction(NetworkAclEntry.RuleAction.class).apply((Object)request.getRuleAction())), request.getEgress(), cidr, request.getPortRange().getFrom(), request.getPortRange().getTo());
                                            break;
                                        }
                                        default: {
                                            entry = NetworkAclEntry.createEntry(networkAcl, request.getRuleNumber(), (Integer)protocolOptional.get(), (NetworkAclEntry.RuleAction)((Object)Enums.valueOfFunction(NetworkAclEntry.RuleAction.class).apply((Object)request.getRuleAction())), request.getEgress(), cidr);
                                        }
                                    }
                                    entries.add(entry);
                                    networkAcl.updateTimeStamps();
                                }
                                catch (Exception e) {
                                    throw Exceptions.toUndeclared((Throwable)e);
                                }
                            } else {
                                throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to create network ACL entry")));
                            }
                        }
                    });
                    return null;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        try {
            allocator.get();
            this.invalidate(networkAclId);
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public CreateNetworkInterfaceResponseType createNetworkInterface(final CreateNetworkInterfaceType request) throws EucalyptusCloudException {
        CreateNetworkInterfaceResponseType reply = (CreateNetworkInterfaceResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String subnetId = Identifier.subnet.normalize(request.getSubnetId());
        final String privateIp = request.getPrivateIpAddress() != null ? request.getPrivateIpAddress() : (request.getPrivateIpAddressesSet() != null && !request.getPrivateIpAddressesSet().getItem().isEmpty() ? ((PrivateIpAddressesSetItemRequestType)request.getPrivateIpAddressesSet().getItem().get(0)).getPrivateIpAddress() : null);
        Supplier<NetworkInterface> allocator = new Supplier<NetworkInterface>(){

            public NetworkInterface get() {
                try {
                    HashSet groups;
                    Subnet subnet = (Subnet)((Object)VpcManager.this.subnets.lookupByName((OwnerFullName)accountFullName, subnetId, Functions.identity()));
                    Vpc vpc = subnet.getVpc();
                    HashSet hashSet = groups = request.getGroupSet() == null ? Sets.newHashSet((Object[])new NetworkGroup[]{(NetworkGroup)((Object)VpcManager.this.securityGroups.lookupDefault(vpc.getDisplayName(), Functions.identity()))}) : Sets.newHashSet((Iterable)Iterables.transform((Iterable)request.getGroupSet().groupIds(), (Function)RestrictedTypes.resolver(NetworkGroup.class)));
                    if (groups.size() > VpcConfiguration.getSecurityGroupsPerNetworkInterface()) {
                        throw new ClientComputeException("SecurityGroupsPerInterfaceLimitExceeded", "Security group limit exceeded");
                    }
                    String identifier = Identifier.eni.generate();
                    if (privateIp != null) {
                        Cidr cidr = Cidr.parse((String)subnet.getCidr());
                        if (!cidr.contains(privateIp)) {
                            throw new ClientComputeException("InvalidParameterValue", "Address does not fall within the subnet's address range");
                        }
                        if (!Iterables.contains((Iterable)Iterables.skip((Iterable)IPRange.fromCidr(cidr), (int)3), (Object)PrivateAddresses.asInteger(privateIp))) {
                            throw new ClientComputeException("InvalidParameterValue", "Address is in subnet's reserved address range");
                        }
                    }
                    String mac = NetworkInterfaceHelper.mac(identifier);
                    String ip = NetworkInterfaceHelper.allocate(vpc.getDisplayName(), subnet.getDisplayName(), identifier, mac, privateIp);
                    return VpcManager.this.networkInterfaces.save(NetworkInterface.create((OwnerFullName)ctx.getUserFullName(), vpc, subnet, groups, identifier, mac, ip, vpc.getDnsHostnames() != false ? VmInstances.dnsName(ip, DomainNames.internalSubdomain()) : null, (String)com.google.common.base.Objects.firstNonNull((Object)request.getDescription(), (Object)"")));
                }
                catch (VpcMetadataNotFoundException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidSubnetID.NotFound", "Subnet not found '" + request.getSubnetId() + "'")));
                }
                catch (ResourceAllocationException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidParameterValue", ex.getMessage())));
                }
                catch (Exception ex) {
                    NoSuchMetadataException e = (NoSuchMetadataException)Exceptions.findCause((Throwable)ex, NoSuchMetadataException.class);
                    if (e != null) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidSecurityGroupID.NotFound", e.getMessage())));
                    }
                    throw new RuntimeException(ex);
                }
            }
        };
        reply.setNetworkInterface(this.allocate(allocator, NetworkInterface.class, NetworkInterfaceType.class));
        return reply;
    }

    public CreateRouteResponseType createRoute(final CreateRouteType request) throws EucalyptusCloudException {
        CreateRouteResponseType reply = (CreateRouteResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String gatewayId = Identifier.igw.normalize(request.getGatewayId());
        final String routeTableId = Identifier.rtb.normalize(request.getRouteTableId());
        final String destinationCidr = request.getDestinationCidrBlock();
        Optional destinationCidrOption = (Optional)Cidr.parse().apply((Object)destinationCidr);
        if (!destinationCidrOption.isPresent()) {
            throw new ClientComputeException("InvalidParameterValue", "Cidr invalid: " + destinationCidr);
        }
        Supplier<Route> allocator = this.transactional(new Supplier<Route>(){

            public Route get() {
                try {
                    final InternetGateway internetGateway = (InternetGateway)((Object)VpcManager.this.internetGateways.lookupByName((OwnerFullName)accountFullName, gatewayId, Functions.identity()));
                    VpcManager.this.routeTables.updateByExample(RouteTable.exampleWithName((OwnerFullName)accountFullName, routeTableId), (OwnerFullName)accountFullName, request.getRouteTableId(), new Callback<RouteTable>(){

                        public void fire(RouteTable routeTable) {
                            try {
                                if (RestrictedTypes.filterPrivileged().apply((Object)routeTable)) {
                                    Optional existingRoute = Iterables.tryFind(routeTable.getRoutes(), (Predicate)CollectionUtils.propertyPredicate((Object)destinationCidr, (Function)RouteTables.RouteFilterStringFunctions.DESTINATION_CIDR));
                                    if (existingRoute.isPresent()) {
                                        throw new ClientComputeException("RouteAlreadyExists", "Route exists for cidr: " + destinationCidr);
                                    }
                                    if (routeTable.getRoutes().size() >= VpcConfiguration.getRoutesPerTable()) {
                                        throw new ClientComputeException("RouteLimitExceeded", "Route limit exceeded for " + request.getRouteTableId());
                                    }
                                } else {
                                    throw new ClientUnauthorizedComputeException("Not authorized to create route");
                                }
                                routeTable.getRoutes().add(Route.create(routeTable, Route.RouteOrigin.CreateRoute, destinationCidr, internetGateway));
                                routeTable.updateTimeStamps();
                            }
                            catch (Exception e) {
                                throw Exceptions.toUndeclared((Throwable)e);
                            }
                        }
                    });
                    return null;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        try {
            allocator.get();
            this.invalidate(routeTableId);
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public CreateRouteTableResponseType createRouteTable(final CreateRouteTableType request) throws EucalyptusCloudException {
        CreateRouteTableResponseType reply = (CreateRouteTableResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        final String vpcId = Identifier.vpc.normalize(request.getVpcId());
        Supplier<RouteTable> allocator = new Supplier<RouteTable>(){

            public RouteTable get() {
                try {
                    Vpc vpc = (Vpc)((Object)VpcManager.this.vpcs.lookupByName((OwnerFullName)ctx.getUserFullName().asAccountFullName(), vpcId, Functions.identity()));
                    long routeTablesForVpc = VpcManager.this.routeTables.countByExample(RouteTable.exampleWithOwner((OwnerFullName)ctx.getUserFullName().asAccountFullName()), (Criterion)Restrictions.eq((String)"vpc.displayName", (Object)vpcId), Collections.singletonMap("vpc", "vpc"));
                    if (routeTablesForVpc >= (long)VpcConfiguration.getRouteTablesPerVpc()) {
                        throw new ClientComputeException(" RouteTableLimitExceeded", "Route table limit exceeded for " + vpc.getDisplayName());
                    }
                    return VpcManager.this.routeTables.save(RouteTable.create((OwnerFullName)ctx.getUserFullName(), vpc, Identifier.rtb.generate(), vpc.getCidr(), false));
                }
                catch (VpcMetadataNotFoundException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidVpcID.NotFound", "Vpc not found '" + request.getVpcId() + "'")));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        reply.setRouteTable(this.allocate(allocator, RouteTable.class, RouteTableType.class));
        return reply;
    }

    public CreateSubnetResponseType createSubnet(final CreateSubnetType request) throws EucalyptusCloudException {
        CreateSubnetResponseType reply = (CreateSubnetResponseType)request.getReply();
        final Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String vpcId = Identifier.vpc.normalize(request.getVpcId());
        final Optional availabilityZone = Iterables.tryFind((Iterable)Clusters.getInstance().listValues(), (Predicate)Predicates.and((Predicate)(request.getAvailabilityZone() == null ? Predicates.alwaysTrue() : CollectionUtils.propertyPredicate((Object)request.getAvailabilityZone(), (Function)CloudMetadatas.toDisplayName())), (Predicate)RestrictedTypes.filterPrivilegedWithoutOwner())).transform(CloudMetadatas.toDisplayName());
        final Optional subnetCidr = (Optional)Cidr.parse().apply((Object)request.getCidrBlock());
        if (!subnetCidr.isPresent()) {
            throw new ClientComputeException("InvalidParameterValue", "Cidr invalid: " + request.getCidrBlock());
        }
        if (!availabilityZone.isPresent()) {
            throw new ClientComputeException("InvalidParameterValue", "Availability zone invalid: " + request.getAvailabilityZone());
        }
        Supplier<Subnet> allocator = new Supplier<Subnet>(){

            public Subnet get() {
                try {
                    Vpc vpc = (Vpc)((Object)VpcManager.this.vpcs.lookupByName((OwnerFullName)accountFullName, vpcId, Functions.identity()));
                    List subnetsInVpc = VpcManager.this.subnets.listByExample(Subnet.exampleWithOwner((OwnerFullName)accountFullName), (Predicate<? super Subnet>)CollectionUtils.propertyPredicate((Object)vpc.getDisplayName(), (Function)Subnets.FilterStringFunctions.VPC_ID), Functions.identity());
                    if (Iterables.size(subnetsInVpc) >= VpcConfiguration.getSubnetsPerVpc()) {
                        throw new ClientComputeException("SubnetLimitExceeded", "Subnet limit exceeded for " + vpc.getDisplayName());
                    }
                    if (!Cidr.parse((String)vpc.getCidr()).contains((Cidr)subnetCidr.get())) {
                        throw new ClientComputeException("InvalidParameterValue", "Cidr not valid for vpc " + request.getCidrBlock());
                    }
                    Iterable existingCidrs = Iterables.transform(subnetsInVpc, (Function)Functions.compose((Function)Cidr.parseUnsafe(), (Function)Subnets.FilterStringFunctions.CIDR));
                    if (Iterables.any((Iterable)existingCidrs, (Predicate)((Cidr)subnetCidr.get()).contains()) || Iterables.any((Iterable)existingCidrs, (Predicate)((Cidr)subnetCidr.get()).containedBy())) {
                        throw new ClientComputeException("InvalidSubnet.Conflict", "Cidr conflict for " + request.getCidrBlock());
                    }
                    NetworkAcl networkAcl = (NetworkAcl)((Object)VpcManager.this.networkAcls.lookupDefault(vpc.getDisplayName(), Functions.identity()));
                    return VpcManager.this.subnets.save(Subnet.create((OwnerFullName)ctx.getUserFullName(), vpc, networkAcl, Identifier.subnet.generate(), request.getCidrBlock(), (String)availabilityZone.get()));
                }
                catch (VpcMetadataNotFoundException ex) {
                    throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidVpcID.NotFound", "Vpc not found '" + request.getVpcId() + "'")));
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        reply.setSubnet(this.allocate(allocator, Subnet.class, SubnetType.class));
        this.invalidate(reply.getSubnet().getSubnetId());
        return reply;
    }

    public CreateVpcResponseType createVpc(final CreateVpcType request) throws EucalyptusCloudException {
        boolean createDefault;
        CreateVpcResponseType reply = (CreateVpcResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final UserFullName userFullName = ctx.getUserFullName();
        boolean bl = createDefault = ctx.isAdministrator() && request.getCidrBlock().matches("[0-9]{12}");
        if (!((Boolean)((Optional)Cidr.parse().apply((Object)request.getCidrBlock())).transform((Function)Cidr.prefix()).transform(Functions.forPredicate((Predicate)Range.closed((Comparable)Integer.valueOf(16), (Comparable)Integer.valueOf(28)))).or((Object)createDefault)).booleanValue()) {
            throw new ClientComputeException("InvalidVpcRange", "Cidr range invalid: " + request.getCidrBlock());
        }
        Supplier<Vpc> allocator = new Supplier<Vpc>(){

            public Vpc get() {
                try {
                    UserFullName vpcOwnerFullName;
                    AccountFullName vpcAccountFullName;
                    String vpcCidr;
                    Vpc vpc = null;
                    RouteTable routeTable = null;
                    NetworkAcl networkAcl = null;
                    if (createDefault) {
                        Account account = Accounts.lookupAccountById((String)request.getCidrBlock());
                        vpcCidr = "172.31.0.0/16";
                        vpcAccountFullName = AccountFullName.getInstance((Account)account, (String[])new String[0]);
                        vpcOwnerFullName = UserFullName.getInstance((User)account.lookupAdmin(), (String[])new String[0]);
                        try {
                            vpc = (Vpc)((Object)VpcManager.this.vpcs.lookupDefault((OwnerFullName)vpcAccountFullName, Functions.identity()));
                            routeTable = (RouteTable)((Object)VpcManager.this.routeTables.lookupMain(vpc.getDisplayName(), Functions.identity()));
                            networkAcl = (NetworkAcl)((Object)VpcManager.this.networkAcls.lookupDefault(vpc.getDisplayName(), Functions.identity()));
                        }
                        catch (VpcMetadataNotFoundException vpcMetadataNotFoundException) {}
                    } else {
                        vpcCidr = request.getCidrBlock();
                        vpcAccountFullName = userFullName.asAccountFullName();
                        vpcOwnerFullName = userFullName;
                    }
                    if (vpc == null) {
                        DhcpOptionSet options;
                        try {
                            options = (DhcpOptionSet)((Object)VpcManager.this.dhcpOptionSets.lookupByExample(DhcpOptionSet.exampleDefault((OwnerFullName)vpcAccountFullName), (OwnerFullName)vpcAccountFullName, "default", (Predicate<? super DhcpOptionSet>)Predicates.alwaysTrue(), Functions.identity()));
                        }
                        catch (VpcMetadataNotFoundException e) {
                            options = VpcManager.this.dhcpOptionSets.save(DhcpOptionSet.createDefault((OwnerFullName)vpcOwnerFullName, Identifier.dopt.generate()));
                        }
                        vpc = VpcManager.this.vpcs.save(Vpc.create((OwnerFullName)vpcOwnerFullName, Identifier.vpc.generate(), options, vpcCidr, createDefault));
                        routeTable = VpcManager.this.routeTables.save(RouteTable.create((OwnerFullName)vpcOwnerFullName, vpc, Identifier.rtb.generate(), vpc.getCidr(), true));
                        networkAcl = VpcManager.this.networkAcls.save(NetworkAcl.create((OwnerFullName)vpcOwnerFullName, vpc, Identifier.acl.generate(), true));
                        NetworkGroup group = NetworkGroup.create((OwnerFullName)vpcOwnerFullName, vpc, ResourceIdentifiers.generateString("sg"), NetworkGroups.defaultNetworkName(), "default VPC security group");
                        ArrayList peers = Lists.newArrayList((Object[])new NetworkPeer[]{NetworkPeer.create(group.getOwnerAccountNumber(), group.getName(), group.getGroupId())});
                        group.getNetworkRules().addAll(Lists.newArrayList((Object[])new NetworkRule[]{NetworkRule.create(null, -1, null, null, (Collection<NetworkPeer>)peers, null), NetworkRule.createEgress(null, -1, null, null, null, Collections.singleton("0.0.0.0/0"))}));
                        VpcManager.this.securityGroups.save(group);
                    }
                    if (createDefault && routeTable != null && networkAcl != null) {
                        InternetGateway internetGateway;
                        try {
                            internetGateway = (InternetGateway)((Object)VpcManager.this.internetGateways.lookupByVpc((OwnerFullName)vpcAccountFullName, vpc.getDisplayName(), Functions.identity()));
                        }
                        catch (VpcMetadataNotFoundException e) {
                            internetGateway = VpcManager.this.internetGateways.save(InternetGateway.create((OwnerFullName)vpcOwnerFullName, Identifier.igw.generate()));
                            internetGateway.setVpc(vpc);
                        }
                        Optional defaultRoute = Iterables.tryFind(routeTable.getRoutes(), (Predicate)CollectionUtils.propertyPredicate((Object)"0.0.0.0/0", (Function)RouteTables.RouteFilterStringFunctions.DESTINATION_CIDR));
                        if (!defaultRoute.isPresent()) {
                            routeTable.getRoutes().add(Route.create(routeTable, Route.RouteOrigin.CreateRouteTable, "0.0.0.0/0", internetGateway));
                            routeTable.updateTimeStamps();
                        }
                        HashSet cidrsInUse = Sets.newHashSet();
                        TreeSet zonesWithoutSubnets = Sets.newTreeSet();
                        for (String zone : Iterables.transform((Iterable)Clusters.getInstance().listValues(), (Function)CloudMetadatas.toDisplayName())) {
                            try {
                                cidrsInUse.add(VpcManager.this.subnets.lookupDefault((OwnerFullName)vpcAccountFullName, zone, Subnets.FilterStringFunctions.CIDR));
                            }
                            catch (VpcMetadataNotFoundException e) {
                                zonesWithoutSubnets.add(zone);
                            }
                        }
                        ArrayList subnetCidrs = Lists.newArrayList((Iterable)Iterables.transform((Iterable)((Cidr)Cidr.parseUnsafe().apply((Object)"172.31.0.0/16")).split(16), (Function)Functions.toStringFunction()));
                        subnetCidrs.removeAll(cidrsInUse);
                        for (String zone : zonesWithoutSubnets) {
                            Subnet subnet = VpcManager.this.subnets.save(Subnet.create((OwnerFullName)vpcOwnerFullName, vpc, networkAcl, Identifier.subnet.generate(), (String)subnetCidrs.remove(0), zone));
                            subnet.setDefaultForAz(true);
                            subnet.setMapPublicIpOnLaunch(true);
                        }
                    }
                    return vpc;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        };
        reply.setVpc(this.allocate(allocator, Vpc.class, VpcType.class));
        this.invalidate(reply.getVpc().getVpcId());
        return reply;
    }

    public CreateVpcPeeringConnectionResponseType createVpcPeeringConnection(CreateVpcPeeringConnectionType request) throws EucalyptusCloudException {
        CreateVpcPeeringConnectionResponseType reply = (CreateVpcPeeringConnectionResponseType)request.getReply();
        return reply;
    }

    public CreateVpnConnectionResponseType createVpnConnection(CreateVpnConnectionType request) throws EucalyptusCloudException {
        CreateVpnConnectionResponseType reply = (CreateVpnConnectionResponseType)request.getReply();
        return reply;
    }

    public CreateVpnConnectionRouteResponseType createVpnConnectionRoute(CreateVpnConnectionRouteType request) throws EucalyptusCloudException {
        CreateVpnConnectionRouteResponseType reply = (CreateVpnConnectionRouteResponseType)request.getReply();
        return reply;
    }

    public CreateVpnGatewayResponseType createVpnGateway(CreateVpnGatewayType request) throws EucalyptusCloudException {
        CreateVpnGatewayResponseType reply = (CreateVpnGatewayResponseType)request.getReply();
        return reply;
    }

    public DeleteCustomerGatewayResponseType deleteCustomerGateway(DeleteCustomerGatewayType request) throws EucalyptusCloudException {
        DeleteCustomerGatewayResponseType reply = (DeleteCustomerGatewayResponseType)request.getReply();
        return reply;
    }

    public DeleteDhcpOptionsResponseType deleteDhcpOptions(DeleteDhcpOptionsType request) throws EucalyptusCloudException {
        DeleteDhcpOptionsResponseType reply = (DeleteDhcpOptionsResponseType)request.getReply();
        this.delete(Identifier.dopt, request.getDhcpOptionsId(), new Function<Pair<Optional<AccountFullName>, String>, DhcpOptionSet>(){

            public DhcpOptionSet apply(Pair<Optional<AccountFullName>, String> accountAndId) {
                try {
                    DhcpOptionSet dhcpOptionSet = (DhcpOptionSet)((Object)VpcManager.this.dhcpOptionSets.lookupByName((OwnerFullName)((Optional)accountAndId.getLeft()).orNull(), (String)accountAndId.getRight(), Functions.identity()));
                    if (!RestrictedTypes.filterPrivileged().apply((Object)dhcpOptionSet)) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to delete DHCP options")));
                    }
                    VpcManager.this.dhcpOptionSets.delete(dhcpOptionSet);
                    return null;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        return reply;
    }

    public DeleteInternetGatewayResponseType deleteInternetGateway(DeleteInternetGatewayType request) throws EucalyptusCloudException {
        DeleteInternetGatewayResponseType reply = (DeleteInternetGatewayResponseType)request.getReply();
        this.delete(Identifier.igw, request.getInternetGatewayId(), new Function<Pair<Optional<AccountFullName>, String>, InternetGateway>(){

            public InternetGateway apply(Pair<Optional<AccountFullName>, String> accountAndId) {
                try {
                    InternetGateway internetGateway = (InternetGateway)((Object)VpcManager.this.internetGateways.lookupByName((OwnerFullName)((Optional)accountAndId.getLeft()).orNull(), (String)accountAndId.getRight(), Functions.identity()));
                    if (!RestrictedTypes.filterPrivileged().apply((Object)internetGateway)) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to delete internet gateway")));
                    }
                    VpcManager.this.internetGateways.delete(internetGateway);
                }
                catch (VpcMetadataNotFoundException internetGateway) {
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
                return null;
            }
        });
        return reply;
    }

    public DeleteNetworkAclResponseType deleteNetworkAcl(DeleteNetworkAclType request) throws EucalyptusCloudException {
        DeleteNetworkAclResponseType reply = (DeleteNetworkAclResponseType)request.getReply();
        this.delete(Identifier.acl, request.getNetworkAclId(), new Function<Pair<Optional<AccountFullName>, String>, NetworkAcl>(){

            public NetworkAcl apply(Pair<Optional<AccountFullName>, String> accountAndId) {
                try {
                    NetworkAcl networkAcl = (NetworkAcl)((Object)VpcManager.this.networkAcls.lookupByName((OwnerFullName)((Optional)accountAndId.getLeft()).orNull(), (String)accountAndId.getRight(), Functions.identity()));
                    if (RestrictedTypes.filterPrivileged().apply((Object)networkAcl)) {
                        if (networkAcl.getDefaultForVpc().booleanValue()) {
                            throw new ClientComputeException("InvalidParameterValue", "Cannot delete default network ACL " + (String)accountAndId.getRight());
                        }
                    } else {
                        throw new ClientUnauthorizedComputeException("Not authorized to delete network ACL");
                    }
                    VpcManager.this.networkAcls.delete(networkAcl);
                    return null;
                }
                catch (Exception ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        });
        return reply;
    }

    public DeleteNetworkAclEntryResponseType deleteNetworkAclEntry(final DeleteNetworkAclEntryType request) throws EucalyptusCloudException {
        DeleteNetworkAclEntryResponseType reply = (DeleteNetworkAclEntryResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.isAdministrator() ? null : ctx.getUserFullName().asAccountFullName();
        String networkAclId = Identifier.acl.normalize(request.getNetworkAclId());
        try {
            this.networkAcls.withRetries().updateByExample((AbstractPersistent)NetworkAcl.exampleWithName((OwnerFullName)accountFullName, networkAclId), (OwnerFullName)accountFullName, request.getNetworkAclId(), (Callback)new Callback<NetworkAcl>(){

                public void fire(NetworkAcl networkAcl) {
                    try {
                        Optional entry;
                        if (RestrictedTypes.filterPrivileged().apply((Object)networkAcl)) {
                            entry = Iterables.tryFind(networkAcl.getEntries(), (Predicate)VpcManager.entryPredicate(request.getEgress(), request.getRuleNumber()));
                            if (!entry.isPresent()) {
                                throw new ClientComputeException("InvalidNetworkAclEntry.NotFound", "Entry not found for number: " + request.getRuleNumber());
                            }
                        } else {
                            throw new ClientUnauthorizedComputeException("Not authorized to delete network ACL entry");
                        }
                        networkAcl.getEntries().remove(entry.get());
                        networkAcl.updateTimeStamps();
                    }
                    catch (Exception e) {
                        throw Exceptions.toUndeclared((Throwable)e);
                    }
                }
            });
            this.invalidate(networkAclId);
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public DeleteNetworkInterfaceResponseType deleteNetworkInterface(final DeleteNetworkInterfaceType request) throws EucalyptusCloudException {
        DeleteNetworkInterfaceResponseType reply = (DeleteNetworkInterfaceResponseType)request.getReply();
        this.delete(Identifier.eni, request.getNetworkInterfaceId(), new Function<Pair<Optional<AccountFullName>, String>, NetworkInterface>(){

            public NetworkInterface apply(Pair<Optional<AccountFullName>, String> accountAndId) {
                try {
                    NetworkInterface networkInterface = (NetworkInterface)((Object)VpcManager.this.networkInterfaces.lookupByName((OwnerFullName)((Optional)accountAndId.getLeft()).orNull(), (String)accountAndId.getRight(), Functions.identity()));
                    if (RestrictedTypes.filterPrivileged().apply((Object)networkInterface)) {
                        if (networkInterface.isAttached()) {
                            throw new ClientComputeException("InvalidNetworkInterface.InUse", "The network interface is in use '" + request.getNetworkInterfaceId() + "'");
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to delete network interface")));
                    }
                    NetworkInterfaceHelper.release(networkInterface);
                    VpcManager.this.networkInterfaces.delete(networkInterface);
                    return null;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        return reply;
    }

    public DeleteRouteResponseType deleteRoute(final DeleteRouteType request) throws EucalyptusCloudException {
        DeleteRouteResponseType reply = (DeleteRouteResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.isAdministrator() ? null : ctx.getUserFullName().asAccountFullName();
        String routeTableId = Identifier.rtb.normalize(request.getRouteTableId());
        try {
            this.routeTables.withRetries().updateByExample((AbstractPersistent)RouteTable.exampleWithName((OwnerFullName)accountFullName, routeTableId), (OwnerFullName)accountFullName, request.getRouteTableId(), (Callback)new Callback<RouteTable>(){

                public void fire(RouteTable routeTable) {
                    try {
                        Optional route;
                        if (RestrictedTypes.filterPrivileged().apply((Object)routeTable)) {
                            route = Iterables.tryFind(routeTable.getRoutes(), (Predicate)CollectionUtils.propertyPredicate((Object)request.getDestinationCidrBlock(), (Function)RouteTables.RouteFilterStringFunctions.DESTINATION_CIDR));
                            if (!route.isPresent()) {
                                throw new ClientComputeException("InvalidRoute.NotFound", "Route not found for cidr: " + request.getDestinationCidrBlock());
                            }
                        } else {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to delete route")));
                        }
                        routeTable.getRoutes().remove(route.get());
                        routeTable.updateTimeStamps();
                    }
                    catch (Exception e) {
                        throw Exceptions.toUndeclared((Throwable)e);
                    }
                }
            });
            this.invalidate(routeTableId);
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public DeleteRouteTableResponseType deleteRouteTable(DeleteRouteTableType request) throws EucalyptusCloudException {
        DeleteRouteTableResponseType reply = (DeleteRouteTableResponseType)request.getReply();
        this.delete(Identifier.rtb, request.getRouteTableId(), new Function<Pair<Optional<AccountFullName>, String>, RouteTable>(){

            public RouteTable apply(Pair<Optional<AccountFullName>, String> accountAndId) {
                try {
                    RouteTable routeTable = (RouteTable)((Object)VpcManager.this.routeTables.lookupByName((OwnerFullName)((Optional)accountAndId.getLeft()).orNull(), (String)accountAndId.getRight(), Functions.identity()));
                    if (RestrictedTypes.filterPrivileged().apply((Object)routeTable)) {
                        if (routeTable.getMain().booleanValue()) {
                            throw new ClientComputeException("InvalidParameterValue", "Cannot delete main route table " + (String)accountAndId.getRight());
                        }
                    } else {
                        throw new ClientUnauthorizedComputeException("Not authorized to delete route table");
                    }
                    VpcManager.this.routeTables.delete(routeTable);
                    return null;
                }
                catch (Exception ex) {
                    throw Exceptions.toUndeclared((Throwable)ex);
                }
            }
        });
        return reply;
    }

    public DeleteSubnetResponseType deleteSubnet(DeleteSubnetType request) throws EucalyptusCloudException {
        DeleteSubnetResponseType reply = (DeleteSubnetResponseType)request.getReply();
        this.delete(Identifier.subnet, request.getSubnetId(), new Function<Pair<Optional<AccountFullName>, String>, Subnet>(){

            public Subnet apply(Pair<Optional<AccountFullName>, String> accountAndId) {
                try {
                    Subnet subnet = (Subnet)((Object)VpcManager.this.subnets.lookupByName((OwnerFullName)((Optional)accountAndId.getLeft()).orNull(), (String)accountAndId.getRight(), Functions.identity()));
                    if (!RestrictedTypes.filterPrivileged().apply((Object)subnet)) {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to delete subnet")));
                    }
                    VpcManager.this.subnets.delete(subnet);
                    return null;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        return reply;
    }

    public DeleteVpcResponseType deleteVpc(DeleteVpcType request) throws EucalyptusCloudException {
        DeleteVpcResponseType reply = (DeleteVpcResponseType)request.getReply();
        this.delete(Identifier.vpc, request.getVpcId(), new Function<Pair<Optional<AccountFullName>, String>, Vpc>(){

            public Vpc apply(Pair<Optional<AccountFullName>, String> accountAndId) {
                try {
                    Vpc vpc = (Vpc)((Object)VpcManager.this.vpcs.lookupByName((OwnerFullName)((Optional)accountAndId.getLeft()).orNull(), (String)accountAndId.getRight(), Functions.identity()));
                    if (RestrictedTypes.filterPrivileged().apply((Object)vpc)) {
                        if (Boolean.TRUE.equals(vpc.getDefaultVpc()) && Contexts.lookup().isAdministrator()) {
                            List defaultSubnets = VpcManager.this.subnets.listByExample(Subnet.exampleDefault((OwnerFullName)AccountFullName.getInstance((String)vpc.getOwnerAccountNumber(), (String[])new String[0]), null), (Predicate<? super Subnet>)Predicates.alwaysTrue(), Functions.identity());
                            for (Subnet subnet : defaultSubnets) {
                                VpcManager.this.subnets.delete(subnet);
                            }
                            try {
                                InternetGateway internetGateway = (InternetGateway)((Object)VpcManager.this.internetGateways.lookupByVpc(null, vpc.getDisplayName(), Functions.identity()));
                                VpcManager.this.internetGateways.delete(internetGateway);
                            }
                            catch (VpcMetadataNotFoundException vpcMetadataNotFoundException) {
                                // empty catch block
                            }
                        }
                        try {
                            VpcManager.this.networkAcls.delete((CloudMetadata.NetworkAclMetadata)VpcManager.this.networkAcls.lookupDefault(vpc.getDisplayName(), Functions.identity()));
                        }
                        catch (VpcMetadataNotFoundException vpcMetadataNotFoundException) {
                            // empty catch block
                        }
                        try {
                            VpcManager.this.routeTables.delete((CloudMetadata.RouteTableMetadata)VpcManager.this.routeTables.lookupMain(vpc.getDisplayName(), Functions.identity()));
                        }
                        catch (VpcMetadataNotFoundException vpcMetadataNotFoundException) {
                            // empty catch block
                        }
                        try {
                            VpcManager.this.securityGroups.delete((NetworkGroup)((Object)VpcManager.this.securityGroups.lookupDefault(vpc.getDisplayName(), Functions.identity())));
                        }
                        catch (VpcMetadataNotFoundException vpcMetadataNotFoundException) {
                            // empty catch block
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to delete vpc")));
                    }
                    VpcManager.this.vpcs.delete(vpc);
                    return null;
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        });
        return reply;
    }

    public DeleteVpcPeeringConnectionResponseType deleteVpcPeeringConnection(DeleteVpcPeeringConnectionType request) throws EucalyptusCloudException {
        DeleteVpcPeeringConnectionResponseType reply = (DeleteVpcPeeringConnectionResponseType)request.getReply();
        return reply;
    }

    public DeleteVpnConnectionResponseType deleteVpnConnection(DeleteVpnConnectionType request) throws EucalyptusCloudException {
        DeleteVpnConnectionResponseType reply = (DeleteVpnConnectionResponseType)request.getReply();
        return reply;
    }

    public DeleteVpnConnectionRouteResponseType deleteVpnConnectionRoute(DeleteVpnConnectionRouteType request) throws EucalyptusCloudException {
        DeleteVpnConnectionRouteResponseType reply = (DeleteVpnConnectionRouteResponseType)request.getReply();
        return reply;
    }

    public DeleteVpnGatewayResponseType deleteVpnGateway(DeleteVpnGatewayType request) throws EucalyptusCloudException {
        DeleteVpnGatewayResponseType reply = (DeleteVpnGatewayResponseType)request.getReply();
        return reply;
    }

    public DescribeAccountAttributesResponseType describeAccountAttributes(DescribeAccountAttributesType request) throws EucalyptusCloudException {
        DescribeAccountAttributesResponseType reply = (DescribeAccountAttributesResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        ArrayList platforms = Lists.newArrayList();
        Set features = Networking.getInstance().describeFeatures();
        if (features.contains(NetworkingFeature.Classic)) {
            platforms.add("EC2");
        }
        if (features.contains(NetworkingFeature.Vpc)) {
            platforms.add("VPC");
        }
        String vpcId = "none";
        try {
            vpcId = (String)this.vpcs.lookupDefault((OwnerFullName)accountFullName, CloudMetadatas.toDisplayName());
        }
        catch (VpcMetadataNotFoundException vpcMetadataNotFoundException) {
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        ImmutableMap attributes = ImmutableMap.of((Object)"supported-platforms", (Object)platforms, (Object)"default-vpc", (Object)Lists.newArrayList((Object[])new String[]{vpcId}));
        HashSet requestedAttributes = Sets.newHashSet((Iterable)request.attributeNames());
        for (Map.Entry attributeEntry : attributes.entrySet()) {
            if (!requestedAttributes.isEmpty() && !requestedAttributes.contains(attributeEntry.getKey())) continue;
            reply.getAccountAttributeSet().getItem().add(new AccountAttributeSetItemType((String)attributeEntry.getKey(), (List)attributeEntry.getValue()));
        }
        return reply;
    }

    public DescribeCustomerGatewaysResponseType describeCustomerGateways(DescribeCustomerGatewaysType request) throws EucalyptusCloudException {
        DescribeCustomerGatewaysResponseType reply = (DescribeCustomerGatewaysResponseType)request.getReply();
        return reply;
    }

    public DescribeDhcpOptionsResponseType describeDhcpOptions(DescribeDhcpOptionsType request) throws EucalyptusCloudException {
        DescribeDhcpOptionsResponseType reply = (DescribeDhcpOptionsResponseType)request.getReply();
        VpcManager.describe(Identifier.dopt, request.dhcpOptionsIds(), request.getFilterSet(), DhcpOptionSet.class, DhcpOptionsType.class, reply.getDhcpOptionsSet().getItem(), DhcpOptionsType.id(), this.dhcpOptionSets);
        return reply;
    }

    public DescribeInternetGatewaysResponseType describeInternetGateways(DescribeInternetGatewaysType request) throws EucalyptusCloudException {
        DescribeInternetGatewaysResponseType reply = (DescribeInternetGatewaysResponseType)request.getReply();
        VpcManager.describe(Identifier.igw, request.internetGatewayIds(), request.getFilterSet(), InternetGateway.class, InternetGatewayType.class, reply.getInternetGatewaySet().getItem(), InternetGatewayType.id(), this.internetGateways);
        return reply;
    }

    public DescribeNetworkAclsResponseType describeNetworkAcls(DescribeNetworkAclsType request) throws EucalyptusCloudException {
        DescribeNetworkAclsResponseType reply = (DescribeNetworkAclsResponseType)request.getReply();
        VpcManager.describe(Identifier.acl, request.networkAclIds(), request.getFilterSet(), NetworkAcl.class, NetworkAclType.class, reply.getNetworkAclSet().getItem(), NetworkAclType.id(), this.networkAcls);
        return reply;
    }

    public DescribeNetworkInterfaceAttributeResponseType describeNetworkInterfaceAttribute(DescribeNetworkInterfaceAttributeType request) throws EucalyptusCloudException {
        DescribeNetworkInterfaceAttributeResponseType reply;
        block15: {
            reply = (DescribeNetworkInterfaceAttributeResponseType)request.getReply();
            Context ctx = Contexts.lookup();
            AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
            try {
                NetworkInterface networkInterface = this.networkInterfaces.lookupByName((OwnerFullName)accountFullName, Identifier.eni.normalize(request.getNetworkInterfaceId()), new Function<NetworkInterface, NetworkInterface>(){

                    public NetworkInterface apply(NetworkInterface networkInterface) {
                        Entities.initialize(networkInterface.getNetworkGroups());
                        return networkInterface;
                    }
                });
                if (!RestrictedTypes.filterPrivileged().apply((Object)networkInterface)) break block15;
                reply.setNetworkInterfaceId(networkInterface.getDisplayName());
                switch (request.getAttribute()) {
                    case "attachment": {
                        if (networkInterface.isAttached()) {
                            reply.setAttachment((NetworkInterfaceAttachmentType)TypeMappers.transform((Object)networkInterface.getAttachment(), NetworkInterfaceAttachmentType.class));
                        }
                        break;
                    }
                    case "description": {
                        reply.setDescription(new NullableAttributeValueType());
                        reply.getDescription().setValue(networkInterface.getDescription());
                        break;
                    }
                    case "groupSet": {
                        reply.setGroupSet(new GroupSetType(Collections2.transform(networkInterface.getNetworkGroups(), (Function)TypeMappers.lookup(NetworkGroup.class, GroupItemType.class))));
                        break;
                    }
                    case "sourceDestCheck": {
                        reply.setSourceDestCheck(new AttributeBooleanValueType());
                        reply.getSourceDestCheck().setValue(networkInterface.getSourceDestCheck());
                        break;
                    }
                    default: {
                        throw new ClientComputeException("InvalidParameterValue", "Value (" + request.getAttribute() + ") for parameter attribute is invalid. Unknown network interface attribute");
                    }
                }
            }
            catch (Exception e) {
                throw VpcManager.handleException(e);
            }
        }
        return reply;
    }

    public DescribeNetworkInterfacesResponseType describeNetworkInterfaces(DescribeNetworkInterfacesType request) throws EucalyptusCloudException {
        DescribeNetworkInterfacesResponseType reply = (DescribeNetworkInterfacesResponseType)request.getReply();
        VpcManager.describe(Identifier.eni, request.networkInterfaceIds(), request.getFilterSet(), NetworkInterface.class, NetworkInterfaceType.class, reply.getNetworkInterfaceSet().getItem(), NetworkInterfaceType.id(), this.networkInterfaces);
        return reply;
    }

    public DescribeRouteTablesResponseType describeRouteTables(DescribeRouteTablesType request) throws EucalyptusCloudException {
        DescribeRouteTablesResponseType reply = (DescribeRouteTablesResponseType)request.getReply();
        VpcManager.describe(Identifier.rtb, request.routeTableIds(), request.getFilterSet(), RouteTable.class, RouteTableType.class, reply.getRouteTableSet().getItem(), RouteTableType.id(), this.routeTables);
        return reply;
    }

    public DescribeSubnetsResponseType describeSubnets(DescribeSubnetsType request) throws EucalyptusCloudException {
        DescribeSubnetsResponseType reply = (DescribeSubnetsResponseType)request.getReply();
        VpcManager.describe(Identifier.subnet, request.subnetIds(), request.getFilterSet(), Subnet.class, SubnetType.class, reply.getSubnetSet().getItem(), SubnetType.id(), this.subnets);
        return reply;
    }

    public DescribeVpcAttributeResponseType describeVpcAttribute(DescribeVpcAttributeType request) throws EucalyptusCloudException {
        DescribeVpcAttributeResponseType reply = (DescribeVpcAttributeResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        try {
            Vpc vpc = (Vpc)((Object)this.vpcs.lookupByName((OwnerFullName)accountFullName, Identifier.vpc.normalize(request.getVpcId()), Functions.identity()));
            if (RestrictedTypes.filterPrivileged().apply((Object)vpc)) {
                reply.setVpcId(vpc.getDisplayName());
                switch (request.getAttribute()) {
                    case "enableDnsSupport": {
                        reply.setEnableDnsSupport(new AttributeBooleanValueType());
                        reply.getEnableDnsSupport().setValue(vpc.getDnsEnabled());
                        break;
                    }
                    case "enableDnsHostnames": {
                        reply.setEnableDnsHostnames(new AttributeBooleanValueType());
                        reply.getEnableDnsHostnames().setValue(vpc.getDnsHostnames());
                        break;
                    }
                    default: {
                        throw new ClientComputeException("InvalidParameterValue", "Value (" + request.getAttribute() + ") for parameter attribute is invalid. Unknown vpc attribute");
                    }
                }
            }
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public DescribeVpcPeeringConnectionsResponseType describeVpcPeeringConnections(DescribeVpcPeeringConnectionsType request) throws EucalyptusCloudException {
        DescribeVpcPeeringConnectionsResponseType reply = (DescribeVpcPeeringConnectionsResponseType)request.getReply();
        return reply;
    }

    public DescribeVpcsResponseType describeVpcs(DescribeVpcsType request) throws EucalyptusCloudException {
        DescribeVpcsResponseType reply = (DescribeVpcsResponseType)request.getReply();
        VpcManager.describe(Identifier.vpc, request.vpcIds(), request.getFilterSet(), Vpc.class, VpcType.class, reply.getVpcSet().getItem(), VpcType.id(), this.vpcs);
        return reply;
    }

    public DescribeVpnConnectionsResponseType describeVpnConnections(DescribeVpnConnectionsType request) throws EucalyptusCloudException {
        DescribeVpnConnectionsResponseType reply = (DescribeVpnConnectionsResponseType)request.getReply();
        return reply;
    }

    public DescribeVpnGatewaysResponseType describeVpnGateways(DescribeVpnGatewaysType request) throws EucalyptusCloudException {
        DescribeVpnGatewaysResponseType reply = (DescribeVpnGatewaysResponseType)request.getReply();
        return reply;
    }

    public DetachInternetGatewayResponseType detachInternetGateway(final DetachInternetGatewayType request) throws EucalyptusCloudException {
        DetachInternetGatewayResponseType reply = (DetachInternetGatewayResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String gatewayId = Identifier.igw.normalize(request.getInternetGatewayId());
        final String vpcId = Identifier.vpc.normalize(request.getVpcId());
        try {
            this.internetGateways.updateByExample(InternetGateway.exampleWithName((OwnerFullName)accountFullName, gatewayId), (OwnerFullName)accountFullName, request.getInternetGatewayId(), new Callback<InternetGateway>(){

                public void fire(InternetGateway internetGateway) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)internetGateway)) {
                        try {
                            Vpc vpc = (Vpc)((Object)VpcManager.this.vpcs.lookupByName((OwnerFullName)accountFullName, vpcId, Functions.identity()));
                            if (internetGateway.getVpc() == null || !vpc.getDisplayName().equals(internetGateway.getVpc().getDisplayName())) {
                                throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("Gateway.NotAttached", "resource " + gatewayId + " is not attached to network " + vpcId)));
                            }
                            internetGateway.setVpc(null);
                        }
                        catch (VpcMetadataNotFoundException e) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidVpcID.NotFound", "Vpc not found '" + request.getVpcId() + "'")));
                        }
                        catch (Exception e) {
                            throw Exceptions.toUndeclared((Throwable)e);
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to detach internet gateway")));
                    }
                }
            });
            this.invalidate(vpcId);
        }
        catch (VpcMetadataNotFoundException e) {
            throw new ClientComputeException("InvalidInternetGatewayID.NotFound", "Internet gateway (" + request.getInternetGatewayId() + ") not found ");
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public DetachNetworkInterfaceResponseType detachNetworkInterface(DetachNetworkInterfaceType request) throws EucalyptusCloudException {
        DetachNetworkInterfaceResponseType reply = (DetachNetworkInterfaceResponseType)request.getReply();
        return reply;
    }

    public DetachVpnGatewayResponseType detachVpnGateway(DetachVpnGatewayType request) throws EucalyptusCloudException {
        DetachVpnGatewayResponseType reply = (DetachVpnGatewayResponseType)request.getReply();
        return reply;
    }

    public DisableVgwRoutePropagationResponseType disableVgwRoutePropagation(DisableVgwRoutePropagationType request) throws EucalyptusCloudException {
        DisableVgwRoutePropagationResponseType reply = (DisableVgwRoutePropagationResponseType)request.getReply();
        return reply;
    }

    public DisassociateRouteTableResponseType disassociateRouteTable(final DisassociateRouteTableType request) throws EucalyptusCloudException {
        DisassociateRouteTableResponseType reply = (DisassociateRouteTableResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String associationId = Identifier.rtbassoc.normalize(request.getAssociationId());
        try {
            String subnetId = this.routeTables.updateByAssociationId(associationId, (OwnerFullName)accountFullName, new Function<RouteTable, String>(){

                public String apply(RouteTable routeTable) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)routeTable)) {
                        try {
                            RouteTableAssociation association = (RouteTableAssociation)((Object)Iterables.find(routeTable.getRouteTableAssociations(), (Predicate)CollectionUtils.propertyPredicate((Object)associationId, (Function)RouteTables.AssociationFilterStringFunctions.ASSOCIATION_ID)));
                            if (association.getMain().booleanValue()) {
                                throw new ClientComputeException("InvalidParameterValue", "Cannot disassociate the main route table association " + request.getAssociationId());
                            }
                            routeTable.disassociate(associationId);
                            return association.getSubnetId();
                        }
                        catch (Exception e) {
                            throw Exceptions.toUndeclared((Throwable)e);
                        }
                    }
                    return null;
                }
            });
            if (subnetId != null) {
                this.invalidate(subnetId);
            }
        }
        catch (VpcMetadataNotFoundException e) {
            throw new ClientComputeException("InvalidAssociationID.NotFound", "Route table association (" + request.getAssociationId() + ") not found ");
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public EnableVgwRoutePropagationResponseType enableVgwRoutePropagation(EnableVgwRoutePropagationType request) throws EucalyptusCloudException {
        EnableVgwRoutePropagationResponseType reply = (EnableVgwRoutePropagationResponseType)request.getReply();
        return reply;
    }

    public ModifyNetworkInterfaceAttributeResponseType modifyNetworkInterfaceAttribute(final ModifyNetworkInterfaceAttributeType request) throws EucalyptusCloudException {
        ModifyNetworkInterfaceAttributeResponseType reply = (ModifyNetworkInterfaceAttributeResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        String eniId = Identifier.eni.normalize(request.getNetworkInterfaceId());
        try {
            final AtomicBoolean invalidate = new AtomicBoolean(false);
            this.networkInterfaces.updateByExample(NetworkInterface.exampleWithName((OwnerFullName)accountFullName, eniId), (OwnerFullName)accountFullName, request.getNetworkInterfaceId(), new Callback<NetworkInterface>(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public void fire(NetworkInterface networkInterface) {
                    if (!RestrictedTypes.filterPrivileged().apply((Object)networkInterface)) throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to modify network interface attribute")));
                    if (request.getAttachment() != null) {
                        if (!networkInterface.isAttached() || !networkInterface.getAttachment().getAttachmentId().equals(request.getAttachment().getAttachmentId())) return;
                        networkInterface.getAttachment().setDeleteOnTerminate(request.getAttachment().getDeleteOnTermination());
                        return;
                    } else if (request.getDescription() != null) {
                        networkInterface.setDescription(request.getDescription().getValue());
                        return;
                    } else if (request.getGroupSet() != null && !request.getGroupSet().getItem().isEmpty()) {
                        try {
                            networkInterface.setNetworkGroups(Sets.newHashSet((Iterable)Iterables.transform((Iterable)request.getGroupSet().groupIds(), (Function)RestrictedTypes.resolver(NetworkGroup.class))));
                            if (networkInterface.getNetworkGroups().size() > VpcConfiguration.getSecurityGroupsPerNetworkInterface()) {
                                throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("SecurityGroupsPerInterfaceLimitExceeded", "Security group limit exceeded")));
                            }
                            if (networkInterface.isAttached() && networkInterface.getAttachment().getDeviceIndex() == 0) {
                                Set<NetworkGroup> instanceGroups = networkInterface.getAttachment().getInstance().getNetworkGroups();
                                instanceGroups.clear();
                                instanceGroups.addAll(networkInterface.getNetworkGroups());
                            }
                            invalidate.set(true);
                            return;
                        }
                        catch (RuntimeException e) {
                            NoSuchMetadataException nsme = (NoSuchMetadataException)Exceptions.findCause((Throwable)e, NoSuchMetadataException.class);
                            if (nsme == null) throw e;
                            throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidSecurityGroupID.NotFound", nsme.getMessage())));
                        }
                    } else {
                        if (request.getSourceDestCheck() == null) throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("MissingParameter", "Missing attribute value")));
                        networkInterface.setSourceDestCheck(request.getSourceDestCheck().getValue());
                        invalidate.set(true);
                    }
                }
            });
            if (invalidate.get()) {
                this.invalidate(eniId);
            }
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public ModifySubnetAttributeResponseType modifySubnetAttribute(final ModifySubnetAttributeType request) throws EucalyptusCloudException {
        ModifySubnetAttributeResponseType reply = (ModifySubnetAttributeResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        try {
            this.subnets.updateByExample(Subnet.exampleWithName((OwnerFullName)(ctx.isAdministrator() ? null : accountFullName), Identifier.subnet.normalize(request.getSubnetId())), (OwnerFullName)accountFullName, request.getSubnetId(), new Callback<Subnet>(){

                public void fire(Subnet subnet) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)subnet)) {
                        AttributeBooleanValueType value = request.getMapPublicIpOnLaunch();
                        if (value != null && value.getValue() != null) {
                            subnet.setMapPublicIpOnLaunch(value.getValue());
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to modify subnet attribute")));
                    }
                }
            });
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public ModifyVpcAttributeResponseType modifyVpcAttribute(final ModifyVpcAttributeType request) throws EucalyptusCloudException {
        ModifyVpcAttributeResponseType reply = (ModifyVpcAttributeResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        try {
            this.vpcs.updateByExample(Vpc.exampleWithName((OwnerFullName)(ctx.isAdministrator() ? null : accountFullName), Identifier.vpc.normalize(request.getVpcId())), (OwnerFullName)accountFullName, request.getVpcId(), new Callback<Vpc>(){

                public void fire(Vpc vpc) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)vpc)) {
                        AttributeBooleanValueType dnsSupport;
                        AttributeBooleanValueType dnsHostnames = request.getEnableDnsHostnames();
                        if (dnsHostnames != null && dnsHostnames.getValue() != null) {
                            vpc.setDnsHostnames(dnsHostnames.getValue());
                        }
                        if ((dnsSupport = request.getEnableDnsSupport()) != null && dnsSupport.getValue() != null) {
                            vpc.setDnsEnabled(dnsSupport.getValue());
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to modify VPC attribute")));
                    }
                }
            });
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public RejectVpcPeeringConnectionResponseType rejectVpcPeeringConnection(RejectVpcPeeringConnectionType request) throws EucalyptusCloudException {
        RejectVpcPeeringConnectionResponseType reply = (RejectVpcPeeringConnectionResponseType)request.getReply();
        return reply;
    }

    public ReplaceNetworkAclAssociationResponseType replaceNetworkAclAssociation(final ReplaceNetworkAclAssociationType request) throws EucalyptusCloudException {
        ReplaceNetworkAclAssociationResponseType reply = (ReplaceNetworkAclAssociationResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String networkAclId = Identifier.acl.normalize(request.getNetworkAclId());
        String associationId = Identifier.aclassoc.normalize(request.getAssociationId());
        try {
            Subnet subnet = this.subnets.updateByExample(Subnet.exampleWithNetworkAclAssociation((OwnerFullName)accountFullName, associationId), (OwnerFullName)accountFullName, request.getAssociationId(), new Callback<Subnet>(){

                public void fire(Subnet subnet) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)subnet)) {
                        try {
                            NetworkAcl networkAcl = (NetworkAcl)((Object)VpcManager.this.networkAcls.lookupByName((OwnerFullName)accountFullName, networkAclId, Functions.identity()));
                            if (!subnet.getVpc().getDisplayName().equals(networkAcl.getVpc().getDisplayName())) {
                                throw new ClientComputeException("InvalidParameterValue", "Network ACL " + networkAclId + " and subnet " + subnet.getDisplayName() + " belong to different networks");
                            }
                            subnet.setNetworkAcl(networkAcl);
                            subnet.setNetworkAclAssociationId(Identifier.aclassoc.generate());
                        }
                        catch (VpcMetadataNotFoundException e) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidNetworkAclID.NotFound", "Network ACL not found '" + request.getAssociationId() + "'")));
                        }
                        catch (Exception e) {
                            throw Exceptions.toUndeclared((Throwable)e);
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to replace network ACL association")));
                    }
                }
            });
            this.invalidate(networkAclId);
            reply.setNewAssociationId(subnet.getNetworkAclAssociationId());
        }
        catch (VpcMetadataNotFoundException e) {
            throw new ClientComputeException("InvalidAssociationID.NotFound", "Network ACL association (" + request.getAssociationId() + ") not found ");
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public ReplaceNetworkAclEntryResponseType replaceNetworkAclEntry(final ReplaceNetworkAclEntryType request) throws EucalyptusCloudException {
        ReplaceNetworkAclEntryResponseType reply = (ReplaceNetworkAclEntryResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        String networkAclId = Identifier.acl.normalize(request.getNetworkAclId());
        final String cidr = request.getCidrBlock();
        Optional cidrOptional = (Optional)Cidr.parse().apply((Object)cidr);
        if (!cidrOptional.isPresent()) {
            throw new ClientComputeException("InvalidParameterValue", "Cidr invalid: " + cidr);
        }
        final Optional<Integer> protocolOptional = VpcManager.protocolNumber(request.getProtocol());
        if (!protocolOptional.isPresent()) {
            throw new ClientComputeException("InvalidParameterValue", "Protocol invalid: " + request.getProtocol());
        }
        if (!Range.closed((Comparable)Integer.valueOf(1), (Comparable)Integer.valueOf(32766)).apply((Comparable)request.getRuleNumber())) {
            throw new ClientComputeException("InvalidParameterValue", "Rule number invalid: " + request.getRuleNumber());
        }
        try {
            this.networkAcls.updateByExample(NetworkAcl.exampleWithName((OwnerFullName)accountFullName, networkAclId), (OwnerFullName)accountFullName, request.getNetworkAclId(), new Callback<NetworkAcl>(){

                public void fire(NetworkAcl networkAcl) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)networkAcl)) {
                        try {
                            NetworkAclEntry entry;
                            List<NetworkAclEntry> entries = networkAcl.getEntries();
                            Optional oldEntry = Iterables.tryFind(entries, (Predicate)VpcManager.entryPredicate(request.getEgress(), request.getRuleNumber()));
                            if (!oldEntry.isPresent()) {
                                throw new ClientComputeException("InvalidNetworkAclEntry.NotFound", "Entry not found for rule number: " + request.getRuleNumber());
                            }
                            switch ((Integer)protocolOptional.get()) {
                                case 1: {
                                    entry = NetworkAclEntry.createIcmpEntry(networkAcl, request.getRuleNumber(), (NetworkAclEntry.RuleAction)((Object)Enums.valueOfFunction(NetworkAclEntry.RuleAction.class).apply((Object)request.getRuleAction())), request.getEgress(), cidr, request.getIcmpTypeCode().getCode(), request.getIcmpTypeCode().getType());
                                    break;
                                }
                                case 6: 
                                case 17: {
                                    entry = NetworkAclEntry.createTcpUdpEntry(networkAcl, request.getRuleNumber(), (Integer)protocolOptional.get(), (NetworkAclEntry.RuleAction)((Object)Enums.valueOfFunction(NetworkAclEntry.RuleAction.class).apply((Object)request.getRuleAction())), request.getEgress(), cidr, request.getPortRange().getFrom(), request.getPortRange().getTo());
                                    break;
                                }
                                default: {
                                    entry = NetworkAclEntry.createEntry(networkAcl, request.getRuleNumber(), (Integer)protocolOptional.get(), (NetworkAclEntry.RuleAction)((Object)Enums.valueOfFunction(NetworkAclEntry.RuleAction.class).apply((Object)request.getRuleAction())), request.getEgress(), cidr);
                                }
                            }
                            entries.set(entries.indexOf(oldEntry.get()), entry);
                            networkAcl.updateTimeStamps();
                        }
                        catch (Exception e) {
                            throw Exceptions.toUndeclared((Throwable)e);
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to replace network ACL entry")));
                    }
                }
            });
            this.invalidate(networkAclId);
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public ReplaceRouteResponseType replaceRoute(ReplaceRouteType request) throws EucalyptusCloudException {
        ReplaceRouteResponseType reply = (ReplaceRouteResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String gatewayId = Identifier.igw.normalize(request.getGatewayId());
        String routeTableId = Identifier.rtb.normalize(request.getRouteTableId());
        final String destinationCidr = request.getDestinationCidrBlock();
        Optional destinationCidrOption = (Optional)Cidr.parse().apply((Object)destinationCidr);
        if (!destinationCidrOption.isPresent()) {
            throw new ClientComputeException("InvalidParameterValue", "Cidr invalid: " + destinationCidr);
        }
        try {
            this.routeTables.updateByExample(RouteTable.exampleWithName((OwnerFullName)accountFullName, routeTableId), (OwnerFullName)accountFullName, request.getRouteTableId(), new Callback<RouteTable>(){

                public void fire(RouteTable routeTable) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)routeTable)) {
                        try {
                            InternetGateway internetGateway = (InternetGateway)((Object)VpcManager.this.internetGateways.lookupByName((OwnerFullName)accountFullName, gatewayId, Functions.identity()));
                            List<Route> routes = routeTable.getRoutes();
                            Optional oldRoute = Iterables.tryFind(routes, (Predicate)CollectionUtils.propertyPredicate((Object)destinationCidr, (Function)RouteTables.RouteFilterStringFunctions.DESTINATION_CIDR));
                            if (!oldRoute.isPresent()) {
                                throw new ClientComputeException("InvalidRoute.NotFound", "Route not found for cidr: " + destinationCidr);
                            }
                            routes.set(routes.indexOf(oldRoute.get()), Route.create(routeTable, Route.RouteOrigin.CreateRoute, destinationCidr, internetGateway));
                            routeTable.updateTimeStamps();
                        }
                        catch (Exception e) {
                            throw Exceptions.toUndeclared((Throwable)e);
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to replace route")));
                    }
                }
            });
            this.invalidate(routeTableId);
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public ReplaceRouteTableAssociationResponseType replaceRouteTableAssociation(final ReplaceRouteTableAssociationType request) throws EucalyptusCloudException {
        ReplaceRouteTableAssociationResponseType reply = (ReplaceRouteTableAssociationResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        final AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        final String routeTableId = Identifier.rtb.normalize(request.getRouteTableId());
        final String associationId = Identifier.rtbassoc.normalize(request.getAssociationId());
        try {
            String newAssociationId = this.routeTables.updateByAssociationId(associationId, (OwnerFullName)accountFullName, new Function<RouteTable, String>(){

                public String apply(RouteTable routeTable) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)routeTable)) {
                        try {
                            RouteTable newRouteTable = (RouteTable)((Object)VpcManager.this.routeTables.lookupByName((OwnerFullName)accountFullName, routeTableId, Functions.identity()));
                            RouteTableAssociation association = (RouteTableAssociation)((Object)Iterables.find(routeTable.getRouteTableAssociations(), (Predicate)CollectionUtils.propertyPredicate((Object)associationId, (Function)RouteTables.AssociationFilterStringFunctions.ASSOCIATION_ID)));
                            if (!newRouteTable.getVpc().getDisplayName().equals(routeTable.getVpc().getDisplayName())) {
                                throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidParameterValue", "Route table " + routeTableId + " belongs to different network")));
                            }
                            RouteTableAssociation oldAssociation = routeTable.disassociate(associationId);
                            Entities.delete((Object)((Object)oldAssociation));
                            Entities.flush((Object)((Object)oldAssociation));
                            RouteTableAssociation newAssociation = association.getMain() != false ? newRouteTable.associateMain() : newRouteTable.associate(association.getSubnet());
                            return newAssociation.getAssociationId();
                        }
                        catch (VpcMetadataNotFoundException e) {
                            throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidRouteTableID.NotFound", "Route table not found '" + request.getRouteTableId() + "'")));
                        }
                        catch (Exception e) {
                            throw Exceptions.toUndeclared((Throwable)e);
                        }
                    }
                    throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to replace route table association")));
                }
            });
            this.invalidate(routeTableId);
            reply.setNewAssociationId(newAssociationId);
        }
        catch (VpcMetadataNotFoundException e) {
            throw new ClientComputeException("InvalidAssociationID.NotFound", "Route table association (" + request.getAssociationId() + ") not found ");
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public ResetNetworkInterfaceAttributeResponseType resetNetworkInterfaceAttribute(final ResetNetworkInterfaceAttributeType request) throws EucalyptusCloudException {
        ResetNetworkInterfaceAttributeResponseType reply = (ResetNetworkInterfaceAttributeResponseType)request.getReply();
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        String eniId = Identifier.eni.normalize(request.getNetworkInterfaceId());
        try {
            this.networkInterfaces.updateByExample(NetworkInterface.exampleWithName((OwnerFullName)accountFullName, eniId), (OwnerFullName)accountFullName, request.getNetworkInterfaceId(), new Callback<NetworkInterface>(){

                public void fire(NetworkInterface networkInterface) {
                    if (RestrictedTypes.filterPrivileged().apply((Object)networkInterface)) {
                        switch (request.getAttribute()) {
                            case "sourceDestCheck": {
                                networkInterface.setSourceDestCheck(true);
                                break;
                            }
                            default: {
                                throw Exceptions.toUndeclared((Throwable)((Object)new ClientComputeException("InvalidParameterValue", "Value (" + request.getAttribute() + ") for parameter attribute is invalid. Unknown network interface attribute")));
                            }
                        }
                    } else {
                        throw Exceptions.toUndeclared((Throwable)((Object)new ClientUnauthorizedComputeException("Not authorized to reset network interface attribute")));
                    }
                }
            });
            this.invalidate(eniId);
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
        return reply;
    }

    public UnassignPrivateIpAddressesResponseType unassignPrivateIpAddresses(UnassignPrivateIpAddressesType request) throws EucalyptusCloudException {
        UnassignPrivateIpAddressesResponseType reply = (UnassignPrivateIpAddressesResponseType)request.getReply();
        return reply;
    }

    private <T extends AbstractPersistent, AT> AT allocate(Supplier<T> allocator, Class<T> type, Class<AT> apiType) throws EucalyptusCloudException {
        try {
            return (AT)TypeMappers.transform(RestrictedTypes.allocateUnitlessResources(type, (Integer)1, this.transactional(allocator)).get(0), apiType);
        }
        catch (Exception e) {
            throw VpcManager.handleException(e, true);
        }
    }

    private <E extends AbstractPersistent> void delete(Identifier identifier, String idParam, Function<Pair<Optional<AccountFullName>, String>, E> deleter) throws EucalyptusCloudException {
        block3: {
            Context ctx = Contexts.lookup();
            AccountFullName accountName = ctx.isAdministrator() ? null : ctx.getUserFullName().asAccountFullName();
            String id = identifier.normalize(idParam);
            try {
                this.transactional(deleter).apply((Object)Pair.lopair((Object)accountName, (Object)id));
            }
            catch (Exception e) {
                if (Exceptions.isCausedBy((Throwable)e, ConstraintViolationException.class)) {
                    throw new ClientComputeException("DependencyViolation", "Resource (" + idParam + ") is in use");
                }
                if (Exceptions.isCausedBy((Throwable)e, VpcMetadataNotFoundException.class)) break block3;
                throw VpcManager.handleException(e);
            }
        }
    }

    private static <AP extends AbstractPersistent, AT extends VpcTagged> void describe(Identifier identifier, Collection<String> ids, Collection<Filter> filters, Class<AP> persistent, Class<AT> api, List<AT> results, Function<AT, String> idFunction, Lister<AP> lister) throws EucalyptusCloudException {
        boolean showAll = ids.remove("verbose");
        Context ctx = Contexts.lookup();
        AccountFullName accountFullName = ctx.getUserFullName().asAccountFullName();
        AccountFullName ownerFullName = ctx.isAdministrator() && showAll ? null : accountFullName;
        com.eucalyptus.tags.Filter filter = Filters.generate(filters, persistent);
        Predicate requestedAndAccessible = CloudMetadatas.filteringFor(persistent).byId(identifier.normalize(ids)).byPredicate(filter.asPredicate()).byPrivileges().buildPredicate();
        try {
            results.addAll(lister.list((OwnerFullName)ownerFullName, filter.asCriterion(), filter.getAliases(), requestedAndAccessible, TypeMappers.lookup(persistent, api)));
            VpcManager.populateTags(accountFullName, persistent, results, idFunction);
        }
        catch (Exception e) {
            throw VpcManager.handleException(e);
        }
    }

    protected <E extends AbstractPersistent> Supplier<E> transactional(Supplier<E> supplier) {
        return Entities.asTransaction(supplier);
    }

    protected <E extends AbstractPersistent, P> Function<P, E> transactional(Function<P, E> function) {
        return Entities.asTransaction(function);
    }

    private static <VT extends VpcTagged> void populateTags(AccountFullName accountFullName, Class<? extends CloudMetadata> resourceType, List<? extends VT> items, Function<? super VT, String> idFunction) {
        Map<String, List<Tag>> tagsMap = TagSupport.forResourceClass(resourceType).getResourceTagMap((OwnerFullName)accountFullName, Iterables.transform(items, idFunction));
        for (VpcTagged item : items) {
            ResourceTagSetType tags = new ResourceTagSetType();
            Tags.addFromTags(tags.getItem(), ResourceTagSetItemType.class, (Iterable<Tag>)tagsMap.get(idFunction.apply((Object)item)));
            if (tags.getItem().isEmpty()) continue;
            item.setTagSet(tags);
        }
    }

    private static Optional<Integer> protocolNumber(String protocol) {
        switch (Objects.toString(protocol, "-1").toLowerCase()) {
            case "tcp": 
            case "6": {
                return Optional.of((Object)6);
            }
            case "udp": 
            case "17": {
                return Optional.of((Object)17);
            }
            case "icmp": 
            case "1": {
                return Optional.of((Object)1);
            }
        }
        return Iterables.tryFind((Iterable)Optional.fromNullable((Object)Ints.tryParse((String)protocol)).asSet(), (Predicate)Range.closed((Comparable)Integer.valueOf(-1), (Comparable)Integer.valueOf(255)));
    }

    private static Predicate<NetworkAclEntry> entryPredicate(Boolean egress, Integer ruleNumber) {
        return Predicates.and((Predicate)(ruleNumber == null ? Predicates.alwaysTrue() : CollectionUtils.propertyPredicate((Object)ruleNumber, (Function)NetworkAcls.NetworkAclEntryFilterIntegerFunctions.RULE_NUMBER)), (Predicate)CollectionUtils.propertyPredicate((Object)egress, (Function)NetworkAcls.NetworkAclEntryFilterBooleanFunctions.EGRESS));
    }

    private void invalidate(String resourceIdentifier) {
        this.vpcInvalidator.invalidate(resourceIdentifier);
    }

    private static ComputeException handleException(Exception e) throws ComputeException {
        throw VpcManager.handleException(e, false);
    }

    private static ComputeException handleException(Exception e, boolean isCreate) throws ComputeException {
        ComputeException cause = (ComputeException)((Object)Exceptions.findCause((Throwable)e, ComputeException.class));
        if (cause != null) {
            throw cause;
        }
        AuthQuotaException quotaCause = (AuthQuotaException)Exceptions.findCause((Throwable)e, AuthQuotaException.class);
        if (quotaCause != null) {
            String code = "ResourceLimitExceeded";
            switch (quotaCause.getType()) {
                case "vpc": {
                    code = "VpcLimitExceeded";
                    break;
                }
                case "internet-gateway": {
                    code = "InternetGatewayLimitExceeded";
                }
            }
            throw new ClientComputeException(code, "Request would exceed quota for type: " + quotaCause.getType());
        }
        logger.error((Object)e, (Throwable)e);
        ComputeException exception = new ComputeException("InternalError", String.valueOf(e.getMessage()));
        if (Contexts.lookup().hasAdministrativePrivileges()) {
            exception.initCause(e);
        }
        throw exception;
    }

    private static enum Identifier {
        acl("networkAcl"),
        aclassoc("networkAclAssociation"),
        dopt("DHCPOption"),
        eni("networkInterface"),
        igw("internetGateway"),
        rtb("routeTable"),
        rtbassoc("routeTableAssociation"),
        subnet("subnet"),
        vpc("vpc");

        private final String code;
        private final String defaultParameter;
        private final String defaultListParameter;

        private Identifier(String defaultParameter) {
            this(defaultParameter, defaultParameter + "s");
        }

        private Identifier(String defaultParameter, String defaultListParameter) {
            this.code = "InvalidParameterValue";
            this.defaultParameter = defaultParameter;
            this.defaultListParameter = defaultListParameter;
        }

        public String generate() {
            return ResourceIdentifiers.generateString(this.name());
        }

        public String normalize(String identifier) throws EucalyptusCloudException {
            return this.normalize(identifier, this.defaultParameter);
        }

        public String normalize(String identifier, String parameter) throws EucalyptusCloudException {
            return this.normalize(Collections.singleton(identifier), parameter).get(0);
        }

        public List<String> normalize(Iterable<String> identifiers) throws EucalyptusCloudException {
            return this.normalize(identifiers, this.defaultListParameter);
        }

        public List<String> normalize(Iterable<String> identifiers, String parameter) throws EucalyptusCloudException {
            try {
                return ResourceIdentifiers.normalize(this.name(), identifiers);
            }
            catch (InvalidResourceIdentifier e) {
                throw new ClientComputeException(this.code, "Value (" + e.getIdentifier() + ") for parameter " + parameter + " is invalid. Expected: '" + this.name() + "-...'.");
            }
        }
    }
}

