/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.DhcpOptionSet;
import com.eucalyptus.compute.vpc.VpcTag;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_vpcs")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Vpc
extends UserMetadata<State>
implements CloudMetadata.VpcMetadata {
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_cidr", nullable=false)
    private String cidr;
    @Column(name="metadata_default", nullable=false)
    private Boolean defaultVpc;
    @Column(name="metadata_dns_enabled", nullable=false)
    private Boolean dnsEnabled;
    @Column(name="metadata_dns_hostnames", nullable=false)
    private Boolean dnsHostnames;
    @ManyToOne
    @JoinColumn(name="metadata_dhcp_option_set_id")
    private DhcpOptionSet dhcpOptionSet;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="vpc")
    private Collection<VpcTag> tags;

    protected Vpc() {
    }

    protected Vpc(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static Vpc create(OwnerFullName owner, String name, DhcpOptionSet dhcpOptionSet, String cidr, boolean defaultVpc) {
        Vpc vpc = new Vpc(owner, name);
        vpc.setDhcpOptionSet(dhcpOptionSet);
        vpc.setCidr(cidr);
        vpc.setDefaultVpc(defaultVpc);
        vpc.setDnsEnabled(true);
        vpc.setDnsHostnames(defaultVpc);
        vpc.setState(State.available);
        return vpc;
    }

    public static Vpc exampleWithOwner(OwnerFullName owner) {
        return new Vpc(owner, null);
    }

    public static Vpc exampleWithName(OwnerFullName owner, String name) {
        return new Vpc(owner, name);
    }

    public static Vpc exampleDefault(String accountNumber) {
        Vpc vpc = Vpc.exampleWithOwner(null);
        vpc.setOwnerAccountNumber(accountNumber);
        vpc.setDefaultVpc(true);
        return vpc;
    }

    public static Vpc exampleDefault(OwnerFullName owner) {
        Vpc vpc = Vpc.exampleWithOwner(owner);
        vpc.setDefaultVpc(true);
        return vpc;
    }

    public String getPartition() {
        return "eucalyptus";
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"vpc", this.getDisplayName()});
    }

    public String getCidr() {
        return this.cidr;
    }

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public Boolean getDefaultVpc() {
        return this.defaultVpc;
    }

    public void setDefaultVpc(Boolean defaultVpc) {
        this.defaultVpc = defaultVpc;
    }

    public Boolean getDnsEnabled() {
        return this.dnsEnabled;
    }

    public void setDnsEnabled(Boolean dnsEnabled) {
        this.dnsEnabled = dnsEnabled;
    }

    public Boolean getDnsHostnames() {
        return this.dnsHostnames;
    }

    public void setDnsHostnames(Boolean dnsHostnames) {
        this.dnsHostnames = dnsHostnames;
    }

    public DhcpOptionSet getDhcpOptionSet() {
        return this.dhcpOptionSet;
    }

    public void setDhcpOptionSet(DhcpOptionSet dhcpOptionSet) {
        this.dhcpOptionSet = dhcpOptionSet;
    }

    public static enum State {
        pending,
        available;

    }
}

