/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.SubnetType;
import com.eucalyptus.compute.vpc.Lister;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.compute.vpc.SubnetTag;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.hibernate.criterion.Criterion;

public interface Subnets
extends Lister<Subnet> {
    @Override
    public <T> List<T> list(OwnerFullName var1, Criterion var2, Map<String, String> var3, Predicate<? super Subnet> var4, Function<? super Subnet, T> var5) throws VpcMetadataException;

    public <T> List<T> listByExample(Subnet var1, Predicate<? super Subnet> var2, Function<? super Subnet, T> var3) throws VpcMetadataException;

    public <T> T lookupByName(@Nullable OwnerFullName var1, String var2, Function<? super Subnet, T> var3) throws VpcMetadataException;

    public <T> T lookupDefault(OwnerFullName var1, String var2, Function<? super Subnet, T> var3) throws VpcMetadataException;

    public boolean delete(CloudMetadata.SubnetMetadata var1) throws VpcMetadataException;

    public Subnet save(Subnet var1) throws VpcMetadataException;

    public Subnet updateByExample(Subnet var1, OwnerFullName var2, String var3, Callback<Subnet> var4) throws VpcMetadataException;

    public static enum FilterBooleanFunctions implements Function<Subnet, Boolean>
    {
        DEFAULT_FOR_AZ{

            public Boolean apply(Subnet subnet) {
                return subnet.getDefaultForAz();
            }
        };

    }

    public static enum FilterIntegerFunctions implements Function<Subnet, Integer>
    {
        AVAILABLE_IP_COUNT{

            public Integer apply(Subnet subnet) {
                return subnet.getAvailableIpAddressCount();
            }
        };

    }

    public static enum FilterStringFunctions implements Function<Subnet, String>
    {
        AVAILABILITY_ZONE{

            public String apply(Subnet subnet) {
                return subnet.getAvailabilityZone();
            }
        }
        ,
        CIDR{

            public String apply(Subnet subnet) {
                return subnet.getCidr();
            }
        }
        ,
        NETWORK_ACL_ASSOCIATION_ID{

            public String apply(Subnet subnet) {
                return subnet.getNetworkAclAssociationId();
            }
        }
        ,
        STATE{

            public String apply(Subnet subnet) {
                return Objects.toString(subnet.getState(), "");
            }
        }
        ,
        VPC_ID{

            public String apply(Subnet subnet) {
                return subnet.getVpc().getDisplayName();
            }
        };

    }

    public static class SubnetFilterSupport
    extends FilterSupport<Subnet> {
        public SubnetFilterSupport() {
            super(SubnetFilterSupport.builderFor(Subnet.class).withTagFiltering(SubnetTag.class, "subnet").withStringProperty("availability-zone", FilterStringFunctions.AVAILABILITY_ZONE).withStringProperty("availabilityZone", FilterStringFunctions.AVAILABILITY_ZONE).withIntegerProperty("available-ip-address-count", FilterIntegerFunctions.AVAILABLE_IP_COUNT).withStringProperty("cidr", FilterStringFunctions.CIDR).withStringProperty("cidr-block", FilterStringFunctions.CIDR).withStringProperty("cidrBlock", FilterStringFunctions.CIDR).withBooleanProperty("default-for-az", FilterBooleanFunctions.DEFAULT_FOR_AZ).withBooleanProperty("defaultForAz", FilterBooleanFunctions.DEFAULT_FOR_AZ).withStringProperty("state", FilterStringFunctions.STATE).withStringProperty("subnet-id", (Function<Subnet, String>)CloudMetadatas.toDisplayName()).withStringProperty("vpc-id", FilterStringFunctions.VPC_ID).withStringProperty("vpcId", FilterStringFunctions.VPC_ID).withPersistenceAlias("vpc", "vpc").withPersistenceFilter("availability-zone", "availabilityZone").withPersistenceFilter("availabilityZone").withPersistenceFilter("available-ip-address-count", "availableIpAddressCount", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("cidr").withPersistenceFilter("cidr-block", "cidr").withPersistenceFilter("cidrBlock", "cidr").withPersistenceFilter("default-for-az", "defaultForAz", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("defaultForAz", "defaultForAz", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("state", "state", Enums.valueOfFunction(Subnet.State.class)).withPersistenceFilter("subnet-id", "displayName").withPersistenceFilter("vpc-id", "vpc.displayName").withPersistenceFilter("vpcId", "vpc.displayName"));
        }
    }

    @TypeMapper
    public static enum SubnetToSubnetTypeTransform implements Function<Subnet, SubnetType>
    {
        INSTANCE;


        @Nullable
        public SubnetType apply(@Nullable Subnet subnet) {
            return subnet == null ? null : new SubnetType(subnet.getDisplayName(), Objects.toString(subnet.getState(), null), (String)CloudMetadatas.toDisplayName().apply((Object)subnet.getVpc()), subnet.getCidr(), subnet.getAvailableIpAddressCount(), subnet.getAvailabilityZone(), subnet.getDefaultForAz(), subnet.getMapPublicIpOnLaunch());
        }
    }

    @RestrictedTypes.Resolver(value=Subnet.class)
    public static enum Lookup implements Function<String, Subnet>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Subnet apply(String identifier) {
            try (TransactionResource tx = Entities.transactionFor(Subnet.class);){
                Subnet subnet = (Subnet)((Object)Entities.uniqueResult((Object)((Object)Subnet.exampleWithName(null, identifier))));
                return subnet;
            }
            catch (TransactionException e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }
}

