/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_tags_subnets")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="subnet")
public class SubnetTag
extends Tag<SubnetTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private Subnet subnet;

    protected SubnetTag() {
        super("subnet", ResourceIdFunction.INSTANCE);
    }

    public SubnetTag(@Nonnull Subnet subnet, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        super("subnet", ResourceIdFunction.INSTANCE, ownerFullName, key, value);
        this.setSubnet(subnet);
        this.init();
    }

    public Subnet getSubnet() {
        return this.subnet;
    }

    public void setSubnet(Subnet subnet) {
        this.subnet = subnet;
    }

    @Nonnull
    public static Tag named(@Nonnull Subnet subnet, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return SubnetTag.namedWithValue(subnet, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull Subnet subnet, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)subnet), (Object)"subnet");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new SubnetTag(subnet, ownerFullName, key, value);
    }

    public static final class SubnetTagSupport
    extends TagSupport {
        public SubnetTagSupport() {
            super(Subnet.class, "subnet", "displayName", "subnet", " InvalidSubnetID.NotFound", "The subnet '%s' does not exist.");
        }

        @Override
        public Tag createOrUpdate(CloudMetadata metadata, OwnerFullName ownerFullName, String key, String value) {
            return Tags.createOrUpdate(new SubnetTag((Subnet)metadata, ownerFullName, key, value));
        }

        @Override
        public Tag example(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return SubnetTag.namedWithValue((Subnet)metadata, ownerFullName, key, value);
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new SubnetTag(), ownerFullName);
        }

        @Override
        public CloudMetadata lookup(String identifier) throws TransactionException {
            return (CloudMetadata)Entities.uniqueResult((Object)((Object)Subnet.exampleWithName(null, identifier)));
        }
    }

    private static enum ResourceIdFunction implements Function<SubnetTag, String>
    {
        INSTANCE{

            public String apply(SubnetTag subnetTag) {
                return subnetTag.getSubnet().getDisplayName();
            }
        };

    }
}

