/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.compute.vpc.NetworkAcl;
import com.eucalyptus.compute.vpc.RouteTableAssociation;
import com.eucalyptus.compute.vpc.SubnetTag;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.util.Cidr;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import java.util.Collection;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_subnets")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Subnet
extends UserMetadata<State>
implements CloudMetadata.SubnetMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_vpc_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Vpc vpc;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_network_acl_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private NetworkAcl networkAcl;
    @Column(name="metadata_nacl_association_id", nullable=false, unique=true)
    private String networkAclAssociationId;
    @Column(name="metadata_cidr", nullable=false)
    private String cidr;
    @Column(name="metadata_availability_zone", nullable=false)
    private String availabilityZone;
    @Column(name="metadata_available_ips", nullable=false)
    private Integer availableIpAddressCount;
    @Column(name="metadata_default_for_az", nullable=false)
    private Boolean defaultForAz;
    @Column(name="metadata_map_public_ip", nullable=false)
    private Boolean mapPublicIpOnLaunch;
    @OneToOne(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, mappedBy="subnet")
    private RouteTableAssociation routeTableAssociation;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="subnet")
    private Collection<SubnetTag> tags;

    protected Subnet() {
    }

    protected Subnet(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static Subnet create(OwnerFullName owner, Vpc vpc, NetworkAcl networkAcl, String name, String cidr, String availabilityZone) {
        Subnet subnet = new Subnet(owner, name);
        subnet.setVpc(vpc);
        subnet.setNetworkAcl(networkAcl);
        subnet.setNetworkAclAssociationId(ResourceIdentifiers.generateString("aclassoc"));
        subnet.setCidr(cidr);
        subnet.setAvailabilityZone(availabilityZone);
        subnet.setAvailableIpAddressCount(Subnet.usableAddressesForSubnet(cidr));
        subnet.setDefaultForAz(false);
        subnet.setMapPublicIpOnLaunch(false);
        subnet.setState(State.available);
        return subnet;
    }

    public static int usableAddressesForSubnet(String cidr) {
        return (int)Math.pow(2.0, 32 - Cidr.parse((String)cidr).getPrefix()) - 5;
    }

    public static Subnet exampleWithOwner(OwnerFullName owner) {
        return new Subnet(owner, null);
    }

    public static Subnet exampleWithName(OwnerFullName owner, String name) {
        return new Subnet(owner, name);
    }

    public static Subnet exampleDefault(OwnerFullName owner, String availabilityZone) {
        Subnet subnet = Subnet.exampleWithOwner(owner);
        subnet.setAvailabilityZone(availabilityZone);
        subnet.setDefaultForAz(true);
        return subnet;
    }

    public static Subnet exampleWithNetworkAclAssociation(OwnerFullName owner, String associationId) {
        Subnet subnet = new Subnet(owner, null);
        subnet.setNetworkAclAssociationId(associationId);
        return subnet;
    }

    public String getPartition() {
        return "eucalyptus";
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"subnet", this.getDisplayName()});
    }

    public Vpc getVpc() {
        return this.vpc;
    }

    public void setVpc(Vpc vpc) {
        this.vpc = vpc;
    }

    public NetworkAcl getNetworkAcl() {
        return this.networkAcl;
    }

    public void setNetworkAcl(NetworkAcl networkAcl) {
        this.networkAcl = networkAcl;
    }

    public String getNetworkAclAssociationId() {
        return this.networkAclAssociationId;
    }

    public void setNetworkAclAssociationId(String networkAclAssociationId) {
        this.networkAclAssociationId = networkAclAssociationId;
    }

    public String getCidr() {
        return this.cidr;
    }

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public Integer getAvailableIpAddressCount() {
        return this.availableIpAddressCount;
    }

    public void setAvailableIpAddressCount(Integer availableIpAddressCount) {
        this.availableIpAddressCount = availableIpAddressCount;
    }

    public Boolean getDefaultForAz() {
        return this.defaultForAz;
    }

    public void setDefaultForAz(Boolean defaultForAz) {
        this.defaultForAz = defaultForAz;
    }

    public Boolean getMapPublicIpOnLaunch() {
        return this.mapPublicIpOnLaunch;
    }

    public void setMapPublicIpOnLaunch(Boolean mapPublicIpOnLaunch) {
        this.mapPublicIpOnLaunch = mapPublicIpOnLaunch;
    }

    public static enum State {
        pending,
        available;

    }
}

