/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.RouteTableAssociationType;
import com.eucalyptus.compute.common.RouteTableType;
import com.eucalyptus.compute.common.RouteType;
import com.eucalyptus.compute.vpc.Lister;
import com.eucalyptus.compute.vpc.Route;
import com.eucalyptus.compute.vpc.RouteTable;
import com.eucalyptus.compute.vpc.RouteTableAssociation;
import com.eucalyptus.compute.vpc.RouteTableTag;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.entities.AbstractPersistentSupport;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.hibernate.criterion.Criterion;

public interface RouteTables
extends Lister<RouteTable> {
    @Override
    public <T> List<T> list(OwnerFullName var1, Criterion var2, Map<String, String> var3, Predicate<? super RouteTable> var4, Function<? super RouteTable, T> var5) throws VpcMetadataException;

    public long countByExample(RouteTable var1, Criterion var2, Map<String, String> var3) throws VpcMetadataException;

    public <T> T lookupByName(@Nullable OwnerFullName var1, String var2, Function<? super RouteTable, T> var3) throws VpcMetadataException;

    public <T> T lookupMain(String var1, Function<? super RouteTable, T> var2) throws VpcMetadataException;

    public boolean delete(CloudMetadata.RouteTableMetadata var1) throws VpcMetadataException;

    public RouteTable save(RouteTable var1) throws VpcMetadataException;

    public RouteTable updateByExample(RouteTable var1, OwnerFullName var2, String var3, Callback<RouteTable> var4) throws VpcMetadataException;

    public <T> T updateByAssociationId(String var1, OwnerFullName var2, Function<RouteTable, T> var3) throws VpcMetadataException;

    public AbstractPersistentSupport<CloudMetadata.RouteTableMetadata, RouteTable, VpcMetadataException> withRetries();

    public static enum AssociationFilterBooleanFunctions implements Function<RouteTableAssociation, Boolean>
    {
        MAIN{

            public Boolean apply(RouteTableAssociation association) {
                return association.getMain();
            }
        };

    }

    public static enum AssociationFilterStringFunctions implements Function<RouteTableAssociation, String>
    {
        ASSOCIATION_ID{

            public String apply(RouteTableAssociation association) {
                return association.getAssociationId();
            }
        }
        ,
        ROUTE_TABLE_ID{

            public String apply(RouteTableAssociation association) {
                return association.getRouteTableId();
            }
        }
        ,
        SUBNET_ID{

            public String apply(RouteTableAssociation association) {
                return association.getSubnetId();
            }
        };

    }

    public static enum FilterBooleanSetFunctions implements Function<RouteTable, Set<Boolean>>
    {
        ASSOCIATION_MAIN{

            public Set<Boolean> apply(RouteTable routeTable) {
                return FilterStringSetFunctions.associationPropertySet(routeTable, AssociationFilterBooleanFunctions.MAIN);
            }
        };

    }

    public static enum FilterStringSetFunctions implements Function<RouteTable, Set<String>>
    {
        ASSOCIATION_ID{

            public Set<String> apply(RouteTable routeTable) {
                return 1.associationPropertySet(routeTable, AssociationFilterStringFunctions.ASSOCIATION_ID);
            }
        }
        ,
        ASSOCIATION_ROUTE_TABLE_ID{

            public Set<String> apply(RouteTable routeTable) {
                return 2.associationPropertySet(routeTable, AssociationFilterStringFunctions.ROUTE_TABLE_ID);
            }
        }
        ,
        ASSOCIATION_SUBNET_ID{

            public Set<String> apply(RouteTable routeTable) {
                return 3.associationPropertySet(routeTable, AssociationFilterStringFunctions.SUBNET_ID);
            }
        }
        ,
        ROUTE_DESTINATION_CIDR{

            public Set<String> apply(RouteTable routeTable) {
                return FilterStringSetFunctions.routePropertySet(routeTable, (Function<? super Route, String>)RouteFilterStringFunctions.DESTINATION_CIDR);
            }
        }
        ,
        ROUTE_GATEWAY_ID{

            public Set<String> apply(RouteTable routeTable) {
                return FilterStringSetFunctions.routePropertySet(routeTable, (Function<? super Route, String>)RouteFilterStringFunctions.GATEWAY_ID);
            }
        }
        ,
        ROUTE_ORIGIN{

            public Set<String> apply(RouteTable routeTable) {
                return FilterStringSetFunctions.routePropertySet(routeTable, (Function<? super Route, String>)RouteFilterStringFunctions.ORIGIN);
            }
        }
        ,
        ROUTE_STATE{

            public Set<String> apply(RouteTable routeTable) {
                return FilterStringSetFunctions.routePropertySet(routeTable, (Function<? super Route, String>)RouteFilterStringFunctions.STATE);
            }
        };


        private static Set<String> routePropertySet(RouteTable routeTable, Function<? super Route, String> propertyGetter) {
            return Sets.newHashSet((Iterable)Iterables.transform(routeTable.getRoutes(), propertyGetter));
        }

        static <T> Set<T> associationPropertySet(RouteTable routeTable, Function<RouteTableAssociation, T> propertyGetter) {
            return Sets.newHashSet((Iterable)Iterables.filter((Iterable)Iterables.transform(routeTable.getRouteTableAssociations(), propertyGetter), (Predicate)Predicates.notNull()));
        }
    }

    public static enum RouteFilterStringFunctions implements Function<Route, String>
    {
        DESTINATION_CIDR{

            public String apply(Route route) {
                return route.getDestinationCidr();
            }
        }
        ,
        GATEWAY_ID{

            public String apply(Route route) {
                return (String)CloudMetadatas.toDisplayName().apply((Object)route.getInternetGateway());
            }
        }
        ,
        ORIGIN{

            public String apply(Route route) {
                return Objects.toString((Object)route.getOrigin(), null);
            }
        }
        ,
        STATE{

            public String apply(Route route) {
                return Objects.toString(route.getState(), null);
            }
        };

    }

    public static enum FilterStringFunctions implements Function<RouteTable, String>
    {
        VPC_ID{

            public String apply(RouteTable routeTable) {
                return routeTable.getVpc().getDisplayName();
            }
        };

    }

    public static class RouteTableFilterSupport
    extends FilterSupport<RouteTable> {
        public RouteTableFilterSupport() {
            super(RouteTableFilterSupport.builderFor(RouteTable.class).withTagFiltering(RouteTableTag.class, "routeTable").withStringSetProperty("association.route-table-association-id", FilterStringSetFunctions.ASSOCIATION_ID).withStringSetProperty("association.route-table-id", FilterStringSetFunctions.ASSOCIATION_ROUTE_TABLE_ID).withStringSetProperty("association.subnet-id", FilterStringSetFunctions.ASSOCIATION_SUBNET_ID).withBooleanSetProperty("association.main", FilterBooleanSetFunctions.ASSOCIATION_MAIN).withStringSetProperty("route.destination-cidr-block", FilterStringSetFunctions.ROUTE_DESTINATION_CIDR).withStringSetProperty("route.gateway-id", FilterStringSetFunctions.ROUTE_GATEWAY_ID).withUnsupportedProperty("route.instance-id").withUnsupportedProperty("route.vpc-peering-connection-id").withStringSetProperty("route.origin", FilterStringSetFunctions.ROUTE_ORIGIN).withStringSetProperty("route.state", FilterStringSetFunctions.ROUTE_STATE).withStringProperty("route-table-id", (Function<RouteTable, String>)CloudMetadatas.toDisplayName()).withStringProperty("vpc-id", FilterStringFunctions.VPC_ID).withPersistenceAlias("routeTableAssociations", "routeTableAssociations").withPersistenceAlias("routes", "routes").withPersistenceAlias("vpc", "vpc").withPersistenceFilter("association.route-table-association-id", "routeTableAssociations.associationId").withPersistenceFilter("association.route-table-id", "routeTableAssociations.routeTableId").withPersistenceFilter("association.subnet-id", "routeTableAssociations.subnetId").withPersistenceFilter("association.main", "routeTableAssociations.main", FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("route.destination-cidr-block", "routes.destinationCidr").withPersistenceFilter("route.gateway-id", "routes.destinationCidr").withPersistenceFilter("route.origin", "routes.origin", Enums.valueOfFunction(Route.RouteOrigin.class)).withPersistenceFilter("route.state", "routes.state", Enums.valueOfFunction(Route.State.class)).withPersistenceFilter("route-table-id", "displayName").withPersistenceFilter("vpc-id", "vpc.displayName"));
        }
    }

    @TypeMapper
    public static enum RouteTableAssociationToAssociationType implements Function<RouteTableAssociation, RouteTableAssociationType>
    {
        INSTANCE;


        @Nullable
        public RouteTableAssociationType apply(@Nullable RouteTableAssociation association) {
            return association == null ? null : new RouteTableAssociationType(association.getAssociationId(), association.getRouteTableId(), association.getSubnetId(), association.getMain());
        }
    }

    @TypeMapper
    public static enum RouteToRouteType implements Function<Route, RouteType>
    {
        INSTANCE;


        @Nullable
        public RouteType apply(@Nullable Route route) {
            return route == null ? null : new RouteType(route.getDestinationCidr(), (String)Optional.fromNullable((Object)((Object)route.getInternetGateway())).transform(CloudMetadatas.toDisplayName()).or((Object)"local"), Objects.toString(route.getState(), null), Objects.toString((Object)route.getOrigin(), null));
        }
    }

    @TypeMapper
    public static enum RouteTableToRouteTableTypeTransform implements Function<RouteTable, RouteTableType>
    {
        INSTANCE;


        @Nullable
        public RouteTableType apply(@Nullable RouteTable routeTable) {
            return routeTable == null ? null : new RouteTableType(routeTable.getDisplayName(), routeTable.getVpc().getDisplayName(), Collections2.transform(routeTable.getRoutes(), (Function)RouteToRouteType.INSTANCE), Collections2.transform(routeTable.getRouteTableAssociations(), (Function)RouteTableAssociationToAssociationType.INSTANCE));
        }
    }
}

