/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.RouteTable;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_tags_route_tables")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="route-table")
public class RouteTableTag
extends Tag<RouteTableTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private RouteTable routeTable;

    protected RouteTableTag() {
        super("route-table", ResourceIdFunction.INSTANCE);
    }

    public RouteTableTag(@Nonnull RouteTable routeTable, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        super("route-table", ResourceIdFunction.INSTANCE, ownerFullName, key, value);
        this.setRouteTable(routeTable);
        this.init();
    }

    public RouteTable getRouteTable() {
        return this.routeTable;
    }

    public void setRouteTable(RouteTable routeTable) {
        this.routeTable = routeTable;
    }

    @Nonnull
    public static Tag named(@Nonnull RouteTable routeTable, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return RouteTableTag.namedWithValue(routeTable, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull RouteTable routeTable, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)routeTable), (Object)"routeTable");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new RouteTableTag(routeTable, ownerFullName, key, value);
    }

    public static final class RouteTableTagSupport
    extends TagSupport {
        public RouteTableTagSupport() {
            super(RouteTable.class, "rtb", "displayName", "routeTable", " InvalidRouteTableID.NotFound", "The route table '%s' does not exist.");
        }

        @Override
        public Tag createOrUpdate(CloudMetadata metadata, OwnerFullName ownerFullName, String key, String value) {
            return Tags.createOrUpdate(new RouteTableTag((RouteTable)metadata, ownerFullName, key, value));
        }

        @Override
        public Tag example(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return RouteTableTag.namedWithValue((RouteTable)metadata, ownerFullName, key, value);
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new RouteTableTag(), ownerFullName);
        }

        @Override
        public CloudMetadata lookup(String identifier) throws TransactionException {
            return (CloudMetadata)Entities.uniqueResult((Object)((Object)RouteTable.exampleWithName(null, identifier)));
        }
    }

    private static enum ResourceIdFunction implements Function<RouteTableTag, String>
    {
        INSTANCE{

            public String apply(RouteTableTag routeTableTag) {
                return routeTableTag.getRouteTable().getDisplayName();
            }
        };

    }
}

