/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.identifier.ResourceIdentifiers;
import com.eucalyptus.compute.vpc.RouteTable;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.entities.AbstractPersistent;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_route_table_associations")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class RouteTableAssociation
extends AbstractPersistent {
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_association_id", nullable=false, updatable=false, unique=true)
    private String associationId;
    @Column(name="metadata_main", nullable=false, updatable=false)
    private Boolean main;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_route_table", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private RouteTable routeTable;
    @Column(name="metadata_route_table_id", nullable=false, updatable=false)
    private String routeTableId;
    @OneToOne
    @JoinColumn(name="metadata_subnet")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Subnet subnet;
    @Column(name="metadata_subnet_id", updatable=false, unique=true)
    private String subnetId;

    protected RouteTableAssociation() {
    }

    public static RouteTableAssociation create(RouteTable routeTable) {
        RouteTableAssociation association = new RouteTableAssociation();
        association.setAssociationId(ResourceIdentifiers.generateString("rtbassoc"));
        association.setRouteTable(routeTable);
        association.setRouteTableId(routeTable.getDisplayName());
        association.setMain(true);
        return association;
    }

    public static RouteTableAssociation create(RouteTable routeTable, Subnet subnet) {
        RouteTableAssociation association = RouteTableAssociation.create(routeTable);
        association.setSubnet(subnet);
        association.setSubnetId(subnet.getDisplayName());
        association.setMain(false);
        return association;
    }

    public String getAssociationId() {
        return this.associationId;
    }

    public void setAssociationId(String associationId) {
        this.associationId = associationId;
    }

    public Boolean getMain() {
        return this.main;
    }

    public void setMain(Boolean main) {
        this.main = main;
    }

    public RouteTable getRouteTable() {
        return this.routeTable;
    }

    public void setRouteTable(RouteTable routeTable) {
        this.routeTable = routeTable;
    }

    public String getRouteTableId() {
        return this.routeTableId;
    }

    public void setRouteTableId(String routeTableId) {
        this.routeTableId = routeTableId;
    }

    public Subnet getSubnet() {
        return this.subnet;
    }

    public void setSubnet(Subnet subnet) {
        this.subnet = subnet;
    }

    public String getSubnetId() {
        return this.subnetId;
    }

    public void setSubnetId(String subnetId) {
        this.subnetId = subnetId;
    }
}

