/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.Route;
import com.eucalyptus.compute.vpc.RouteTableAssociation;
import com.eucalyptus.compute.vpc.RouteTableTag;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Optional;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_route_tables")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class RouteTable
extends AbstractOwnedPersistent
implements CloudMetadata.RouteTableMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_vpc_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Vpc vpc;
    @Column(name="metadata_main")
    private Boolean main;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="routeTable")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<Route> routes = Lists.newArrayList();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="routeTable")
    private List<RouteTableAssociation> routeTableAssociations;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="routeTable")
    private Collection<RouteTableTag> tags;

    protected RouteTable() {
    }

    protected RouteTable(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static RouteTable create(OwnerFullName owner, Vpc vpc, String name, String destinationCidr, boolean main) {
        RouteTable routeTable = new RouteTable(owner, name);
        routeTable.setVpc(vpc);
        routeTable.setMain(main);
        routeTable.setRoutes(Lists.newArrayList((Object[])new Route[]{Route.create(routeTable, destinationCidr)}));
        routeTable.setRouteTableAssociations(Lists.newArrayList((Iterable)Optional.fromNullable((Object)((Object)(main ? RouteTableAssociation.create(routeTable) : null))).asSet()));
        return routeTable;
    }

    public static RouteTable exampleWithOwner(OwnerFullName owner) {
        return new RouteTable(owner, null);
    }

    public static RouteTable exampleWithName(OwnerFullName owner, String name) {
        return new RouteTable(owner, name);
    }

    public static RouteTable exampleMain() {
        RouteTable routeTable = new RouteTable();
        routeTable.setMain(true);
        return routeTable;
    }

    public Vpc getVpc() {
        return this.vpc;
    }

    public void setVpc(Vpc vpc) {
        this.vpc = vpc;
    }

    public Boolean getMain() {
        return this.main;
    }

    public void setMain(Boolean main) {
        this.main = main;
    }

    public List<Route> getRoutes() {
        return this.routes;
    }

    public void setRoutes(List<Route> routes) {
        this.routes = routes;
    }

    public List<RouteTableAssociation> getRouteTableAssociations() {
        return this.routeTableAssociations;
    }

    public void setRouteTableAssociations(List<RouteTableAssociation> routeTableAssociations) {
        this.routeTableAssociations = routeTableAssociations;
    }

    public RouteTableAssociation associateMain() {
        RouteTableAssociation association = RouteTableAssociation.create(this);
        this.setMain(true);
        this.getRouteTableAssociations().add(association);
        return association;
    }

    public RouteTableAssociation associate(Subnet subnet) {
        RouteTableAssociation association = RouteTableAssociation.create(this, subnet);
        this.getRouteTableAssociations().add(association);
        this.updateTimeStamps();
        return association;
    }

    public RouteTableAssociation disassociate(String associationId) {
        for (RouteTableAssociation association : this.getRouteTableAssociations()) {
            if (!associationId.equals(association.getAssociationId())) continue;
            if (association.getMain().booleanValue()) {
                this.setMain(false);
            }
            this.getRouteTableAssociations().remove((Object)association);
            this.updateTimeStamps();
            return association;
        }
        return null;
    }
}

