/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.vpc.InternetGateway;
import com.eucalyptus.compute.vpc.RouteTable;
import com.eucalyptus.entities.AbstractStatefulPersistent;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_routes")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class Route
extends AbstractStatefulPersistent<State> {
    private static final long serialVersionUID = 1L;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_route_table_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private RouteTable routeTable;
    @Column(name="metadata_origin", nullable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private RouteOrigin origin;
    @Column(name="metadata_destination_cidr", nullable=false, updatable=false)
    private String destinationCidr;
    @Column(name="metadata_internet_gateway_id", nullable=true, updatable=false)
    private InternetGateway internetGateway;

    protected Route() {
    }

    protected Route(RouteTable routeTable, RouteOrigin origin, String destinationCidr, InternetGateway internetGateway) {
        this.routeTable = routeTable;
        this.origin = origin;
        this.destinationCidr = destinationCidr;
        this.internetGateway = internetGateway;
        this.setState(State.active);
    }

    public static Route create(RouteTable routeTable, RouteOrigin origin, String destinationCidr, InternetGateway internetGateway) {
        return new Route(routeTable, origin, destinationCidr, internetGateway);
    }

    public static Route create(RouteTable routeTable, String destinationCidr) {
        return new Route(routeTable, RouteOrigin.CreateRouteTable, destinationCidr, null);
    }

    public RouteTable getRouteTable() {
        return this.routeTable;
    }

    public void setRouteTable(RouteTable routeTable) {
        this.routeTable = routeTable;
    }

    public RouteOrigin getOrigin() {
        return this.origin;
    }

    public void setOrigin(RouteOrigin origin) {
        this.origin = origin;
    }

    public String getDestinationCidr() {
        return this.destinationCidr;
    }

    public void setDestinationCidr(String destinationCidr) {
        this.destinationCidr = destinationCidr;
    }

    public InternetGateway getInternetGateway() {
        return this.internetGateway;
    }

    public void setInternetGateway(InternetGateway internetGateway) {
        this.internetGateway = internetGateway;
    }

    public static enum RouteOrigin {
        CreateRouteTable,
        CreateRoute;

    }

    public static enum State {
        active,
        blackhole;

    }
}

