/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.GroupItemType;
import com.eucalyptus.compute.common.NetworkInterfaceAssociationType;
import com.eucalyptus.compute.common.NetworkInterfaceAttachmentType;
import com.eucalyptus.compute.common.NetworkInterfaceType;
import com.eucalyptus.compute.vpc.Lister;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.compute.vpc.NetworkInterfaceAssociation;
import com.eucalyptus.compute.vpc.NetworkInterfaceAttachment;
import com.eucalyptus.compute.vpc.NetworkInterfaceTag;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.network.NetworkGroups;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.Exceptions;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMapper;
import com.eucalyptus.util.TypeMappers;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.hibernate.criterion.Criterion;

public interface NetworkInterfaces
extends Lister<NetworkInterface> {
    @Override
    public <T> List<T> list(OwnerFullName var1, Criterion var2, Map<String, String> var3, Predicate<? super NetworkInterface> var4, Function<? super NetworkInterface, T> var5) throws VpcMetadataException;

    public <T> T lookupByName(@Nullable OwnerFullName var1, String var2, Function<? super NetworkInterface, T> var3) throws VpcMetadataException;

    public boolean delete(CloudMetadata.NetworkInterfaceMetadata var1) throws VpcMetadataException;

    public NetworkInterface save(NetworkInterface var1) throws VpcMetadataException;

    public NetworkInterface updateByExample(NetworkInterface var1, OwnerFullName var2, String var3, Callback<NetworkInterface> var4) throws VpcMetadataException;

    public static enum FilterDateFunctions implements Function<NetworkInterface, Date>
    {
        ATTACHMENT_ATTACH_TIME{

            public Date apply(NetworkInterface networkInterface) {
                return networkInterface.getAttachment() == null ? null : networkInterface.getAttachment().getAttachTime();
            }
        };

    }

    public static enum FilterIntegerFunctions implements Function<NetworkInterface, Integer>
    {
        ATTACHMENT_DEVICE_INDEX{

            public Integer apply(NetworkInterface networkInterface) {
                return networkInterface.getAttachment() == null ? null : networkInterface.getAttachment().getDeviceIndex();
            }
        };

    }

    public static enum FilterBooleanFunctions implements Function<NetworkInterface, Boolean>
    {
        ATTACHMENT_DELETE_ON_TERMINATION{

            public Boolean apply(NetworkInterface networkInterface) {
                return networkInterface.getAttachment() == null ? null : networkInterface.getAttachment().getDeleteOnTerminate();
            }
        }
        ,
        REQUESTER_MANAGED{

            public Boolean apply(NetworkInterface networkInterface) {
                return networkInterface.getRequesterManaged();
            }
        }
        ,
        SOURCE_DEST_CHECK{

            public Boolean apply(NetworkInterface networkInterface) {
                return networkInterface.getSourceDestCheck();
            }
        };

    }

    public static enum FilterStringSetFunctions implements Function<NetworkInterface, Set<String>>
    {
        GROUP_ID{

            public Set<String> apply(NetworkInterface networkInterface) {
                return FilterStringSetFunctions.networkGroupSet(networkInterface, NetworkGroups.groupId());
            }
        }
        ,
        GROUP_NAME{

            public Set<String> apply(NetworkInterface networkInterface) {
                return FilterStringSetFunctions.networkGroupSet(networkInterface, CloudMetadatas.toDisplayName());
            }
        };


        private static <T> Set<T> networkGroupSet(NetworkInterface networkInterface, Function<? super NetworkGroup, T> transform) {
            return networkInterface.getNetworkGroups() != null ? Sets.newHashSet((Iterable)Iterables.transform(networkInterface.getNetworkGroups(), transform)) : Collections.emptySet();
        }
    }

    public static enum FilterStringFunctions implements Function<NetworkInterface, String>
    {
        ASSOCIATION_ALLOCATION_ID{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getAssociation() == null ? null : networkInterface.getAssociation().getAllocationId();
            }
        }
        ,
        ASSOCIATION_ID{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getAssociation() == null ? null : networkInterface.getAssociation().getAssociationId();
            }
        }
        ,
        ASSOCIATION_IP_OWNER_ID{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getAssociation() == null ? null : networkInterface.getAssociation().getDisplayIpOwnerId();
            }
        }
        ,
        ASSOCIATION_PUBLIC_IP{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getAssociation() == null ? null : networkInterface.getAssociation().getPublicIp();
            }
        }
        ,
        ASSOCIATION_PUBLIC_DNS_NAME{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getAssociation() == null ? null : networkInterface.getAssociation().getPublicDnsName();
            }
        }
        ,
        ATTACHMENT_ATTACHMENT_ID{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getAttachment() == null ? null : networkInterface.getAttachment().getAttachmentId();
            }
        }
        ,
        ATTACHMENT_INSTANCE_ID{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getAttachment() == null ? null : networkInterface.getAttachment().getInstanceId();
            }
        }
        ,
        ATTACHMENT_INSTANCE_OWNER_ID{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getAttachment() == null ? null : networkInterface.getAttachment().getInstanceOwnerId();
            }
        }
        ,
        ATTACHMENT_STATUS{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getAttachment() == null ? null : Objects.toString((Object)networkInterface.getAttachment().getStatus(), null);
            }
        }
        ,
        AVAILABILITY_ZONE{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getAvailabilityZone();
            }
        }
        ,
        DESCRIPTION{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getDescription();
            }
        }
        ,
        MAC_ADDRESS{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getMacAddress();
            }
        }
        ,
        OWNER_ID{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getOwnerAccountNumber();
            }
        }
        ,
        PRIVATE_DNS_NAME{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getPrivateDnsName();
            }
        }
        ,
        PRIVATE_IP{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getPrivateIpAddress();
            }
        }
        ,
        REQUESTER_ID{

            public String apply(NetworkInterface networkInterface) {
                return networkInterface.getRequesterId();
            }
        }
        ,
        STATE{

            public String apply(NetworkInterface networkInterface) {
                return Objects.toString(networkInterface.getState(), null);
            }
        }
        ,
        SUBNET_ID{

            public String apply(NetworkInterface networkInterface) {
                return (String)CloudMetadatas.toDisplayName().apply((Object)networkInterface.getSubnet());
            }
        }
        ,
        VPC_ID{

            public String apply(NetworkInterface networkInterface) {
                return (String)CloudMetadatas.toDisplayName().apply((Object)networkInterface.getVpc());
            }
        };

    }

    public static class NetworkInterfaceFilterSupport
    extends FilterSupport<NetworkInterface> {
        public NetworkInterfaceFilterSupport() {
            super(NetworkInterfaceFilterSupport.builderFor(NetworkInterface.class).withTagFiltering(NetworkInterfaceTag.class, "networkInterface").withStringProperty("addresses.private-ip-address", FilterStringFunctions.PRIVATE_IP).withConstantProperty("addresses.primary", "true").withStringProperty("addresses.association.public-ip", FilterStringFunctions.ASSOCIATION_PUBLIC_IP).withStringProperty("addresses.association.owner-id", FilterStringFunctions.ASSOCIATION_IP_OWNER_ID).withStringProperty("association.allocation-id", FilterStringFunctions.ASSOCIATION_ALLOCATION_ID).withStringProperty("association.association-id", FilterStringFunctions.ASSOCIATION_ID).withStringProperty("association.ip-owner-id", FilterStringFunctions.ASSOCIATION_IP_OWNER_ID).withStringProperty("association.public-ip", FilterStringFunctions.ASSOCIATION_PUBLIC_IP).withStringProperty("association.public-dns-name", FilterStringFunctions.ASSOCIATION_PUBLIC_DNS_NAME).withStringProperty("attachment.attachment-id", FilterStringFunctions.ATTACHMENT_ATTACHMENT_ID).withStringProperty("attachment.instance-id", FilterStringFunctions.ATTACHMENT_INSTANCE_ID).withStringProperty("attachment.instance-owner-id", FilterStringFunctions.ATTACHMENT_INSTANCE_OWNER_ID).withIntegerProperty("attachment.device-index", FilterIntegerFunctions.ATTACHMENT_DEVICE_INDEX).withStringProperty("attachment.status", FilterStringFunctions.ATTACHMENT_STATUS).withDateProperty("attachment.attach.time", FilterDateFunctions.ATTACHMENT_ATTACH_TIME).withBooleanProperty("attachment.delete-on-termination", FilterBooleanFunctions.ATTACHMENT_DELETE_ON_TERMINATION).withStringProperty("availability-zone", FilterStringFunctions.AVAILABILITY_ZONE).withStringProperty("description", FilterStringFunctions.DESCRIPTION).withStringSetProperty("group-id", FilterStringSetFunctions.GROUP_ID).withStringSetProperty("group-name", FilterStringSetFunctions.GROUP_NAME).withStringProperty("mac-address", FilterStringFunctions.MAC_ADDRESS).withStringProperty("network-interface-id", (Function<NetworkInterface, String>)CloudMetadatas.toDisplayName()).withStringProperty("owner-id", FilterStringFunctions.OWNER_ID).withStringProperty("private-ip-address", FilterStringFunctions.PRIVATE_IP).withStringProperty("private-dns-name", FilterStringFunctions.PRIVATE_DNS_NAME).withStringProperty("requester-id", FilterStringFunctions.REQUESTER_ID).withBooleanProperty("requester-managed", FilterBooleanFunctions.REQUESTER_MANAGED).withBooleanProperty("source-dest-check", FilterBooleanFunctions.SOURCE_DEST_CHECK).withStringProperty("status", FilterStringFunctions.STATE).withStringProperty("subnet-id", FilterStringFunctions.SUBNET_ID).withStringProperty("vpc-id", FilterStringFunctions.VPC_ID).withPersistenceAlias("networkGroups", "networkGroups").withPersistenceAlias("subnet", "subnet").withPersistenceAlias("vpc", "vpc").withPersistenceFilter("addresses.private-ip-address", "privateIpAddress").withPersistenceFilter("addresses.association.public-ip", "association.publicIp", Collections.emptySet()).withPersistenceFilter("addresses.association.owner-id", "association.ipOwnerId", Collections.emptySet()).withPersistenceFilter("association.allocation-id", "association.allocationId", Collections.emptySet()).withPersistenceFilter("association.association-id", "association.associationId", Collections.emptySet()).withPersistenceFilter("association.ip-owner-id", "association.ipOwnerId", Collections.emptySet()).withPersistenceFilter("association.public-ip", "association.publicIp", Collections.emptySet()).withPersistenceFilter("association.public-dns-name", "association.publicDnsName", Collections.emptySet()).withPersistenceFilter("attachment.attachment-id", "attachment.attachmentId", Collections.emptySet()).withPersistenceFilter("attachment.instance-id", "attachment.instanceId", Collections.emptySet()).withPersistenceFilter("attachment.instance-owner-id", "attachment.instanceOwnerId", Collections.emptySet()).withPersistenceFilter("attachment.device-index", "attachment.deviceIndex", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("attachment.status", "attachment.status", Collections.emptySet(), Enums.valueOfFunction(NetworkInterfaceAttachment.Status.class)).withPersistenceFilter("attachment.attach.time", "attachment.attachTime", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Date).withPersistenceFilter("attachment.delete-on-termination", "attachment.deleteOnTerminate", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("availability-zone", "availabilityZone").withPersistenceFilter("description").withPersistenceFilter("group-id", "networkGroups.groupId").withPersistenceFilter("group-name", "networkGroups.displayName").withPersistenceFilter("mac-address", "macAddress").withPersistenceFilter("network-interface-id", "displayName").withPersistenceFilter("owner-id", "ownerAccountNumber").withPersistenceFilter("private-ip-address", "privateIpAddress").withPersistenceFilter("private-dns-name", "privateDnsName").withPersistenceFilter("requester-id", "requesterId").withPersistenceFilter("requester-managed", "requesterManaged", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("source-dest-check", "sourceDestCheck", Collections.emptySet(), FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("status", "state", Enums.valueOfFunction(NetworkInterface.State.class)).withPersistenceFilter("subnet-id", "subnet.displayName").withPersistenceFilter("vpc-id", "vpc.displayName"));
        }
    }

    @TypeMapper
    public static enum NetworkInterfaceAttachmentToNetworkInterfaceAttachmentTypeTransform implements Function<NetworkInterfaceAttachment, NetworkInterfaceAttachmentType>
    {
        INSTANCE;


        @Nullable
        public NetworkInterfaceAttachmentType apply(@Nullable NetworkInterfaceAttachment networkInterfaceAttachment) {
            return networkInterfaceAttachment == null ? null : new NetworkInterfaceAttachmentType(networkInterfaceAttachment.getAttachmentId(), networkInterfaceAttachment.getInstanceId(), networkInterfaceAttachment.getInstanceOwnerId(), networkInterfaceAttachment.getDeviceIndex(), networkInterfaceAttachment.getAttachTime(), networkInterfaceAttachment.getDeleteOnTerminate());
        }
    }

    @TypeMapper
    public static enum NetworkInterfaceAssociationToNetworkInterfaceAssociationTypeTransform implements Function<NetworkInterfaceAssociation, NetworkInterfaceAssociationType>
    {
        INSTANCE;


        @Nullable
        public NetworkInterfaceAssociationType apply(@Nullable NetworkInterfaceAssociation networkInterfaceAssociation) {
            return networkInterfaceAssociation == null ? null : new NetworkInterfaceAssociationType(networkInterfaceAssociation.getPublicIp(), networkInterfaceAssociation.getPublicDnsName(), networkInterfaceAssociation.getDisplayIpOwnerId(), networkInterfaceAssociation.getAllocationId(), networkInterfaceAssociation.getAssociationId());
        }
    }

    @TypeMapper
    public static enum NetworkInterfaceToNetworkInterfaceTypeTransform implements Function<NetworkInterface, NetworkInterfaceType>
    {
        INSTANCE;


        @Nullable
        public NetworkInterfaceType apply(@Nullable NetworkInterface networkInterface) {
            return networkInterface == null ? null : new NetworkInterfaceType(networkInterface.getDisplayName(), (String)CloudMetadatas.toDisplayName().apply((Object)networkInterface.getSubnet()), (String)CloudMetadatas.toDisplayName().apply((Object)networkInterface.getVpc()), networkInterface.getAvailabilityZone(), networkInterface.getDescription(), networkInterface.getOwnerAccountNumber(), networkInterface.getRequesterId(), networkInterface.getRequesterManaged(), Objects.toString(networkInterface.getState(), null), networkInterface.getMacAddress(), networkInterface.getPrivateIpAddress(), networkInterface.getPrivateDnsName(), networkInterface.getSourceDestCheck(), networkInterface.getAssociation() == null ? null : (NetworkInterfaceAssociationType)TypeMappers.transform((Object)networkInterface.getAssociation(), NetworkInterfaceAssociationType.class), networkInterface.getAttachment() == null ? null : (NetworkInterfaceAttachmentType)TypeMappers.transform((Object)networkInterface.getAttachment(), NetworkInterfaceAttachmentType.class), Collections2.transform(networkInterface.getNetworkGroups(), (Function)TypeMappers.lookup(NetworkGroup.class, GroupItemType.class)));
        }
    }

    @RestrictedTypes.Resolver(value=NetworkInterface.class)
    public static enum Lookup implements Function<String, NetworkInterface>
    {
        INSTANCE;


        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public NetworkInterface apply(String identifier) {
            try (TransactionResource tx = Entities.transactionFor(NetworkInterface.class);){
                NetworkInterface networkInterface = (NetworkInterface)((Object)Entities.uniqueResult((Object)((Object)NetworkInterface.exampleWithName(null, identifier))));
                return networkInterface;
            }
            catch (TransactionException e) {
                throw Exceptions.toUndeclared((Throwable)e);
            }
        }
    }
}

