/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_tags_network_interfaces")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="network-interface")
public class NetworkInterfaceTag
extends Tag<NetworkInterfaceTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private NetworkInterface networkInterface;

    protected NetworkInterfaceTag() {
        super("network-interface", ResourceIdFunction.INSTANCE);
    }

    public NetworkInterfaceTag(@Nonnull NetworkInterface networkInterface, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        super("network-interface", ResourceIdFunction.INSTANCE, ownerFullName, key, value);
        this.setNetworkInterface(networkInterface);
        this.init();
    }

    public NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    public void setNetworkInterface(NetworkInterface networkInterface) {
        this.networkInterface = networkInterface;
    }

    @Nonnull
    public static Tag named(@Nonnull NetworkInterface networkInterface, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return NetworkInterfaceTag.namedWithValue(networkInterface, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull NetworkInterface networkInterface, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)networkInterface), (Object)"networkInterface");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new NetworkInterfaceTag(networkInterface, ownerFullName, key, value);
    }

    public static final class NetworkInterfaceTagSupport
    extends TagSupport {
        public NetworkInterfaceTagSupport() {
            super(NetworkInterface.class, "eni", "displayName", "networkInterface", " InvalidNetworkInterfaceID.NotFound", "The network interface '%s' does not exist.");
        }

        @Override
        public Tag createOrUpdate(CloudMetadata metadata, OwnerFullName ownerFullName, String key, String value) {
            return Tags.createOrUpdate(new NetworkInterfaceTag((NetworkInterface)metadata, ownerFullName, key, value));
        }

        @Override
        public Tag example(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return NetworkInterfaceTag.namedWithValue((NetworkInterface)metadata, ownerFullName, key, value);
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new NetworkInterfaceTag(), ownerFullName);
        }

        @Override
        public CloudMetadata lookup(String identifier) throws TransactionException {
            return (CloudMetadata)Entities.uniqueResult((Object)((Object)NetworkInterface.exampleWithName(null, identifier)));
        }
    }

    private static enum ResourceIdFunction implements Function<NetworkInterfaceTag, String>
    {
        INSTANCE{

            public String apply(NetworkInterfaceTag networkInterfaceTag) {
                return networkInterfaceTag.getNetworkInterface().getDisplayName();
            }
        };

    }
}

