/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.address.Address;
import com.eucalyptus.address.Addresses;
import com.eucalyptus.cloud.util.ResourceAllocationException;
import com.eucalyptus.compute.common.network.Networking;
import com.eucalyptus.compute.common.network.PrepareNetworkResourcesResultType;
import com.eucalyptus.compute.common.network.PrepareNetworkResourcesType;
import com.eucalyptus.compute.common.network.PublicIPResource;
import com.eucalyptus.compute.common.network.ReleaseNetworkResourcesType;
import com.eucalyptus.compute.common.network.VpcNetworkInterfaceResource;
import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.compute.vpc.NetworkInterfaceAssociation;
import com.eucalyptus.util.dns.DomainNames;
import com.eucalyptus.vm.VmInstance;
import com.eucalyptus.vm.VmInstances;
import com.eucalyptus.vm.VmNetworkConfig;
import com.google.common.base.Optional;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import java.lang.ref.SoftReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.log4j.Logger;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.DefaultGroovyMethods;
import org.codehaus.groovy.runtime.GStringImpl;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;
import org.codehaus.groovy.runtime.callsite.CallSite;
import org.codehaus.groovy.runtime.callsite.CallSiteArray;
import org.codehaus.groovy.runtime.typehandling.DefaultTypeTransformation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkInterfaceHelper
implements GroovyObject {
    private static final Logger logger;
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;
    public static /* synthetic */ long __timeStamp;
    public static /* synthetic */ long __timeStamp__239_neverHappen1453166313777;
    private static /* synthetic */ SoftReference $callSiteArray;

    public NetworkInterfaceHelper() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static String mac(String identifier) {
        return String.format((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{VmInstances.MAC_PREFIX}, new String[]{"", ":%s:%s:%s:%s"}), String.class), identifier.substring(4, 6), identifier.substring(6, 8), identifier.substring(8, 10), identifier.substring(10, 12)).toLowerCase();
    }

    public static String allocate(String vpcId, String subnetId, String networkInterfaceId, String mac, String privateIp) throws ResourceAllocationException {
        Networking networking = Networking.getInstance();
        PrepareNetworkResourcesType prepareNetworkResourcesType = new PrepareNetworkResourcesType();
        prepareNetworkResourcesType.setVpc(vpcId);
        prepareNetworkResourcesType.setSubnet(subnetId);
        Object[] objectArray = new Object[1];
        VpcNetworkInterfaceResource vpcNetworkInterfaceResource = new VpcNetworkInterfaceResource();
        vpcNetworkInterfaceResource.setOwnerId(networkInterfaceId);
        vpcNetworkInterfaceResource.setValue(networkInterfaceId);
        vpcNetworkInterfaceResource.setMac(mac);
        vpcNetworkInterfaceResource.setPrivateIp(privateIp);
        objectArray[0] = vpcNetworkInterfaceResource;
        prepareNetworkResourcesType.setResources((ArrayList)ScriptBytecodeAdapter.asType((Object)ScriptBytecodeAdapter.createList((Object[])objectArray), ArrayList.class));
        PrepareNetworkResourcesResultType result = networking.prepare(prepareNetworkResourcesType);
        PrepareNetworkResourcesResultType prepareNetworkResourcesResultType = result;
        ArrayList arrayList = prepareNetworkResourcesResultType != null ? prepareNetworkResourcesResultType.getResources() : null;
        VpcNetworkInterfaceResource resource = (VpcNetworkInterfaceResource)ScriptBytecodeAdapter.asType((Object)(arrayList != null ? DefaultGroovyMethods.getAt((List)arrayList, (int)0) : null), VpcNetworkInterfaceResource.class);
        VpcNetworkInterfaceResource vpcNetworkInterfaceResource2 = resource;
        String allocatedIp = vpcNetworkInterfaceResource2 != null ? vpcNetworkInterfaceResource2.getPrivateIp() : null;
        if (!DefaultTypeTransformation.booleanUnbox((Object)allocatedIp)) {
            throw (Throwable)new ResourceAllocationException((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{privateIp}, new String[]{"Address (", ") not available"}), String.class));
        }
        return allocatedIp;
    }

    public static void associate(Address address, NetworkInterface networkInterface) {
        NetworkInterfaceHelper.associate(address, networkInterface, (Optional<VmInstance>)Optional.fromNullable((Object)((Object)networkInterface.getInstance())));
    }

    public static void associate(Address address, NetworkInterface networkInterface, Optional<VmInstance> instanceOption) {
        address.assign(networkInterface);
        if (instanceOption.isPresent() && VmInstance.VmStateSet.RUN.apply((VmInstance)((Object)ScriptBytecodeAdapter.castToType((Object)instanceOption.get(), VmInstance.class)))) {
            address.start((VmInstance)((Object)ScriptBytecodeAdapter.castToType((Object)instanceOption.get(), VmInstance.class)));
        }
        Boolean bl = networkInterface.getVpc().getDnsHostnames();
        networkInterface.associate(NetworkInterfaceAssociation.create(address.getAssociationId(), address.getAllocationId(), address.getOwnerAccountNumber(), address.getDisplayName(), (bl == null ? false : bl) ? VmInstances.dnsName(address.getDisplayName(), DomainNames.externalSubdomain()) : (String)ScriptBytecodeAdapter.asType(null, String.class)));
        if (instanceOption.isPresent()) {
            ((VmInstance)((Object)instanceOption.get())).updatePublicAddress(address.getDisplayName());
        }
    }

    public static void releasePublic(NetworkInterface networkInterface) {
        try {
            ArrayList resources = Lists.newArrayList();
            if (networkInterface.isAssociated()) {
                try {
                    Address address = (Address)((Object)ScriptBytecodeAdapter.castToType((Object)Addresses.getInstance().lookup(networkInterface.getAssociation().getPublicIp()), Address.class));
                    try {
                        if (address.isStarted()) {
                            address.stop();
                        }
                    }
                    catch (Exception e1) {
                        logger.error((Object)new GStringImpl(new Object[]{networkInterface.getAssociation().getPublicIp(), networkInterface.getDisplayName()}, new String[]{"Error stopping address '", "' for interface '", "' clean up."}), (Throwable)e1);
                    }
                    try {
                        address.unassign(networkInterface);
                    }
                    catch (Exception e2) {
                        logger.error((Object)new GStringImpl(new Object[]{networkInterface.getAssociation().getPublicIp(), networkInterface.getDisplayName()}, new String[]{"Error unassiging address '", "' for interface '", "'."}), (Throwable)e2);
                    }
                    if (address.isSystemOwned()) {
                        PublicIPResource publicIPResource = new PublicIPResource();
                        publicIPResource.setValue(networkInterface.getAssociation().getPublicIp());
                        DefaultGroovyMethods.leftShift((Collection)resources, (Object)publicIPResource);
                    }
                }
                catch (NoSuchElementException e) {
                    logger.warn((Object)new GStringImpl(new Object[]{networkInterface.getAssociation().getPublicIp(), networkInterface.getDisplayName()}, new String[]{"Address '", "' not found when releasing '", "'"}));
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)resources)) {
                Networking networking = Networking.getInstance();
                ReleaseNetworkResourcesType releaseNetworkResourcesType = new ReleaseNetworkResourcesType();
                releaseNetworkResourcesType.setVpc(networkInterface.getVpc().getDisplayName());
                releaseNetworkResourcesType.setResources(resources);
                networking.release(releaseNetworkResourcesType);
            }
        }
        catch (Exception ex) {
            logger.error((Object)new GStringImpl(new Object[]{networkInterface.getPrivateIpAddress(), networkInterface.getDisplayName()}, new String[]{"Error releasing public address '", "' for interface '", "'."}), (Throwable)ex);
        }
    }

    public static void start(NetworkInterface networkInterface, VmInstance instance) {
        if (networkInterface.isAssociated()) {
            try {
                Address address = (Address)((Object)ScriptBytecodeAdapter.castToType((Object)Addresses.getInstance().lookup(networkInterface.getAssociation().getPublicIp()), Address.class));
                try {
                    address.start(instance);
                }
                catch (Exception e) {
                    logger.error((Object)new GStringImpl(new Object[]{networkInterface.getAssociation().getPublicIp(), networkInterface.getDisplayName(), instance.getDisplayName()}, new String[]{"Error starting address '", "' for interface '", ", instance ", "'."}), (Throwable)e);
                }
            }
            catch (NoSuchElementException e) {
                logger.warn((Object)new GStringImpl(new Object[]{networkInterface.getAssociation().getPublicIp(), networkInterface.getDisplayName(), instance.getDisplayName()}, new String[]{"Address '", "' not found when stopping '", ", instance ", "'"}));
            }
        }
    }

    public static void stop(NetworkInterface networkInterface) {
        if (networkInterface.isAssociated()) {
            try {
                Address address = (Address)((Object)ScriptBytecodeAdapter.castToType((Object)Addresses.getInstance().lookup(networkInterface.getAssociation().getPublicIp()), Address.class));
                try {
                    if (address.isStarted()) {
                        address.stop();
                    }
                }
                catch (Exception e) {
                    logger.error((Object)new GStringImpl(new Object[]{networkInterface.getAssociation().getPublicIp(), networkInterface.getDisplayName()}, new String[]{"Error stopping address '", "' for interface '", "'."}), (Throwable)e);
                }
            }
            catch (NoSuchElementException e) {
                logger.warn((Object)new GStringImpl(new Object[]{networkInterface.getAssociation().getPublicIp(), networkInterface.getDisplayName()}, new String[]{"Address '", "' not found when stopping '", "'"}));
            }
        }
    }

    public static void release(NetworkInterface networkInterface) {
        try {
            ArrayList resources = Lists.newArrayList();
            if (!Strings.isNullOrEmpty((String)networkInterface.getPrivateIpAddress()) && !VmNetworkConfig.DEFAULT_IP.equals(networkInterface.getPrivateIpAddress())) {
                VpcNetworkInterfaceResource vpcNetworkInterfaceResource = new VpcNetworkInterfaceResource();
                vpcNetworkInterfaceResource.setValue(networkInterface.getDisplayName());
                vpcNetworkInterfaceResource.setMac(networkInterface.getMacAddress());
                vpcNetworkInterfaceResource.setPrivateIp(networkInterface.getPrivateIpAddress());
                DefaultGroovyMethods.leftShift((Collection)resources, (Object)vpcNetworkInterfaceResource);
            }
            if (networkInterface.isAssociated()) {
                try {
                    Address address = (Address)((Object)ScriptBytecodeAdapter.castToType((Object)Addresses.getInstance().lookup(networkInterface.getAssociation().getPublicIp()), Address.class));
                    try {
                        if (address.isStarted()) {
                            address.stop();
                        }
                    }
                    catch (Exception e1) {
                        logger.error((Object)new GStringImpl(new Object[]{networkInterface.getAssociation().getPublicIp(), networkInterface.getDisplayName()}, new String[]{"Error stopping address '", "' for interface '", "' clean up."}), (Throwable)e1);
                    }
                    try {
                        address.unassign(networkInterface);
                    }
                    catch (Exception e2) {
                        logger.error((Object)new GStringImpl(new Object[]{networkInterface.getAssociation().getPublicIp(), networkInterface.getDisplayName()}, new String[]{"Error unassiging address '", "' for interface '", "' clean up."}), (Throwable)e2);
                    }
                    if (address.isSystemOwned()) {
                        PublicIPResource publicIPResource = new PublicIPResource();
                        publicIPResource.setValue(networkInterface.getAssociation().getPublicIp());
                        DefaultGroovyMethods.leftShift((Collection)resources, (Object)publicIPResource);
                    }
                }
                catch (NoSuchElementException e) {
                    logger.warn((Object)new GStringImpl(new Object[]{networkInterface.getAssociation().getPublicIp(), networkInterface.getDisplayName()}, new String[]{"Address '", "' not found when releasing '", "'"}));
                }
            }
            if (DefaultTypeTransformation.booleanUnbox((Object)resources)) {
                Networking networking = Networking.getInstance();
                ReleaseNetworkResourcesType releaseNetworkResourcesType = new ReleaseNetworkResourcesType();
                releaseNetworkResourcesType.setVpc(networkInterface.getVpc().getDisplayName());
                releaseNetworkResourcesType.setResources(resources);
                networking.release(releaseNetworkResourcesType);
            }
        }
        catch (Exception ex) {
            logger.error((Object)new GStringImpl(new Object[]{networkInterface.getPrivateIpAddress(), networkInterface.getDisplayName()}, new String[]{"Error releasing private address '", "' for interface '", "' clean up."}), (Throwable)ex);
        }
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != NetworkInterfaceHelper.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    public /* synthetic */ Object this$dist$invoke$1(String name, Object args) {
        return ScriptBytecodeAdapter.invokeMethodOnCurrentN(NetworkInterfaceHelper.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)), (Object[])ScriptBytecodeAdapter.despreadList((Object[])new Object[0], (Object[])new Object[]{args}, (int[])new int[]{0}));
    }

    public /* synthetic */ void this$dist$set$1(String name, Object value) {
        Object object = value;
        ScriptBytecodeAdapter.setGroovyObjectField((Object)object, NetworkInterfaceHelper.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ Object this$dist$get$1(String name) {
        return ScriptBytecodeAdapter.getGroovyObjectField(NetworkInterfaceHelper.class, (GroovyObject)this, (String)((String)ScriptBytecodeAdapter.castToType((Object)new GStringImpl(new Object[]{name}, new String[]{"", ""}), String.class)));
    }

    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }

    public static /* synthetic */ void __$swapInit() {
    }

    static {
        Logger logger;
        long l;
        long l2;
        NetworkInterfaceHelper.__$swapInit();
        __timeStamp__239_neverHappen1453166313777 = l2 = 0L;
        __timeStamp = l = 1453166313777L;
        NetworkInterfaceHelper.logger = logger = Logger.getLogger(NetworkInterfaceHelper.class);
    }

    public /* synthetic */ void super$1$wait() {
        super.wait();
    }

    public /* synthetic */ String super$1$toString() {
        return super.toString();
    }

    public /* synthetic */ void super$1$wait(long l) {
        super.wait(l);
    }

    public /* synthetic */ void super$1$wait(long l, int n) {
        super.wait(l, n);
    }

    public /* synthetic */ void super$1$notify() {
        super.notify();
    }

    public /* synthetic */ void super$1$notifyAll() {
        super.notifyAll();
    }

    public /* synthetic */ Class super$1$getClass() {
        return super.getClass();
    }

    public /* synthetic */ Object super$1$clone() {
        return super.clone();
    }

    public /* synthetic */ boolean super$1$equals(Object object) {
        return super.equals(object);
    }

    public /* synthetic */ int super$1$hashCode() {
        return super.hashCode();
    }

    public /* synthetic */ void super$1$finalize() {
        super.finalize();
    }

    private static /* synthetic */ CallSiteArray $createCallSiteArray() {
        String[] stringArray = new String[]{};
        return new CallSiteArray(NetworkInterfaceHelper.class, stringArray);
    }

    private static /* synthetic */ CallSite[] $getCallSiteArray() {
        CallSiteArray callSiteArray;
        if ($callSiteArray == null || (callSiteArray = (CallSiteArray)$callSiteArray.get()) == null) {
            callSiteArray = NetworkInterfaceHelper.$createCallSiteArray();
            $callSiteArray = new SoftReference<CallSiteArray>(callSiteArray);
        }
        return callSiteArray.array;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

