/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.vpc.NetworkInterface;
import com.eucalyptus.vm.VmInstance;
import java.io.Serializable;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Embeddable;
import javax.persistence.Transient;
import org.hibernate.annotations.Parent;

@Embeddable
public class NetworkInterfaceAttachment
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Parent
    private NetworkInterface networkInterface;
    @Transient
    private VmInstance instance;
    @Column(name="metadata_attachment_id")
    private String attachmentId;
    @Column(name="metadata_att_instance_id")
    private String instanceId;
    @Column(name="metadata_att_instance_owner_id")
    private String instanceOwnerId;
    @Column(name="metadata_att_device_index")
    private Integer deviceIndex;
    @Column(name="metadata_att_status")
    private Status status;
    @Column(name="metadata_att_time")
    private Date attachTime;
    @Column(name="metadata_att_delete_on_term")
    private Boolean deleteOnTerminate;

    protected NetworkInterfaceAttachment() {
    }

    protected NetworkInterfaceAttachment(String attachmentId, VmInstance instance, String instanceId, String instanceOwnerId, Integer deviceIndex, Status status, Date attachTime, Boolean deleteOnTerminate) {
        this.attachmentId = attachmentId;
        this.instance = instance;
        this.instanceId = instanceId;
        this.instanceOwnerId = instanceOwnerId;
        this.deviceIndex = deviceIndex;
        this.status = status;
        this.attachTime = attachTime;
        this.deleteOnTerminate = deleteOnTerminate;
    }

    public static NetworkInterfaceAttachment create(String attachmentId, VmInstance instance, String instanceId, String instanceOwnerId, Integer deviceIndex, Status status, Date attachTime, Boolean deleteOnTerminate) {
        return new NetworkInterfaceAttachment(attachmentId, instance, instanceId, instanceOwnerId, deviceIndex, status, attachTime, deleteOnTerminate);
    }

    protected NetworkInterface getNetworkInterface() {
        return this.networkInterface;
    }

    protected void setNetworkInterface(NetworkInterface networkInterface) {
        this.networkInterface = networkInterface;
    }

    public String getAttachmentId() {
        return this.attachmentId;
    }

    public void setAttachmentId(String attachmentId) {
        this.attachmentId = attachmentId;
    }

    public VmInstance getInstance() {
        return this.instance;
    }

    public void setInstance(VmInstance instance) {
        this.instance = instance;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceOwnerId() {
        return this.instanceOwnerId;
    }

    public void setInstanceOwnerId(String instanceOwnerId) {
        this.instanceOwnerId = instanceOwnerId;
    }

    public Integer getDeviceIndex() {
        return this.deviceIndex;
    }

    public void setDeviceIndex(Integer deviceIndex) {
        this.deviceIndex = deviceIndex;
    }

    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    public Date getAttachTime() {
        return this.attachTime;
    }

    public void setAttachTime(Date attachTime) {
        this.attachTime = attachTime;
    }

    public Boolean getDeleteOnTerminate() {
        return this.deleteOnTerminate;
    }

    public void setDeleteOnTerminate(Boolean deleteOnTerminate) {
        this.deleteOnTerminate = deleteOnTerminate;
    }

    public static enum Status {
        attaching,
        attached,
        detaching,
        detached;

    }
}

