/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.auth.principal.Principals;
import java.io.Serializable;
import javax.persistence.Column;
import javax.persistence.Embeddable;

@Embeddable
public class NetworkInterfaceAssociation
implements Serializable {
    private static final long serialVersionUID = 1L;
    @Column(name="metadata_association_id")
    private String associationId;
    @Column(name="metadata_association_allocation_id")
    private String allocationId;
    @Column(name="metadata_association_ip_owner_id")
    private String ipOwnerId;
    @Column(name="metadata_association_address")
    private String publicIp;
    @Column(name="metadata_association_public_dns")
    private String publicDnsName;

    protected NetworkInterfaceAssociation() {
    }

    protected NetworkInterfaceAssociation(String associationId, String allocationId, String ipOwnerId, String publicIp, String publicDnsName) {
        this.associationId = associationId;
        this.allocationId = allocationId;
        this.ipOwnerId = ipOwnerId;
        this.publicIp = publicIp;
        this.publicDnsName = publicDnsName;
    }

    public static NetworkInterfaceAssociation create(String associationId, String allocationId, String ipOwnerId, String publicIp, String publicDnsName) {
        return new NetworkInterfaceAssociation(associationId, allocationId, ipOwnerId, publicIp, publicDnsName);
    }

    public String getAssociationId() {
        return this.associationId;
    }

    public void setAssociationId(String associationId) {
        this.associationId = associationId;
    }

    public String getAllocationId() {
        return this.allocationId;
    }

    public void setAllocationId(String allocationId) {
        this.allocationId = allocationId;
    }

    public String getIpOwnerId() {
        return this.ipOwnerId;
    }

    public void setIpOwnerId(String ipOwnerId) {
        this.ipOwnerId = ipOwnerId;
    }

    public String getDisplayIpOwnerId() {
        return Principals.isFakeIdentityAccountNumber((String)this.ipOwnerId) ? Principals.systemAccount().getName() : this.ipOwnerId;
    }

    public String getPublicIp() {
        return this.publicIp;
    }

    public void setPublicIp(String publicIp) {
        this.publicIp = publicIp;
    }

    public String getPublicDnsName() {
        return this.publicDnsName;
    }

    public void setPublicDnsName(String publicDnsName) {
        this.publicDnsName = publicDnsName;
    }
}

