/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.component.ComponentIds;
import com.eucalyptus.component.id.Eucalyptus;
import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.NetworkInterfaceAssociation;
import com.eucalyptus.compute.vpc.NetworkInterfaceAttachment;
import com.eucalyptus.compute.vpc.NetworkInterfaceTag;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.entities.UserMetadata;
import com.eucalyptus.network.NetworkGroup;
import com.eucalyptus.util.FullName;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.vm.VmInstance;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.PostLoad;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;
import org.hibernate.annotations.NotFound;
import org.hibernate.annotations.NotFoundAction;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_network_interfaces")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class NetworkInterface
extends UserMetadata<State>
implements CloudMetadata.NetworkInterfaceMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_vpc_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Vpc vpc;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_subnet_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Subnet subnet;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="metadata_instance_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private VmInstance instance;
    @NotFound(action=NotFoundAction.IGNORE)
    @JoinTable(name="metadata_network_interfaces_groups", joinColumns={@JoinColumn(name="networkinterface_id")}, inverseJoinColumns={@JoinColumn(name="networkgroup_id")})
    @ManyToMany
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Set<NetworkGroup> networkGroups = Sets.newHashSet();
    @Column(name="metadata_zone", nullable=false, updatable=false)
    private String availabilityZone;
    @Column(name="metadata_description", nullable=false)
    private String description;
    @Column(name="metadata_requester_id", updatable=false)
    private String requesterId;
    @Column(name="metadata_requester_managed", nullable=false)
    private Boolean requesterManaged;
    @Column(name="metadata_mac_address", nullable=false)
    private String macAddress;
    @Column(name="metadata_private_ip", nullable=false)
    private String privateIpAddress;
    @Column(name="metadata_private_name")
    private String privateDnsName;
    @Column(name="metadata_source_dest_check", nullable=false)
    private Boolean sourceDestCheck;
    @Embedded
    private NetworkInterfaceAttachment attachment;
    @Embedded
    private NetworkInterfaceAssociation association;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="networkInterface")
    private Collection<NetworkInterfaceTag> tags;

    protected NetworkInterface() {
    }

    protected NetworkInterface(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static NetworkInterface create(OwnerFullName owner, Vpc vpc, Subnet subnet, Set<NetworkGroup> networkGroups, String displayName, String macAddress, String privateIp, String privateDnsName, String description) {
        NetworkInterface networkInterface = new NetworkInterface(owner, displayName);
        networkInterface.setVpc(vpc);
        networkInterface.setSubnet(subnet);
        networkInterface.setNetworkGroups(networkGroups);
        networkInterface.setAvailabilityZone(subnet.getAvailabilityZone());
        networkInterface.setDescription(description);
        networkInterface.setState(State.available);
        networkInterface.setSourceDestCheck(true);
        networkInterface.setRequesterManaged(false);
        networkInterface.setMacAddress(macAddress);
        networkInterface.setPrivateIpAddress(privateIp);
        networkInterface.setPrivateDnsName(privateDnsName);
        return networkInterface;
    }

    public static NetworkInterface exampleWithOwner(OwnerFullName owner) {
        return new NetworkInterface(owner, null);
    }

    public static NetworkInterface exampleWithName(OwnerFullName owner, String name) {
        return new NetworkInterface(owner, name);
    }

    public String getPartition() {
        return "eucalyptus";
    }

    public FullName getFullName() {
        return FullName.create.vendor((String)"euca").region(((Eucalyptus)ComponentIds.lookup(Eucalyptus.class)).name()).namespace(this.getOwnerAccountNumber()).relativeId(new String[]{"network-interface", this.getDisplayName()});
    }

    public Vpc getVpc() {
        return this.vpc;
    }

    public void setVpc(Vpc vpc) {
        this.vpc = vpc;
    }

    public Subnet getSubnet() {
        return this.subnet;
    }

    public void setSubnet(Subnet subnet) {
        this.subnet = subnet;
    }

    public Set<NetworkGroup> getNetworkGroups() {
        return this.networkGroups;
    }

    public void setNetworkGroups(Set<NetworkGroup> networkGroups) {
        this.networkGroups = networkGroups;
    }

    VmInstance getInstance() {
        return this.instance;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getRequesterId() {
        return this.requesterId;
    }

    public void setRequesterId(String requesterId) {
        this.requesterId = requesterId;
    }

    public Boolean getRequesterManaged() {
        return this.requesterManaged;
    }

    public void setRequesterManaged(Boolean requesterManaged) {
        this.requesterManaged = requesterManaged;
    }

    public String getMacAddress() {
        return this.macAddress;
    }

    public void setMacAddress(String macAddress) {
        this.macAddress = macAddress;
    }

    public String getPrivateIpAddress() {
        return this.privateIpAddress;
    }

    public void setPrivateIpAddress(String privateIpAddress) {
        this.privateIpAddress = privateIpAddress;
    }

    public String getPrivateDnsName() {
        return this.privateDnsName;
    }

    public void setPrivateDnsName(String privateDnsName) {
        this.privateDnsName = privateDnsName;
    }

    public Boolean getSourceDestCheck() {
        return this.sourceDestCheck;
    }

    public void setSourceDestCheck(Boolean sourceDestCheck) {
        this.sourceDestCheck = sourceDestCheck;
    }

    public boolean isAttached() {
        return this.attachment != null;
    }

    public NetworkInterfaceAttachment getAttachment() {
        return this.attachment;
    }

    public void attach(NetworkInterfaceAttachment attachment) {
        if (this.isAttached()) {
            throw new IllegalStateException("Already attached");
        }
        this.setState(State.in_use);
        this.attachment = attachment;
        this.instance = attachment.getInstance();
    }

    public void detach() {
        if (this.attachment != null) {
            this.setState(State.available);
        }
        this.attachment = null;
        this.instance = null;
    }

    public boolean isAssociated() {
        return this.association != null;
    }

    public NetworkInterfaceAssociation getAssociation() {
        return this.association;
    }

    public void associate(NetworkInterfaceAssociation association) {
        if (this.isAssociated()) {
            throw new IllegalStateException("Already associated");
        }
        this.association = association;
        this.updateTimeStamps();
    }

    public void disassociate() {
        this.association = null;
    }

    @PostLoad
    protected void postLoad() {
        if (this.isAttached()) {
            this.getAttachment().setInstance(this.instance);
        }
    }

    public static enum State {
        available,
        attaching,
        in_use("in-use"),
        detaching;

        private final String value;

        private State() {
            this.value = this.name();
        }

        private State(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

