/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.NetworkAclAssociationType;
import com.eucalyptus.compute.common.NetworkAclEntryType;
import com.eucalyptus.compute.common.NetworkAclType;
import com.eucalyptus.compute.vpc.Lister;
import com.eucalyptus.compute.vpc.NetworkAcl;
import com.eucalyptus.compute.vpc.NetworkAclEntry;
import com.eucalyptus.compute.vpc.NetworkAclTag;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.compute.vpc.Subnets;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.entities.AbstractPersistentSupport;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Enums;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Iterables;
import com.google.common.collect.Ordering;
import com.google.common.collect.Sets;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import org.hibernate.criterion.Criterion;

public interface NetworkAcls
extends Lister<NetworkAcl> {
    public static final Ordering<NetworkAclEntry> ENTRY_ORDERING = Ordering.natural().reverse().onResultOf((Function)NetworkAclEntryFilterBooleanFunctions.EGRESS).compound((Comparator)Ordering.natural().onResultOf((Function)NetworkAclEntryFilterIntegerFunctions.RULE_NUMBER));

    @Override
    public <T> List<T> list(OwnerFullName var1, Criterion var2, Map<String, String> var3, Predicate<? super NetworkAcl> var4, Function<? super NetworkAcl, T> var5) throws VpcMetadataException;

    public long countByExample(NetworkAcl var1, Criterion var2, Map<String, String> var3) throws VpcMetadataException;

    public <T> T lookupByName(@Nullable OwnerFullName var1, String var2, Function<? super NetworkAcl, T> var3) throws VpcMetadataException;

    public <T> T lookupDefault(String var1, Function<? super NetworkAcl, T> var2) throws VpcMetadataException;

    public boolean delete(CloudMetadata.NetworkAclMetadata var1) throws VpcMetadataException;

    public NetworkAcl save(NetworkAcl var1) throws VpcMetadataException;

    public NetworkAcl updateByExample(NetworkAcl var1, OwnerFullName var2, String var3, Callback<NetworkAcl> var4) throws VpcMetadataException;

    public AbstractPersistentSupport<CloudMetadata.NetworkAclMetadata, NetworkAcl, VpcMetadataException> withRetries();

    public static enum FilterIntegerSetFunctions implements Function<NetworkAcl, Set<Integer>>
    {
        ICMP_CODE{

            public Set<Integer> apply(NetworkAcl networkAcl) {
                return FilterStringSetFunctions.entryPropertySet(networkAcl, NetworkAclEntryFilterIntegerFunctions.ICMP_CODE);
            }
        }
        ,
        ICMP_TYPE{

            public Set<Integer> apply(NetworkAcl networkAcl) {
                return FilterStringSetFunctions.entryPropertySet(networkAcl, NetworkAclEntryFilterIntegerFunctions.ICMP_TYPE);
            }
        }
        ,
        PORT_FROM{

            public Set<Integer> apply(NetworkAcl networkAcl) {
                return FilterStringSetFunctions.entryPropertySet(networkAcl, NetworkAclEntryFilterIntegerFunctions.PORT_FROM);
            }
        }
        ,
        PORT_TO{

            public Set<Integer> apply(NetworkAcl networkAcl) {
                return FilterStringSetFunctions.entryPropertySet(networkAcl, NetworkAclEntryFilterIntegerFunctions.PORT_TO);
            }
        }
        ,
        PROTOCOL{

            public Set<Integer> apply(NetworkAcl networkAcl) {
                return FilterStringSetFunctions.entryPropertySet(networkAcl, NetworkAclEntryFilterIntegerFunctions.PROTOCOL);
            }
        }
        ,
        RULE_NUMBER{

            public Set<Integer> apply(NetworkAcl networkAcl) {
                return FilterStringSetFunctions.entryPropertySet(networkAcl, NetworkAclEntryFilterIntegerFunctions.RULE_NUMBER);
            }
        };

    }

    public static enum FilterBooleanSetFunctions implements Function<NetworkAcl, Set<Boolean>>
    {
        ENTRY_EGRESS{

            public Set<Boolean> apply(NetworkAcl networkAcl) {
                return FilterStringSetFunctions.entryPropertySet(networkAcl, NetworkAclEntryFilterBooleanFunctions.EGRESS);
            }
        };

    }

    public static enum FilterStringSetFunctions implements Function<NetworkAcl, Set<String>>
    {
        ASSOCIATION_ID{

            public Set<String> apply(NetworkAcl networkAcl) {
                return 1.subnetPropertySet(networkAcl, Subnets.FilterStringFunctions.NETWORK_ACL_ASSOCIATION_ID);
            }
        }
        ,
        ASSOCIATION_SUBNET_ID{

            public Set<String> apply(NetworkAcl networkAcl) {
                return 2.subnetPropertySet(networkAcl, CloudMetadatas.toDisplayName());
            }
        }
        ,
        ENTRY_CIDR{

            public Set<String> apply(NetworkAcl networkAcl) {
                return 3.entryPropertySet(networkAcl, NetworkAclEntryFilterStringFunctions.CIDR);
            }
        }
        ,
        ENTRY_RULE_ACTION{

            public Set<String> apply(NetworkAcl networkAcl) {
                return 4.entryPropertySet(networkAcl, NetworkAclEntryFilterStringFunctions.RULE_ACTION);
            }
        };


        static <T> Set<T> entryPropertySet(NetworkAcl networkAcl, Function<? super NetworkAclEntry, T> propertyGetter) {
            return Sets.newHashSet((Iterable)Iterables.transform(networkAcl.getEntries(), propertyGetter));
        }

        static <T> Set<T> subnetPropertySet(NetworkAcl networkAcl, Function<? super Subnet, T> propertyGetter) {
            return Sets.newHashSet((Iterable)Iterables.transform(networkAcl.getSubnets(), propertyGetter));
        }
    }

    public static enum NetworkAclEntryFilterIntegerFunctions implements Function<NetworkAclEntry, Integer>
    {
        ICMP_CODE{

            public Integer apply(NetworkAclEntry entry) {
                return entry.getIcmpCode();
            }
        }
        ,
        ICMP_TYPE{

            public Integer apply(NetworkAclEntry entry) {
                return entry.getIcmpType();
            }
        }
        ,
        PORT_FROM{

            public Integer apply(NetworkAclEntry entry) {
                return entry.getPortRangeFrom();
            }
        }
        ,
        PORT_TO{

            public Integer apply(NetworkAclEntry entry) {
                return entry.getPortRangeTo();
            }
        }
        ,
        PROTOCOL{

            public Integer apply(NetworkAclEntry entry) {
                return entry.getProtocol();
            }
        }
        ,
        RULE_NUMBER{

            public Integer apply(NetworkAclEntry entry) {
                return entry.getRuleNumber();
            }
        };

    }

    public static enum NetworkAclEntryFilterBooleanFunctions implements Function<NetworkAclEntry, Boolean>
    {
        EGRESS{

            public Boolean apply(NetworkAclEntry entry) {
                return entry.getEgress();
            }
        };

    }

    public static enum NetworkAclEntryFilterStringFunctions implements Function<NetworkAclEntry, String>
    {
        CIDR{

            public String apply(NetworkAclEntry entry) {
                return entry.getCidr();
            }
        }
        ,
        RULE_ACTION{

            public String apply(NetworkAclEntry entry) {
                return Objects.toString((Object)entry.getRuleAction(), null);
            }
        };

    }

    public static enum FilterBooleanFunctions implements Function<NetworkAcl, Boolean>
    {
        DEFAULT_FOR_VPC{

            public Boolean apply(NetworkAcl networkAcl) {
                return networkAcl.getDefaultForVpc();
            }
        };

    }

    public static enum FilterStringFunctions implements Function<NetworkAcl, String>
    {
        ASSOCIATION_NETWORK_ACL_ID{

            public String apply(NetworkAcl networkAcl) {
                return networkAcl.getSubnets().isEmpty() ? null : networkAcl.getDisplayName();
            }
        }
        ,
        VPC_ID{

            public String apply(NetworkAcl networkAcl) {
                return networkAcl.getVpc().getDisplayName();
            }
        };

    }

    public static class NetworkAclFilterSupport
    extends FilterSupport<NetworkAcl> {
        public NetworkAclFilterSupport() {
            super(NetworkAclFilterSupport.builderFor(NetworkAcl.class).withTagFiltering(NetworkAclTag.class, "networkAcl").withStringSetProperty("association.association-id", FilterStringSetFunctions.ASSOCIATION_ID).withStringProperty("association.network-acl-id", FilterStringFunctions.ASSOCIATION_NETWORK_ACL_ID).withStringSetProperty("association.subnet-id", FilterStringSetFunctions.ASSOCIATION_SUBNET_ID).withBooleanProperty("default", FilterBooleanFunctions.DEFAULT_FOR_VPC).withStringSetProperty("entry.cidr", FilterStringSetFunctions.ENTRY_CIDR).withBooleanSetProperty("entry.egress", FilterBooleanSetFunctions.ENTRY_EGRESS).withIntegerSetProperty("entry.icmp.code", FilterIntegerSetFunctions.ICMP_CODE).withIntegerSetProperty("entry.icmp.type", FilterIntegerSetFunctions.ICMP_TYPE).withIntegerSetProperty("entry.port-range.from", FilterIntegerSetFunctions.PORT_FROM).withIntegerSetProperty("entry.port-range.to", FilterIntegerSetFunctions.PORT_TO).withIntegerSetProperty("entry.protocol", FilterIntegerSetFunctions.PROTOCOL, ProtocolValueFunction.INSTANCE).withStringSetProperty("entry.rule-action", FilterStringSetFunctions.ENTRY_RULE_ACTION).withIntegerSetProperty("entry.rule-number", FilterIntegerSetFunctions.RULE_NUMBER).withStringProperty("network-acl-id", (Function<NetworkAcl, String>)CloudMetadatas.toDisplayName()).withStringProperty("vpc-id", FilterStringFunctions.VPC_ID).withPersistenceAlias("subnets", "subnets").withPersistenceAlias("entries", "entries").withPersistenceAlias("vpc", "vpc").withPersistenceFilter("association.association-id", "subnets.networkAclAssociationId").withPersistenceFilter("association.subnet-id", "subnets.displayName").withPersistenceFilter("default", "defaultForVpc", FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("entry.cidr", "entries.cidr").withPersistenceFilter("entry.egress", "entries.egress", FilterSupport.PersistenceFilter.Type.Boolean).withPersistenceFilter("entry.icmp.code", "entries.icmpCode", FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("entry.icmp.type", "entries.icmpType", FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("entry.port-range.from", "entries.portRangeFrom", FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("entry.port-range.to", "entries.portRangeTo", FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("entry.protocol", "entries.protocol", ProtocolValueFunction.INSTANCE).withPersistenceFilter("entry.rule-action", "entries.ruleAction", Enums.valueOfFunction(NetworkAclEntry.RuleAction.class)).withPersistenceFilter("entry.rule-number", "entries.ruleNumber", FilterSupport.PersistenceFilter.Type.Integer).withPersistenceFilter("network-acl-id", "displayName").withPersistenceFilter("vpc-id", "vpc.displayName"));
        }

        private static enum ProtocolValueFunction implements Function<String, Integer>
        {
            INSTANCE{

                @Nullable
                public Integer apply(String value) {
                    switch (value.toLowerCase()) {
                        case "tcp": {
                            return 6;
                        }
                        case "udp": {
                            return 17;
                        }
                        case "icmp": {
                            return 1;
                        }
                    }
                    return Ints.tryParse((String)value);
                }
            };

        }
    }

    @TypeMapper
    public static enum SubnetToNetworkAclAssociationType implements Function<Subnet, NetworkAclAssociationType>
    {
        INSTANCE;


        @Nullable
        public NetworkAclAssociationType apply(@Nullable Subnet subnet) {
            return subnet == null ? null : new NetworkAclAssociationType(subnet.getNetworkAclAssociationId(), subnet.getNetworkAcl().getDisplayName(), subnet.getDisplayName());
        }
    }

    @TypeMapper
    public static enum NetworkAclEntryToNetworkAclEntryType implements Function<NetworkAclEntry, NetworkAclEntryType>
    {
        INSTANCE;


        @Nullable
        public NetworkAclEntryType apply(@Nullable NetworkAclEntry networkAclEntry) {
            return networkAclEntry == null ? null : new NetworkAclEntryType(networkAclEntry.getRuleNumber(), Integer.toString(networkAclEntry.getProtocol()), networkAclEntry.getRuleAction().toString(), networkAclEntry.getEgress(), networkAclEntry.getCidr(), networkAclEntry.getIcmpCode(), networkAclEntry.getIcmpType(), networkAclEntry.getPortRangeFrom(), networkAclEntry.getPortRangeTo());
        }
    }

    @TypeMapper
    public static enum NetworkAclToNetworkAclTypeTransform implements Function<NetworkAcl, NetworkAclType>
    {
        INSTANCE;


        @Nullable
        public NetworkAclType apply(@Nullable NetworkAcl networkAcl) {
            return networkAcl == null ? null : new NetworkAclType(networkAcl.getDisplayName(), networkAcl.getVpc().getDisplayName(), networkAcl.getDefaultForVpc(), Collections2.transform((Collection)ENTRY_ORDERING.sortedCopy(networkAcl.getEntries()), (Function)NetworkAclEntryToNetworkAclEntryType.INSTANCE), Collections2.transform(networkAcl.getSubnets(), (Function)SubnetToNetworkAclAssociationType.INSTANCE));
        }
    }
}

