/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.NetworkAcl;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionException;
import com.eucalyptus.tags.Tag;
import com.eucalyptus.tags.TagSupport;
import com.eucalyptus.tags.Tags;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_tags_network_acls")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
@DiscriminatorValue(value="network-acl")
public class NetworkAclTag
extends Tag<NetworkAclTag> {
    private static final long serialVersionUID = 1L;
    @JoinColumn(name="metadata_tag_resource_id", updatable=false, nullable=false)
    @ManyToOne(fetch=FetchType.LAZY)
    private NetworkAcl networkAcl;

    protected NetworkAclTag() {
        super("network-acl", ResourceIdFunction.INSTANCE);
    }

    public NetworkAclTag(@Nonnull NetworkAcl networkAcl, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        super("network-acl", ResourceIdFunction.INSTANCE, ownerFullName, key, value);
        this.setNetworkAcl(networkAcl);
        this.init();
    }

    public NetworkAcl getNetworkAcl() {
        return this.networkAcl;
    }

    public void setNetworkAcl(NetworkAcl networkAcl) {
        this.networkAcl = networkAcl;
    }

    @Nonnull
    public static Tag named(@Nonnull NetworkAcl networkAcl, @Nonnull OwnerFullName ownerFullName, @Nullable String key) {
        return NetworkAclTag.namedWithValue(networkAcl, ownerFullName, key, null);
    }

    @Nonnull
    public static Tag namedWithValue(@Nonnull NetworkAcl networkAcl, @Nonnull OwnerFullName ownerFullName, @Nullable String key, @Nullable String value) {
        Preconditions.checkNotNull((Object)((Object)networkAcl), (Object)"networkAcl");
        Preconditions.checkNotNull((Object)ownerFullName, (Object)"ownerFullName");
        return new NetworkAclTag(networkAcl, ownerFullName, key, value);
    }

    public static final class NetworkAclTagSupport
    extends TagSupport {
        public NetworkAclTagSupport() {
            super(NetworkAcl.class, "acl", "displayName", "networkAcl", " InvalidNetworkAclID.NotFound", "The network ACL '%s' does not exist.");
        }

        @Override
        public Tag createOrUpdate(CloudMetadata metadata, OwnerFullName ownerFullName, String key, String value) {
            return Tags.createOrUpdate(new NetworkAclTag((NetworkAcl)metadata, ownerFullName, key, value));
        }

        @Override
        public Tag example(@Nonnull CloudMetadata metadata, @Nonnull OwnerFullName ownerFullName, String key, String value) {
            return NetworkAclTag.namedWithValue((NetworkAcl)metadata, ownerFullName, key, value);
        }

        @Override
        public Tag example(@Nonnull OwnerFullName ownerFullName) {
            return this.example(new NetworkAclTag(), ownerFullName);
        }

        @Override
        public CloudMetadata lookup(String identifier) throws TransactionException {
            return (CloudMetadata)Entities.uniqueResult((Object)((Object)NetworkAcl.exampleWithName(null, identifier)));
        }
    }

    private static enum ResourceIdFunction implements Function<NetworkAclTag, String>
    {
        INSTANCE{

            public String apply(NetworkAclTag networkAclTag) {
                return networkAclTag.getNetworkAcl().getDisplayName();
            }
        };

    }
}

