/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.vpc.NetworkAcl;
import com.eucalyptus.entities.AbstractPersistent;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_network_acl_entries")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class NetworkAclEntry
extends AbstractPersistent {
    private static final long serialVersionUID = 1L;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_network_acl_id", nullable=false, updatable=false)
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private NetworkAcl networkAcl;
    @Column(name="metadata_rule_number", nullable=false, updatable=false)
    private Integer ruleNumber;
    @Column(name="metadata_protocol", nullable=false, updatable=false)
    private Integer protocol;
    @Column(name="metadata_rule_action", nullable=false, updatable=false)
    @Enumerated(value=EnumType.STRING)
    private RuleAction ruleAction;
    @Column(name="metadata_egress", nullable=false, updatable=false)
    private Boolean egress;
    @Column(name="metadata_cidr", nullable=false, updatable=false)
    private String cidr;
    @Column(name="metadata_icmp_code", updatable=false)
    private Integer icmpCode;
    @Column(name="metadata_icmp_type", updatable=false)
    private Integer icmpType;
    @Column(name="metadata_port_from", updatable=false)
    private Integer portRangeFrom;
    @Column(name="metadata_port_to", updatable=false)
    private Integer portRangeTo;

    protected NetworkAclEntry() {
    }

    protected NetworkAclEntry(NetworkAcl networkAcl, Integer ruleNumber, Integer protocol, RuleAction ruleAction, Boolean egress, String cidr, Integer icmpCode, Integer icmpType, Integer portRangeFrom, Integer portRangeTo) {
        this.networkAcl = networkAcl;
        this.ruleNumber = ruleNumber;
        this.protocol = protocol;
        this.ruleAction = ruleAction;
        this.egress = egress;
        this.cidr = cidr;
        this.icmpCode = icmpCode;
        this.icmpType = icmpType;
        this.portRangeFrom = portRangeFrom;
        this.portRangeTo = portRangeTo;
    }

    public static NetworkAclEntry createIcmpEntry(NetworkAcl networkAcl, Integer ruleNumber, RuleAction ruleAction, Boolean egress, String cidr, Integer icmpCode, Integer icmpType) {
        return new NetworkAclEntry(networkAcl, ruleNumber, 1, ruleAction, egress, cidr, icmpCode, icmpType, null, null);
    }

    public static NetworkAclEntry createTcpUdpEntry(NetworkAcl networkAcl, Integer ruleNumber, Integer protocol, RuleAction ruleAction, Boolean egress, String cidr, Integer portRangeFrom, Integer portRangeTo) {
        return new NetworkAclEntry(networkAcl, ruleNumber, protocol, ruleAction, egress, cidr, null, null, portRangeFrom, portRangeTo);
    }

    public static NetworkAclEntry createEntry(NetworkAcl networkAcl, Integer ruleNumber, Integer protocol, RuleAction ruleAction, Boolean egress, String cidr) {
        return new NetworkAclEntry(networkAcl, ruleNumber, protocol, ruleAction, egress, cidr, null, null, null, null);
    }

    public Integer getRuleNumber() {
        return this.ruleNumber;
    }

    public void setRuleNumber(Integer ruleNumber) {
        this.ruleNumber = ruleNumber;
    }

    public Integer getProtocol() {
        return this.protocol;
    }

    public void setProtocol(Integer protocol) {
        this.protocol = protocol;
    }

    public RuleAction getRuleAction() {
        return this.ruleAction;
    }

    public void setRuleAction(RuleAction ruleAction) {
        this.ruleAction = ruleAction;
    }

    public Boolean getEgress() {
        return this.egress;
    }

    public void setEgress(Boolean egress) {
        this.egress = egress;
    }

    public String getCidr() {
        return this.cidr;
    }

    public void setCidr(String cidr) {
        this.cidr = cidr;
    }

    public Integer getIcmpCode() {
        return this.icmpCode;
    }

    public void setIcmpCode(Integer icmpCode) {
        this.icmpCode = icmpCode;
    }

    public Integer getIcmpType() {
        return this.icmpType;
    }

    public void setIcmpType(Integer icmpType) {
        this.icmpType = icmpType;
    }

    public Integer getPortRangeFrom() {
        return this.portRangeFrom;
    }

    public void setPortRangeFrom(Integer portRangeFrom) {
        this.portRangeFrom = portRangeFrom;
    }

    public Integer getPortRangeTo() {
        return this.portRangeTo;
    }

    public void setPortRangeTo(Integer portRangeTo) {
        this.portRangeTo = portRangeTo;
    }

    public static enum RuleAction {
        allow,
        deny;

    }
}

