/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.vpc.NetworkAclEntry;
import com.eucalyptus.compute.vpc.NetworkAclTag;
import com.eucalyptus.compute.vpc.Subnet;
import com.eucalyptus.compute.vpc.Vpc;
import com.eucalyptus.entities.AbstractOwnedPersistent;
import com.eucalyptus.util.OwnerFullName;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceContext;
import javax.persistence.Table;
import org.hibernate.annotations.Cache;
import org.hibernate.annotations.CacheConcurrencyStrategy;

@Entity
@PersistenceContext(name="eucalyptus_cloud")
@Table(name="metadata_network_acls")
@Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
public class NetworkAcl
extends AbstractOwnedPersistent
implements CloudMetadata.NetworkAclMetadata {
    private static final long serialVersionUID = 1L;
    @ManyToOne(optional=false)
    @JoinColumn(name="metadata_vpc_id")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private Vpc vpc;
    @Column(name="metadata_default")
    private Boolean defaultForVpc;
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, mappedBy="networkAcl")
    @Cache(usage=CacheConcurrencyStrategy.TRANSACTIONAL)
    private List<NetworkAclEntry> entries = Lists.newArrayList();
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REFRESH}, orphanRemoval=true, mappedBy="networkAcl")
    private Collection<Subnet> subnets;
    @OneToMany(fetch=FetchType.LAZY, cascade={CascadeType.REMOVE}, orphanRemoval=true, mappedBy="networkAcl")
    private Collection<NetworkAclTag> tags;

    protected NetworkAcl() {
    }

    protected NetworkAcl(OwnerFullName owner, String displayName) {
        super(owner, displayName);
    }

    public static NetworkAcl create(OwnerFullName owner, Vpc vpc, String name, boolean defaultForVpc) {
        NetworkAcl networkAcl = new NetworkAcl(owner, name);
        networkAcl.setVpc(vpc);
        networkAcl.setDefaultForVpc(defaultForVpc);
        networkAcl.setEntries(defaultForVpc ? Lists.newArrayList((Object[])new NetworkAclEntry[]{NetworkAclEntry.createEntry(networkAcl, 100, -1, NetworkAclEntry.RuleAction.allow, true, "0.0.0.0/0"), NetworkAclEntry.createEntry(networkAcl, Short.MAX_VALUE, -1, NetworkAclEntry.RuleAction.deny, true, "0.0.0.0/0"), NetworkAclEntry.createEntry(networkAcl, 100, -1, NetworkAclEntry.RuleAction.allow, false, "0.0.0.0/0"), NetworkAclEntry.createEntry(networkAcl, Short.MAX_VALUE, -1, NetworkAclEntry.RuleAction.deny, false, "0.0.0.0/0")}) : Lists.newArrayList((Object[])new NetworkAclEntry[]{NetworkAclEntry.createEntry(networkAcl, Short.MAX_VALUE, -1, NetworkAclEntry.RuleAction.deny, true, "0.0.0.0/0"), NetworkAclEntry.createEntry(networkAcl, Short.MAX_VALUE, -1, NetworkAclEntry.RuleAction.deny, false, "0.0.0.0/0")}));
        networkAcl.subnets = Lists.newArrayList();
        return networkAcl;
    }

    public static NetworkAcl exampleWithOwner(OwnerFullName owner) {
        return new NetworkAcl(owner, null);
    }

    public static NetworkAcl exampleWithName(OwnerFullName owner, String name) {
        return new NetworkAcl(owner, name);
    }

    public static NetworkAcl exampleDefault() {
        NetworkAcl networkAcl = new NetworkAcl();
        networkAcl.setDefaultForVpc(true);
        return networkAcl;
    }

    public Vpc getVpc() {
        return this.vpc;
    }

    public void setVpc(Vpc vpc) {
        this.vpc = vpc;
    }

    public Boolean getDefaultForVpc() {
        return this.defaultForVpc;
    }

    public void setDefaultForVpc(Boolean defaultForVpc) {
        this.defaultForVpc = defaultForVpc;
    }

    public List<NetworkAclEntry> getEntries() {
        return this.entries;
    }

    public void setEntries(List<NetworkAclEntry> entries) {
        this.entries = entries;
    }

    public List<Subnet> getSubnets() {
        return Lists.newArrayList(this.subnets);
    }
}

