/*
 * Decompiled with CFR 0.152.
 */
package com.eucalyptus.compute.vpc;

import com.eucalyptus.compute.common.CloudMetadata;
import com.eucalyptus.compute.common.CloudMetadatas;
import com.eucalyptus.compute.common.InternetGatewayType;
import com.eucalyptus.compute.vpc.InternetGateway;
import com.eucalyptus.compute.vpc.InternetGatewayTag;
import com.eucalyptus.compute.vpc.Lister;
import com.eucalyptus.compute.vpc.VpcMetadataException;
import com.eucalyptus.entities.Entities;
import com.eucalyptus.entities.TransactionResource;
import com.eucalyptus.tags.FilterSupport;
import com.eucalyptus.util.Callback;
import com.eucalyptus.util.OwnerFullName;
import com.eucalyptus.util.RestrictedTypes;
import com.eucalyptus.util.TypeMapper;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.hibernate.criterion.Criterion;

public interface InternetGateways
extends Lister<InternetGateway> {
    @Override
    public <T> List<T> list(OwnerFullName var1, Criterion var2, Map<String, String> var3, Predicate<? super InternetGateway> var4, Function<? super InternetGateway, T> var5) throws VpcMetadataException;

    public <T> T lookupByName(@Nullable OwnerFullName var1, String var2, Function<? super InternetGateway, T> var3) throws VpcMetadataException;

    public <T> T lookupByVpc(@Nullable OwnerFullName var1, String var2, Function<? super InternetGateway, T> var3) throws VpcMetadataException;

    public boolean delete(CloudMetadata.InternetGatewayMetadata var1) throws VpcMetadataException;

    public InternetGateway save(InternetGateway var1) throws VpcMetadataException;

    public InternetGateway updateByExample(InternetGateway var1, OwnerFullName var2, String var3, Callback<InternetGateway> var4) throws VpcMetadataException;

    @RestrictedTypes.QuantityMetricFunction(value=CloudMetadata.InternetGatewayMetadata.class)
    public static enum CountInternetGateways implements Function<OwnerFullName, Long>
    {
        INSTANCE;


        public Long apply(@Nullable OwnerFullName input) {
            try (TransactionResource tx = Entities.transactionFor(InternetGateway.class);){
                Long l = Entities.count((Object)((Object)InternetGateway.exampleWithOwner(input)));
                return l;
            }
        }
    }

    public static enum FilterStringFunctions implements Function<InternetGateway, String>
    {
        STATE{

            public String apply(InternetGateway internetGateway) {
                return internetGateway.getVpc() == null ? null : "available";
            }
        }
        ,
        VPC_ID{

            public String apply(InternetGateway internetGateway) {
                return (String)CloudMetadatas.toDisplayName().apply((Object)internetGateway.getVpc());
            }
        };

    }

    public static class InternetGatewayFilterSupport
    extends FilterSupport<InternetGateway> {
        public InternetGatewayFilterSupport() {
            super(InternetGatewayFilterSupport.builderFor(InternetGateway.class).withTagFiltering(InternetGatewayTag.class, "internetGateway").withStringProperty("attachment.state", FilterStringFunctions.STATE).withStringProperty("attachment.vpc-id", FilterStringFunctions.VPC_ID).withStringProperty("internet-gateway-id", (Function<InternetGateway, String>)CloudMetadatas.toDisplayName()).withPersistenceAlias("vpc", "vpc").withPersistenceFilter("attachment.state", "vpc.displayName", new Function<String, String>(){

                @Nullable
                public String apply(@Nullable String value) {
                    return "available".equals(value) ? "*" : null;
                }
            }).withPersistenceFilter("vpc-id", "vpc.displayName").withPersistenceFilter("internet-gateway-id", "displayName"));
        }
    }

    @TypeMapper
    public static enum InternetGatewayToInternetGatewayTypeTransform implements Function<InternetGateway, InternetGatewayType>
    {
        INSTANCE;


        @Nullable
        public InternetGatewayType apply(@Nullable InternetGateway internetGateway) {
            return internetGateway == null ? null : new InternetGatewayType(internetGateway.getDisplayName(), (String)CloudMetadatas.toDisplayName().apply((Object)internetGateway.getVpc()));
        }
    }
}

